module memory_manager(

   input wire clock_in, n_mreq, n_iorq, n_res, n_rd, n_wr, n_m1,
	input wire [15:0] a,
	input wire [7:0] d,
   output n_ramcs, n_romcs, n_concs,
	output wire [5:0] ext_a,
	output wire n_wait
);

   reg n_rom_select = 1'b0;
	reg [3:0] ext_ad;
	reg [1:0] iowait;
	wire n_cfcs;

   always @(posedge clock_in) begin
		if (!n_res) begin
			n_rom_select <= 1'b0; // Set ROM available
			ext_ad <= 4'b0010; // Set A19..A16 to (A19 used as CF select, A18 = 0, A17 = 1, A16 = 0)
		end else begin
			if (n_iorq == 0 && n_wr == 0 && a[7:3] == 5'b00111) n_rom_select <= d[0]; // Port 0x38..0x3f ROM lock
		end
	end
	
   always @(posedge clock_in) begin
		iowait[0] <= n_iorq;
		iowait[1] <= iowait[0];
	end

	assign n_ramcs = n_rom_select ? n_mreq : n_mreq | ~(a[15] | a[14]);
	assign n_romcs = n_rom_select ? 1'h1 : n_mreq | a[15] | a[14];
	assign n_concs = ~(n_iorq == 0 && n_m1 == 1 && a[7:3] == 5'b00001); // Port 0x08..0x0f 8251 Select
   assign n_cfcs = ~(n_iorq == 0 && n_m1 == 1 && a[7:3] == 5'b00010); // Port 0x10..0x17 8251 Select
	assign n_wait = ~(~iowait[0] & iowait[1]);
	assign ext_a = {n_cfcs, ext_ad[2:0], a[15], a[14]};

endmodule