
module VGA_LITE (
	input R_IN,
	input G_IN,
	input B_IN,
	input I_IN,
	input KSI_IN,
	input SSI_IN,
	input F14,

	input SET_FK_OUT,
	input INVERSE_KSI,
	input INVERSE_SSI,

	output reg R_VGA,
	output reg G_VGA,
	output reg B_VGA,
	output [2:0] I_VGA,
	output reg VSYNC_VGA,
	output reg HSYNC_VGA,

	output [16:0] A,
	output WE,
	output OE,
	inout [7:0] D
);


reg I_VGA_REG;

wire VGA_KSI;
wire VGA_SSI;

wire VGA_KGI;
wire VGA_SGI;
wire VGA_BLANK;

wire R3;
wire G3;
wire B3;
wire I3;

reg [8:0] VGA_H_MAX;
reg [8:0] VGA_H;
reg [9:0] VGA_V;
reg [9:0] VIDEO_H_MAX;
reg [9:0] VIDEO_H;
reg [8:0] VIDEO_V;

reg [9:0] H_COUNT;

wire RESET_ZONE;
wire RESET_H;
wire RESET_V;

reg KSI;
reg KSI_2;
reg SSI;
reg SSI_2;

assign RESET_H = SSI || SSI_2;
assign RESET_V = KSI || KSI_2;
assign RESET_ZONE = (~VIDEO_V[7]) || VIDEO_V[8]; 

assign VGA_SSI = ~(VGA_H > 8 && VGA_H < 62);	
assign VGA_SGI = ~(VGA_H < 89);	

assign VGA_KSI = SET_FK_OUT ? ( (VGA_V == 74)||(VGA_V == 75) ? 0 : 1 ) : ( (VGA_V == 10)||(VGA_V == 11) ? 0 : 1 );
assign VGA_KGI = SET_FK_OUT ? ( (VGA_V < 109) ? 0 : 1 ) : ( (VGA_V < 65) ? 0 : 1 );

assign VGA_BLANK = VGA_KGI && VGA_SGI;


reg [7:0] WR_REG;
reg [7:0] RD_REG;

assign WE = F14 || !(VIDEO_H[1] && VIDEO_H[0]);
assign OE = F14 || VIDEO_H[0];
assign A[16:0] = SET_FK_OUT  ? ( VIDEO_H[0] ? {VIDEO_V[8:0], VIDEO_H[9:2]} : {VGA_V[9:1], VGA_H[8:1]} ) :
                               ( VIDEO_H[0] ? {8'b00000000, VIDEO_V[0], VIDEO_H[9:2]} : {8'b00000000, ~VIDEO_V[0], VGA_H[8:1]} );
assign D[7:0] = VIDEO_H[0] ? WR_REG : 8'bzzzzzzzz;



always @(posedge F14) begin
	SSI <= INVERSE_SSI ? SSI_IN : ~SSI_IN;
	SSI_2 <= ~SSI;

	if (!VGA_H[0]) RD_REG <= D[7:0];
end



always @(posedge H_COUNT[8]) begin
	if (!H_COUNT[9]) begin
		KSI <= INVERSE_KSI ? KSI_IN : ~KSI_IN;
		KSI_2 <= ~KSI;
	end
end



always @(negedge VGA_H[8]) begin
	if (SET_FK_OUT==0)
		if (!RESET_V) VGA_V <= 10'b0000000000;
		else VGA_V <= VGA_V + 1'b1;
	else
		if (VGA_V == 587) VGA_V <= 10'b0001000000;
		else VGA_V <= VGA_V + 1'b1;
end



always @(negedge H_COUNT[9]) begin
	if (!RESET_V) VIDEO_V <= 10'b0000000000;
	else VIDEO_V <= VIDEO_V + 1;
end



always @(negedge SSI) begin
	if (!RESET_ZONE) VIDEO_H_MAX <= H_COUNT;
end



always @(F14) begin
	VGA_H_MAX <= VIDEO_H_MAX[9:1];
end
	



assign R3 = !VGA_H[0] ? RD_REG[3] : RD_REG[7];
assign G3 = !VGA_H[0] ? RD_REG[2] : RD_REG[6];
assign B3 = !VGA_H[0] ? RD_REG[1] : RD_REG[5];
assign I3 = !VGA_H[0] ? RD_REG[0] : RD_REG[4];

assign I_VGA = {I_VGA_REG,I_VGA_REG,I_VGA_REG};


always @(negedge F14) begin
	if (!RESET_H) H_COUNT <= 10'b0000000000;
	else H_COUNT <= H_COUNT + 1;
	
	if (!(RESET_H || RESET_ZONE)) begin
			VGA_H <= 9'b000000000;
			VIDEO_H <= 9'b000000000;
		end
	else begin
			if (VGA_H == VGA_H_MAX) VGA_H <= 9'b000000000;
			else VGA_H <= VGA_H + 1;

			if (VIDEO_H == VIDEO_H_MAX) VIDEO_H <= 9'b000000000;
			else VIDEO_H <= VIDEO_H + 1;
	end

	R_VGA  <= VGA_BLANK && R3;
	G_VGA  <= VGA_BLANK && G3;
	B_VGA  <= VGA_BLANK && B3;
	I_VGA_REG  <= !(I3 && VGA_BLANK) ? 1'b0: 1'bz;
	VSYNC_VGA <= VGA_KSI;
	HSYNC_VGA <= VGA_SSI;

end



always @(posedge VIDEO_H[0])begin
	if (!VIDEO_H[1]) begin
			WR_REG[3] <= R_IN;
			WR_REG[2] <= G_IN;
			WR_REG[1] <= B_IN;
			WR_REG[0] <= I_IN;
		end
	else begin
			WR_REG[7] <= R_IN;
			WR_REG[6] <= G_IN;
			WR_REG[5] <= B_IN;
			WR_REG[4] <= I_IN;
		end
end



endmodule