module z80mini(
	input wire CLK50MHz,
	input wire [15:0] A,
	inout wire [7:0] D,
	input wire nMREQ, nIORQ, nWR, nRD, nM1, nRES, nHALT, IRQ,
	output wire nWAIT, nINT, nNMI, CPUCLK, nRESET,
	output wire CONCLK, TCLK, RESET, nCONCS,
	output wire nRAMCS, nROMCS,
	output wire [5:0] EXT_A,
	input wire [3:0] EXT_P_IN,
	output wire [3:0] EXT_P_OUT
);

	reg reset;
	wire [7:0] DO;
	wire DO_ENABLE;

	memory_manager mm0 (
		    .clock_in(CPUCLK), .n_mreq(nMREQ), .n_iorq(nIORQ), 
			.n_res(nRESET), .n_rd(nRD), .n_wr(nWR), .n_m1(nM1),
			.a(A), .d_i(D), .d_o(DO), .ext_line_i(EXT_P_IN), .ext_line_o(EXT_P_OUT),
			.n_ramcs(nRAMCS), .n_romcs(nROMCS), .n_concs(nCONCS),
			.ext_a(EXT_A),
			.n_wait(nWAIT), .d_o_enable(DO_ENABLE)
	);

	frequency_divider #(.DIVIDER(20)) f_cpuclk (.clock_in(CLK50MHz), .clock_out(CPUCLK)); // CPUCLK = TCLK = 2.5Mhz
	frequency_divider #(.DIVIDER(81)) f_conclk (.clock_in(CLK50MHz), .clock_out(CONCLK)); // CONCLK = 617 kHz

//	frequency_divider #(.DIVIDER(12)) f_tclk (.clock_in(CLK50MHz), .clock_out(TCLK));
	assign TCLK = CPUCLK;
	
	always @(posedge CPUCLK) begin
		if (!nRES) begin
			reset <= 1;
		end else reset <= 0;
	end

	assign D = nM1 | nIORQ ? (DO_ENABLE ? DO : 8'bzzzzzzzz) : 8'hfa; // Set INT IM 2 vector to 0xIIFA (for CP/M: II = 0xFF) or set D to DO when DO_ENABLE
	assign nNMI = 1'b1;
	assign nINT = ~IRQ;
	assign nRESET = ~reset;
	assign RESET = reset;

endmodule