;  -  -128  
;   /  51, ASCII-    
;         
;   VT52     VT100
;        -     !
;=====================================================================================
ccp		.EQU	0cf00h		; Base of CCP.
bdos		.EQU	ccp + 0806h	; Base of BDOS.
bios		.EQU	ccp + 1600h	; Base of BIOS.

; Set CP/M low memory datA, vector and buffer addresses.

iobyte		.EQU	03h		; Intel standard I/O definition byte.
userdrv		.EQU	04h		; Current user number and drive.
tpabuf		.EQU	80h		; Default I/O buffer and command line storage.


SER_BUFSIZE		.EQU	60
SER_FULLSIZE	.EQU	50
SER_EMPTYSIZE	.EQU	5


RTS_HIGH	.EQU	05H
RTS_LOW		.EQU	025H ;  51

;      -     equ  , 
;         
;SIOA_D		.EQU	$00 ; +  -  SIOA_D
;SIOA_C		.EQU	$02 ; + + -   SIOA_C-1
;SIOB_D		.EQU	$01 ;  51  -   SIOB_D+7
;SIOB_C		.EQU	$03 ; 51  -  SIOB_C+6

SERB_D		.EQU	$08
SERB_C		.EQU	$09
SERA_D		.EQU	$FE
SERA_C		.EQU	$FF


int38		.EQU	38H ;,   
nmi			.EQU	66H ;,   

blksiz		.equ	4096		;CP/M allocation size
hstsiz		.equ	512		;host disk sector size
hstspt		.equ	32		;host disk sectors/trk
hstblk		.equ	hstsiz/128	;CP/M sects/host buff
cpmspt		.equ	hstblk * hstspt	;CP/M sectors/track
secmsk		.equ	hstblk-1	;sector mask
					;compute sector mask
;secshf		.equ	2		;log2(hstblk)

wrall		.equ	0		;write to allocated
wrdir		.equ	1		;write to directory
wrual		.equ	2		;write to unallocated

; SD registers/configs
SD_DATA		.EQU	02Ah
SD_CONFIG	.EQU	02Bh

SD_WAIT_WR	.EQU	3000 ; Wait cycles to write finish
SD_WAIT		.EQU	3000 ; Wait cycles to CMD answer
SD_WAIT_I	.EQU	200 ; Wait cycles to INIT finish

LF		.EQU	0AH		;line feed
FF		.EQU	0CH		;form feed
CR		.EQU	0DH		;carriage RETurn

ESCTST		.EQU	0FFFDH		;    ESC-
BUF1		.EQU	0FFFCH		;1     ESC-

;================================================================================================

		.ORG	bios		; BIOS origin.

;================================================================================================
; BIOS jump table.
;================================================================================================
		JP	boot		;  0 Initialize.
wboote:
		JP	wboot		;  1 Warm boot.
		JP	const		;  2 Console status.
		JP	conin		;  3 Console input.
		JP	conout		;  4 Console OUTput.
		JP	list		;  5 List OUTput.
		JP	punch		;  6 punch OUTput.
		JP	reader		;  7 Reader input.
		JP	home		;  8 Home disk.
		JP	seldsk		;  9 Select disk.
		JP	settrk		; 10 Select track.
		JP	setsec		; 11 Select sector.
		JP	setdma		; 12 Set DMA ADDress.
		JP	read		; 13 Read 128 bytes.
		JP	write		; 14 Write 128 bytes.
		JP	listst		; 15 List status.
		JP	sectran		; 16 Sector translate.

;================================================================================================
; Disk parameter headers for disk 0 to 15
;================================================================================================
dpbase:
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb0,0000h,alv00
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv01
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv02
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv03
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv04
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv05
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv06
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv07
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv08
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv09
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv10
	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpbLast,0000h,alv11
;	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv12
;	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv13
;	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpb,0000h,alv14
;	 	.DW 0000h,0000h,0000h,0000h,dirbuf,dpbLast,0000h,alv15

; First drive has a reserved track for CP/M
dpb0:
		.DW 128 ;SPT - sectors per track
		.DB 5   ;BSH - block shift factor
		.DB 31  ;BLM - block mask
		.DB 1   ;EXM - Extent mask
		.DW 2043 ; (2047-4) DSM - Storage size (blocks - 1)
		.DW 511 ;DRM - Number of directory entries - 1
		.DB 240 ;AL0 - 1 bit set per directory block
		.DB 0   ;AL1 -            "
		.DW 0   ;CKS - DIR check vector size (DRM+1)/4 (0=fixed disk)
		.DW 1   ;OFF - Reserved tracks

dpb:
		.DW 128 ;SPT - sectors per track
		.DB 5   ;BSH - block shift factor
		.DB 31  ;BLM - block mask
		.DB 1   ;EXM - Extent mask
		.DW 2047 ;DSM - Storage size (blocks - 1)
		.DW 511 ;DRM - Number of directory entries - 1
		.DB 240 ;AL0 - 1 bit set per directory block
		.DB 0   ;AL1 -            "
		.DW 0   ;CKS - DIR check vector size (DRM+1)/4 (0=fixed disk)
		.DW 0   ;OFF - Reserved tracks

; Last drive is smaller because CF is never full 64MB or 128MB
dpbLast:
		.DW 128 ;SPT - sectors per track
		.DB 5   ;BSH - block shift factor
		.DB 31  ;BLM - block mask
		.DB 1   ;EXM - Extent mask
		.DW 511 ;DSM - Storage size (blocks - 1)  ; 511 = 2MB (for 128MB card), 1279 = 5MB (for 64MB card)
		.DW 511 ;DRM - Number of directory entries - 1
		.DB 240 ;AL0 - 1 bit set per directory block
		.DB 0   ;AL1 -            "
		.DW 0   ;CKS - DIR check vector size (DRM+1)/4 (0=fixed disk)
		.DW 0   ;OFF - Reserved tracks

;================================================================================================
; Cold boot
;================================================================================================

boot:
		DI				; Disable interrupts.
		LD	SP,biosstack		; Set default stack.

;		Turn off ROM

		LD	A,$01
		OUT ($38),A


		; Interrupt vector in page FF
		LD	A,$FF
		LD	I,A

;	Initialise SIO

		LD	HL,SINTTB
		LD	BC,$0006
SINIT1:
		DEC B
		JR NZ,SINIT1
		
		LD	A,(HL)
		INC	HL
		OUT	(SERB_C),A
		DEC C
		JR	NZ,SINIT1
		
		IN A,(SERB_D) ; 

		CALL	printInline
		.DB FF
		.TEXT "Z80 CP/M BIOS"
		.DB CR,LF
		.DB CR,LF
		.TEXT "CP/M 2.2 "
		.TEXT	"Copyright"
		.TEXT	" 1979 (c) by Digital Research"
		.DB CR,LF
		.TEXT	"Try to init SD Card..."
		.DB 0
		
		CALL	sdInit
		
		LD	A, (erflag)
		CP	0
		JR Z, boot1
		
		CALL	printInline
		.TEXT "Error - "
		.DB 0
		
		CALL printHEX

		LD	C, 020H
		CALL conout
		
		LD	A, (ercode)
		CALL printHEX
		
bootH:
		JP	bootH
		
boot1:
		CALL	printInline
		.TEXT "Ok"
		.DB CR, LF, 0


		XOR	a				; Clear I/O & drive bytes.
		LD	(userdrv),A

		LD	(serABufUsed),A
		LD	(serBBufUsed),A
		LD	HL,serABuf
		LD	(serAInPtr),HL
		LD	(serARdPtr),HL

		LD	HL,serBBuf
		LD	(serBInPtr),HL
		LD	(serBRdPtr),HL

		JP	gocpm

SINTTB:	.DB $0,$0,$0,$40,$4F,$35

;================================================================================================
; Warm boot
;================================================================================================

wboot:
		DI				; Disable interrupts.
		LD	SP,biosstack		; Set default stack.

;commit by Helbr 09.03.2020 - start. Correct WarmBoot init

		; Interrupt vector in page FF
		LD	A,$FF
		LD	I,A

		CALL	printInline
		.TEXT	"Try to init SD Card..."
		.DB 0
		
		CALL	sdInit
		
		LD	A, (erflag)
		CP	0
		JR Z, wboot1
		
		CALL	printInline
		.TEXT "Error - "
		.DB 0
		
		CALL printHEX

		LD	C, 020H
		CALL conout
		
		LD	A, (ercode)
		CALL printHEX
		
wbootH:
		JP	wbootH

wboot1:
		CALL	printInline
		.TEXT "Ok"
		.DB CR, LF
		.TEXT "Rading CCP..."
		.DB 0


;commit by Helbr - end

		LD	B,11 ; Number of sectors to reload to reload CCP

		LD	A,0
		LD	(hstsec),A
		LD	HL,ccp

rdSectors:

		LD	A, (sdhcs)
		AND	040H
		JR NZ, rdS1
		
		LD	A, (hstsec)
		RLC	A
		LD	(lba1), A

		LD	A,0
		LD	(lba0), A
		LD	(lba2), A
		LD	(lba3), A

		JP	rdS2
rdS1:
		LD	A,(hstsec)
		LD	(lba0), A
		LD	A,0
		LD	(lba1), A
		LD	(lba2), A
		LD	(lba3), A
rdS2:
		CALL	readLBA

		LD	A, (erflag)
		CP	0
		JR NZ, rdSectorsEr

		LD	A,(hstsec)
		INC	A
		LD	(hstsec),A

		djnz	rdSectors
		
		CALL	printInline
		.TEXT "Ok"
		.DB 0

		JP	gocpm

rdSectorsEr:

		CALL	printInline
		.TEXT "Error"
		.DB 0
		
rdSectorsErH:

		JP rdSectorsErH

;================================================================================================
; Common code for cold and warm boot
;================================================================================================

gocpm:
		xor	a			;0 to accumulator
		ld	(hstact),a		;host buffer inactive
		ld	(unacnt),a		;clear unalloc count

		LD	A, 0C3h		; Opcode for 'JP'.

		LD	HL,tpabuf		; ADDress of BIOS DMA buffer.
		LD	(dmaAddr),HL

		LD	(00h),A			; Load at start of RAM.

		LD	HL, wboote		; ADDress of jump for a warm boot.
		LD	(01h), HL


		LD	(05h), A			; Opcode for 'JP'.

		LD	HL, bdos			; ADDress of jump for the BDOS.
		LD	(06h), HL

		LD	A, (userdrv)		; Save new drive number (0).
		LD	C, A			; Pass drive number in C.

		IM	2
		EI				; Enable interrupts

		JP	ccp			; Start CP/M by jumping to the CCP.

;================================================================================================
; Console I/O routines
;================================================================================================

serialInt:	DI
		PUSH	AF
		PUSH	HL

		;    51 (B)
		;  ,    (A)

		IN   	A,(SERB_C)			; -, D1=1   	
		AND 00000010B			;  	
		JR	NZ, serialIntB		;  ,    

serialIntA:
		LD	HL,(serAInPtr)
		INC	HL
		LD	A,L
		CP	(serABuf+SER_BUFSIZE) & $FF
		JR	NZ, notAWrap
		LD	HL,serABuf
notAWrap:
		LD	(serAInPtr),HL
		IN	A,(SERA_D) 	;     
		LD	(HL),A
		
		LD	A,(serABufUsed)
		INC	A
		LD	(serABufUsed),A

		POP	HL
		POP	AF

		EI
		RETI


serialIntB:
		LD	HL,(serBInPtr)
		INC	HL
		LD	A,L
		CP	(serBBuf+SER_BUFSIZE) & $FF
		JR	NZ, notBWrap
		LD	HL,serBBuf
notBWrap:
		LD	(serBInPtr),HL
		IN	A,(SERB_D)
		LD	(HL),A

		LD	A,(serBBufUsed)
		INC	A
		LD	(serBBufUsed),A
		CP	SER_FULLSIZE
		JR	C,rtsB0
        LD 	A,RTS_HIGH
		OUT	(SERB_C),A
rtsB0:
		POP	HL
		POP	AF
		EI
		RETI

;------------------------------------------------------------------------------------------------
const:
		LD	A,(iobyte)
		AND	00001011b ; Mask off console and high bit of reader
		CP	00001010b ; redirected to reader on UR1/2 (Serial A)
		JR	Z,constA
		CP	00000010b ; redirected to reader on TTY/RDR (Serial B)
		JR	Z,constB

		AND	$03 ; remove the reader from the mask - only console bits then remain
		CP	$01
		JR	NZ,constB
constA:
		PUSH	HL
		LD	A,(serABufUsed)
		CP	$00
		JR	Z, dataAEmpty
 		LD	A,0FFH
		POP	HL
		RET
dataAEmpty:
		LD	A,0
		POP	HL
       	RET


constB:
		PUSH	HL
		LD	A,(serBBufUsed)
		CP	$00
		JR	Z, dataBEmpty
 		LD	A,0FFH
		POP	HL
		RET
dataBEmpty:
		LD	A,0
		POP	HL
       	RET

;------------------------------------------------------------------------------------------------
reader:		
		PUSH	HL
		PUSH	AF
reader2:
		LD	A,(iobyte)
		AND	$08
		CP	$08
		JR	NZ,coninB
		JR	coninA
;------------------------------------------------------------------------------------------------
conin:
		PUSH	HL
		PUSH	AF
		LD	A,(iobyte)
		AND	$03
		CP	$02
		JR	Z,reader2	; "BAT:" redirect
		CP	$01
		JR	NZ,coninB
		

coninA:
		POP	AF
waitForCharA:
		LD	A,(serABufUsed)
		CP	$00
		JR	Z, waitForCharA
		LD	HL,(serARdPtr)
		INC	HL
		LD	A,L
		CP	(serABuf+SER_BUFSIZE) & $FF
		JR	NZ, notRdWrapA
		LD	HL,serABuf
notRdWrapA:
		DI
		LD	(serARdPtr),HL

		LD	A,(serABufUsed)
		DEC	A
		LD	(serABufUsed),A

		CP	SER_EMPTYSIZE
		LD	A,(HL)
		POP	HL
		
		EI

		RET	; Char ready in A


coninB:
		POP	AF
waitForCharB:
		LD	A,(serBBufUsed)
		CP	$00
		JR	Z, waitForCharB
		LD	HL,(serBRdPtr)
		INC	HL
		LD	A,L
		CP	(serBBuf+SER_BUFSIZE) & $FF
		JR	NZ, notRdWrapB
		LD	HL,serBBuf
notRdWrapB:
		DI
		LD	(serBRdPtr),HL

		LD	A,(serBBufUsed)
		DEC	A
		LD	(serBBufUsed),A

		CP	SER_EMPTYSIZE
		JR	NC,rtsB1
        LD 	A,RTS_LOW
		OUT	(SERB_C),A
rtsB1:
		LD	A,(HL)
		POP	HL
		EI
		RET	; Char ready in B

;------------------------------------------------------------------------------------------------
list:
		PUSH	AF		; Store character
list2:
		LD	A,(iobyte)
		AND	$C0
		CP	$40
		JR	NZ,conoutB1
		JP	conoutA1

;------------------------------------------------------------------------------------------------
punch:
		PUSH	AF		; Store character
		LD	A,(iobyte)
		AND	$20
		CP	$20
		JR	NZ,conoutB1
		JP	conoutA1

;------------------------------------------------------------------------------------------------
conout:
		PUSH	AF		; Store character
		LD	A,(iobyte)
		AND	$03
		CP	$02
		JR	Z,list2		; "BAT:" redirect
		CP	$01
		JR	NZ,conoutB1
		JP	conoutA1	
		
;------  COM  A.
conoutA1:
		LD A,C
		OUT	(SERA_D),A	; OUTput the character
		POP	AF		; RETrieve character
		RET

;-------  -,        ,  ----------
conoutB1:
		IN	A,(SERB_C)	;   D2=1  	
		AND 00000001B			;  	
		JR	Z,conoutB1	; Loop until SIO flag signals ready
		LD A,C
		OUT	(SERB_D),A	; OUTput the character
		POP	AF		; RETrieve character
		RET

;------------------------------------------------------------------------------------------------
listst:
		LD	A,$FF		; Return list status of 0xFF (ready).
		RET
;================================================================================================
; Disk processing entry points
;================================================================================================

seldsk:
		LD	HL,$0000
		LD	A,C
		CP	12		; 16 for 128MB disk, 8 for 64MB disk, 12 disk limit by free memory
		jr	C,chgdsk	; if invalid drive will give BDOS error
		LD	A,(userdrv)	; so set the drive back to a:
		CP	C		; If the default disk is not the same as the
		RET	NZ		; selected drive then return, 
		XOR	A		; else reset default back to a:
		LD	(userdrv),A	; otherwise will be stuck in a loop
		LD	(sekdsk),A
		ret

chgdsk:		LD 	(sekdsk),A
		RLC	a		;*2
		RLC	a		;*4
		RLC	a		;*8
		RLC	a		;*16
		LD 	HL,dpbase
		LD	b,0
		LD	c,A	
		ADD	HL,BC

		RET

;------------------------------------------------------------------------------------------------
home:
		ld	a,(hstwrt)	;check for pending write
		or	a
		jr	nz,homed
		ld	(hstact),a	;clear host active flag
homed:
		LD 	BC,0000h

;------------------------------------------------------------------------------------------------
settrk:		LD 	(sektrk),BC	; Set track passed from BDOS in register BC.
		RET

;------------------------------------------------------------------------------------------------
setsec:		LD 	(seksec),BC	; Set sector passed from BDOS in register BC.
		RET

;------------------------------------------------------------------------------------------------
setdma:		LD 	(dmaAddr),BC	; Set DMA ADDress given by registers BC.
		RET

;------------------------------------------------------------------------------------------------
sectran:	PUSH 	BC
		POP 	HL
		RET

;------------------------------------------------------------------------------------------------
read:
		;read the selected CP/M sector
		xor	a
		ld	(unacnt),a
		ld	a,1
		ld	(readop),a		;read operation
		ld	(rsflag),a		;must read data
		ld	a,wrual
		ld	(wrtype),a		;treat as unalloc
		jp	rwoper			;to perform the read


;------------------------------------------------------------------------------------------------
write:
		;write the selected CP/M sector
		xor	a		;0 to accumulator
		ld	(readop),a	;not a read operation
		ld	a,c		;write type in c
		ld	(wrtype),a
		cp	wrual		;write unallocated?
		jr	nz,chkuna	;check for unalloc
;
;		write to unallocated, set parameters
		ld	a,blksiz/128	;next unalloc recs
		ld	(unacnt),a
		ld	a,(sekdsk)		;disk to seek
		ld	(unadsk),a		;unadsk = sekdsk
		ld	hl,(sektrk)
		ld	(unatrk),hl		;unatrk = sectrk
		ld	a,(seksec)
		ld	(unasec),a		;unasec = seksec
;
chkuna:
;		check for write to unallocated sector
		ld	a,(unacnt)		;any unalloc remain?
		or	a	
		jr	z,alloc		;skip if not
;
;		more unallocated records remain
		dec	a		;unacnt = unacnt-1
		ld	(unacnt),a
		ld	a,(sekdsk)		;same disk?
		ld	hl,unadsk
		cp	(hl)		;sekdsk = unadsk?
		jp	nz,alloc		;skip if not
;
;		disks are the same
		ld	hl,unatrk
		call	sektrkcmp	;sektrk = unatrk?
		jp	nz,alloc		;skip if not
;
;		tracks are the same
		ld	a,(seksec)		;same sector?
		ld	hl,unasec
		cp	(hl)		;seksec = unasec?
		jp	nz,alloc		;skip if not
;
;		match, move to next sector for future ref
		inc	(hl)		;unasec = unasec+1
		ld	a,(hl)		;end of track?
		cp	cpmspt		;count CP/M sectors
		jr	c,noovf		;skip if no overflow
;
;		overflow to next track
		ld	(hl),0		;unasec = 0
		ld	hl,(unatrk)
		inc	hl
		ld	(unatrk),hl		;unatrk = unatrk+1
;
noovf:
		;match found, mark as unnecessary read
		xor	a		;0 to accumulator
		ld	(rsflag),a		;rsflag = 0
		jr	rwoper		;to perform the write
;
alloc:
		;not an unallocated record, requires pre-read
		xor	a		;0 to accum
		ld	(unacnt),a		;unacnt = 0
		inc	a		;1 to accum
		ld	(rsflag),a		;rsflag = 1

;------------------------------------------------------------------------------------------------
rwoper:
		;enter here to perform the read/write
		xor	a		;zero to accum
		ld	(erflag),a		;no errors (yet)
		ld	a,(seksec)		;compute host sector
		or	a		;carry = 0
		rra			;shift right
		or	a		;carry = 0
		rra			;shift right
		ld	(sekhst),a		;host sector to seek
;
;		active host sector?
		ld	hl,hstact	;host active flag
		ld	a,(hl)
		ld	(hl),1		;always becomes 1
		or	a		;was it already?
		jr	z,filhst		;fill host if not
;
;		host buffer active, same as seek buffer?
		ld	a,(sekdsk)
		ld	hl,hstdsk	;same disk?
		cp	(hl)		;sekdsk = hstdsk?
		jr	nz,nomatch
;
;		same disk, same track?
		ld	hl,hsttrk
		call	sektrkcmp	;sektrk = hsttrk?
		jr	nz,nomatch
;
;		same disk, same track, same buffer?
		ld	a,(sekhst)
		ld	hl,hstsec	;sekhst = hstsec?
		cp	(hl)
		jr	z,match		;skip if match
;
nomatch:
		;proper disk, but not correct sector
		ld	a,(hstwrt)		;host written?
		or	a
		call	nz,writehst	;clear host buff
;
filhst:
		;may have to fill the host buffer
		ld	a,(sekdsk)
		ld	(hstdsk),a
		ld	hl,(sektrk)
		ld	(hsttrk),hl
		ld	a,(sekhst)
		ld	(hstsec),a
		ld	a,(rsflag)		;need to read?
		or	a
		call	nz,readhst		;yes, if 1
		xor	a		;0 to accum
		ld	(hstwrt),a		;no pending write
;
match:
		;copy data to or from buffer
		ld	a,(seksec)		;mask buffer number
		and	secmsk		;least signif bits
		ld	l,a		;ready to shift
		ld	h,0		;double count
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
;		hl has relative host buffer address
		ld	de,hstbuf
		add	hl,de		;hl = host address
		ex	de,hl			;now in DE
		ld	hl,(dmaAddr)		;get/put CP/M data
		ld	c,128		;length of move
		ld	a,(readop)		;which way?
		or	a
		jr	nz,rwmove		;skip if read
;
;	write operation, mark and switch direction
		ld	a,1
		ld	(hstwrt),a		;hstwrt = 1
		ex	de,hl			;source/dest swap
;
rwmove:
		;C initially 128, DE is source, HL is dest
		ld	a,(de)		;source character
		inc	de
		ld	(hl),a		;to dest
		inc	hl
		dec	c		;loop 128 times
		jr	nz,rwmove
;
;		data has been moved to/from host buffer
		ld	a,(wrtype)		;write type
		cp	wrdir		;to directory?
		ld	a,(erflag)		;in case of errors
		ret	nz			;no further processing
;
;		clear host buffer for directory write
		or	a		;errors?
		ret	nz			;skip if so
		xor	a		;0 to accum
		ld	(hstwrt),a		;buffer written
		call	writehst
		ld	a,(erflag)
		ret

;------------------------------------------------------------------------------------------------
;Utility subroutine for 16-bit compare
sektrkcmp:
		;HL = .unatrk or .hsttrk, compare with sektrk
		ex	de,hl
		ld	hl,sektrk
		ld	a,(de)		;low byte compare
		cp	(HL)		;same?
		ret	nz			;return if not
;		low bytes equal, test high 1s
		inc	de
		inc	hl
		ld	a,(de)
		cp	(hl)	;sets flags
		ret

;================================================================================================
; Convert track/head/sector into LBA for physical access to the disk
;================================================================================================
setLBAaddr:	
		LD	A, (sdhcs)
		AND	40H
		JR NZ, setLBA1
		
		LD	A, 0 ; Conver T/H/S to LBA for SDSC  with byte addressing
		LD	(lba0), A
		
		LD	HL,(hsttrk)
		RLC	L
		RLC	L
		RLC	L
		RLC	L
		RLC	L
		RLC	L ; *
		LD	A,L
		AND	0C0H ; *
		LD	L,A
		LD	A,(hstsec)
		RLC	A
		ADD	A,L
		LD	(lba1),A

		LD	HL,(hsttrk)
		RRC	L
		RRC	L
;		RRC	L ; *
		LD	A,L
		AND	03FH ; *
		LD	L,A
		RLC	H
		RLC	H
		RLC	H
		RLC	H
		RLC	H
		RLC	H ; *
		LD	A,H
		AND	040H ; *
		LD	H,A
		LD	A,(hstdsk)
		RLC	a
		RLC	a
		RLC	a
		RLC	a
		RLC	a
		RLC	a
		RLC	a ; *
		AND	080H
		ADD	A,H
		ADD	A,L
		LD	(lba2),A

		LD	A,(hstdsk)
;		RRC	A ; *
		RRC	A
		AND	07H
		LD	(lba3),A

		JP	setLBAx

setLBA1:  ; Conver T/H/S to LBA for SDHC with sector addressing
		LD	HL,(hsttrk) 
		RLC	L
		RLC	L
		RLC	L
		RLC	L
		RLC	L
		LD	A,L
		AND	0E0H
		LD	L,A
		LD	A,(hstsec)
		ADD	A,L
		LD	(lba0),A

		LD	HL,(hsttrk)
		RRC	L
		RRC	L
		RRC	L
		LD	A,L
		AND	01FH
		LD	L,A
		RLC	H
		RLC	H
		RLC	H
		RLC	H
		RLC	H
		LD	A,H
		AND	020H
		LD	H,A
		LD	A,(hstdsk)
		RLC	a
		RLC	a
		RLC	a
		RLC	a
		RLC	a
		RLC	a
		AND	0C0H
		ADD	A,H
		ADD	A,L
		LD	(lba1),A
		

		LD	A,(hstdsk)
		RRC	A
		RRC	A
		AND	03H
		LD	(lba2),A

; SD Card most significant LBA3 byte = 0
		LD	a,0
		LD	(lba3),A

setLBAx:

		RET				

;================================================================================================
; Read physical sector from host
;================================================================================================

readhst:
		PUSH 	AF
		PUSH 	BC
		PUSH 	HL

		CALL 	setLBAaddr

		LD		A, 1
		OUT		(SD_CONFIG), A ; Set SD Fast mode, CS Low

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this

		LD		A, 0
		LD		(crc), A
		LD		A, 040H + 17
		CALL	sdSendCmd ; Send CMD17 command
		
		CALL	sdWait
		LD		(ercode), A
		
		CP		0
		LD		A, 01H ; Set Error Code to 1 (Stop at CMD17)
		JP NZ,	rdExit ; Exit with error

		CALL	sdWait
		LD		(ercode), A
		
		CP		0FEh
		LD		A, 2 ; Set Error Code to 2 (Timeout waiting data)
		JP NZ,	rdExit
		
		LD		C, 4
		LD		HL, hstbuf
rd4secs:
		LD		b, 128
rdByte:
		LD		A, 0FFH
		OUT		(SD_DATA), A

		IN	 	A,(SD_DATA)
		LD		(HL), A
		INC 	HL
		DEC 	B
		JR 	NZ, rdByte
		DEC 	C
		JR 	NZ,	rd4secs

		LD		A, 0FFH
		OUT		(SD_DATA), A
		IN		A, (SD_DATA) ; Read CRC1

		LD		A, 0FFH
		OUT		(SD_DATA), A
		IN		A, (SD_DATA) ; Read CRC1

		XOR 	a
rdExit:
		ld	(erflag),a

		LD		A, 2
		OUT		(SD_CONFIG), A ; Set SD Slow mode, CS Low

		POP 	HL
		POP 	BC
		POP 	AF

		RET

;================================================================================================
; Read LBA sector from host to (HL)
;================================================================================================

readLBA:
		PUSH 	AF
		PUSH 	BC

		LD		A, 1
		OUT		(SD_CONFIG), A ; Set SD Fast mode, CS Low

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this

		LD		A, 0
		LD		(crc), A
		LD		A, 040H + 17
		CALL	sdSendCmd ; Send CMD17 command
		
		CALL	sdWait
		LD		(ercode), A
		
		CP		0
		LD		A, 01H ; Set Error Code to 1 (Stop at CMD17)
		JP NZ,	rdLBAExit ; Exit with error

		CALL	sdWait
		LD		(ercode), A
		
		CP		0FEh
		LD		A, 2 ; Set Error Code to 2 (Timeout waiting data)
		JP NZ,	rdLBAExit
		
		LD		C, 4

rdLBA4secs:

		LD		B, 128

rdLBAByte:
		LD		A, 0FFH
		OUT		(SD_DATA), A

		IN	 	A,(SD_DATA)
		LD		(HL), A
		INC 	HL
		DEC 	B
		JR 	NZ, rdLBAByte
		DEC 	C
		JR 	NZ,	rdLBA4secs

		LD		A, 0FFH
		OUT		(SD_DATA), A
		IN		A, (SD_DATA) ; Read CRC1

		LD		A, 0FFH
		OUT		(SD_DATA), A
		IN		A, (SD_DATA) ; Read CRC1

		XOR 	A
rdLBAExit:
		ld		(erflag),A

		LD		A, 2
		OUT		(SD_CONFIG), A ; Set SD Slow mode, CS Low

		POP 	BC
		POP 	AF

		RET

;================================================================================================
; Write physical sector to host
;================================================================================================

writehst:
		PUSH 	AF
		PUSH 	BC
		PUSH 	HL

		CALL 	setLBAaddr

		LD		A, 1
		OUT		(SD_CONFIG), A ; Set SD Fast mode, CS Low

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this

		LD		A, 0
		LD		(crc), A
		LD		A, 040H + 24
		CALL	sdSendCmd ; Send CMD24 command
		
		CALL	sdWait
		LD		(ercode), A
		
		CP		0
		LD		A, 01H ; Set Error Code to 1 (Stop at CMD24)
		JP NZ,	wrExit ; Exit with error

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this

		LD		A, 0FEH
		OUT		(SD_DATA), A ; Send Data tocken to SD Card

		LD		C, 4
		LD		HL, hstbuf
wr4secs:
		LD		B, 128
wrByte:	
		LD		A, (HL)
		OUT 	(SD_DATA),A
		INC 	HL
		DEC 	B
		JR 	NZ,	wrByte

		DEC 	C
		JR 	NZ,	wr4secs

		LD		A, 0H
		OUT		(SD_DATA), A ; Send fake CRC byte 1
		OUT		(SD_DATA), A ; Send fake CRC byte 2

		CALL	sdWait
		LD		(ercode), A
		
		AND		01FH
		
		CP		05H ; Check that data accepted
		LD		A, 2 ; Set error to 2 (Data not accepted by SD Card)
		JP NZ,	wrExit
		
		LD		BC, SD_WAIT_WR ; cycles to write complete
wrWait1:
		CALL	sdWait

		CP		0
		JR NZ,	wrWait2
		
		DEC		C
		JR NZ,	wrWait1
		
		DEC		B
		JR NZ,	wrWait1
		
		LD		A, 3 ; Set error to 3 (Card timeout to write)
		JP		wrExit
wrWait2:
		XOR 	a
wrExit:
		ld	(erflag),a

		LD		A, 2
		OUT		(SD_CONFIG), A ; Set SD Slow mode, CS High

		POP 	HL
		POP 	BC
		POP 	AF

		RET

;================================================================================================
; SD Card send command (CMD = A, Op1 = lba3, Op2 = lba2, Op3 - lba1, Op4 = lba0, CRC = crc
;================================================================================================

sdSendCmd:
;		CALL	printHEX

		OUT		(SD_DATA), A
		CALL	SPIready
		
		LD		A, (lba3)
		OUT		(SD_DATA), A
		CALL	SPIready
		
		LD		A, (lba2)
		OUT		(SD_DATA), A
		CALL	SPIready
		
		LD		A, (lba1)
		OUT		(SD_DATA), A
		CALL	SPIready
		
		LD		A, (lba0)
		OUT		(SD_DATA), A
		CALL	SPIready
		
		LD		A, (crc)
		OUT		(SD_DATA), A
		CALL	SPIready
		
		RET

;================================================================================================
; SD Card wait for response (Return A = response)
;================================================================================================

sdWait:
		PUSH	BC
		
		LD		BC, SD_WAIT ; attempts to answer to CMD
sdWait1:
		LD		A, 0FFH
		OUT		(SD_DATA), A
		CALL	SPIready
		
		IN		A, (SD_DATA)
		
;		call printHEX
		
		CP		0FFH
		JR NZ,	sdWait2
		
		DEC		C
		JR NZ,	sdWait1

		DEC		B
		JR NZ,	sdWait1
		
sdWait2:		
		POP		BC
		RET

;================================================================================================
; SD Card Init procedure
;================================================================================================

sdInit:
		PUSH 	AF
		PUSH 	BC
		PUSH 	HL

		LD		A, 02h
		OUT		(SD_CONFIG), A ; Set Slow mode, CS High
		
		LD		B, 10
sdInit1:
		LD		A, 0FFh
		OUT		(SD_DATA), A
		CALL	SPIready
		
		DEC		B
		JR NZ,	sdInit1

		LD		A, 0
		OUT		(SD_CONFIG), A ; Set Slow mode, CS Low
		CALL	SPIready

		LD		B, 4 ; Try 4 times to send CMD0
sdInit0:
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready

		LD		A, 0
		LD		(lba0), A
		LD		(lba1), A
		LD		(lba2), A
		LD		(lba3), A
		LD		A, 095H
		LD		(crc), A
		LD		A, 040H + 0
		CALL	sdSendCmd ; Send CMD0 command
		
		CALL	sdWait
		LD		(ercode), A

		CP		01H
		JP Z,	sdInit8 ; CMD 0 applied
		
		DEC		B
		JR NZ,	sdInit0

		LD		A, 01H ; Set Error Code to 1 (Stop at CMD0)
		JP		sdInitX
sdInit8:
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready
		
		LD		A, 0AAh
		LD		(lba0), A
		LD		A, 01H
		LD		(lba1), A
		LD		A, 0
		LD		(lba2), A
		LD		A, 0
		LD		(lba3), A
		LD		A, 086H
		LD		(crc), A
		LD		A, 040H + 8
		CALL	sdSendCmd ; Send CMD8 command (Argument = 0x000001AA)
		
		CALL	sdWait
		LD		(ercode), A
		
		CP		05H	; CMD8 command not supported
		JR Z,	sdInitOldSD
		
		CP		01H
		LD		A, 02H ; Set Error Code to 2 (Stop at CMD8)
		JP NZ,	sdInitX ; Exit with error
		
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
;		CALL	printHEX

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
;		CALL	printHEX

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
		LD		(ercode), A
;		CALL	printHEX

		CP		01H
		JR Z,	sdInit2

		LD		A, 03H ; Set Error Code to 3 (Card voltage out of range)
		JP		sdInitX ; Exit with error
sdInit2:
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
		LD		(ercode), A
;		CALL	printHEX

		CP		0AAH
		JR Z,	sdInit3
		
		LD		A, 03H ; Set Error Code to 3 (Card voltage out of range)
		JP		sdInitX ; Exit with error
sdInit3:
		LD		A, 040H
		LD		(sdhcs), A
		
sdInitOldSD:

		LD		B, SD_WAIT_I ; Try to init with ACMD41 X times
sdInit4:		
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready

		LD		A, 0
		LD		(lba0), A
		LD		(lba1), A
		LD		(lba2), A
		LD		(lba3), A
		LD		(crc), A
		LD		A, 040H + 55
		CALL	sdSendCmd ; Send CMD55 command
		
		CALL	sdWait
		LD		(ercode), A
		
		CP		05H	; CMD55 command not supported
		JR Z,	sdInit5

		CP		01H
		LD		A, 04H ; Set Error Code to 4 (Stop at CMD55)
		JP NZ,	sdInitX ; Exit with error
		
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready
		
		LD		A, 0
		LD		(lba0), A
		LD		(lba1), A
		LD		(lba2), A
		LD		A, (sdhcs)
		LD		(lba3), A
		LD		A, 0
		LD		(crc), A
		LD		A, 040H + 41
		CALL	sdSendCmd ; Send ACMD41 command
		
		CALL	sdWait
		LD		(ercode), A
		
		CP		05H	; ACMD41 command not supported
		JR Z,	sdInit5

		CP		00H
		JP Z,	sdInitCpl ; Init complete
		
		CP		01H
		LD		A, 05H ; Set Error Code to 5 (Stop at ACMD41)
		JP NZ,	sdInitX ; Exit with error
		
		DEC		B
		JR NZ,	sdInit4
		
		LD		A, 06H ; Set Error Code to 6 (Init timeout)
		JP		sdInitX ; Exit with error
sdInit5:
		LD		B, SD_WAIT_I ; Try to init with CMD1 X times
sdInit6:		
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready

		LD		A, 0
		LD		(lba0), A
		LD		(lba1), A
		LD		(lba2), A
		LD		(lba3), A
		LD		(crc), A
		LD		A, 040H + 1
		CALL	sdSendCmd ; Send CMD1 command
		
		CALL	sdWait
		LD		(ercode), A

		CP		00H
		JP Z,	sdInitCpl ; Init complete
		
		CP		01H
		LD		A, 07H ; Set Error Code to 7 (Stop at CMD1)
		JP NZ,	sdInitX ; Exit with error
		
		DEC		B
		JR NZ,	sdInit6
		
		LD		A, 06H ; Set Error Code to 6 (Init timeout)
		JP		sdInitX ; Exit with error

sdInitCpl:

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready

		LD		A, 0
		LD		(lba0), A
		LD		(lba1), A
		LD		(lba2), A
		LD		(lba3), A
		LD		(crc), A
		LD		A, 040H + 58
		CALL	sdSendCmd ; Send CMD58 command
		
		CALL	sdWait
		LD		(ercode), A

		CP		0
		LD		A, 08H ; Set Error Code to 8 (Stop at CMD58)
		JP NZ,	sdInitX ; Exit with error

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
		LD		B, A
;		CALL	printHEX

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
;		CALL	printHEX

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
;		CALL	printHEX

		LD		A, 0FFH
		OUT		(SD_DATA), A ; Send FF to read a byte
		CALL	SPIready
		IN		A, (SD_DATA)
;		CALL	printHEX
		
		LD		A, B
		LD		(sdhcs), A
		AND		040H
		JR NZ,	sdInit7 ; SD Card is high capacity, no need to set 512 large blocks
		
		LD		A, 0FFH
		OUT		(SD_DATA), A ; Skip a 8 clock, some card required this
		CALL	SPIready

		LD		A, 0
		LD		(lba0), A
		LD		A, 02H ; Set block size = 512 bytes
		LD		(lba1), A
		LD		A, 0
		LD		(lba2), A
		LD		(lba3), A
		LD		(crc), A
		LD		A, 040H + 16
		CALL	sdSendCmd ; Send CMD16 command
		
		CALL	sdWait
		LD		(ercode), A

		CP		0
		LD		A, 09H ; Set Error Code to 9 (Stop at CMD16)
		JP NZ,	sdInitX ; Exit with error
sdInit7:
		LD		A, 0
sdInitX:
		LD		(erflag), A

		LD		A, 2
		OUT		(SD_CONFIG), A ; Set SD Slow mode, CS High

		POP 	HL
		POP 	BC
		POP 	AF

		RET

;================================================================================================
; Utilities
;================================================================================================

printInline:
		EX 	(SP),HL 	; PUSH HL and put RET ADDress into HL
		PUSH 	AF
		PUSH 	BC
nextILChar:	LD 	A,(HL)
		CP	0
		JR	Z,endOfPrint
		LD  	C,A 
		CALL 	conout		; Print to TTY
		iNC 	HL
		JR	nextILChar
endOfPrint:	INC 	HL 		; Get past "null" terminator
		POP 	BC
		POP 	AF
		EX 	(SP),HL 	; PUSH new RET ADDress on stack and restore HL
		RET

printHEX:
		PUSH AF
		PUSH BC

		LD	B, A

		RRC	A
		RRC	A
		RRC	A
		RRC	A
		
		AND 0FH
		
		CP	10
		JR	C, pHEX1
		
		ADD A, 7
pHEX1:
		ADD	A, 30H
		LD	C, A
		CALL conout

		LD	A, B

		AND 0FH
		
		CP	10
		JR	C, pHEX2
		
		ADD A, 7
pHEX2:
		ADD	A, 30H
		LD	C, A
		CALL conout
		
		POP BC
		POP AF

		RET

SPIready:
		PUSH	AF
SPIr1:
		IN		A, (SD_CONFIG)
		AND		01H
		JR NZ,	SPIr1

		POP		AF
		
		RET

;================================================================================================
; Data storage
;================================================================================================

dirbuf: 	.ds 128 		;scratch directory area
alv00: 		.ds 257			;allocation vector 0
alv01: 		.ds 257			;allocation vector 1
alv02: 		.ds 257			;allocation vector 2
alv03: 		.ds 257			;allocation vector 3
alv04: 		.ds 257			;allocation vector 4
alv05: 		.ds 257			;allocation vector 5
alv06: 		.ds 257			;allocation vector 6
alv07: 		.ds 257			;allocation vector 7
alv08: 		.ds 257			;allocation vector 8
alv09: 		.ds 257			;allocation vector 9
alv10: 		.ds 257			;allocation vector 10
alv11: 		.ds 257			;allocation vector 11
;alv12: 		.ds 257			;allocation vector 12
;alv13: 		.ds 257			;allocation vector 13
;alv14: 		.ds 257			;allocation vector 14
;alv15: 		.ds 257			;allocation vector 15

lba0		.DB	00h
lba1		.DB	00h
lba2		.DB	00h
lba3		.DB	00h
crc			.DB 00h
sdhcs		.DB 00h

			.DS	040h		; Start of BIOS stack area.

biosstack:	.EQU	$

sekdsk:		.ds	1		;seek disk number
sektrk:		.ds	2		;seek track number
seksec:		.ds	2		;seek sector number
;
hstdsk:		.ds	1		;host disk number
hsttrk:		.ds	2		;host track number
hstsec:		.ds	1		;host sector number
;
sekhst:		.ds	1		;seek shr secshf
hstact:		.ds	1		;host active flag
hstwrt:		.ds	1		;host written flag
;
unacnt:		.ds	1		;unalloc rec cnt
unadsk:		.ds	1		;last unalloc disk
unatrk:		.ds	2		;last unalloc track
unasec:		.ds	1		;last unalloc sector
;
erflag:		.ds	1		;error reporting
ercode:		.ds 1		;error code
rsflag:		.ds	1		;read sector flag
readop:		.ds	1		;1 if read operation
wrtype:		.ds	1		;write operation type
dmaAddr:	.ds	2		;last dma address
hstbuf:		.ds	512		;host buffer

hstBufEnd:	.EQU	$

serABuf:	.ds	SER_BUFSIZE	; SIO A Serial buffer
serAInPtr	.DW	00h
serARdPtr	.DW	00h
serABufUsed	.DB	00h
serBBuf:	.ds	SER_BUFSIZE	; SIO B Serial buffer
serBInPtr	.DW	00h
serBRdPtr	.DW	00h
serBBufUsed	.DB	00h

serialVarsEnd:	.EQU	$


biosEnd:	.EQU	$


; Disable the ROM, pop the active IO port from the stack (supplied by monitor),
; then start CP/M

		.org 0FFD3H
popAndRun:
		LD	A,$01 
		OUT	($38),A ; Disable the ROM

		POP	AF
		CP	$01
		JR	Z,consoleAtB
		LD	A,$01 ;(List is TTY:, Punch is TTY:, Reader is TTY:, Console is CRT:)
		JR	setIOByte
consoleAtB:
		LD	A,$00 ;(List is TTY:, Punch is TTY:, Reader is TTY:, Console is TTY:)
setIOByte:
		LD (iobyte),A
		JP	bios


;=================================================================================
; Relocate TPA area from 4100 to 0100 then start CP/M
; Used to manually transfer a loaded program after CP/M was previously loaded
; ,    /  ,    ,
;          ,   
;   -  ,  ,   
;=================================================================================

		.org	0FFE8H
		LD	A,$01
		OUT	($38),A

		LD	HL,04100H
		LD	DE,00100H
		LD	BC,08F00H
		LDIR
		JP	bios

;=================================================================================
;   IM2
;=================================================================================
		.ORG 0FFFAH
		.dw serialInt

; 8    + 2   2 ,  ""  D0  D2,   FA
;           /IM  /IORQ
;             
;     5V- - ,          CF-


;=================================================================================
;      VT52
;=================================================================================
		.ORG 0FFFCH
		NOP ;     
		NOP

;=================================================================================
; Normal start CP/M vector
;=================================================================================

		.ORG 0FFFEH
		.dw	popAndRun

		.END
