library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity kmport is
   port
   (
	A        : in  std_logic_vector (7 downto 0);	--Address bus
	D        : out std_logic_vector (7 downto 0);	--Data bus output (to Speccy)
	DI       : in  std_logic_vector (7 downto 0);	--Data bus input (to read data from ATTiny)

	nIORQ    : in  std_logic;
	nRD       : in  std_logic;
	nM1       : in  std_logic;
	
	nPORTSEL  : out  std_logic		--PortSelect signal
--	nDATAOE	: out  std_logic;		--Databuffer OE signal

--	CLK	: in  std_logic

   );
end kmport;

architecture RTL of kmport is
begin
 nPORTSEL <= '0' when A(7 downto 0) = "11011111" and nM1 = '1' and nIORQ = '0' else '1';
 D <= DI when A(7 downto 0) = "11011111" and nM1 = '1' and nIORQ = '0' and nRD = '0' else "ZZZZZZZZ";
end architecture;