CONST
  VHIGH = 500B; 	{THE MOST HIGH VECTOR}
  VLOW	 = 60B;		{THE MOST LOWER VECTOR}

  INDA=010B;
  INDB=100B;
  INDC=200B;
  INDD=001B;
  INDE=040B;
  INDF=020B;
  INDG=002B;
  INDH=004B;

  SEMLEN	= 8;
  REGLEN	= 12;
  PROLEN	= 62;


TYPE
  STR20 = PACKED ARRAY [1..20] OF CHAR;

  REGDES  = RECORD		{REGISTER DESCRIPTOR]
		RMASK,		{BIT-MASK TO RESTORE REG}
		RCOPY:		{COPY OF R/O BITS}
			INTEGER;
		RRQST,		{REQUESTED OPERATION ON REG}
		RSTAT:		{PROPER ACTIONS ON REG}
			CHAR;
		RPROC,		{POINTER TO PROCESS TO OPERATE THE REG}
		RSTRT,		{PARAMETER WORD FOR PROCESSING (USER DEFINED)}
		RRESET:	{THIS WORD MOVED TO THE REG ON RESET (NOTHING IF -1)}
			INTEGER
	    END;


  PRODES = RECORD		{PROCESS DESCRIPTOR}
		PSUCC,		{POINTER TO SUCC PROC IN QUEUES}
		PPRED,		{POINTER TO PRED PROC IN QUEUES}
		PR0,		{CONTENTS OF CPU REGS}
		PR1,
		PR2,
		PR3,
		PR4,
		PR5,
		PSP,
		PPC,
		PPS,
		PUR0,		{CONTENTS OF MEMORY CONTROL REGS}
		PUR1,
		PUR2,
		PUR3,
		PUR4,
		PUR5,
		PUR6,
		PUR7,
		PMASK,		{BIT-MASK TO DESABLE INTS DURING PROCESSING}
			{(BIT15=1 => CAN HAVE VECTORED INTS, I.E. SIMULATED)}
		PCPRC,		{POINTER TO PROCESS, WAITING REG'S EMULATION}
		PTIM,		{TIME PERIOD FOR SLEEPPING}
		PPRI,		{PRIORITY OF THE PROCESS}
		PMEM:		{POINTER TO RAM-MAP FOR THE PROCESS (OR 0, IF NONE)}
			INTEGER;
		PNAME: ARRAY [1..8] OF INTEGER;	{process name}
		PTIM0,
		PTIM1,
		PDSUCC:	  {ptr on succ}
			INTEGER
	   END;


  SEM  = RECORD			{SEMAPHORE}
		SCNTR,		{SEM'S COUNTER}
		SFRST,		{POINTER TO QUEUE OF WAITING PROCESSES}
		SSUCC,		{DUMMY QUEUE-HEAD OF}
		SPRED:		{WAITING PROCESSES}
			INTEGER
	  END;



{****************************************************************}
CONST	(* common definitions for WINDOW-monitor *)

  vd208	= 1400B;	(* video-density *)
  vd104	= 1000B;
  vd52	= 0400B;
  vd52s	= 0000B;

  vm1	= 000B;		(* video-mode (bits per point) *)
  vm2	= 001B;
  vm40	= 002B;
  vm41	= 003B;

  pl0	= 00000B;	(* pal number *)
  pl1	= 40000B;
  pl2	= 100000B;
  pl3	= 140000B;

  VMASK	= 200B;
  VDX	= 100B;
  VDY	= 040B;
  VVP	= 030B;
  VVV	= 020B;
  VPV	= 010B;
  VCV	= 000B;
  VBIC	= 006B;
  VBIS	= 004B;
  VXOR	= 002B;
  VBYTE	= 001B;

TYPE

  PALTYP = RECORD
		CODE	: INTEGER;
		MODPAL	: INTEGER;
		C	: ARRAY [0..15] OF CHAR;
	    END;

  ARETYP = RECORD
		ANUM	: INTEGER;
		LINS	: INTEGER;
		SLEN	: INTEGER;
		MODPAL	: INTEGER;
		AMMR	: INTEGER;
		NPAGE	: INTEGER;
	   END;

  WINTYP = RECORD
		CODE	: INTEGER;
		WNUM	: INTEGER;
		AREA	: INTEGER;
		ARY	: INTEGER;
		ARX	: INTEGER;
		SY1	: INTEGER;
		SY2	: INTEGER;
		SX1	: INTEGER;
		SX2	: INTEGER;
		DEN	: INTEGER;
	   END;
  
  FNTYP	= RECORD
		CODE	: INTEGER;
		PAR	: INTEGER;
		FNNAME	: STR20
	  END;

(*--------------------------------------------------------*)

VAR

  HEAP ORIGIN 100000B : INTEGER;		{HEAP POINTER}
  HSTACK ORIGIN 140000B : INTEGER;	 	{BOTTOM OF HALT-STACK}

	PICCSR ORIGIN 161000B,	{ 8259 }
	PICMR ORIGIN 161002B : INTEGER;

	SNDC0R ORIGIN 161010B,	{ 8253.F }
	SNDC1R ORIGIN 161012B,  
	SNDC2R ORIGIN 161014B,
	SNDCSR ORIGIN 161016B : INTEGER;

	SNLC0R ORIGIN 161020B,	{ 8253.L }
	SNLC1R ORIGIN 161022B,
	SNLC2R ORIGIN 161024B,
	SNLCSR ORIGIN 161026B : INTEGER;

	PPIA ORIGIN 161030B,	{ PPI }
	PPIB ORIGIN 161032B : INTEGER;
	
	PPIC ORIGIN 161034B : INTEGER;

	PPIP ORIGIN 161036B : INTEGER;

	KBDBUF ORIGIN 161040B,	{ 8279 KBD }
	KBDCSR ORIGIN 161042B : INTEGER;	   

	DLBUF ORIGIN 161060B,	{ 8251A UART }
	DLCS ORIGIN  161062B : INTEGER;

	HR0 ORIGIN 161200B,	{ MMU reg. }
	HR1 ORIGIN 161202B,	      
	HR2 ORIGIN 161204B,
	HR3 ORIGIN 161206B,
	HR4 ORIGIN 161210B,
	HR5 ORIGIN 161212B,
	HR6 ORIGIN 161214B,
	HR7 ORIGIN 161216B,
	UR0 ORIGIN 161220B,
	UR1 ORIGIN 161222B,
	UR2 ORIGIN 161224B,
	UR3 ORIGIN 161226B,
	UR4 ORIGIN 161230B,
	UR5 ORIGIN 161232B,
	UR6 ORIGIN 161234B,
	UR7 ORIGIN 161236B : INTEGER;

        WCSR ORIGIN 177530B : INTEGER; (* reg for WINDOW control *)
                                                    