(*$T-*)
(*$A-*)
(*$S+*)


VAR
  A2W : RECORD CASE INTEGER OF
	1: (W : INTEGER);	
	2: (A : ^INTEGER);
	3: (AC : ^CHAR);
	END;


(*--------------------------------------------------------*)

PROCEDURE ARGET ( VAR AR :ARETYP);
VAR
  W : RECORD
	CODE	: INTEGER;
	ANUM	: INTEGER;
	LINS	: INTEGER;
	SLEN	: INTEGER;
	TAS	: ARRAY [1..300, 1..2] OF INTEGER;
      END;
  LINP, NPAGE, MMR, VADR, MODPAL, I,J,K : INTEGER;

BEGIN
  W.CODE := 0;
  W.ANUM := AR.ANUM;
  W.LINS := AR.LINS;
  W.SLEN := AR.SLEN;
  LINP := 8192 DIV W.SLEN;
  
  IF AR.AMMR=0 THEN
  BEGIN
  NPAGE := (W.LINS + LINP - 1) DIV LINP;
  AR.NPAGE := NPAGE;
    (*$C
	MOV	NPAGE(6),@#^O174200 ;GET8K
	NOP
	MOV	R0, MMR(6)
    *)
    AR.AMMR := MMR;
  END
  ELSE
    MMR := AR.AMMR;
  VADR := 0;
  MODPAL := AR.MODPAL;
  WITH W DO
  bEGIN
    FOR I := 1 TO LINS DO
    BEGIN
      TAS[I,1] := VADR;
      TAS[I,2] := MMR + MODPAL; 
      VADR := VADR + SLEN;
      IF VADR >= 10000B THEN
      BEGIN
        VADR := VADR AND 7777B;
        MMR := MMR + 20B;
      END;
      IF (I MOD LINP) = 0 THEN
      BEGIN
	VADR := 0;
	MMR := MMR + 20B;
      END;
    END;
    A2W.A := @CODE;
    WCSR := A2W.W;
    A2W.W := ANUM;
    AR.ANUM := ANUM;
  END; (* WITH W *)
  HBMOVE(AR.ANUM,VCV,0,AR.LINS,0,AR.SLEN,0,0,0);
END;

PROCEDURE ARFRE ( VAR AR :ARETYP);
VAR
  W : RECORD
       CODE : INTEGER;
       ANUM : INTEGER;
      END;
  LINP, NPAGE, MMR, I,J,K : INTEGER;
  WR : WINTYP;

BEGIN
  WITH W DO
  BEGIN
    CODE := 2;
    ANUM := AR.ANUM;
    A2W.A := @CODE;
    WCSR := A2W.W;
  END;
  NPAGE := AR.NPAGE;
  MMR := AR.AMMR;
    (*$C
	MOV	MMR(6), R0
	MOV	NPAGE(6),@#^O174202 ; FREMEM
    *)
   AR.ANUM := 0;
   AR.AMMR := 0;
END;

(*--------------- MAIN DATA BASE -------------------------*)
type
  str10 = array [1..10] of char;
const
  Gray = 216B;
  Blue = 002B;
var
  BGLine : array [1..26] of integer;
  BGAR, TXAR, TX1AR, RNAR, SHAR, VEAR, GOAR, SAAR, CAAR, MYAR : AreTyp;
  BGWN, TXWN, TX1WN, RNWN, SHWN, VEWN, GOWN, SAWN, CAWN, MYWN : WinTyp;
  VM1PL0, VM1PL1 : PalTyp;
  TX1, TX2, TX3 : Str20;
  CLINE : array [1..16, 0..17] of integer;
  PIC1AR, PIC2AR, PIC3AR, PIC4AR, PIC5AR : AreTyp;
  PIC1WN, PIC2WN, PIC3WN, PIC4WN, PIC5WN : WinTyp;
(*---------------- MAIN PROCEDURES -----------------------*)

procedure Delay ( D :integer);
var
  I, J : integer;
begin
  for I := 1 to D do J := I + 8;
end;

procedure LDelay ( D :integer);
var
  I : integer;
begin
  for I := 1 to D do Delay(21425);
end;

procedure Rwprint( ANUM, COL, X, Y, N :integer; S : str20);
var
  W : array [1..25] of char;
  C, I : integer;
begin
  C := abs(COL);
  IF COL > 0 THEN W[1] := CHR(6) ELSE W[1] := CHR(5);
  W[2] := chr(7); W[3] := chr(C*16);
  for I := 1 to N do
  begin
    W[3+I] := S[I];
  end;
  W[N+4] := chr(0);
  Wprint(ANUM,X,Y,W[1]);
end;

procedure PutWin (var WIN : WinTyp; X, Y : integer);
begin
  with WIN do
  begin
    SX2 := X + SX2 - SX1;
    SX1 := X;
    SY2 := Y + SY2 - SY1;
    SY1 := Y;
  end;
  VWCRE(WIN);
end;

procedure WHMove ( var WIN :WinTyp; D :integer);
var
  I,J,N : integer;
begin
  N := abs(D);
  J := N div D;
  for I := 1 to N do
  begin
    WIN.SX1 := WIN.SX1 + J;
    WIN.SX2 := WIN.SX2 + J;
    VWCRE(WIN);
  end;
end;

procedure WVMove ( var WIN :WinTyp; D :integer);
var
  I,J,N : integer;
begin
  I := D div 8;
  N := abs(I);
  J := (D div N);
  for I := 1 to N do
  begin
    WIN.SY1 := WIN.SY1 + J;
    WIN.SY2 := WIN.SY2 + J;
    VWCRE(WIN);
  end;
end;

procedure ReadPic;
var
  PAL : PalTyp;
  I, J : integer;

  procedure LoadATR(name :str10; var AR :AreTyp; var WIN :WinTyp; X,Y : integer);
  var
    FATR : file of array [0..159] of char;
    FA2W : record case integer of
            1: (W : integer);
            2: (A : ^char);
           end;
  begin
    RESET(FATR, name, 'atr');
    with PAL do
    begin
      for I := 0 to 15 do
        C[I] := FATR^[I * 2];
      MODPAL := vm40;
    end;
    PLCRE(PAL);
    with AR do
    begin
     ANUM := 0;
     LINS := 200;
     SLEN := 160;
     MODPAL := PAL.MODPAL;
     AMMR := 0;
    end;
    ARGET(AR);
    with WIN do
    begin
      AREA := AR.ANUM;
      WNUM := 0;
      DEN := 2 * 256 + 2;
      ARY := 0;
      ARX := 0;
      SY1 := Y;
      SY2 := Y + 200;
      SX1 := X;
      SX2 := X + 20;
    end;
    VWCRE(WIN);
    for I := 0 to 199 do
    begin
      GET(FATR);
      FA2W.A := @FATR^[0];
      HBMOVE(AR.ANUM,VPV,I,1,0,160,FA2W.W,0,0);
    end;
   CLOSE(FATR);
  end;

begin
  LoadATR('PIC1/SPAN ', PIC1AR, PIC1WN, 1, 25);
  LDelay(2);
  LoadATR('PIC2/SPAN ', PIC2AR, PIC2WN, 3, 45);
  LDelay(2);
  LoadATR('PIC3/SPAN ', PIC3AR, PIC3WN, 5, 65);
  LDelay(2);
  LoadATR('PIC4/SPAN ', PIC4AR, PIC4WN, 7, 85);
  LDelay(2);
  LoadATR('PIC5/SPAN ', PIC5AR, PIC5WN, 9, 105);
  LDelay(2);
end;

procedure TXArea;
var
  PAL : PalTyp;
begin
  with PAL do
  begin
   MODPAL := vm41;
   C[ 0]:=chr(Gray); C[ 1]:=chr(034B); C[ 2]:=chr(374B); C[ 3]:=chr(334B);    
   C[ 4]:=chr(156B); C[ 5]:=chr(377B); C[ 6]:=chr(266B); C[ 7]:=chr(000B);    
   C[ 8]:=chr(340B); C[ 9]:=chr(303B); C[10]:=chr(034B); C[11]:=chr(234B);    
   C[12]:=chr(172B); C[13]:=chr(374B); C[14]:=chr(374B); C[15]:=chr(000B);    
  end;
  PLCRE(PAL);
  with TXAR do
  begin
    ANUM := 0;
    LINS := 160;
    SLEN := 160;
    MODPAL := PAL.MODPAL;
    AMMR := 0;
  end;
  ArGet(TXAR);
  with TX1AR do
  begin
    ANUM := 0;
    LINS := 30;
    SLEN := 80;
    MODPAL := PAL.MODPAL;
    AMMR := 0;
  end;
  ArGet(TX1AR);
end;

PROCEDURE BGArea;
const
  blins = 300;
  bslen = 52;
VAR
  W : RECORD
	CODE	: INTEGER;
	ANUM	: INTEGER;
	LINS	: INTEGER;
	SLEN	: INTEGER;
	TAS	: ARRAY [1..300, 1..2] OF INTEGER;
      END;
  LINP, NPAGE, MMR, VADR, MODPAL, I,J,K : INTEGER;
  PAL : PALTYP;

BEGIN
  FOR I := 0 TO 15 DO
    PAL.C[I] := CHR(216B);
  PAL.MODPAL := vm2;
  PLCRE(PAL);
  BGAR.lins := blins;
  BGAR.slen := bslen;
  BGAR.modpal := PAL.MODPAL; 
  W.CODE := 0;
  W.ANUM := 0;
  W.LINS := bLINS;
  W.SLEN := bSLEN;
  (*$C
	mov	r5, r0
	add	#BGLine, r0
	mov	r0, vadr(6)
	ash	#-13., r0
	asl	r0
	mov	^O161220(r0), mmr(6)
  *)
  MMR := MMR + BGAR.MODPAL;
  WITH W DO
  BEGIN
    FOR I := 1 TO LINS DO
    BEGIN
      TAS[I,1] := VADR;
      TAS[I,2] := MMR; 
    END;
    A2W.A := @CODE;
    WCSR := A2W.W;
    A2W.W := ANUM;
    BGAR.ANUM := ANUM;
  END; (* WITH W *)
  WITH BGWN DO
  BEGIN
    AREA := BGAR.ANUM;
    WNUM := 0;
    DEN := 0;
    ARY := 0;
    ARX := 0;
  END;
END;

procedure BgCre(var W, B :WinTyp; N :integer);
begin
  with B do
  begin
    AREA := BGAR.ANUM;
    sy1 := W.sy1+12*N;
    sy2 := W.sy2+12*N;
    sx1 := W.sx1+1*N;
    sx2 := W.sx2+1*N;
    DEN := 0;
    ARX := 0;
    ARY := 0;
  end;
  VWCre(B);
end;

procedure HideVT( COL :integer);
var
  PAL : PalTyp;
  I : integer;
begin
  VM1PL0.MODPAL := VM1 + PL0;
  PLSAV(VM1PL0);
  VM1PL1.MODPAL := VM1 + PL1;
  PLSAV(VM1PL1);
  for I := 0 to 15 do
    PAL.C[I] := chr(COL);
  PAL.MODPAL := VM1 + PL0;
  PlMod(PAL);
  PAL.MODPAL := VM1 + PL1;
  PlMod(PAL);
end;

procedure ShowVT( COL :integer);
begin
  PlMod(VM1PL0);
  PlMod(VM1PL1);
end;

procedure ClearTX;
begin
TX1 := '                    ';
TX2 := TX1;
TX3 := TX1;
end;

procedure OpenTX;
var
  I : integer;
  PAL : PalTyp;
begin
  HBMOVE(TXAR.ANUM,VCV,0,100,0,100,0,0,0);
  PAL.MODPAL := TXAR.MODPAL;
  PlSav(PAL);
  PAL.C[0] := chr(142B);
  PlMod(PAL);
  Rwprint(TXar.anum, 7, 5, 12, 20, TX1);
  Rwprint(TXar.anum,-2, 4, 10, 20, TX1);
  Rwprint(TXar.anum, 7, 5, 32, 20, TX2);
  Rwprint(TXar.anum,-2, 4, 30, 20, TX2);
  Rwprint(TXar.anum, 7, 5, 52, 20, TX3);
  Rwprint(TXar.anum,-2, 4, 50, 20, TX3);
  with TXWN do
  begin
    WNUM := 0;
    AREA := TXAR.ANUM;
    SY1 := 120;
    SY2 := 120;
    SX1 := 12;
    SX2 := 12;
    ARX := 40;
    ARY := 80;
    DEN := 1 * 256 + 2;
  end;
  bgCre(TXWN,BGWN,1);
  FOR I := 1 TO 5 DO
  BEGIN
    TXWN.SY1 := TXWN.SY1 - 16;
    TXWN.SY2 := TXWN.SY2 + 16;
    TXWN.SX1 := TXWN.SX1 - 1;
    TXWN.SX2 := TXWN.SX2 + 1;
    TXWN.ARY := TXWN.ARY - 16;
    TXWN.ARX := TXWN.ARX - 8;
    VWCRE(TXWN);
  END;
  bgCre(TXWN,BGWN,1);
end;

procedure CloseTX;
var
  I : integer;
begin
  VWkill(BGWN); 
  FOR I := 1 TO 5 DO
  BEGIN
    TXWN.SY1 := TXWN.SY1 + 16;
    TXWN.SY2 := TXWN.SY2 - 16;
    TXWN.SX1 := TXWN.SX1 + 1;
    TXWN.SX2 := TXWN.SX2 - 1;
    TXWN.ARY := TXWN.ARY + 16;
    TXWN.ARX := TXWN.ARX + 8;
    VWCRE(TXWN);
  END;
  VWKILL(TXWN);
END;

procedure Present;
var
  X,Y,I,J,K,L,M,N, ADR, CMD : integer;
  BG, VEWN : WinTyp;
  ST1, ST2 : STR20;

  procedure Scprint(ST : str20; SHDW, NUM : integer);
  begin
    Rwprint(TXar.anum, 7, 11, 142, 19, st);
    Rwprint(TXar.anum,-SHDW, 10, 140, 19, st);
    CMD := VVV + VBYTE ;
    FOR J := 140 downto NUM DO
      HBMOVE(TXAR.ANUM,CMD, J-1, 14, 10, 72, TXAR.ANUM, J, 10);
  end;

begin
  with TXWN do
  begin
    WNUM := 0;
    AREA := TXAR.ANUM;
    ARY := 0;
    ARX := 0;
    SY1 := 8;
    SY2 := 300;
    SX1 := 2;
    SX2 := 23;
    DEN := 1 * 256 + 1;
  end;
  VWCre(TXWN);
  ST1 := ' ᮭ쭠    ';
  ST2 := '      - 11/16     ';
  Scprint(ST1, 2, 2);
  Scprint(ST2, 2, 16);
  Scprint('ய      ',  8,  40);
  Scprint('   18062 / 8   ',  8,  52);
  Scprint('⨢   ',  9,  64);
  Scprint('   512 - 4    ',  9,  76);
  Scprint('        ', 10,  88);
  Scprint('   ஫  ', 10, 100);
  Scprint(' 600 梥⮢    ', 11, 112);
  Scprint('  ࠭ ᯫ  ', 11, 124);
  LDelay(6);
  WITH TX1WN DO
  begin
    WNUM := 0;
    AREA := TX1AR.ANUM;
    ARY := 0;
    ARX := 0;
    SY1 := 4;
    SY2 := 30;
    SX1 := 1;
    SX2 := 12;
    DEN := 2 * 256 + 2;
  end;
  Rwprint(TX1ar.anum, 7, 3,  4, 17, ST1);
  Rwprint(TX1ar.anum,-2, 2,  2, 17, ST1);
  Rwprint(TX1ar.anum, 7, 3, 14, 17, ST2);
  Rwprint(TX1ar.anum,-2, 2, 12, 17, ST2);
  VWKILL(TXWN);
  VWCRE(TX1WN);
end;

PROCEDURE Color64;
VAR
  W : RECORD
	CODE	: INTEGER;
	ANUM	: INTEGER;
	LINS	: INTEGER;
	SLEN	: INTEGER;
	TAS	: ARRAY [1..300, 1..2] OF INTEGER;
      END;
  MMR, VADR, D,RGB,I,J,K,TAS2 : INTEGER;
  WIN : WinTyp;
  PAL : PlxTyp;
  AR : AreTyp;

  PROCEDURE CRPAL256;
  VAR
    BR, RH, RL, BG, GH, GL : INTEGER;
  BEGIN
    K := 0;
    WITH PAL DO
      FOR I := 0 TO 15 DO
        FOR J := 0 TO 15 DO
        BEGIN
          BR := I * 2; (* BITS 4,3,2,1 *)
          BG := J * 4; (* BITS 5,4,3,2 *)
          RH := BR AND 34B; (* R4 R3 R2 *)
          RL := (BR AND 3) * 8; (* R1 R0=0 *)
          GH := (BG AND 70B) * 4; (* G5 G4 G3 *)
          GL := (BG AND 7) * 32; (* G2,G1=0,G0=0 *)
          CH[K] := CHR(RH + GH);
          CL[K] := CHR(RL + GL);
          K := K + 1;
        END; (*FOR*)
    PLMODx(PAL);
  END;

  PROCEDURE RTPAL256;
  VAR
    CNT, PLH, PLL, BLUE, BH, BL, ADDBL : INTEGER;
  BEGIN
    BLUE := 0; ADDBL := 1;
    FOR CNT := 1 TO 62 DO
    BEGIN
      Delay(10000);
      K := 0;
      BH := (BLUE AND 30B) DIV 8;
      BL := BLUE AND 7;
      WITH PAL DO
        FOR I := 0 TO 15 DO
          FOR J := 0 TO 15 DO
          BEGIN
            PLH := ORD(CH[K]);
            PLL := ORD(CL[K]);
            PLH := (PLH AND 374B) + BH;
            PLL := (PLL AND 370B) + BL;
            CH[K] := CHR(PLH);
            CL[K] := CHR(PLL);
            K := K + 1;
          END;
      PLMODx(PAL);
      BLUE := BLUE + ADDBL;
      BLUE := BLUE MOD 32;
      IF BLUE=0 THEN
      BEGIN
        ADDBL := -ADDBL;
        BLUE := 30;
      END;
    END;
  END;

BEGIN
  W.CODE := 0;
  W.ANUM := 0;
  W.LINS := 64;
  W.SLEN := 36;
  (*$C
	mov	r5, r0
	add	#CLINE, r0
	mov	r0, r1
	bic	#^O160000, R1
	mov	r1, vadr(6)
	ash	#-13., r0
	BIC	#^O177770, R0
	asl	r0
	add	#^O161220, r0
	mov	@r0, mmr(6)
  *)
      IF VADR >= 10000B THEN
      BEGIN
        VADR := VADR AND 7777B;
        MMR := MMR + 20B;
      END;
  PAL.MODPAL := vm8;
  PLCREx(PAL);
  TAS2 := PAL.MODPAL + MMR;
  CRPAL256;
  WITH W DO
  BEGIN
    FOR I := 1 TO 64 DO
      BEGIN
        TAS[I,1] := VADR;
        TAS[I,2] := TAS2; 
        IF (I MOD 4) = 0 THEN VADR := VADR + 36;
      END;
    A2W.A := @CODE;
    WCSR := A2W.W;
    A2W.W := ANUM;
    AR.ANUM := ANUM;
  END;
  WITH MYWN DO
  BEGIN
    AREA := W.ANUM;
    WNUM := 0;
    DEN := 0;
    ARY := 0; ARX := 2;
    SX1 := 5; SX2 := 20;
    SY1 := 32; SY2 := 32 + 250;
  END;
  MYAR:=AR;
  for I := 1 to 16 do
    for j := 0 to 15 do
    begin
      K := J + (I-1)*16;
      CLINE [I,J] := K*256+K;
    end;
  WIN.WNUM := 0;
  BgCre(MYWN,WIN,1);
  VWCre(MYWN);
  TX1 := '  256 梥⮢     ';
  TX2 := ' ⤥쭮    ';
  TX3 := ' 65535- ⥭   '; 
  OpenTX;
  Ldelay(3);
  CloseTX;
  RTPAL256;
  VWKILL(WIN);
  VWBACK(MYWN);
END;

procedure ColWprint(ST : str20; X, ChCol, BgCol : integer; var AR : AreTyp);
var
  STT : str20;
begin
  STT[1] := CHR(7);
  STT[2] := CHR(ChCol * 16 + BgCol);
  STT[3] := CHR(0);
  WPRINT(AR.ANUM, 1, X, STT[1]);
  STT := ST; STT[20] := CHR(0);
  WPRINT(AR.ANUM, 9, X * 10, STT[1]);
end;

procedure Pictures;
var
  I,J : integer;
  BG : WinTyp;
  PAL : PalTyp;
 
  procedure GetPal(var PAL : PalTyp; BGCOL, CHCOL : integer);
  begin
    with PAL do
    begin
      MODPAL := vm1;
      C[0]  := CHR(BGCOL); C[7]  := CHR(BGCOL); C[11] := CHR(BGCOL);
      C[13] := CHR(BGCOL); C[14] := CHR(BGCOL); C[15] := CHR(CHCOL);
    end;
    PLCRE(PAL);
  end;

  procedure CreSWWin(var WIN : WinTyp);
  begin
    with WIN do
    begin
      WNUM := 0;
      DEN := 2 * 256 + 2;
      SY1 := 162;
      SY2 := 182;
      SX1 := 13;
      SX2 := 13;
      ARY := 80;
      ARX := 40;
    end;
    for I := 1 to 5 do
    begin
      with WIN do
      begin
        SY1 := SY1 - 16;
        SY2 := SY2 + 16;
        SX1 := SX1 - 1;
        SX2 := SX2 + 1;
        ARY := ARY - 16;
        ARX := ARX - 8;
      end;
      VWCRE(WIN);
    end;
  end;

begin
  VEAR.ANUM := 0;
  VEAR.LINS := 180;
  VEAR.SLEN := 92;
  VEAR.AMMR := 0;
 
  GOAR := VEAR;
  SAAR := VEAR;
  CAAR := VEAR;

  GetPal(PAL, 34B, 377B);
  VEAR.MODPAL := PAL.MODPAL;
  GetPal(PAL, 340B, 0);
  GOAR.MODPAL := PAL.MODPAL;
  GetPal(PAL, 200B, 374B);
  SAAR.MODPAL := PAL.MODPAL;
  GetPal(PAL, 374B, 34B);
  CAAR.MODPAL := PAL.MODPAL;
 
  ArGet(VEAR);
  ArGet(GOAR);
  ArGet(SAAR);
  ArGet(CAAR);

  ColWprint('  ᨬ ',  1, 1, 4, VEAR);
  ColWprint('                    ',  2, 1, 4, VEAR);
  ColWprint('     ',  3, 1, 4, VEAR);
  ColWprint('᫥騥 ࠬ:',  4, 1, 4, VEAR);
  ColWprint(' - ०       ',  5, 1, 4, VEAR);
  ColWprint(' -           ',  6, 1, 4, VEAR);
  ColWprint(' - ⠡          ',  7, 1, 4, VEAR);
  ColWprint(' -       ',  8, 1, 4, VEAR);
  ColWprint('         ᪮  ',  9, 1, 4, VEAR);
  ColWprint(' -       ', 10, 1, 4, VEAR);
  ColWprint('         ᪮  ', 11, 1, 4, VEAR);
  ColWprint(' - ࠧ饭     ', 12, 1, 4, VEAR);
  ColWprint('         ࠭     ', 13, 1, 4, VEAR);
  ColWprint('                    ', 14, 1, 4, VEAR);

  ColWprint(' ०: ',  1, 2, 6, GOAR);
  ColWprint('  ',  2, 2, 6, GOAR);
  ColWprint('祪   -    ',  3, 2, 6, GOAR);
  ColWprint('ப   梥⮢    ',  4, 2, 6, GOAR);
  ColWprint('  ',  5, 2, 6, GOAR);
  ColWprint('  832       2      ',  6, 2, 6, GOAR);
  ColWprint('  832       4      ',  7, 2, 6, GOAR);
  ColWprint('  416      16      ',  8, 2, 6, GOAR);
  ColWprint('  208     256      ',  9, 2, 6, GOAR);
  ColWprint('                    ', 10, 2, 6, GOAR);
  ColWprint('      3 0 0         ', 11, 2, 6, GOAR);
  ColWprint('       ', 12, 2, 6, GOAR);
  ColWprint('                    ', 13, 2, 6, GOAR);
  ColWprint('                    ', 14, 2, 6, GOAR);

  ColWprint('ᨬ -   ',  1, 6, 12, SAAR);
  ColWprint('⠡஢       ',  2, 6, 12, SAAR);
  ColWprint('⨪:          ',  3, 6, 12, SAAR);
  ColWprint('    1 : 1           ',  4, 6, 12, SAAR);
  ColWprint('    1 : 2           ',  5, 6, 12, SAAR);
  ColWprint('    1 : 4           ',  6, 6, 12, SAAR);
  ColWprint(' ਧ⠫:      ',  7, 6, 12, SAAR);
  ColWprint('    1 : 1           ',  8, 6, 12, SAAR);
  ColWprint('    1 : 2           ',  9, 6, 12, SAAR);
  ColWprint('    1 : 4           ', 10, 6, 12, SAAR);
  ColWprint('                    ', 11, 6, 12, SAAR);
  ColWprint('                    ', 12, 6, 12, SAAR);

  ColWprint('ᨬ  ',  1, 10, 3, CAAR);
  ColWprint(' ࠧ       ',  2, 10, 3, CAAR);
  ColWprint('     -०  ',  3, 10, 3, CAAR);
  ColWprint(' ',  4, 10, 3, CAAR);
  ColWprint(' ०     -  ',  5, 10, 3, CAAR);
  ColWprint('/    ',  6, 10, 3, CAAR);
  ColWprint(' ',  7, 10, 3, CAAR);
  ColWprint('    1        8     ',  8, 10, 3, CAAR);
  ColWprint('    2        8     ',  9, 10, 3, CAAR);
  ColWprint('    4       12     ', 10, 10, 3, CAAR);
  ColWprint('    8        2     ', 11, 10, 3, CAAR);
  ColWprint('                    ', 12, 10, 3, CAAR);
  ColWprint('⢮ ⥭:', 12, 10, 3, CAAR);
  ColWprint('      6 5 5 3 5     ', 12, 10, 3, CAAR);
  ColWprint('                    ', 12, 10, 3, CAAR);

  VEWN.AREA := VEAR.ANUM;
  CreSWWin(VEWN);
  LDelay(6);
  GOWN.AREA := GOAR.ANUM;
  CreSWWin(GOWN);
  LDelay(6);
  SAWN.AREA := SAAR.ANUM;
  CreSWWin(SAWN);
  LDelay(6);
  CAWN.AREA := CAAR.ANUM;
  CreSWWin(CAWN);
  LDelay(6);

  for I := 1 to 7 do
  begin
    with VEWN do
    begin
      SY1 := SY1 - 12;
      SY2 := SY2 - 12;
      SX1 := SX1 - 1;
      SX2 := SX2 - 1;
    end;
    with GOWN do
    begin
      SY1 := SY1 - 12;
      SY2 := SY2 - 12;
      SX1 := SX1 + 1;
      SX2 := SX2 + 1;
    end;
    with SAWN do
    begin
      SY1 := SY1 + 12;
      SY2 := SY2 + 12;
      SX1 := SX1 - 1;
      SX2 := SX2 - 1;
    end;
    with CAWN do
    begin
      SY1 := SY1 + 12;
      SY2 := SY2 + 12;
      SX1 := SX1 + 1;
      SX2 := SX2 + 1;
    end;
    if (I MOD 2)<>0 then
    begin
      VWCRE(VEWN);
      VWCRE(GOWN);
      VWCRE(SAWN);
      VWCRE(CAWN);
    end;
  end;
  LDelay(5);

  VWKILL(VEWN);
  VWKILL(GOWN);
  VWKILL(SAWN);
  VWKILL(CAWN);
  LDelay(1);
end;

procedure WinExp;
var
  I,J,K,L,M,N : integer;
  WIN : array [0..5] of WinTyp;
begin
(* Zoom Area in Window *)
  TX1 := '       ';
  TX2 := ' ⠡ ᪮  ';
  TX3 := '               '; 
  OpenTX;
  Ldelay(3);
  CloseTX;
  VWFORE(PIC4WN);
  for I := 2 downto 0 do
    for J := 2 downto 0 do
    begin
      PIC4WN.DEN := I * 256 + J;
      case J of
        2: PIC4WN.ARX := 0;
        1: PIC4WN.ARX := 40;
        0: PIC4WN.ARX := 60;
      end;
      case I of
        2: PIC4WN.ARY := 0;
        1: PIC4WN.ARY := 50;
        0: PIC4WN.ARY := 75;
      end;
      VWCRE(PIC4WN);
      LDelay(4);
    end;
  PIC4WN.DEN := 2 * 256 + 2;
  PIC4WN.ARX := 0;
  PIC4WN.ARY := 0;
  VWCRE(PIC4WN);
  LDelay(2);

(* Move Area in Window *)
  TX1 := '        ';
  TX2 := ' ᪮          ';
  TX3 := '               '; 
  OpenTX;
  Ldelay(3);
  CloseTX;
  VWFORE(PIC5WN);
  Ldelay(3);
  PIC5WN.DEN := 1 * 256 + 1;
  VWCRE(PIC5WN);
  N := 20;
  for I := 1 to N do
  begin
    PIC5WN.ARX := PIC5WN.ARX + 4;
    VWCRE(PIC5WN);
    Delay(3000);
  end;
  for I := 1 to N do
  begin
    PIC5WN.ARX := PIC5WN.ARX - 4;
    VWCRE(PIC5WN);
    Delay(3000);
  end;
  N := PIC5WN.SY2 - PIC5WN.SY1;
  for I := 1 to N do
  begin
    PIC5WN.ARY := PIC5WN.ARY + 1;
    VWCRE(PIC5WN);
  end;
  for I := 1 to N do
  begin
    PIC5WN.ARY := PIC5WN.ARY - 1;
    VWCRE(PIC5WN);
  end;
  PIC5WN.DEN := 2 * 256 + 2;
  VWCRE(PIC5WN);
  Ldelay(2);

(* Many Window for Area *)
  TX1 := '        ';
  TX2 := ' ᪮쪮      ';
  TX3 := '   ᪮  '; 
  OpenTX;
  Ldelay(3);
  for I := 0 to 5 do
    with WIN[I] do
    begin
      WNUM := 0;
      AREA := 14;
      ARY := 0;
      ARX := 0;
      SY2 := 300;
    end;
  for I := 1 downto 0 do
    for J := 2 downto 0 do
    begin
      with WIN[J + I * 3] do
      begin
        DEN := J * 256 + I;
        case J of
          0: SY1 := 160;
          1: SY1 := 224;
          2: SY1 := 256;
        end;
        SX1 := I * 15 + 2;
        SX2 := SX1 + 12 + I * -6;
      end;
      VWCRE(WIN[J + I * 3]);
    end;
  LDelay(15);
  for I := 0 to 5 do
    VWKILL(WIN[I]);
  CloseTX;
  LDelay(3);
end;

procedure RainbowColors( var PAL :PalTyp);
begin
  with PAL do
  begin
   C[ 0]:=chr(000B); C[ 1]:=chr(036B); C[ 2]:=chr(034B); C[ 3]:=chr(234B);    
   C[ 4]:=chr(334B); C[ 5]:=chr(374B); C[ 6]:=chr(360B); C[ 7]:=chr(340B);    
   C[ 8]:=chr(342B); C[ 9]:=chr(343B); C[10]:=chr(303B); C[11]:=chr(203B);    
   C[12]:=chr(017B); C[13]:=chr(023B); C[14]:=chr(033B); C[15]:=chr(037B);    
  end;
  PlMod(PAL);
end;

procedure PalRot (var PAL :PalTyp;  CNT, DEL :integer);
var
  I, J : integer;
  T : char;
begin
  for J := 1 to CNT do
  begin
    Delay(DEL);
    with PAL do
    begin
      T := C[15];
      for I := 15 downto 2 do
        C[I] := C[I-1];
      C[1] := T;
    end;
    PlMod(PAL);
  end;
end;

PROCEDURE RAINBOW;
VAR
  PAL : PALTYP;
  LW, LY, Y, I, MX, C : INTEGER;
  RX, DX : REAL;
  T : CHAR; 
BEGIN
  PAL.MODPAL := VM41;
  PLCRE(PAL);
  RNAR.ANUM := 0;
  RNAR.LINS := 220;
  RNAR.SLEN := 160;
  RNAR.MODPAL := PAL.MODPAL;
  RNAR.AMMR := 0;
  ARGET(RNAR);
  RainbowColors(PAL);
  PlMod(PAL);
  Rwprint(RNAR.ANUM, 2, 8, 10, 3, '.................');
  Rwprint(RNAR.ANUM, 3, 8, 25, 5, '梥...............');
  Rwprint(RNAR.ANUM, 4, 8, 40, 6, 'ࠤ㣨..............');
  Rwprint(RNAR.ANUM, 5, 8, 55, 2, '..................');
  Rwprint(RNAR.ANUM, 6, 8, 70, 6, '࠭..............');

  WITH RNWN DO
  BEGIN
    AREA := RNAR.ANUM;
    WNUM := 0;
    DEN := 1*256+0;
    SY1 := 40;
    SY2 := 260;
    SX1 := 3+23;
    SX2 := 22+23;
    ARY := 0;
    ARX := 0;
  END;
  WHMove(RNWN, -23);
  LDelay(2);
  RNWN.DEN := 2*256 + 2;
  VWCRE(RNWN);
  LDelay(2);
  RX := 0.;
  MX := 152 - 36;
  DX := 6.27999995/MX;
  LY := 110+TRUNC(80.*SIN(DX));
  FOR I := 0 TO MX DO
  BEGIN
    Y := 110 + TRUNC (80.*SIN(RX));
    C := ((I DIV 2) MOD 15) + 1;
    C := (C*16 + C) * 256 + C*16 + C;
    HBMOVE(RNAR.ANUM,VCV,Y,ABS(Y-LY)+1,I,36,C,0,0);
    LY := Y;
    RX := RX + DX;
  END;
  PalRot (PAL,  100, 1700 );
  VWKILL(RNWN);
end;

procedure RandWin;
var
  SEED : 0..65535;
  S256, S32, S01, I, J, K : integer;
  WIN : array [1..12] of WinTyp;
  TWIN : WinTyp;

  procedure Rand;
  begin
    seed := (seed * 13077 + 6925) mod 32768;
    s256 := (seed div 32) and 377B;
    s32  := seed  and 17B;
    S01  := (seed div 8192) and 1; 
  end;

begin
  seed := 12345;
  TWIN.WNUM := 2;
  VWTake(TWIN);
  WIN[1] := TWIN;
  WIN[2] := VEWN;
  WIN[3] := GOWN;
  WIN[4] := SAWN;
  WIN[5] := CAWN;
  WIN[6] := RNWN;
  WIN[7] := MYWN;
  WIN[8] := PIC1WN;
  WIN[9] := PIC2WN;
  WIN[10] := PIC3WN;
  WIN[11] := PIC4WN;
  WIN[12] := PIC5WN;

  for I := 2 to 12 do
    VWCRE(WIN[I]);

  for I := 1 to 20 do
    for J := 1 to 12 do
    begin
      Delay(10000);
      Rand;
      TWIN := WIN[J];
      if (I mod 20) >= 1 then
      begin 
        with TWIN do
        begin
          K := SX2 - SX1;
          SX1 := S32+2; SX2 := S32 + K;
          K := SY2 - SY1;
          SY1 :=  S256; SY2 := s256 + K; 
          if S01 <> 0 then DEN := 2 * 256 + 2 else DEN := 1 * 256 + 1;
        end;
        VWCre(TWIN);
        VWFORE(TWIN);
      end;
    end;
  VWCre(WIN[1]);
end;

procedure WinBrCnCh;
var
  PAL : PLxTyp;
  R0, G0, B0,
  R1, G1, B1,
  R2, G2, B2,
  R3, G3, B3, 
  COEFF : array [0..15] of integer;
  I, J : integer;
  TCH, TCL : char;

  procedure PALRGB;
  begin
    for I := 0 to 15 do
    begin
      TCH := PAL.CH[I]; TCL := PAL.CH[I+16];
      R0[I] := (ORD(TCH) AND 34B) * 2 + ((ORD(TCL) AND 30B) DIV 4);
      G0[I] := ((ORD(TCH) AND 340B) DIV 4) + ((ORD(TCL) AND 340B) DIV 32);
      B0[I] := (ORD(TCH) AND 3) * 16 + (ORD(TCL) AND 7) * 2;
    end;
    R1:=R0;
    G1:=G0;
    B1:=B0;
    R2:=R0;
    G2:=G0;
    B2:=B0;
  end;

  procedure RGBPAL;
  var
    I : integer;
  begin
    for I := 0 to 15 do
    begin
      if (R1[I] AND 177700B)=0 then
        R0[I] := R1[I];
      if (G1[I] AND 177700B)=0 then
        G0[I] := G1[I];
      if (B1[I] AND 177700B)=0 then
        B0[I] := B1[I];
      TCH := CHR(((R0[I] AND 70B) DIV 2)+((G0[I] AND 70B)*4)+((B0[I] AND 60B) DIV 16));
      TCL := CHR(((R0[I] AND 6)*4)+((G0[I] AND 7)*32)+((B0[I] AND 16B) DIV 2));
      PAL.CH[I] := TCH; PAL.CH[I+16] := TCL;
    end;
    PLMODx(PAL);
  end;

  procedure PreCHROMA(MODPAL : integer);
  var
    I : integer;
  begin
    PAL.MODPAL := MODPAL;
    PLSAVx(PAL);
    PALRGB;
    for I := 0 to 15 do
      COEFF[I] := (R1[I] * 2 + G1[I] * 4 + B1[I]) * 64;
    for I := 0 to 15 do
    begin
      R3[I] := R1[I] * 64 - (COEFF[I] DIV 7);
      G3[I] := G1[I] * 64 - (COEFF[I] DIV 7);
      B3[I] := B1[I] * 64 - (COEFF[I] DIV 7);
    end;
  end;

  procedure ChgCHROMA(N : integer);
  var
    I : integer; F : real;
  begin
    F := N;
    for I := 0 to 15 do
    begin
      R1[I] := R2[I] + ROUND(R3[I] * F / 4096.0);
      G1[I] := G2[I] + ROUND(G3[I] * F / 4096.0);
      B1[I] := B2[I] + ROUND(B3[I] * F / 4096.0);
    end;
    RGBPAL;
  end;

  procedure PreCONTRAST(MODPAL : integer);
  var
    I : integer;
  begin
    PAL.MODPAL := MODPAL;
    PLSAVx(PAL);
    PALRGB;
    J := 0;
    for I := 0 to 15 do
    begin
      COEFF[I] := R1[I] * 2 + G1[I] * 4 + B1[I];
      J := J + COEFF[I];
      COEFF[I] := COEFF[I] * 64;
    end;
    J := J * 4;
    for I := 0 to 15 do
      COEFF[I] := COEFF[I] - J;
  end;

  procedure ChgCONTRAST(N : integer);
  var
    I : integer; F : real;
  begin
    F := (N / 7.0) / 4096.0;
    for I := 0 to 15 do
    begin
      R1[I] := R2[I] + ROUND(COEFF[I] * F);
      G1[I] := G2[I] + ROUND(COEFF[I] * F);
      B1[I] := B2[I] + ROUND(COEFF[I] * F);
    end;
    RGBPAL;
  end;

  procedure PreBRIGHT(MODPAL : integer);
  var
    I : integer;
  begin
    PAL.MODPAL := MODPAL;
    PLSAVx(PAL);
    PALRGB;
    for I := 0 to 15 do
      COEFF[I] := (R1[I] * 2 + G1[I] * 4 + B1[I]) * 64;
  end;

  procedure ChgBRIGHT(N : integer);
  var
    I : integer; F : real;
  begin
    F := (N / 7.0) / 4096.0;
    for I := 0 to 15 do
    begin
      R1[I] := R2[I] + ROUND(COEFF[I] * F);
      G1[I] := G2[I] + ROUND(COEFF[I] * F);
      B1[I] := B2[I] + ROUND(COEFF[I] * F);
    end;
    RGBPAL;
  end;

begin
  TX1 := '  ॣ㫨஢ ';
  TX2 := '             ';
  TX3 := '  ⤥쭮    ';
  OpenTX;
  LDelay(3);
  CloseTX;
  VWFORE(PIC1WN);
  PreBRIGHT(PIC1AR.MODPAL);
  for I := 0 downto -65 do
    ChgBRIGHT(I);
  for I := -64 to 128 do
    ChgBRIGHT(I);
  LDelay(1);
  for I := 128 downto 0 do
    ChgBRIGHT(I);
  LDelay(3);

  TX2 := ' ⭮      ';
  OpenTX;
  LDelay(3);
  CloseTX;
  VWFORE(PIC2WN);
  PreCONTRAST(PIC2AR.MODPAL);
  for I := 0 downto -55 do
    ChgCONTRAST(I);
  LDelay(1);
  for I := -55 to 127 do
    ChgCONTRAST(I);
  LDelay(1);
  for I := 127 downto 0 do
    ChgCONTRAST(I);
  LDelay(3);

  TX2 := '           ';
  OpenTX;
  LDelay(3);
  CloseTX;
  VWFORE(PIC3WN);
  PreCHROMA(PIC3AR.MODPAL);
  for I := 0 downto -65 do
    ChgCHROMA(I);
  LDelay(5);
  for I := -64 to 128 do
    ChgCHROMA(I);
  LDelay(1);
  for I := 128 downto 0 do
    ChgCHROMA(I);
  LDelay(3);
end;

procedure AllFre;
var
  PAL : PalTyp;

  procedure PalFre(MDPL : integer);
  begin
    PAL.MODPAL := MDPL;
    PLFRE(PAL);
  end;

  procedure ArPalFre(var AR : AreTyp);
  begin
    PAL.MODPAL := AR.MODPAL;
    PLFRE(PAL);
    ArFre(AR);
  end;

begin
  ArPalFre(TXAR);
  ArFre(TX1AR);
  PalFre(MYAR.MODPAL);
  ARKILL(MYAR);
  ArPalFre(RNAR);
  ArPalFre(PIC1AR);
  ArPalFre(PIC2AR);
  ArPalFre(PIC3AR);
  ArPalFre(PIC4AR);
  ArPalFre(PIC5AR);
  ArPalFre(VEAR);
  ArPalFre(GOAR);
  ArPalFre(SAAR);
  ArPalFre(CAAR);
  PalFre(BGAR.MODPAL);
  ArKill(BGAR);
end;
(*---------------- MAIN PROGRAM --------------------------*)
BEGIN  (* MAIN *)
  TXArea;
  BGArea;
  HideVT( Gray );
  Present;
  RAINBOW;
  ReadPic;
  ShowVT( Blue);
  pictures;
  color64;
  WinBrCnCh;
  WinExp;
  RandWin;
  ALLFRE;
END.
