module memory_manager(

   input wire clock_in, n_mreq, n_iorq, n_res, n_rd, n_wr, n_m1,
	input wire [15:0] a,
	input wire [7:0] d_i,
	output wire [7:0] d_o,
	input wire [7:0] ext_line_i,
	output wire [7:0] ext_line_o,
	output wire [3:0] ext_line_dir,
   output n_ramcs, n_romcs, n_concs, n_piocs,
	output wire [4:0] ext_a,
	output wire n_wait,
	output wire d_o_enable,
	input wire [7:0] sd_data_in,
	output wire [7:0] sd_data_out,
	output wire [7:0] sd_mode,
	output wire sd_out_flag,
	input wire sd_busy
);

   reg n_rom_select;
	reg [2:0] ext_ad;
	reg [1:0] iowait;
	reg [7:0] ext_port;
	reg [3:0] ext_port_dir;
	reg [7:0] data_out;
	
	reg [7:0] sd_data_latch;
	reg [7:0] sd_mode_latch;

   always @(posedge clock_in) begin
		if (!n_res) begin
			n_rom_select <= 1'b0; // Set ROM available
			ext_ad <= 3'b010; // Set A18..A16 to (A18 = 0, A17 = 1, A16 = 0)
			sd_mode_latch <= 8'h0; // Set SD mode to Slow clock, normal CS operation
			ext_port_dir <= 4'h0; // Set PORT direction to input (0 - read, 1 - write)
		end else begin
			if (n_iorq == 0 && n_wr == 0 && a[7:3] == 5'b00111) n_rom_select <= d_i[0]; // Port 0x38..0x3f ROM lock
			
			if (n_iorq == 0 && n_wr == 0 && a[7:0] == 8'h28) ext_port <= d_i; // Port 0x28 External port write
			if (n_iorq == 0 && n_rd == 0 && a[7:0] == 8'h28) data_out <= ext_line_i; // Port 0x28 External port read

			if (n_iorq == 0 && n_wr == 0 && a[7:0] == 8'h29) ext_port_dir <= d_i[3:0]; // Port 0x29 External write port direction (P0,P1 - Bit0, P2,P3 - Bit1, P4,P5 - Bit3, P6,P7 - Bit4)

			if (n_iorq == 0 && n_wr == 0 && a[7:0] == 8'h2a) sd_data_latch <= d_i; // Port 0x2A SD card write
			if (n_iorq == 0 && n_rd == 0 && a[7:0] == 8'h2a) data_out <= sd_data_in; // Port 0x2A SD card read

			if (n_iorq == 0 && n_wr == 0 && a[7:0] == 8'h2b) sd_mode_latch <= d_i; // Port 0x2B SD card MODE register write
			if (n_iorq == 0 && n_rd == 0 && a[7:0] == 8'h2b) data_out <= {7'b0, sd_busy}; // Port 0x2B SD card MODE register read
		end
	end
	
	assign n_ramcs = n_rom_select ? n_mreq : n_mreq | ~(a[15] | a[14]);
	assign n_romcs = n_rom_select ? 1'h1 : n_mreq | a[15] | a[14];
	assign n_concs = ~(n_iorq == 0 && n_m1 == 1 && a[7:3] == 5'b00001); // Port 0x08..0x0f SIO 8251 Select
	assign n_piocs = ~(n_iorq == 0 && n_m1 == 1 && a[7:2] == 6'b001000); // Port 0x20..0x23 PIO 8255 Select

// Add clk tick WAIT when reading IO
//	always @(posedge clock_in) begin
//		iowait[0] <= n_iorq;
//		iowait[1] <= iowait[0];
//	end

//	assign n_wait = ~(~iowait[0] & iowait[1]);

	assign n_wait = 1'b1;

	assign ext_a = {ext_ad[2:0], a[15], a[14]};

	assign ext_line_o = ext_port;
	assign ext_line_dir = ext_port_dir;
	assign d_o_enable = (n_iorq == 0 && n_rd == 0 && (a[7:0] == 8'h28 || a[7:0] == 8'h2a || a[7:0] == 8'h2b)); // d_o is sensible (at port 0x28 and 0x2A and 0x2B)
	assign d_o = data_out; // Set d_o line to sensible data
	
	assign sd_data_out = sd_data_latch;
	assign sd_mode = sd_mode_latch;
	assign sd_out_flag = (n_iorq == 0 && n_wr == 0 && a[7:0] == 8'h2a); // data is written to SD port, effective at negative edge (start SPI TX/RX state machine)

endmodule