module z80mini(
	input wire CLK50MHz,
	input wire [15:0] A,
	inout wire [7:0] D,
	input wire nMREQ, nIORQ, nWR, nRD, nM1, nRES, nHALT, IRQ,
	output wire nWAIT, nINT, nNMI, CPUCLK, nRESET,
	output wire CONCLK, TCLK, RESET, nCONCS,
	output wire nRAMCS, nROMCS, nPIOCS,
	output wire [5:0] EXT_A,
	inout wire [7:0] EXT_P,
	output wire SD_CLK, SD_MOSI,
	input wire SD_MISO
);

	reg reset;
	wire DO_ENABLE;
	wire [7:0] DO;
	wire [7:0] EXT_P_OUT;
	wire [3:0] EXT_P_DIR;
	wire [4:0] MM_EXT_A;
	
	wire SD_CS;
	wire SD_OUT_FLAG;
	wire [7:0] SD_DATA_IN;
	wire [7:0] SD_DATA_OUT;
	wire [7:0] SD_MODE;
	wire SD_BUSY;
	
//	wire AO18;

	frequency_generator fg0 (.clock_in(CLK50MHz), .t_clk(TCLK), .con_clk(CONCLK), .cpu_clk(CPUCLK));

// t_clk - 2.5MHz
// cpu_clk - 2.5 MHz
// con_clk - 625 KHz	

	memory_manager mm0 (
			.clock_in(CLK50MHz), .n_mreq(nMREQ), .n_iorq(nIORQ), 
			.n_res(nRESET), .n_rd(nRD), .n_wr(nWR), .n_m1(nM1),
			.a(A), .d_i(D), .d_o(DO), .d_o_enable(DO_ENABLE),
			.n_ramcs(nRAMCS), .n_romcs(nROMCS), .n_concs(nCONCS),
			.ext_a(MM_EXT_A), .n_piocs(nPIOCS),
			
			.ext_line_i(EXT_P), .ext_line_o(EXT_P_OUT),
			.ext_line_dir(EXT_P_DIR), .n_wait(nWAIT),
			
			.sd_data_out(SD_DATA_IN), .sd_data_in(SD_DATA_OUT), 
			.sd_mode(SD_MODE), .sd_out_flag(SD_OUT_FLAG), .sd_busy(SD_BUSY)
	);

	sd_card_manager sd0 (
			.clock50m(CLK50MHz), .cs(SD_CS), .mosi(SD_MOSI), .miso(SD_MISO), .clk(SD_CLK),
			.data_in(SD_DATA_IN), .data_out(SD_DATA_OUT), .mode(SD_MODE), .out_flag(SD_OUT_FLAG),
			.n_res(nRESET), .busy(SD_BUSY)
	);
	
	always @(posedge CPUCLK) begin
		if (!nRES) begin
			reset <= 1;
		end else reset <= 0;
	end

	genvar i;
	generate
		for(i = 0; i < 4; i = i + 1) begin : ASSIGN_GEN
			assign EXT_P[i*2] = EXT_P_DIR[i] ? EXT_P_OUT[i*2] : 1'bz;
			assign EXT_P[i*2+1] = EXT_P_DIR[i] ? EXT_P_OUT[i*2+1] : 1'bz;
		end
	endgenerate
	
	assign D = nM1 | nIORQ ? (DO_ENABLE ? DO : 8'bzzzzzzzz) : 8'hfa; // Set INT IM 2 vector to 0xIIFA (for CP/M: II = 0xFF) or set D to DO when DO_ENABLE
	assign nNMI = 1'b1;
	assign nINT = ~IRQ;
	assign nRESET = ~reset;
	assign RESET = reset;
	assign EXT_A = {SD_CS, MM_EXT_A}; // AO19 used as SD_CS signal

//	assign EXT_A = {SD_CS, AO18, MM_EXT_A[3:0]}; // AO19 used as SD_CS signal
//	assign AO18 = SD_DATA_IN[0];

// SD_CLK - RS
// SD_MOSI - E
// SD_MISO - R/W
// SD_CS - AO19
	
endmodule