B equ 0
C equ 1
D equ 2
E equ 3
H equ 4
L equ 5
M equ 6
A equ 7
SP equ 6
PSW equ 6

macro cmdr code,r { DB code or r }
macro cmdrp code,rp { DB code or (rp shl 3) }
macro cmdw code,w {
  local addr
  addr = w
  DB code
  DW addr
}
macro LXI rp,w { cmdw 01h or (rp shl 3),w }
macro MVI r,b { DB 06h or (r shl 3),b }
macro MOV r1,r2 { DB 40h or (r1 shl 3) or r2 }

NOP  fix DB 00h
STAX fix cmdrp 02h,
INX  fix cmdrp 03h,
INR  fix cmdrp 04h,
DCR  fix cmdrp 05h,
RLC  fix DB 07h
DAD  fix cmdrp 09h,
LDAX fix cmdrp 0Ah,
DCX  fix cmdrp 0Bh,
RRC  fix DB 0Fh
RAL  fix DB 17h
RAR  fix DB 1Fh
SHLD fix cmdw 22h,
DAA  fix DB 27h
LHLD fix cmdw 2Ah,
CMA  fix DB 2Fh
STA  fix cmdw 32h,
STC  fix DB 37h
LDA  fix cmdw 3Ah,
CMC  fix DB 3Fh
HLT  fix DB 76h
ADD  fix cmdr 80h,
ADC  fix cmdr 88h,
SUB  fix cmdr 90h,
SBB  fix cmdr 98h,
ANA  fix cmdr 0A0h,
XRA  fix cmdr 0A8h,
ORA  fix cmdr 0B0h,
CMP  fix cmdr 0B8h,

RNZ  fix DB 0C0h
RZ   fix DB 0C8h
RNC  fix DB 0D0h
RC   fix DB 0D8h
RPO  fix DB 0E0h
RPE  fix DB 0E8h
RP   fix DB 0F0h
RM   fix DB 0F8h

JNZ  fix cmdw 0C2h,
JZ   fix cmdw 0CAh,
JNC  fix cmdw 0D2h,
JC   fix cmdw 0DAh,
JPO  fix cmdw 0E2h,
JPE  fix cmdw 0EAh,
JP   fix cmdw 0F2h,
JM   fix cmdw 0FAh,

CNZ  fix cmdw 0C4h,
CZ   fix cmdw 0CCh,
CNC  fix cmdw 0D4h,
CC   fix cmdw 0DCh,
CPO  fix cmdw 0E4h,
CPE  fix cmdw 0ECh,
CP   fix cmdw 0F4h,
CM   fix cmdw 0FCh,

POP  fix cmdrp 0C1h,
JMP  fix cmdw 0C3h,
PUSH fix cmdrp 0C5h,
ADI  fix DB 0C6h,
RST  fix cmdrp 0C7h,
RET  fix DB 0C9h
CALL fix cmdw 0CDh,
ACI  fix DB 0CEh,
OUT  fix DB 0D3h,
SUI  fix DB 0D6h,
IN   fix DB 0DBh,
SBI  fix DB 0DEh,
XTHL fix DB 0E3h
ANI  fix DB 0E6h,
PCHL fix DB 0E9h
XCHG fix DB 0EBh
XRI  fix DB 0EEh,
DI   fix DB 0F3h
ORI  fix DB 0F6h,
SPHL fix DB 0F9h
EI   fix DB 0FBh
CPI  fix DB 0FEh,
DS   fix RB

EXX  fix DB 0D9h

macro EX a,b { DB 8 }

macro DJNZ lbl {
  local addr
  addr = lbl-$-2
  DB 10h,addr
}

macro JR cc,lbl {
  local addr,code
  if lbl eq
    addr = cc-$-2
    code = 18h
  else
    addr = lbl-$-2
    match =NZ,cc \{ code = 20h \}
    match =Z,cc  \{ code = 28h \}
    match =NC,cc \{ code = 30h \}
    match =1,cc  \{ code = 38h \}
  end if
  DB code
  DB addr and 255
}
