--------------------------------------------------------------------------------
--  ПРОШИВКА ПЛИС ДЛЯ УСТРОЙСТВА: "ZXKit1 - ПЛАТА VGA & PAL"                  --                        
--  ВЕРСИЯ:  V1.0.2.00                                          ДАТА: 100216  --
--  АВТОР:   САБИРЖАНОВ ВАДИМ                                                 --
--                                                                            --
--  ПЛИС: EPM3128ATC100-10N (128 MACROCELLS, КОРПУС TQFP100)                  --
--  ОЗУ:  K6R4016V1D-UI10 (256K * 16 бит)                                     --
--  ТАКТОВАЯ ЧАСТОТА: 14 МГц, ПОДАЕТСЯ СО СПЕКТРУМА                           --
--  СРЕДА РАЗРАБОТКИ: Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 29
-- Total macrocels = 128/128
-- Total pins      = 64/80

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;


entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                 ВХОДНЫЕ СИГНАЛЫ ПЛИС СО СПЕКТРУМА                  091218  --
--------------------------------------------------------------------------------

R_IN       : in std_logic := '1'; -- цифровой RED
G_IN       : in std_logic := '1'; -- цифровой GREEN
B_IN       : in std_logic := '1'; -- цифровой BLUE
I_IN       : in std_logic := '1'; -- цифровой BRIGHT

KSI_IN     : in std_logic := '1'; -- кадровые синхроимпульсы
SSI_IN     : in std_logic := '1'; -- строчные синхроимпульсы
F14        : in std_logic := '1'; -- тактовые импульсы частотой 14 МГц
F14_2      : in std_logic := '1'; -- F12, задержанный с помощью двух инверторов


--------------------------------------------------------------------------------
--             ПЕРЕМЫЧКИ / ТУМБЛЕРЫ ДЛЯ УПРАВЛЕНИЯ РЕЖИМАМИ           090812  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; -- инверсия кода цвета: 
                                     -- 0 - инвертировать, 1 - нет.
                                      
INVERSE_KSI   : in std_logic := '1'; -- инверсия кадровых синхроимпульсов: 
                                     -- 0 - инвертировать, 1 - нет.
                                      
INVERSE_SSI   : in std_logic := '1'; -- инверсия строчных синхроимпульсов: 
                                     -- 0 - инвертировать, 1 - нет.
                                      
INVERSE_F14MHZ: in std_logic := '1'; -- инверсия тактовых импульсов: 
                                     -- 0 - инвертировать, 1 - нет.

VGA_SCART     : in std_logic := '1'; -- выбор сигнала на разъеме VGA: 
                                     -- 0 - для SCART, 1 - для VGA.

SET_FK_IN     : in std_logic := '1'; -- установка входной частоты кадров: 
                                     -- 0 - 50 Гц(312 строк), 1 - 48 Гц(320 ст.)
                                      
SET_FK_OUT    : in std_logic := '1'; -- установка выходной частоты кадров: 
                                     -- 1 - 60 Гц, 0 - 50/48 Гц.

--------------------------------------------------------------------------------
--                     ВЫХОДНЫЕ ПОРТЫ ПЛИС ДЛЯ VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic := '0'; -- цифровой RED
G_VGA      : out std_logic := '0'; -- цифровой GREEN
B_VGA      : out std_logic := '0'; -- цифровой BLUE
I_VGA      : out std_logic_vector (2 downto 0) := "000"; -- выходы яркости VGA

VSYNC_VGA  : out std_logic := '1'; -- кадровые синхроимпульсы/синхроимп. SCART
HSYNC_VGA  : out std_logic := '1'; -- строчные синхроимпульсы/enable RGB SCART


--------------------------------------------------------------------------------
--                     ВЫХОДНЫЕ ПОРТЫ ПЛИС ДЛЯ VIDEO                  090728  --
--------------------------------------------------------------------------------

--R_VIDEO    : out std_logic := '0'; -- цифровой RED
--G_VIDEO    : out std_logic := '0'; -- цифровой GREEN
--B_VIDEO    : out std_logic := '0'; -- цифровой BLUE
--I_VIDEO    : out std_logic_vector (2 downto 0) := "000"; -- выходы яркости VIDEO
--
--SYNC_VIDEO : out std_logic := '1'; -- синхросмесь кадровых и строчных синхроимп.


--------------------------------------------------------------------------------
--                     ВЫХОДНЫЕ ПОРТЫ ПЛИС ДЛЯ ОЗУ                    090803  --
--------------------------------------------------------------------------------
A18        : out std_logic := '0'; -- старший бит адреса не используется
A17        : out std_logic; -- пред-старший бит адреса не используется
A          : out std_logic_vector(16 downto 0); -- ША

WE         : out std_logic := '1'; -- сигнал записи в  ОЗУ  
OE         : buffer std_logic := '1'; -- сигнал чтения из ОЗУ   
--UB         : out std_logic := '1'; -- активация старшего байта ШД ОЗУ (D15..D8)
--LB         : out std_logic := '1'; -- активация младшего байта ШД ОЗУ  (D7..D0)
CS         : out std_logic := '0'; -- сигнал выбора кристалла ОЗУ     

--------------------------------------------------------------------------------
--                  ДВУНАПРАВЛЕННЫЕ ПОРТЫ ПЛИС ДЛЯ ОЗУ                090727  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(7 downto 0) := "ZZZZZZZZ" -- ШД

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                       ВНУТРЕННИЕ СИГНАЛЫ ПЛИС                      090804  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                   НОРМАЛИЗОВАННЫЕ ВХОДНЫЕ СИГНАЛЫ                  090805  --
--------------------------------------------------------------------------------

signal R      : std_logic; -- цифровой RED
signal G      : std_logic; -- цифровой GREEN
signal B      : std_logic; -- цифровой BLUE
signal I      : std_logic; -- цифровой BRIGHT
signal RGBI_CLK : std_logic; -- тактовый сигнал входного кода цвета

--signal KSI_IN : std_logic; -- выборка  синхросмеси в 1/4 и 3/4 строки
signal KSI    : std_logic; -- кадровые синхроимпульсы
signal SSI    : std_logic; -- строчные синхроимпульсы

--------------------------------------------------------------------------------
--                     ПРОМЕЖУТОЧНЫЕ ДАННЫЕ ЦВЕТА                     090802  --
--------------------------------------------------------------------------------
signal R3     : std_logic; -- цифровой RED      -- при чтении из регистра
signal G3     : std_logic; -- цифровой GREEN
signal B3     : std_logic; -- цифровой BLUE
signal I3     : std_logic; -- цифровой BRIGHT


--------------------------------------------------------------------------------
--                     СИГНАЛЫ ДЛЯ СБРОСА СЧЕТЧИКОВ                   090726  --
--------------------------------------------------------------------------------

signal KSI_2  : std_logic; -- задержанные кадровые синхроимпульсы
signal SSI_2  : std_logic; -- задержанные строчные синхроимпульсы

--------------------------------------------------------------------------------
--                СЧЕТЧИКИ ТОЧЕК И СТРОК ДЛЯ VGA И VIDEO              100216  --
--------------------------------------------------------------------------------
signal VGA_H_MAX   : std_logic_vector(8 downto 0);
signal VGA_H       : std_logic_vector(8 downto 0); -- сч. точек в строке для VGA
signal VGA_V       : std_logic_vector(9 downto 0); -- сч. строк в кадре  для VGA

signal VIDEO_H_MAX : std_logic_vector(9 downto 0); -- макс. знач. сч. точек
signal VIDEO_H     : std_logic_vector(9 downto 0); -- сч. точек в строке VIDEO
signal VIDEO_V     : std_logic_vector(8 downto 0); -- сч. строк в кадре  VIDEO

signal H_COUNT     : std_logic_vector(9 downto 0); -- вспомогательный счетчик

--------------------------------------------------------------------------------
--                     СИНХРОИМПУЛЬСЫ ДЛЯ VGA И VIDEO                 091223  --
--------------------------------------------------------------------------------

signal VGA_KSI     : std_logic; -- кадровые синхроимпульсы для VGA
signal VGA_SSI     : std_logic; -- строчные синхроимпульсы для VGA

--signal VIDEO_KSI   : std_logic; -- кадровые синхроимпульсы для VIDEO
--signal VIDEO_SSI1  : std_logic; -- основные строчные синхроимпульсы для VIDEO
--signal VIDEO_SSI2  : std_logic; -- строчные синхроимпульсы - врезки для VIDEO
--signal VIDEO_SYNC  : std_logic; -- синхросмесь для VIDEO

signal RESET_ZONE   : std_logic; -- сигнал для синхроницации счетчика тактов
signal RESET_H      : std_logic; -- если 0, то можно сбрасывать счетчик тактов    
signal RESET_V      : std_logic; -- если 0, то можно сбрасывать счетчик строк    

 
--------------------------------------------------------------------------------
--                    ГАСЯЩИЕ ИМПУЛЬСЫ ДЛЯ VGA И VIDEO                090726  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; -- кадровые гасящие импульсы для VGA
signal VGA_SGI     : std_logic; -- строчные гасящие импульсы для VGA
signal VGA_BLANK   : std_logic; -- гасящие импульсы для VGA

signal VIDEO_KGI   : std_logic; -- кадровые гасящие импульсы для VIDEO
signal VIDEO_SGI   : std_logic; -- строчные гасящие импульсы для VIDEO
--signal VIDEO_BLANK : std_logic; -- гасящие импульсы для VIDEO

--------------------------------------------------------------------------------
--                РЕГИСТР ДЛЯ ЗАПИСИ ПО ДВЕ ТОЧКИ В ОЗУ               090726  --
--------------------------------------------------------------------------------

signal WR_REG     : std_logic_vector(7 downto 0); -- биты 3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                РЕГИСТР ДЛЯ ЧТЕНИЯ ПО ДВЕ ТОЧКИ В ОЗУ               090726  --
--------------------------------------------------------------------------------

signal RD_REG     : std_logic_vector(7 downto 0); -- биты 3-R, 2-G, 1-B, 0-I

begin

A18 <= '1';
A17 <= '1';
CS  <= '0';
--INVERSE_RGBI <= '1';
--INVERSE_KSI  <= '1';
--INVERSE_SSI  <= '1';

--------------------------------------------------------------------------------
--                            ПРОЦЕССЫ                                090813  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                   НОРМАЛИЗАЦИЯ ВХОДНЫХ СИГНАЛОВ                    090813  --
--------------------------------------------------------------------------------

-- если соответствующая перемычка/тумблер находится в положении ON, 
-- что соответствует логическому нулю, соответствующий сигнал инвертируется.
-- затем код цвета тактируются
--------------------------------------------------------------------------------
RGBI_CLK <= F14 xnor INVERSE_F14MHZ; -- нормализация тактовых синхроимпульсов
--------------------------------------------------------------------------------
process (RGBI_CLK)   
begin
  if (falling_edge(RGBI_CLK)) then -- если спад тактового импульса
--------------------------------------------------------------------------------
      R   <=   R_IN xnor INVERSE_RGBI;  -- нормализация кода цвета
      G   <=   G_IN xnor INVERSE_RGBI;
      B   <=   B_IN xnor INVERSE_RGBI;
      I   <=   I_IN xnor INVERSE_RGBI;
  end if;
end process;

--------------------------------------------------------------------------------
--              ФОРМИРОВАНИЕ СИГНАЛОВ ДЛЯ СБРОСА СЧЕТЧИКОВ            100216  --
--------------------------------------------------------------------------------
process (F14, VIDEO_H(8),VIDEO_H(9), H_COUNT)
begin

  if (rising_edge(F14)) then  -- если фронт тактового импульса, переход из 0 в 1
      SSI   <= SSI_IN xnor INVERSE_SSI;
      SSI_2 <= not SSI;       -- задержка на такт строчного синхроимпульса
  end if;

  -- выборка состояния кадрового синхроимпульса во время 1/4...1/2 строки VIDEO
  if (rising_edge(H_COUNT(8)) and H_COUNT(9)='0') then
      KSI   <= KSI_IN xnor INVERSE_KSI;
      KSI_2 <= not KSI;       -- задержка кадрового синхроимпульса на строку 
  end if;
end process;

RESET_H <= SSI or SSI_2;      -- если 0, то можно сбрасывать счетчик тактов    
RESET_V <= KSI or KSI_2;      -- если 0, то можно сбрасывать счетчик строк
-- зона для сброса счетчиков, 0 в средней части экрана по-вертикали
RESET_ZONE <= (not VIDEO_V(7) or VIDEO_V(8)); 


--------------------------------------------------------------------------------
--                 УПРАВЛЕНИЕ СЧЕТЧИКАМИ ТОЧЕК В СТРОКАХ              100216  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2, VGA_H_MAX)
begin  
  if (falling_edge(SSI)) then -- если спад  строчного синхроимпульса,
    if RESET_ZONE = '0'  then -- если зона для сброса счетчиков
      -- запоминаем состояние вспомогательного счетчика тактов в строке
      VIDEO_H_MAX <= H_COUNT;
--      VGA_H_MAX   <= (VIDEO_H(9 downto 1) );
    end if;
  end if;
--------------------------------------------------------------------------------
  VGA_H_MAX   <= (VIDEO_H_MAX(9 downto 1) ); -- максимальное знач. счетчика VGA
--------------------------------------------------------------------------------
  if (falling_edge(F14)) then         -- по спаду тактового импульса:
--------------------------------------------------------------------------------
    if (RESET_H = '0')  then          -- если спад входного синхросигнала,
      H_COUNT <= (others => '0');     -- обнуляем вспомогательный счетчик тактов
    else 
      H_COUNT <= H_COUNT + 1;         -- иначе - увеличиваем его
    end if;   
--------------------------------------------------------------------------------
    -- если начало строчного СИ и строка в средней части экрана по-вертикали:
    -- синхронизируем счетчики тактов с входными синхроимпульсами
    if (RESET_H or RESET_ZONE) = '0'  then
      VGA_H     <= (others => '0');   -- обнуляем счетчик тактов VGA
      VIDEO_H   <= (others => '0');   -- обнуляем счетчик тактов VIDEO
    else
    
      if (VGA_H = VGA_H_MAX) then     -- если последняя точка в строке VGA,
        VGA_H   <= (others => '0');   -- обнуляем счетчик VGA
      else
        VGA_H   <= VGA_H   + 1;       -- иначе - увеличиваем счетчик точек VGA
      end if;    

      if (VIDEO_H = VIDEO_H_MAX) then -- если конец строки VIDEO,
        VIDEO_H <= (others => '0');   -- обнуляем счетчик VIDEO
      else
        VIDEO_H <= VIDEO_H + 1;       -- увеличиваем счетчик точек VIDEO,
      end if;    
   end if;   
  end if;   
end process;


--------------------------------------------------------------------------------
--                 УПРАВЛЕНИЕ СЧЕТЧИКАМИ СТРОК В КАДРЕ                100216  --
--------------------------------------------------------------------------------
-- чтобы не было смещения экрана вниз при частоте VGA 60 Гц 
-- пропускаются 32 строки экрана Спектрума сверху экрана, 
-- что соответствует 64 строкам VGA.


process (VGA_H(8), VIDEO_H(9), H_COUNT)
begin
-- счетчик строк VGA:
  if (falling_edge(VGA_H(8))) then   -- по спаду старшего бита счетчика точек

    -- если выходная частота кадров 48/50 Гц
    if (SET_FK_OUT = '0') then
      if (RESET_V = '0')  then       -- если начало кадрового синхроимпульса:
        VGA_V <= (others => '0');    -- обнуляем счетчик строк VGA
      else                           -- иначе 
        VGA_V <= VGA_V   + 1;        -- увеличиваем счетчик строк VGA
      end if;    
    else  

    -- иначе, если выходная частота кадров 60 Гц
      if VGA_V = 587 then            -- и последняя строка в кадре (523+64=587):
        VGA_V <= ("0001000000");     -- первая отображаемая строка VGA: номер 44
      else                           -- иначе 
        VGA_V <= VGA_V   + 1;        -- увеличиваем счетчик строк VGA
      end if;    

    end if;    
  end if;    
--------------------------------------------------------------------------------
-- счетчик строк VIDEO: использует много макроячеек!
  if (falling_edge(H_COUNT(9))) then -- по спаду ст. бита счетчика точек
    if (RESET_V = '0') then          -- если начало кадрового синхроимпульса:
      VIDEO_V <= (others => '0');    -- обнуляем счетчик строк VIDEO
    else    
      VIDEO_V <= VIDEO_V + 1;        -- увеличиваем счетчик строк VIDEO
    end if;    
  end if;    
-------------------------------------------------------------------------------
end process;


--------------------------------------------------------------------------------
--                      ФОРМИРОВАНИЕ СТРОЧНЫХ ИМПУЛЬСОВ               090820  --
--------------------------------------------------------------------------------
-- строчные синхроимпульсы для VGA
VGA_SSI    <= '0' when VGA_H > 8 and VGA_H < 62 else '1';

-- строчные гасящие импульсы для VGA
VGA_SGI    <= '0' when VGA_H < 89 else '1';

---- основные строчные синхроимпульсы для VIDEO
--VIDEO_SSI1 <= '0' when VIDEO_H > 20 and VIDEO_H < 87 else '1';
--
---- строчные синхроимпульсы - врезки для VIDEO
--VIDEO_SSI2 <= '0' when VIDEO_H > 20 and VIDEO_H < 851 else '1';
--
---- строчные гасящие импульсы для VIDEO
--VIDEO_SGI  <= '0' when VIDEO_H < 168 else '1';


--------------------------------------------------------------------------------
--                      ФОРМИРОВАНИЕ КАДРОВЫХ ИМПУЛЬСОВ               090820  --
--------------------------------------------------------------------------------
-- чтобы не было смещения экрана вниз при частоте VGA 60 Гц 
-- пропускаются 32 строки экрана Спектрума сверху экрана, 
-- что соответствует 64 строкам VGA.

-- кадровые синхроимпульсы для VGA
-- для частоты кадров 60 Гц: 
VGA_KSI  <= '0' when ((VGA_V = 74 or VGA_V = 75) and SET_FK_OUT = '1')
-- для частоты кадров 48/50 Гц: 
                  or ((VGA_V = 10 or VGA_V = 11) and SET_FK_OUT = '0') else '1';

-- кадровые гасящие импульсы для VGA
-- для частоты кадров 60 Гц: 
VGA_KGI  <= '0' when (VGA_V < 109 and SET_FK_OUT = '1')
-- для частоты кадров 48/50 Гц: 
                  or (VGA_V < 65 and SET_FK_OUT = '0') else '1';

---- кадровые синхроимпульсы для VIDEO
--VIDEO_KSI  <= '0' when VIDEO_V < 4 else '1';
--
---- кадровые гасящие импульсы для VIDEO
--VIDEO_KGI  <= '0' when VIDEO_V < 16 else '1';


--------------------------------------------------------------------------------
--                    ФОРМИРОВАНИЕ СИНХРОСМЕСИ ДЛЯ VIDEO              090820  --
--------------------------------------------------------------------------------
--VIDEO_SYNC <= VIDEO_SSI2 when VIDEO_KSI = '0' else VIDEO_SSI1;

--------------------------------------------------------------------------------
--                    ФОРМИРОВАНИЕ СМЕСИ ГАСЯЩИХ ИМПУЛЬСОВ            090820  --
--------------------------------------------------------------------------------

-- гасящие импульсы для VGA
VGA_BLANK   <= VGA_KGI and VGA_SGI;

---- гасящие импульсы для VIDEO
--VIDEO_BLANK <= VIDEO_KGI and VIDEO_SGI;


--------------------------------------------------------------------------------
--                     МУЛЬТИПЛЕКСИРОВАНИЕ АДРЕСОВ ОЗУ                090812  --
--------------------------------------------------------------------------------

-- если цикл записи и выходная частота кадров 50/48 Гц:
A <= "00000000" & VIDEO_V(0) & VIDEO_H(9 downto 2)
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='0')

-- если цикл записи и выходная частота кадров 60 Гц:
else VIDEO_V(8 downto 0) & VIDEO_H(9 downto 2) 
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='1')

-- если цикл чтения и выходная частота кадров 50/48 Гц:
else "00000000" & (not VIDEO_V(0)) & VGA_H(8 downto 1) 
                                        when (VIDEO_H(0)='0' and SET_FK_OUT='0')

-- если цикл чтения и выходная частота кадров 60 Гц:
else VGA_V(9 downto 1) & VGA_H(8 downto 1);


--------------------------------------------------------------------------------
--                       ПЕРЕДАЧА ДАННЫХ ЧЕРЕЗ ОЗУ                    090817  --
--------------------------------------------------------------------------------
-- управление выводом на шину данных (запись произойдет по фронту WE) 
D(7 downto 0) <= WR_REG when VIDEO_H(0) = '1' else (others => 'Z');

process (VIDEO_H(0), F14, VGA_H)                   
begin
  if (rising_edge(VIDEO_H(0))) then -- по фронту 
--------------------------------------------------------------------------------
      -- запись кода двух точек VIDEO в регистр для записи в ОЗУ
      if VIDEO_H(1) = '0' then  
          WR_REG(3) <= R; -- запись точки в младший полубайт регистра
          WR_REG(2) <= G;
          WR_REG(1) <= B;
          WR_REG(0) <= I;
      else
          WR_REG(7) <= R; -- запись точки в старший полубайт регистра
          WR_REG(6) <= G;
          WR_REG(5) <= B;
          WR_REG(4) <= I;
      end if;
--------------------------------------------------------------------------------
  end if;

  if (rising_edge(F14) and VGA_H(0)='0') then -- по фронту OE
      -- чтение кода двух точек из ОЗУ в регистр для вывода на VGA
      RD_REG <= D(7 downto 0);

--------------------------------------------------------------------------------
  end if;

end process;


--------------------------------------------------------------------------------
--                  ФОРМИРОВАНИЕ СИГНАЛОВ УПРАВЛЕНИЯ ОЗУ              090812  --
--------------------------------------------------------------------------------

-- сигнал записи в  ОЗУ  
WE <= F14 or (VIDEO_H(1) nand VIDEO_H(0));
-- сигнал чтения из ОЗУ   
OE <= F14 or VIDEO_H(0);
--UB <= '1'; -- старший байт ШД ОЗУ(D15..D8) пока не используется
--LB <= '0'; -- активация младшего байта ШД ОЗУ (D7..D0)


--------------------------------------------------------------------------------
--         РАЗДЕЛЕНИЕ БАЙТА ИЗ ОЗУ НА ОТДЕЛЬНЫЕ ТОЧКИ ДЛЯ VGA         090812  --
--------------------------------------------------------------------------------
-- разделение точек при чтении из регистра
R3  <= RD_REG(3) when VGA_H(0) = '0' else RD_REG(7);
G3  <= RD_REG(2) when VGA_H(0) = '0' else RD_REG(6);
B3  <= RD_REG(1) when VGA_H(0) = '0' else RD_REG(5);
I3  <= RD_REG(0) when VGA_H(0) = '0' else RD_REG(4);

--------------------------------------------------------------------------------
--                      ВЫВОД СИГНАЛОВ НА ГНЕЗДО VGA                  100216  --
--------------------------------------------------------------------------------
process (F14) 
begin
--if (rising_edge(F14)) then  -- если фронт тактового импульса, переход из 0 в 1
  if (falling_edge(F14)) then  -- если спад тактового импульса, переход из 1 в 0

--    if VGA_SCART = '1' then      -- если вывод сигналов для VGA: 

      R_VGA  <= VGA_BLANK and R3; -- подаем цвет VGA на выход
      G_VGA  <= VGA_BLANK and G3;
      B_VGA  <= VGA_BLANK and B3;

      if (I3 and VGA_BLANK) = '0'  then          -- если яркость пониженная:
          I_VGA <= "000";        -- уменьшаем сигнал подключением резисторов к 0
      else
          I_VGA <= "ZZZ";        -- резисторы отключены
      end if;

      VSYNC_VGA <= VGA_KSI;      -- кадровые синхроимпульсы для VGA
      HSYNC_VGA <= VGA_SSI;      -- строчные синхроимпульсы для VGA
     
-- убран вывод на SCART --   
--    else                         -- иначе, вывод сигналов для SCART
--    
--      R_VGA  <= VIDEO_BLANK and R; -- подаем цвет VIDEO на выход
--      G_VGA  <= VIDEO_BLANK and G;
--      B_VGA  <= VIDEO_BLANK and B;
--
--      if (I and VIDEO_BLANK) = '0'  then          -- если яркость пониженная:
--          I_VGA <= "000";        -- уменьшаем сигнал подключением резисторов к 0
--      else
--          I_VGA <= "ZZZ";        -- резисторы отключены
--      end if;
--
--      VSYNC_VGA <= VIDEO_SYNC;   -- синхросмесь VIDEO
--      HSYNC_VGA <= '1';          -- разрешение RGB на SCART
--    
--    end if;
  end if;
end process;

--------------------------------------------------------------------------------
--                      ВЫВОД СИГНАЛОВ НА PAL-CODER                   090820  --
--------------------------------------------------------------------------------
--process (F14) 
--begin
--if (rising_edge(F14)) then  -- если фронт тактового импульса, переход из 0 в 1
----if (falling_edge(F14)) then  -- если спад тактового импульса, переход из 1 в 0
--  
--      R_VIDEO  <= VIDEO_BLANK and R; -- подаем цвет на выход
--      G_VIDEO  <= VIDEO_BLANK and G;
--      B_VIDEO  <= VIDEO_BLANK and B;
--
--      if (I and VIDEO_BLANK) = '0'  then          -- если яркость пониженная:
--          I_VIDEO <= "000";      -- уменьшаем сигнал подключением резисторов к 0
--      else
--          I_VIDEO <= "ZZZ";      -- резисторы отключены
--      end if;
--
--      SYNC_VIDEO  <= VIDEO_SYNC; -- подаем синхросмесь VIDEO
--
--  end if;
--end process;


--------------------------------------------------------------------------------

end RTL;

