#!/bin/bash

#			options+=("${1%=*}")
#			values+=("${1#*=}")
echo \
'''
 0 : HLT
1-9: REG
 A : ADC
 B : SBB
 C : AND
 D : OR
 E : EOR
 F : MOV

1 9 A: ADD R1,R9
1 
_______________________________________________________________________________
PVIIISSS

??000???|HLT
??001???|BCD
??010???|ALU
??011???|BRK
??100???|REG
??101???|ARG
??110???|INT

« »…
	.1	.2	.3	.4
M1	->IP	->IC
M2	->VA	->VB	->VC	->VD
M3	->A0	->Rcv	->Trs
M4	<-M/D	
M5	<-IP
M6	<-VA	<-VB	<-VC	<-VD
M7	<-A0	<-Rcv	<-Trs
M8	->M/D

     .0 .1 .2 .3 .4 .5 .6 .7 .8 .9 .A .B .C .D .E .F
??A0 A0 A1 A2 A3 A4 A5 A6 A7 A8 A9 -- -- -- -- -- An
??B0 B0 B1 B2 B3 B4 B5 B6 B7 B8 B9 VA VB VC VD IP Bn
??C0 C0 C1 C2 C3 C4 C5 C6 C7 C8 C9 VA VB VC VD IP Cn
??D0 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- Dn
??E0 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
??F0 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

VA - Vector Applies (Mask bits)
VB - Vector Base (Base index & Bits mask)
VC - Vector Counters Index
VD - Vector Data offset

M1	Fetch		Get IP IC
M2	Vector		Get IV
M3	Arguments	Get RT REGS A0
M4	Memory/Device	Get RAM/DEV
M5			Put IP
M6			Put IV
M7			Put RT REGS A0
M8			Put RAM/DEV
M9			---



2-И	4
2-И-НЕ	7
3-И-НЕ	3
2-ИЛИ-НЕ 1
3-ИЛИ-НЕ 2

M0	Get A0/PSW
M1	Get Operand #1
M2	Get Operand #2
M3	Get Memory
M4	Get Device
M5	
M6	
M7	
M8	
M9	
M10	Put A0/PSW
M11	Put Operand #1
M12	Put Operand #2
M13	Put Memory
M14	Put Device

Notes:
?MA0A0A	ADD	A0,M,A0	; INC	M		# Uncondition Increment
?MA0A0B	SUB	A0,M,A0	; DEC	M		# Uncondition Decrement
?MA0A0C	AND	A0,M,A0	; CLR	M		# Uncondition Clear
?MA0A0D	OR	A0,M,A0	; SET	M		# Uncondition Set
?MA0A0E	EOR	A0,M,A0	; NOT	M		# Uncondition Inverse
?MA0A0F	MOV	A0,M,A0	; MOV	A0,M
	;;;;;;;;;;;;;;;;;
?RA0A0A	ADD	A0,A0	; REA			#
?RA0A0B	SUB	A0,A0	; REB
?RA0A0C	AND	A0,A0	; REC
?RA0A0D	OR	A0,A0	; RED
?RA0A0E	EOR	A0,A0	; REE
?RA0A0F	MOV	A0,A0	; REF			#
	;;;;;;;;;;;;;;;;;
?MA0D?A	ADD	A0,M,D2	; ADD	M,D2
?MA0D?B	SUB	A0,M,D2	; SUB	M,D2
?MA0D?C	AND	A0,M,D2	; AND	M,D2
?MA0D?D	OR	A0,M,D2	; OR	M,D2
?MA0D?E	EOR	A0,M,D2	; EOR	M,D2
?MA0D?F	MOV	A0,M,D2	; MOV	M,D2
	;;;;;;;;;;;;;;;;;
?RA0D?A	ADD	A0,D2	; INC	D2		# Uncondition Increment
?RA0D?B	SUB	A0,D2	; DEC	D2		# Uncondition Decrement
?RA0D?C	AND	A0,D2	; CLR	D2		# Uncondition Clear
?RA0D?D	OR	A0,D2	; SET	D2		# Uncondition Set
?RA0D?E	EOR	A0,D2	; NOT	D2		# Uncondition Inverse
?RA0D?F	MOV	A0,D2	; INF	@2		# Try for Input from Port @2 with Flags sets
	;;;;;;;;;;;;;;;;;
?MA0??A	ADD	A0,M,A1	; ADD	M,A1
?MA0??B	SUB	A0,M,A1	; SUB	M,A1
?MA0??C	AND	A0,M,A1	; AND	M,A1
?MA0??D	OR	A0,M,A1	; OR	M,A1
?MA0??E	EOR	A0,M,A1	; EOR	M,A1
?MA0??F	MOV	A0,M,A1	; MOV	M,A1 ???
	;;;;;;;;;;;;;;;;;
?RA0??A	ADD	A0,A1	; INC	A1		# Uncondition Increment
?RA0??B	SUB	A0,A1	; DEC	A1		# Uncondition Decrement
?RA0??C	AND	A0,A1	; CLR	A1		# Uncondition Clear
?RA0??D	OR	A0,A1	; SET	A1		# Uncondition Set
?RA0??E	EOR	A0,A1	; NOT	A1		# Uncondition Inverse
?RA0??F	MOV	A0,A1	; MOV	A0,A1
	;;;;;;;;;;;;;;;;;
?MD?A0A	ADD	D2,M,A0	; ADD	D2,M
?MD?A0B	SUB	D2,M,A0	; SUB	D2,M
?MD?A0C	AND	D2,M,A0	; AND	D2,M
?MD?A0D	OR	D2,M,A0	; OR	D2,M
?MD?A0E	EOR	D2,M,A0	; EOR	D2,M
?MD?A0F	MOV	D2,M,A0 ; MOV	D2,M
	;;;;;;;;;;;;;;;;;
?RD?A0A	ADD	D2,A0	; INC	D2,CF
?RD?A0B	SUB	D2,A0	; DEC	D2,CF
?RD?A0C	AND	D2,A0	; CLR	D2,CF
?RD?A0D	OR	D2,A0	; SET	D2,CF
?RD?A0E	EOR	D2,A0	; NOT	D2,CF
?RD?A0F	MOV	D2,A0	; OUF	@2		# Try for Output to Port @2 with Flags sets
	;;;;;;;;;;;;;;;;;
?M??A0A	ADD	A1,M,A0	; ADD	A1,M
?M??A0B	SUB	A1,M,A0	; SUB	A1,M
?M??A0C	AND	A1,M,A0	; AND	A1,M
?M??A0D	OR	A1,M,A0	; OR	A1,M
?M??A0E	EOR	A1,M,A0	; EOR	A1,M
?M??A0F	MOV	A1,M,A0	; MOV	A1,M
	;;;;;;;;;;;;;;;;;
?R??A0A	ADD	A1,A0	; AE
?R??A0B	SUB	A1,A0	; BE
?R??A0C	AND	A1,A0	; CE
?R??A0D	OR	A1,A0	; DE
?R??A0E	EOR	A1,A0	; EE
?R??A0F	MOV	A1,A0	; MOV	A1,A0
	;;;;;;;;;;;;;;;;;
?MD?D?A	ADD	D2,M,D3	; ADD	D2,M,D3
?MD?D?B	SUB	D2,M,D3	; SUB	D2,M,D3
?MD?D?C	AND	D2,M,D3	; AND	D2,M,D3
?MD?D?D	OR	D2,M,D3	; OR	D2,M,D3
?MD?D?E	EOR	D2,M,D3	; EOR	D2,M,D3
?MD?D?F	MOV	D2,M,D3	; ORD	D2,M,D3		# Sort registers
	;;;;;;;;;;;;;;;;;
?RD?D?A	ADD	D2,D3	; ADD	D2,D3
?RD?D?B	SUB	D2,D3	; SUB	D2,D3
?RD?D?C	AND	D2,D3	; AND	D2,D3
?RD?D?D	OR	D2,D3	; OR	D2,D3
?RD?D?E	EOR	D2,D3	; EOR	D2,D3
?RD?D?F	MOV	D2,D3	; MOV	D2,D3
	;;;;;;;;;;;;;;;;;
?MD???A	ADD	D2,M,A1	; ADD	D2,M,A1
?MD???B	SUB	D2,M,A1	; SUB	D2,M,A1
?MD???C	AND	D2,M,A1	; AND	D2,M,A1
?MD???D	OR	D2,M,A1	; OR	D2,M,A1
?MD???E	EOR	D2,M,A1	; EOR	D2,M,A1
?MD???F	MOV	D2,M,A1	; 
	;;;;;;;;;;;;;;;;;
?RD???A	ADD	D2,A1	; ADD	D2,A1		# Adding 16-bit D2(B2C2) with 8-bit A1 expanded to 16-bits
?RD???B	SUB	D2,A1	; SUB	D2,A1		# Subtract 16-bit D2(B2C2) with 8-bit A1 expanded to 16-bits
?RD???C	AND	D2,A1	; AND	D2,A1		# Conjunct 16-bit D2(B2C2) with 8-bit A1 expanded to 16-bits
?RD???D	OR	D2,A1	; OR	D2,A1		# Disjunct 16-bit D2(B2C2) with 8-bit A1 expanded to 16-bits
?RD???E	EOR	D2,A1	; EOR	D2,A1		# Exclude 16-bit D2(B2C2) with 8-bit A1 expanded to 16-bits
?RD???F	MOV	D2,A1	; MOV	@2,A1		# Output A1 to Port @2
	;;;;;;;;;;;;;;;;;
?M??D?A	ADD	A1,M,D2	; ADD	A1,M,@2
?M??D?B	SUB	A1,M,D2	; SUB	A1,M,@2
?M??D?C	AND	A1,M,D2	; AND	A1,M,@2
?M??D?D	OR	A1,M,D2	; OR	A1,M,@2
?M??D?E	EOR	A1,M,D2	; EOR	A1,M,@2
?M??D?F	MOV	A1,M,D2	; 
	;;;;;;;;;;;;;;;;;
?R??D?A	ADD	A1,D2	; ADD	A1,@2
?R??D?B	SUB	A1,D2	; SUB	A1,@2
?R??D?C	AND	A1,D2	; AND	A1,@2
?R??D?D	OR	A1,D2	; OR	A1,@2
?R??D?E	EOR	A1,D2	; EOR	A1,@2
?R??D?F	MOV	A1,D2	; MOV	A1,@2		# Input from Port @2
	;;;;;;;;;;;;;;;;;
?M????A	ADD	A1,M,A2	; ADD	A1,M,A2
?M????B	SUB	A1,M,A2	; SUB	A1,M,A2
?M????C	AND	A1,M,A2	; AND	A1,M,A2
?M????D	OR	A1,M,A2	; OR	A1,M,A2
?M????E	EOR	A1,M,A2	; EOR	A1,M,A2
?M????F	MOV	A1,M,A2	; ORD	A1,M,A2		# Sort registers
	;;;;;;;;;;;;;;;;;
?R????A	ADD	A1,A2	; ADD	A1,A2
?R????B	SUB	A1,A2	; SUB	A1,A2
?R????C	AND	A1,A2	; AND	A1,A2
?R????D	OR	A1,A2	; OR	A1,A2
?R????E	EOR	A1,A2	; EOR	A1,A2
?R????F	MOV	A1,A2	; MOV	A1,A2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MOV		A0,[RAM],A0	; Тернарное присвоение невозможно
		MOV	A0,[RAM]	; Работает как загрузка флагов из памяти
	ALU		A0,[RAM],A0	; Тернарные вычисления невозможны
		UNAR	[RAM]		; Работает как унарные операции
		add:INC	[RAM]		; Сложение - это инкремент
		sub:DEC	[RAM]		; Вычитание - это декремент
		and:CLR	[RAM]		; Конъюнкция - это сброс всех битов
		or:SET	[RAM]		; Дизъюнкция - это установка всех битов
		eor:NOT	[RAM]		; Исключающее ИЛИ - инверсия всех битов
	MOV/ALU		A0,A0		; Рекурсивное присвоение/вычисление флагов невозможно
	ALU		A0,[RAM],Dn	; Вычисление памяти и порта с сохранением в флаги невозможно
		ALU	[RAM],Dn	; Работает как операция памяти с регистровой парой Bn:Cn
	MOV		A0,Dn		; Загрузка из порта в флаги невозможна
		INF	Dn		; Работает как тест на чтение из порта
	ALU		A0,Dn		; Вычисление флагов и порта невозможно
		UNAR	Dn		; Работает как унарные INC/DEC/CLR/SET/NOT над парой Bn:Cn
	ALU		A0,Rn		; Вычисление флагов и РОН невозможно
		UNAR	Rn		; Работает как унарные INC/DEC/CLR/SET/NOT над РОН
	MOV		Dn,[RAM],Dm	; Тернарное присвоение невозможно
		ORD	Dn,[RAM],Dm	; Работает как упорядочивание MIN(Dn)..MID([RAM])..MAX(Dm)
	MOV		Dn,[RAM],Dn	; Тернарное присвоение с одинаковыми операнндами невозможно
		LEA	Dn,[RAM]	; Работает как загрузка эффективного адреса
	MOV		Rn,[RAM],Rm	; Тернарное присвоение невозможно
		ORD	Rn,[RAM],Rm	; Работает как упорядочивание MIN(Rn)..MID([RAM])..MAX(Rm)
	MOV		Rn,[RAM],Rn	; Тернарное присвоение с одинаковыми операнндами невозможно
		LEX	Rn,[RAM]	; Работает подобно x86-XLAT: Rn <- [RAM + Rn]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
?MA0A0F	MOV	A0,M,A0	; MOV	A0,M	; 
?MA0A0?	ALU	A0,M,A0	; REG	M	; INC DEC CLR SET NOT
;;;;;;;
?RA0A0?	???	A0,A0	; ???	---	; ???
;;;;;;;
?MA0D??	ALU	A0,M,D?	; ALU	M,D?	; 
;;;;;;;
?RA0D?F	MOV	A0,D?	; INF	@?	; 
?RA0D??	ALU	A0,D?	; REG	D	; INC DEC CLR SET NOT
;;;;;;;
?MA0??F	MOV	A0,M,??	; MOV	M,??	; 
?MA0???	ALU	A0,M,??	; ALU	M,??	; 
;;;;;;;
?RA0??F	MOV	A0,??	; MOV	A0,??	; 
?RA0???	ALU	A0,??	; REG	R	; INC DEC CLR SET NOT
;;;;;;;
?MD?A0F	MOV	D?,M,A0	; MOV	D?,M	; 
?MD?A0?	ALU	D?,M,A0	; ALU	D?,M	; 
;;;;;;;
?RD?A0F	MOV	D?,A0	; OUF	@?	; 
?RD?A0?	ALU	D?,A0	; REG	D,CF	; INC DEC CLR SET NOT
;;;;;;;
?M??A0?	ALU	R?,M,A0	; ALU	R?,M	; 
;;;;;;;
?R??A0F	MOV	R?,A0	; MOV	R?,A0	; 
?R??A0?	ALU	R?,A0	; REG	R,CF	; INC DEC CLR SET NOT
;;;;;;;
?MD?D?F	MOV	D?,M,D?	; ORD	D?,M,D?	; LEA	D?,M (R=T)
?MD?D??	ALU	D?,M,D?	; ALU	D?,M,D?	; 
;;;;;;;
?RD?D??	ALU	D?,D?	; ALU	D?,D?	; 
;;;;;;;
?MD???F	MOV	D?,M,R?	; ???	D?,M,R?	; ???
?MD????	ALU	D?,M,R?	; ALU	D?,M,R?	; 
;;;;;;;
?RD???F	MOV	D?,R?	; MOV	@?,R?	; 
?RD????	ALU	D?,R?	; ALU	D?,R?	; 
:;;;;;;
?M??D?F	MOV	R?,M,D?	; ???	R?,M,@?	; 
?M??D??	ALU	R?,M,D?	; ALU	R?,M,@?	; 
;;;;;;;
?R??D??	ALU	R?,D?	; ALU	R?,@?	; 
;;;;;;;
?M????F	MOV	R?,M,R?	; ORD	R?,M,R?	; LEX/XLAT R?,M (R=T)
?M?????	ALU	R?,M,R?	; ALU	R?,M,R?	; 
;;;;;;;
?R?????	ALU	R?,R?	; ALU	R?,R?	; 

10 9F			; ALU	R?,[D1+0],R9
10 10 9F		; ALU	R?,[D1-0],R9
10 10 20 9F		; ALU	R?,[D1-D2],R9
10 10 10 9F		; ALU	R?,[$+0],R9
10 10 10 10 9F		; ALU	R?,[$-0],R9
10 10 10 20 9F		; ALU	R?,[$-D2],R9

''' >/dev/null

testing="00 DA D1 0F 12 0F AD A0 1F 12 1F AB 1F DD D5 12 6F 12 5F CC C4 12 4F 12 5F A5 20 20 80 80 60 60 00"
tests=(${testing})

function tty_height {
	local	ROW COL
	IFS=';' read -sdR -p $'\E[s\E[999B\E[6n\E[u' ROW COL >/dev/tty
	echo "${ROW#*[}"
}

function tty_width {
	local	ROW COL
	IFS=';' read -sdR -p $'\E[s\E[999C\E[6n\E[u' ROW COL >/dev/tty
	echo "${COL}"
}

function InKey {
	local	KEY K S T __V1
	if read -rsn 1 -d '' "${T[@]}" "${S[@]}" K
	then
		if [[ $K == $'\e' ]]
		then
			if [[ BASH_VERSINFO -ge 4 ]]
			then
				T=(-t 0.05)
			else
				T=(-t 1)
			fi
			if read -rsn 1 -d '' "${T[@]}" "${S[@]}" K
			then
				case "$K" in
				\[)	echo -n "["
					while
						read -rsn 1 -d '' "${T[@]}" "${S[@]}" K && \
						[[ $K != [[:upper:]~] ]]
					do
						echo -n "$K"
					done
					;;
				O)	echo -n "O"
					read -rsn 1 -d '' "${T[@]}" K
					;;
				[[:print:]]|$'\t'|$'\e')
					echo -n "_"
					;;
				*)	echo -n "!"$K
					;;
				esac
			else
				echo -n "Esc$K"
			fi
		fi
	fi
	echo -n "$K"
	#echo -n ${KEY[0]} ${KEY[1]} ${KEY[2]} ${KEY[3]}
}

function dump_show {
	address=$1
	redraw=1
	z=0
	clear
	while [ 1 ]
	do
		let address=$((address&0xFFFF))
		if [ $redraw -eq 1 ]
		then
			addr=$((address&0xFF00))
			printf "\e[1;1H"
			for y in {0..15}
			do
				printf "%04X" $addr
				for x in {0..15}
				do
					printf " %2s" ${memory[addr]}
					let	addr+=1
				done
				printf "\n"
			done
			redraw=0
		fi
		x=$(((address&15)*3+6+$z))
		y=$((((address>>4)&15)+1))
		printf "\e[%d;%dH" $y $x
		Key=(`InKey`)
		case ${Key} in
		\[A)
			let address+=65520
			if [ $((address&0xF0)) -eq 240 ]
			then
				redraw=1
			fi
			;;
		\[B)
			let address+=16
			if [ $((address&0xF0)) -eq 0 ]
			then
				redraw=1
			fi
			;;
		\[C)
			let z^=1
			if [ $z -eq 0 ]
			then
				let address+=1
				if [ $((address&0xFF)) -eq 0 ]
				then
					redraw=1
				fi
			fi
			;;
		\[D)
			let z^=1
			if [ $z -ne 0 ]
			then
				let address+=65535
				if [ $((address&0xFF)) -eq 255 ]
				then
					redraw=1
				fi
			fi
			;;
		\[5~)
			let address+=65280
			redraw=1
			;;
		\[6~)
			let address+=256
			redraw=1
			;;
		[0-9A-Fa-f])
			byte=${memory[$address]}
			if [ $z -eq 0 ]
			then
				memory[$address]="${Key^^}${byte:1:1}"
			else
				memory[$address]="${byte:0:1}${Key^^}"
				let address+=1
			fi
			let z^=1
			redraw=1
			;;
		*)	return
			;;
		esac
	done
}

#utils_implode KEY __V0

function KeyTest {
	while [ 1 ]
	do
		Key=(`InKey`)
		case ${Key} in
		\t)		echo Tab;;
		O[PQRS])	echo F1-F4;;
		\[[ABCD])	echo Arrows;;
		\[[0-9]~)	echo Paging;;
		\[[0-9][0-9]~)	echo F5-F12;;
		\[1\;3P)	echo AltF1;;
		esac
		printf "[%s]" "${Key[*]}"
		echo
	done
}

function read_bin {
	xxd -s 0 -l 65536 -g 1 "$1" | tr a-f A-F | sed -E "s/^.{9}(.{3,48})?.*$/\1/g;s/([0-9a-f]+):?/\1/g"
}

function asm_Px2 {
	let asm_Px[0]+=${asm_Px[0]}
	let asm_Px[1]+=${asm_Px[1]}
	let asm_Px[2]+=${asm_Px[2]}
	let asm_Px[3]+=${asm_Px[3]}
	let asm_Px[4]+=${asm_Px[4]}
	let asm_Px[5]+=${asm_Px[5]}
	let asm_Px[6]+=${asm_Px[6]}
	let asm_Px[7]+=${asm_Px[7]}
	let asm_Px[8]+=${asm_Px[8]}
	let asm_Px[9]+=${asm_Px[9]}
}

#					   8 4   2        1
#	------------------------------------------------------------------------------------------------------
# 0000	ADD A0,A0	RET		rt=A,A	A0	0:1=0	ALU_RETURN	REA REB REC RED RET - IP/D0..9
# 0000	ADD A0,[P],A0	INC [P]		rt=A,A	A0	0:1=0	ALU_USERAM	INC DEC CLR SET NOT - RAM
# 0101	ADD A0,A1	INC A1		rt=A,?	A0	0:1=?	ALU_USEREG	INC DEC CLR SET NOT - REG
# 0101	ADD A0,[P],A1	ADD [P],A1	rt=A,?	A0	0:1=?	ALU_RAMREG	ADD SUB AND OR  EOR - RAM,REG
# 1010	ADD A1,A0			rt=?,A	??	0:1=0	ALU_CALLER	AE  BE  CE  DE
# 1010	ADD A1,[P],A0	ADD A1.[P]	rt=?,A	??	0:1=0	ALU_REGRAM	ADD SUB AND OR  EOR - REG,RAM
echo '''

''' /dev/null
function cpu_peep {
	local	is_pfx=false
	local	rec=asm_${asm_rt:0:1}
	local	vector=""			# "v" - vector
	local	vectors=""			# "w" - vector
	local	rcv=${!rec}			# "r" - receiver
	local	trs=${asm_rt:1:1}${1:0:1}	# "t" - translator
	local	asm
	local	rem=""
	local	ops_idx=$((16#${1:1:1}-10))
	local	ops_idy=$((16#${1:1:1}))
	local	term
	local	alu_ops=("" "" "" "" "" "" "" "" "" "" "ADD" "SUB" "AND" "OR" "EOR" "MOV")	# alu
	local	reg_ops=("" "" "" "" "" "" "" "" "" "" "INC" "DEC" "CLR" "SET" "NOT" "---")	# reg
	local	ret_ops=("" "" "" "" "" "" "" "" "" "" "REA" "REB" "REC" "RED" "RET" "---")	# ret
	local	inf_ops=("" "" "" "" "" "" "" "" "" "" "?A?" "?B?" "?C?" "?D?" "?E?" "INF")	# inf
	local	ouf_ops=("" "" "" "" "" "" "" "" "" "" "?A?" "?B?" "?C?" "?D?" "?E?" "OUF")	# ouf
	local	xxx_ops=("" "" "" "" "" "" "" "" "" "" "?A?" "?B?" "?C?" "?D?" "?E?" "")	# xxx
	local	aluo=${alu_ops[$ops_idy]}
	local	rego=${reg_ops[$ops_idy]}
	local	reto=${ret_ops[$ops_idy]}
	local	info=${inf_ops[$ops_idy]}
	local	oufo=${ouf_ops[$ops_idy]}
	local	xxxo=${xxx_ops[$ops_idy]}
	local	a=${1:0:1} b=${1:1:1} r=${!rec} t=${asm_rt:1:1}${1:0:1} v w
	local	A=${alu_ops[$ops_idy]}
	local	R=${reg_ops[$ops_idy]}
	local	T=${ret_ops[$ops_idy]}
	local	I=${inf_ops[$ops_idy]}
	local	O=${ouf_ops[$ops_idy]}
	local	X=${xxx_ops[$ops_idy]}
	local	lea="O"
	###
	asm_cmd=$1
	if [ "$rcv" == "$trs" ]
	then
		lea="L"
	fi
				asm_vector="$asm_padding#D$asm_base"
				for i in {1..9}
				do
					if [ ${asm_Px[$i]} -gt 1 ]
					then
						asm_vector+="+"${asm_Px[$i]}"D"$i
					elif [ ${asm_Px[$i]} -gt 0 ]
					then
						asm_vector+="+D"$i
					fi
				done
				asm_vector+="+$asm_offset"

	if [ -z $asm_base ]
	then
		if [ $asm_pad -eq 0 ]
		then
			if [ $is_complex == true ]
			then term=$lea"SR"$rcv${asm_rt:1:1}$1	# Standard Reg/Reg operation
			else term=$lea"DR"$rcv${asm_rt:1:1}$1	# Detailed Reg/Reg operation
			fi
		else
			if [ $is_complex == true ]
			then term=$lea"SM"$rcv${asm_rt:1:1}$1	# Standard Memory operation
			else term=$lea"DM"$rcv${asm_rt:1:1}$1	# Detailed Memory operation
			fi
			vectors="$asm_padding#D$asm_pad+$asm_offset,"
			vector="$asm_padding#D$asm_pad+$asm_offset"
		fi
	else
		if [ $is_complex == true ]
		then term=$lea"SM"$rcv${asm_rt:1:1}$1	# Standard Memory operation
		else term=$lea"DM"$rcv${asm_rt:1:1}$1	# Detailed Memory operation
		fi
		if [ ${#asm_vector} -lt 20 ]
		then
			vectors=$asm_vector","
			vector=$asm_vector
		else
			vectors=`printf "%s\U2026%s," ${asm_vector:0:7} ${asm_vector: -10}`
			vector=`printf "%s\U2026%s" ${asm_vector:0:8} ${asm_vector: -10}`
		fi
	fi
	v=$vector
	w=$vectors
	case "$term" in
	??R???00)
		asm="HLT "
		rem="System HALT"
		;;
	??M???00)
		asm="JMP $v"
		rem="Jump / Return"
		;;
	??????[0-9][0-9])
		if [ "$asm_base" == "" ]
		then
			asm_vector=$asm_padding"#"
			asm_offset=${1:1:1}
			if [ "${1:1:1}" == "0" ]
			then
				asm_Px=(0 0 0 0 0 0 0 0 0 0)
				if [ $asm_pad -eq 0 ]
				then
					let asm_pad=${1:0:1}
					asm_vector+="#D${1:0:1}"
					rem="is Base #D${1:0:1}?"
				elif [ $asm_pad -eq ${1:0:1} ]
				then
					asm_padding+=$asm_pad
					rem="Padding $asm_padding#"
					asm_offset=""
					let asm_pad=0
				else
					asm_base=${1:0:1}
					asm_vector+="D"$asm_base
					let asm_Px[${1:0:1}]+=1
					rem="Base #D$asm_base"
				fi
			else
				asm_base=${1:0:1}
				asm_vector+="D"$asm_base
				let asm_factor=0
				rem=" # Basic vector"
			fi
		else
			if [ "$asm_base" == "${1:0:1}" ] && [ "${1:1:1}" == "0" ] && [ $asm_factor -lt 0 ]
			then
				let asm_factor-=1
			else
				[ $asm_factor -lt 0 ] && asm_factor=$((-asm_factor))
				if [ "$asm_offset" == "0" ]
				then
					asm_offset=${1:1}
				else
					asm_offset=$asm_offset${1:1}
				fi
				if [ $asm_base == ${1:0:1} ]
				then
					asm_Px2
				elif [ $((${asm_Px[${1:0:1}]}%2)) -gt 0 ]
				then
					asm_Px2
					let asm_Px[${1:0:1}]+=1
				else
					let asm_Px[${1:0:1}]+=1
				fi
				#
			fi
		fi
		asm=""
		asm_vector+="+"$asm_offset
		if [ "$is_complex" == "false" ]
		then
			asm_ins=`printf "... %s" $asm_vector`
			is_pfx=true
		fi
		asm_pfx=$1
		asm_cmd="  "
		;;
	??????[EF][0-9A-F])
		asm="HLT $a$b $v"
		rem="Optional HALT to $a$b00";;
	??M???[A-D][EF])
		asm="$a$b  $v"
		rem="Conditional JUMP/RET";;
	??R???[A-D][EF])
		asm="$a$b  "
		rem="Flags control";;
	?DR???[A-D][0-9])
		if [ ${asm_rt:0:1} == ${1:0:1} ]
		then
			asm_reg=$1
			asm_cmd="  "
			asm="REG $a$b"
			rem="Select accumulator"
			eval asm_${1:0:1}="${1:0:2}"
		else
			asm="??? $a$b"
			rem="ARG ${asm_rt:0:1},${asm_rt:1:1} + REG $1 -> ???"
		fi
		;;
	?SR???[A-D][0-9])
		if [ ${asm_rt:0:1} == ${1:0:1} ]
		then
			asm_reg=$1
			asm_cmd="  "
			eval asm_${1:0:1}="${1:0:2}"
		else
			rem="reserved"
		fi
		;;
	?DR???[A-D][A-D])
		asm="ARG $a,$b"
		rem="Select operands pair"
		asm_rt=${1:0:2}
		asm_arg=$1
		asm_cmd="  "
		;;
	?SR???[A-D][A-D])
		asm_rt=${1:0:2}
		asm_arg=$1
		asm_cmd="  "
		;;
	??M???[A-D][0-9])
		asm="MOV $v,$1";	rem="Save to RAM";;
	??MA0A0F)asm="$A $r,$v";	rem="Load Flags";;
	??MA0A0?)asm="$R $v";		rem="Unar operations";;
	??RA0A0F)asm="$1";		rem="reserved FLAG";;
	??RA0A0?)asm="$1";		rem="reserved FLAG";;
	??MA0D?F)asm="SWP $v,$t";	rem="SWAP memory";;
	??MA0D??)asm="$A $v,$t";	rem="$A memory";;
	??RA0D?F)asm="INF @$t";		rem="Test Input";;
	??RA0D??)asm="$R $t";		rem="$R 16-bit";;
	??MA0??F)asm="SWP $v,$t";	rem="SWAP memory";;
	??MA0???)asm="$A $v,$t";	rem="$A memory";;
	??RA0??F)asm="$A $r,$t";	rem="$A";;
	??RA0???)asm="$R $t";		rem="$R 8-bit";;
	??MD?A0?)asm="$A $r,$v";	rem="$A with memory";;
	??RD?A0F)asm="OUF @$r";		rem="Test Output";;
	??RD?A0?)asm="$R $r,CF";	rem="$R 16-bit if CF";;
	??M??A0?)asm="$A $r,$v";	rem="$A with memory";;
	??R??A0F)asm="$A $r,$t";	rem="Load from memory";;
	??R??A0?)asm="$R $r,CF";	rem="$R 8-bit if CF";;
	L?MD?D?F)asm="LEA $r,$v";	rem="Load Address";;
	O?MD?D?F)asm="ORD $r,$v,$t";	rem="MIN-MID-MAX";;
	??MD?D??)asm="$A $r,$v,$t";	rem="$A 16-bit";;
	??RD?D??)asm="$A $r,$t";	rem="$A 16-bit";;
	??MD???F)asm="??? $r,$v,$t";	rem="reserved MOV";;
	??MD????)asm="$A $r,$v,$t";	rem="$A shift to 16-bit";;
	??RD???F)asm="$A @$r,$t";	rem="Output to Port";;
	??RD????)asm="$A $r,$t";	rem="$A shift to 8-bit";;
	??M??D?F)asm="??? $r,$v,$t";	rem="reserved MOV";;
	??M??D??)asm="$A $r,$v,@$t";	rem="$A with Port";;
	??R??D??)asm="$A $r,@$t";	rem="$A with Port";;
	L?M????F)asm="LEX $r,$v";	rem="Load Encoded XLAT";;
	O?M????F)asm="ORD $r,$v,$t";	rem="MIN-MID-MAX";;
	??M?????)asm="$A $r,$v,$t";	rem="$A with memory";;
	??R?????)asm="$A $r,$t";	rem="$A";;
	*)	asm="---";;
	esac
	if [ "$v" !=  "" ]
	then
		asm_ins=$asm
	else
		asm_ins=${asm// /$asm_padding }
	fi
	if [ "$asm_cmd" != "  " ] || [ "$is_complex" == "false" ]
	then
		if [ "$asm_pfx" != "  " ] && ([ "$asm_arg" != "  " ] || [ "$asm_reg" != "  " ])
		then
			printf "%2s %2s %2s %2s|%-26s%-22s" "$asm_arg" "$asm_reg" "$asm_pfx" "$asm_cmd" "$asm_ins" "$rem"
		else
			printf "%2s %2s %2s %2s|%-26s%-22s" "$asm_pfx" "$asm_arg" "$asm_reg" "$asm_cmd" "$asm_ins" "$rem"
		fi
		asm_pfx="  "
		asm_arg="  "
		asm_reg="  "
		asm_cmd="  "
		if ([ "$is_complex" != "false" ] || [ $is_pfx != true ])
		then
			asm_base=""
			asm_padding=""
			asm_pad=0
		fi
		return 1
	fi
}

function cpu_dis {
	printf "\e[s\e[2;1H"
	asm_rt=$cpu_rt
	asm_A=$cpu_A
	asm_B=$cpu_B
	asm_C=$cpu_C
	asm_D=$cpu_D
	asm_ip=$asm_addr
	asm_base=""
	asm_index=""
	asm_offset=""
	asm_vector=""
	asm_factor=0
	asm_pad=0
	asm_padding=""
	if [ $cpu_ip -gt $((asm_ip+lines*8/9)) ]
	then
		if [ $cpu_ip -gt $((asm_ip+lines)) ]
		then
			asm_ip=$((cpu_ip))
		else
			asm_ip=$((cpu_ip-lines*8/9))
		fi
		asm_addr=$asm_ip
	elif [ $cpu_ip -lt $((asm_ip)) ]
	then
		asm_ip=0
		[ $cpu_ip -gt 3 ] && asm_ip=$((cpu_ip-3))
		asm_addr=$asm_ip
	fi
	printf "\x2D%.0s" $(seq 1 $width)
		asm_pfx="  "
		asm_arg="  "
		asm_reg="  "
		asm_cmd="  "
		asm_ins="  "
		asm_base=""
	for i in $(seq 3 $(($height-1)))
	do
		printf "\e[%d;16H" $i
		if [ $asm_ip == $cpu_ip ]
		then
			printf "\e[7m%04X " $asm_ip
		else
			printf "%04X " $asm_ip
		fi
		while
			cpu_peep ${memory[$((asm_ip++))]}
		do
			printf ""
		done
		printf "\e[0m\e[K\n"
	done
	printf "\e[3;1H"
	for i in {0..9}
	do
		[ "${cpu_B:1:1}" == "$i" ] && printf "\e[1m"
		printf "B%d:%02X\e[0m " $i ${cpu_Bx[i]}
		[ "${cpu_C:1:1}" == "$i" ] && printf "\e[1m"
		printf "C%d:%02X\e[0m" $i ${cpu_Cx[i]}
		printf "\n"
	done
	printf "\e[7mF:%s" $( [ $((${cpu_Ax[0]}&8)) -eq 0 ] && echo "NS" || echo "SF")
	printf " %s" $( [ $((${cpu_Ax[0]}&4)) -eq 0 ] && echo "NO" || echo "OF")
	printf " %s" $( [ $((${cpu_Ax[0]}&2)) -eq 0 ] && echo "NC" || echo "CF")
	printf " %s" $( [ $((${cpu_Ax[0]}&1)) -eq 0 ] && echo "NZ" || echo "ZF")
	printf "\e[0m"
	for i in {0..9}
	do
		printf "\n"
		[ "${cpu_A:1:1}" == "$i" ] && printf "\e[1m"
		printf "A%d:%02X\e[0m " $i ${cpu_Ax[i]}
		[ "${cpu_D:1:1}" == "$i" ] && printf "\e[1m"
		printf "D%d\e[0m" $i
		[ "${cpu_B:1:1}" == "$i" ] && printf "\e[1m"
		printf ":%02X\e[0m" ${cpu_Bx[i]}
		[ "${cpu_C:1:1}" == "$i" ] && printf "\e[1m"
		printf "%02X\e[0m" ${cpu_Cx[i]}
	done
	printf "\e[u"
}

function show_frame {
	printf "\r\e[s"
	printf "\e[999;0H\e[0;34;47m\e[2K"
	printf "\e[0m1\e[37;44m\e[7m About "
	printf "\e[0m 2\e[47;44m\e[%d;34;47m Wrap  " $([ "$is_complex" == "true" ] && echo 1 || echo 0 )
	printf "\e[0m 3\e[34;47m Step  "
	printf "\e[0m 4\e[34;47m Edit  "
	printf "\e[0m 5\e[34;47m Reset "
	printf "\e[0m 6\e[34;47m Run   "
	printf "\e[0m 7\e[34;47m Assm  "
	printf "\e[0m 8\e[34;47m       "
	printf "\e[0m 9\e[34;47m       \e[0m"
	printf "\e[u"

}
function cpu_Px2 {
	let cpu_Px[0]+=${cpu_Px[0]}
	let cpu_Px[1]+=${cpu_Px[1]}
	let cpu_Px[2]+=${cpu_Px[2]}
	let cpu_Px[3]+=${cpu_Px[3]}
	let cpu_Px[4]+=${cpu_Px[4]}
	let cpu_Px[5]+=${cpu_Px[5]}
	let cpu_Px[6]+=${cpu_Px[6]}
	let cpu_Px[7]+=${cpu_Px[7]}
	let cpu_Px[8]+=${cpu_Px[8]}
	let cpu_Px[9]+=${cpu_Px[9]}
}

function cpu_flags {
	((cpu_Ax[0]=$((($2>>4)&8))))			# Sign Flag - SF
	[ $(($2&255)) -eq 0 ] && ((cpu_Ax[0]+=1))	# Zero Flag - ZF
	[ $((($2)&256)) -ne 0 ] && ((cpu_Ax[0]+=2))	# Carry Flag - CF
	[ $((($1^$2)&128)) -ne 0 ] && ((cpu_Ax[0]+=4))	# Overflow Flag - CF
}

function cpu_flags16 {
	((cpu_Ax[0]=$((($2>>12)&8))))				# Sign Flag - SF
	[ $(($2&65535)) -eq 0 ] && ((cpu_Ax[0]+=1))		# Zero Flag - ZF
	[ $((($2)&65536)) -ne 0 ] && ((cpu_Ax[0]+=2))		# Carry Flag - CF
	[ $((($1^$2)&32768)) -ne 0 ] && ((cpu_Ax[0]+=4))	# Overflow Flag - CF
}

function cpu_step {
	local	rec=cpu_${cpu_rt:0:1}
	local	acc=${rec}x[${!rec:1}]
	local	acc16 pre_acc16
	local	src=cpu_$cpu_${cpu_rt:1:1}x[${1:0:1}]
	local	src16
	local	carry=$(((cpu_A0&2)/2))
	local	pre_acc=${!acc}
	local	pre_cmd=cpu_${1:0:1}x[${1:1:1}]
	local	op1=$acc
	local	op2=${!src}
	if [ "$cpu_base" != "" ]
	then
		case $cpu_factor in
		0)	let cpu_ptr=$(($cpu_vector+$cpu_index+$cpu_offset));;
		1)	let cpu_ptr=$(($cpu_vector+$cpu_index-$cpu_offset));;
		2)	let cpu_ptr=$(($cpu_ip+$cpu_index+$cpu_offset));;
		3)	let cpu_ptr=$(($cpu_ip+$cpu_index-$cpu_offset));;
		4)	let cpu_ptr=$(($cpu_index+$cpu_offset));;
		5)	let cpu_ptr=$(($cpu_index-$cpu_offset));;
		*)	let cpu_ptr=$(($cpu_vector+$cpu_index+$cpu_offset));;
		esac
		if [ $cpu_ptr -gt 65535 ] || [ $cpu_ptr -lt 0 ]
		then
			cpu_ptr=65535
		fi
		op1=$((16#${memory[$cpu_ptr]}))
		op2=${!src}
	else
		let cpu_ptr=0
	fi
	if [[ "${1:0:1}" =~ [0-9] ]]
	then
		acc16=$((cpu_Bx[${cpu_D:1:1}]*256+cpu_Cx[${cpu_D:1:1}]))
		if [ "${1:0:1}" == "0" ]
		then
			src16=$((acc16))
		else
			src16=$((cpu_Bx[${1:0:1}]*256+cpu_Cx[${1:0:1}]))
		fi
		if [ "$cpu_base" != "" ]
		then
			if [ "${1:0:1}" != "0" ]
			then
				acc16=$((16#${memory[$cpu_ptr]}+16#${memory[$((cpu_ptr+1))]}*256))
			else
				src16=$((16#${memory[$cpu_ptr]}+16#${memory[$((cpu_ptr+1))]}*256))
			fi
		fi
		pre_acc16=$acc16
	fi
	case "$1" in
	00)		cpu_Bx[0]=$((cpu_ip>>8))
			cpu_Cx[0]=$((cpu_ip&255))
			[ "$cpu_base" == "" ] && let	cpu_ip=0
			[ "$cpu_base" != "" ] && let	cpu_ip=$(($cpu_ptr))
			cpu_base=""
			return 1;;
	[0-9][0-9])	if [ "$cpu_base" == "" ]
			then
				cpu_base=${1:0:1}
				cpu_offset=$((${1:1:1}))
				if [ "$((${1:1:1}))" == "0" ]
				then
					let cpu_factor=-1
				else
					let cpu_factor=0
				fi
				let cpu_Px=0
				let cpu_index=0
				cpu_vector=$((${cpu_Bx[$cpu_base]}*256+${cpu_Cx[$cpu_base]}))
			else
				if [ "$cpu_base" == "${1:0:1}" ] && [ "${1:1:1}" == "0" ] && [ $cpu_factor -lt 0 ]
				then
					let cpu_factor-=1
				else
					[ $cpu_factor -lt 0 ] && let cpu_factor=$((-cpu_factor))
					cpu_offset=$(($cpu_offset*10+${1:1}))
					if [ $cpu_base == ${1:0:1} ]
					then
						let cpu_Px=0
						let cpu_index*=2
					elif [ $(($(($cpu_Px>>${1:0:1}))%2)) -gt 0 ]
					then
						let cpu_Px=$((1<<${1:0:1}))
						let cpu_index*=2
						let cpu_Px[${1:0:1}]+=1
					else
						let cpu_Px=$(($((1<<${1:0:1}))|$cpu_Px))
						let cpu_index+=$((${cpu_Bx[${1:0:1}]}*256+${cpu_Cx[${1:0:1}]}))
					fi
				fi
			fi
			let	cpu_ip+=1
			[ "$is_complex" == "false" ] && return 1
			return 0
			;;
	[0-9][A-F])				# Arithmetic-Logical Unit
			if [ "$cpu_rt" == "DD" ]	# 16-Bit ALU
			then
				case "$1" in
				[0-9]A)	let acc16=$((acc16+src16+carry));;
				[0-9]B)	let acc16=$((acc16-src16-carry));;
				[0-9]C)	let acc16=$((acc16&src16));;
				[0-9]D)	let acc16=$((acc16|src16));;
				[0-9]E)	let acc16=$((acc16^src16));;
				[0-9]F)	let acc16=$((src16));;
				esac
				if [[ "$1" =~ [0-9][A-E] ]]
				then
					cpu_flags16 $pre_acc16 $acc16
				fi
				let cpu_Bx[${cpu_D:1:1}]=$(((acc16>>8)&255))
				let cpu_Cx[${cpu_D:1:1}]=$((acc16&255))
			elif [ "$cpu_rt" == "AD" ] && [ "${cpu_A:1:1}" == "0" ]
			then
				printf "\r\e[2KA0,D:TRY FOR INPUT#%c" ${1:0:1}
				read
			elif [ "$cpu_rt" == "DA" ] && [ "${1:0:1}" == "0" ]
			then
				printf "\r\e[2KD,A0:TRY FOR OUTPUT#%c" ${1:0:1}
				read
			elif [[ "$cpu_rt" =~ D[ABC] ]] && [ "${1:1:1}" == "F" ]
			then
				printf "\r\e[2KOUTPUT#%c" ${1:0:1}
				read
			else
				case "$1" in		# 8-Bit ALU
				#0A)	[ $((cpu_Ax[0]&2)) -ne 0 ] && eval let $acc=$((($op1+1)&255));;
				[0-9]A)	eval let $acc=$(($op1+$op2+carry))
					cpu_flags $pre_acc ${!acc}
					;;
				#0B)	[ $((cpu_Ax[0]&2)) -ne 0 ] && eval let $acc=$((($op1+255)&255));;
				[0-9]B)	eval let $acc=$(($op1-$op2-carry))
					cpu_flags $pre_acc ${!acc}
					;;
				#0C)	[ $((cpu_Ax[0]&2)) -eq 0 ] && eval let $acc=0;;
				[0-9]C)	eval let $acc=$(($op1&$op2))
					cpu_flags $pre_acc ${!acc}
					;;
				#0D)	[ $((cpu_Ax[0]&2)) -ne 0 ] && eval let $acc=255;;
				[0-9]D)	eval let $acc=$(($op1|$op2))
					cpu_flags $pre_acc ${!acc}
					;;
				#0E)	[ $((cpu_Ax[0]&2)) -ne 0 ] && eval let $acc=$(($op1^255));;
				[0-9]E)	eval let $acc=$(($op1-$op2))
					cpu_flags $pre_acc ${!acc}
					;;
				[0-9]F)	eval let $acc=$(($op2));;
				esac
				eval let $acc=$((${!acc}&255))
			fi;;
	[EF][0-9])	cpu_Bx[0]=$((cpu_ip>>8))
			cpu_Cx[0]=$((cpu_ip&255))
			[ "$cpu_base" == "" ] && let cpu_ip=$((16#$1*256))
			[ "$cpu_base" != "" ] && let cpu_ip=$(($cpu_ptr))
			cpu_base=""
			return 1;;
	[A-D][EF])	if [ "$cpu_base" == "" ]
			then
				if [ "${1:1:1}" == "E" ]
				then
					((cpu_Ax[0]&=255^(8192>>16#${1:0:1})))
				else
					((cpu_Ax[0]^=(8192>>16#${1:0:1})))
				fi
			else
				if [ "${1:1:1}" == "E" ]
				then
					if [ $((cpu_Ax[0]&(8192>>16#${1:0:1}))) -ne 0 ]
					then
						cpu_Bx[0]=$((cpu_ip>>8))
						cpu_Cx[0]=$((cpu_ip&255))
						let cpu_ip=$(($cpu_ptr))
						cpu_base=""
						return 1
					fi
				else
					if [ $((cpu_Ax[0]&(8192>>16#${1:0:1}))) -eq 0 ]
					then
						cpu_Bx[0]=$((cpu_ip>>8))
						cpu_Cx[0]=$((cpu_ip&255))
						let cpu_ip=$(($cpu_ptr))
						cpu_base=""
						return 1
					fi
				fi
			fi
			;;
	[A-D][0-9])	if [ "$cpu_base" == "" ]
			then
				eval cpu_${1:0:1}="${1:0:2}"
				if [ "$is_complex" == "true" ]
				then
					let	cpu_ip+=1
					cpu_base=""
					return 0
				fi
			else
				if [ "$cpu_rt" == "DD" ]
				then
					memory[$cpu_ptr]=`printf %02X $((cpu_Cx[${1:1:1}]))`
					memory[$((cpu_ptr+1))]=`printf %02X $((cpu_Bx[${1:1:1}]))`
				elif [ "${1:0:1}" == "D" ]
				then
					printf "INPUT#%s" ${1:1:1}
					read
				else
					memory[$cpu_ptr]=`printf %02X $((${!pre_cmd}))`
				fi
			fi
			;;
	[A-D][A-D])	cpu_rt=${1:0:2}
			if [ "$is_complex" == "true" ]
			then
				let	cpu_ip+=1
				cpu_base=""
				return 0
			fi
			;;
	*)		cpu_Bx[0]=$((cpu_ip>>8))
			cpu_Cx[0]=$((cpu_ip&255))
			[ "$cpu_base" == "" ] && let cpu_ip=$((16#$1*256))
			[ "$cpu_base" != "" ] && let cpu_ip=$(($cpu_ptr))
			cpu_base=""
			return 1;;
	esac
	let	cpu_ip+=1
	cpu_base=""
	return 1
}

is_complex=false

declare -a asm_Ax=(0 0 0 0 0 0 0 3 0 0)
declare -a asm_Bx=(0 0 0 0 0 6 0 0 0 0)
declare -a asm_Cx=(0 0 0 0 0 0 0 0 0 0)
declare -a asm_Dx=(0 0 0 0 0 0 0 0 0 0)
declare -a asm_Px=(0 0 0 0 0 0 0 0 0 0)
asm_rt="AB"
asm_A="A0"
asm_B="B0"
asm_C="C0"
asm_D="D0"
asm_ip=0
asm_addr=0
asm_base=""
asm_index=0
asm_offset=""
asm_vector=""
asm_factor=0
asm_pad=0
asm_padding=""
asm_pfx=""
asm_arg=""
asm_reg=""
asm_cmd=""
asm_ins=""

declare -a cpu_Ax=(10 26 42 58 74 90 106 122 138 154)
declare -a cpu_Bx=(0 177 178 179 180 181 182 183 184 185)
declare -a cpu_Cx=(0 193 194 195 196 197 198 199 200 201)
declare -a cpu_Dx=(0 0 0 0 0 0 0 0 0 0)
cpu_Px=0
cpu_rt="AB"
cpu_A="A0"
cpu_B="B1"
cpu_C="C2"
cpu_D="D3"
cpu_ip=0
cpu_ptr=0
cpu_base=""
cpu_index=0
cpu_offset=0
cpu_vector=0
cpu_factor=0
cpu_pad=0
cpu_padding=0

#is_complex=true

function cpu_reset {
	cpu_Ax[0]=0
	cpu_Bx[0]=0
	cpu_Cx[0]=0
	cpu_Px=0
	cpu_ip=0
	cpu_ptr=0
	cpu_base=""
	cpu_index=0
	cpu_offset=0
	cpu_vector=0
	cpu_factor=0
	cpu_pad=0
	cpu_padding=0
}

function help_page {
	clear
	help_rows=$(cat "$0" | grep -n -E "^:(HELP|PLEH):$" | cut -d: -f1 | sed -E "s/\n/ /g")
	help_range=(${help_rows})
	tail -n +$((1+${help_range[0]})) "$0" |\
		head -c -22 -n $((${help_range[1]}-${help_range[0]}-1)) |\
		sed -z "$ s/\n$//"
	while :
	do
		Key=`InKey`
		printf %s "$Key"
		if [ "$1" != "true" ] || [ "$Key" == "Esc" ]
		then break; fi
	done
	clear
}

function resize {
	clear
	height=$(tty_height)
	width=$(tty_width)
	lines=height-4
}

function parse_vector {
	local	parts
	local	ps=(0 0 0 0 0 0 0 0 0 0)
	local	pad=0
	local	ofs=0
	local	sgn=1
	local	scan=0
	local	bcd=()
	local	base code base pid uses using ptr i j
	local	used=0
	local	usings=()
	local	codes
	IFS='# ' read -r -a parts <<< ${1^^}
	if [ -n "${parts[0]}" ]
	then
		pad=${parts[0]}
	fi
	IFS='+ ' read -r -a parts <<< ${parts[1]}
	if [ ${#parts[@]} -gt 0 ]
	then
		base=${parts[0]:1:1}
		parts=${parts[@]:1:}
		for part in ${parts[@]}
		do
			IFS='D ' read -r -a ptr <<< ${part}
			if [ ${#ptr[@]} -eq 1 ]
			then
				((ofs+=ptr[0]))
			elif [ "${ptr[0]}" != "" ]
			then
				((ps[ptr[1]]+=ptr[0]))
			else
				((ps[ptr[1]]+=1))
			fi
		done
		for i in {0..9}
		do
			j=-1;
			while [ $((ps[$i]>>($j+1))) -gt 0 ]
			do
				((j+=1))
			done
			if [ $scan -lt $j ]
			then
				scan=$j
			fi
		done
		usings+=($base)
		while [ $scan -ge 0 ]
		do
			uses=0
			using=()
			i=${usings[-1]}
			unset usings[-1]
			code=()
			if [ $((ps[i]>>scan)) -gt 0 ]
			then
				((ps[$i]-=(1<<$scan)))
				((uses|=1<<$i))
				code+=($i)
				if [ $scan -gt 0 ] && [ $(((ps[i]>>(scan-1))&1)) -gt 0 ]
				then
					using+=($i)
				fi
			fi
			for i in {0..9}
			do
				if [ $((ps[i]>>scan)) -gt 0 ]
				then
					((uses|=1<<$i))
					code+=($i)
					((ps[$i]-=(1<<$scan)))
					if [ $scan -gt 0 ] && [ $(((ps[$i]>>($scan-1))&1)) -gt 0 ]
					then
						using+=($i)
					fi
				fi
			done
			if [ $(($used&$uses)) -eq 0 ]
			then
				codes+=($base)
			fi
			codes+=(${code[@]})
			for i in {0..9}
			do
				if [ $((ps[i]>>scan)) -gt 0 ]
				then
					((ps[i]-=1<<$scan))
				fi
				used=$uses
				usings=($base ${using[@]})
			done
			((scan-=1))
		done
	fi
	i=${#codes[@]}
	while [ $((--i)) -ge 0 ]
	do
		codes[$i]+=$((ofs%10))
		ofs=$(($ofs/10))
	done
	while [ $ofs -gt 0 ]
	do
		codes=("$base$((ofs%10))" ${codes[@]})
		ofs=$(($ofs/10))
	done
	while [ $pad -gt 0 ]
	do
		codes=("$((pad%10))0 $((pad%10))0 ${codes[@]}")
		pad=$(($pad/10))
	done
	echo ${codes[@]}
}

function assm {
	local	i=$cpu_ip
	local	__=`echo ${1^^} | sed -E 's/ADC|ADD|INC/A/; s/SBB|SUB|DEC/B/; s/AND|CON|CLR/C/; s/EOR|XOR|NOT/E/; s/FOR|MOV/F/; s/DIS|OR|SET/D/'`
	local	cmd=`echo ${1^^} | sed -E 's/ADC|ADD|AND|CON|DIS|EOR|OR|SBB|SUB|XOR/ALU/; s/CLR|DEC|INC|NOT|SET/UNA/'`
	local	arg=`echo ${2^^} | sed -E 's/[0-9_]*#D[^,]+/@/'`
	local	args code
	local	CF
	local	Vec=`echo ${2^^} | grep -E -o '[0-9]*#[^,]+'`
	local	BCD=$(parse_vector "$Vec")
	echo $Vec is $BCD
	if [ ${1^^} == "ADD" ] || [ ${1^^} == "SUB" ]
	then
		CF="CE "
	fi
	IFS=', ' read -r -a args <<< "$arg"
	local	X=${args[0]:0:1}
	local	x=${args[0]:1:1}
	local	Y=${args[1]:0:1}
	local	y=${args[1]:1:1}
	local	Z=${args[2]:0:1}
	local	z=${args[2]:1:1}
	case "$cmd $arg" in
	MOV\ A0\,@)
		code="AA A0 $BCD 0F";;
	MOV\ @\,A0)
		code="$BCD A0";;
	SWP\ @\,D[0-9])
		code="A$Y A0 $BCD ${y}F";;
	SWP\ D[0-9]\,@)
		code="A$X A0 $BCD ${x}F";;
	MOV\ @\,[ABCD][0-9])
		code="$BCD $Y$y";;
	ALU\ @\,D[0-9])
		code="A$Y A0 $CF$BCD $y$__";;
	UNA\ D[0-9])
		code="AD A0 $x$__";;
	SWP\ [ABC][0-9]\,@)
		code="A$X A0 $BCD A${x}F";;
	SWP\ @\,[ABC][0-9])
		code="A$Y A0 $BCD A${y}F";;
	ALU\ @\,[ABC][0-9])
		code="A$Y A0 $CF$BCD $y$__";;
	MOV\ A0\,[ABC][0-9])
		code="A$Y A0 ${y}F";;
	UNA\ [ABC][0-9])
		code="A$X A0 $x$__";;
	ALU\ D[0-9]\,@)
		code="${X}A $X$x $CF$BCD 0$__";;
	OUT\ D[0-9])
		code="${X}A $X$x 0F";;
	UNA\ D[0-9]\,CF)
		code="${X}A $X$x 0$__";;
	ALU\ [ABC][0-9]\,@)
		code="${X}A $X$x $CF$BCD 0$__";;
	MOV\ [ABC][0-9]\,A0)
		code="${X}A $X$x 0F";;
	UNA\ [ABC][0-9]\,CF)
		code="${X}A $X$x 0$__";;
	LEA\ D[0-9]\,@)
		code="$X$X $X$x $BCD ${x}F";;
	LEX\ [ABC][0-9]\,@\,[ABC][0-9])
		code="$X$Z $X$x $BCD ${z}F";;
	ORD\ @\,[ABC][0-9]\,[ABC][0-9])
		code="$Y$Z $Y$y $BCD ${z}F";;
	ALU\ D[0-9]\,@\,D[0-9])
		code="$X$Z $X$x $BCD $z$__";;
	ALU\ D[0-9]\,D[0-9])
		code="$X$Y $X$x $y$__";;
	ALU\ D[0-9]\,@\,[ABC][0-9])
		code="$X$Z $X$x $BCD $z$__";;
	OUT\ D[0-9]\,[ABC][0-9])
		code="$X$Y $X$x ${y}F";;
	ALU\ D[0-9]\,[ABC][0-9])
		code="$X$Y $X$x $CF$y$__";;
	ALU\ [ABC][0-9]\,@\,D[0-9])
		code="$X$Z $X$x $CF$BCD $z$__";;
	IN\ [ABC][0-9]\,D[0-9])
		code="$X$Y $X$x ${y}F";;
	ALU\ [ABC][0-9]\,D[0-9])
		code="$X$Y $X$x $CF$y$__";;
	ALU\ [ABC][0-9]\,@\,[ABC][0-9])
		code="$X$Z $X$x $CF$BCD $z$__";;
	ALU\ [ABC][0-9]\,[ABC][0-9])
		code="$X$Y $X$x $CF $y$__";;
	ALU\ R[0-9])
		code="$CF$x$__";;
	ALU\ R[0-9]\,@\,R[0-9])
		code="$CF$BCD $z$__";;
	REG\ [ABCD][0-9]\,[ABCD][0-9]\,[ABCD][0-9])
		code="$X$x $Y$y $Z$z";;
	REG\ [ABCD][0-9]\,[ABCD][0-9])
		code="$X$x $Y$y";;
	REG\ [A-D][0-9])
		code="$X$x";;
	ARG\ [A-D][0-9]\,[A-D])
		code="$X$Y $X$x";;
	ARG\ [A-D]\,[A-D])
		code="$X$Y";;
	JMP\ @)
		code="$BCD 00";;
	HLT\ )
		code="00";;
	CLR\ [ABCD]F)
		code="${X}E";;
	INV\ [ABCD]F)
		code="$X$x";;
	SET\ [ABCD]F)
		code="${X}E $X$x";;
	JMP\ @,[ABCD]E)
		code="$BCD $Y$y";;
	JMP\ @,[ABCD]F)
		code="$BCD $Y$y";;
	*)
		return;;
	esac
	read -r -a codes <<< "$code"
	for byte in ${codes[@]}
	do
		memory[$i]="$byte"
		let i=i+1
	done
}

width=80
height=25
lines=21

for i in $(seq 1 ${#tests[@]})
do
	cpu_peep ${tests[$((i-1))]}
	printf "\n"
done

last_assm="ADC 12#D3+4D4+5D5+6,B7"

memory=($(read_bin "./cpu.rom"))

read

key_class=""
Key=`printf "\U2592\U2592\U2592\U2592\U2592\U2592"`

stty -echo

trap "resize" SIGWINCH
resize

while [ 1 ]
do
	tput civis
	#assm "jmp" "123#d4"
	cpu_dis
	show_frame
	tput cnorm
	Key=(`InKey`)
	case "${Key}" in
	Esc)		exit;;
	\[1\;2P)		help_page true;;
	OP)		# F1
			help_page;;
	OQ)		# F2
			[ "$is_complex" == "true" ] && is_complex="false" || is_complex="true";;
	OR)		# F3
			while	code=${memory[$cpu_ip]} && \
				cpu_step $code
			do
				echo -n "" #([ "$is_complex" == "false" ] || [ "$cpu_base" == "" ]) && break
			done;;
	\[1\;2S)	# Shift+F4
			if dpkg -l hexcurse >/dev/null 2>/dev/null
			then
				hexcurse ./cpu.rom
			else
				clear
				echo "Please, install 'hexcurse' first..."
				read
			fi
			memory=($(read_bin "./cpu.rom"));;
	\[15~)		# F5
			let	height=$(tty_height)
			let	width=$(tty_width)
			let	lines=height-4
			cpu_reset
			memory=($(read_bin "./cpu.rom"));;
	\[17~)		# F6
			while :
			do
				code=${memory[$cpu_ip]}
				cpu_step $code
				[ $cpu_ip -eq 0 ] && break
			done
			;;
	\[18~)		# F7
			stty echo
			exec 3>&1
			command=$(dialog --title "Assembly ($last_assm)" --inputbox "Enter instruction:" 7 64 2>&1 1>&3)
			return_value=$?
			exec 3>&-
			last_assm="$command"
			assm ${command}
			stty -echo
			clear
			;;
	OS)		# F4
			clear
			dump_show ${cpu_ip}
			clear
			;;
	\[[ABCD])	key_class="<Arrows>";;
	\[[0-9]~)	key_class="<Paging>";;
	\[[0-9][0-9]~)	key_class="<F5-F12>";;
	\[1\;3P)	KeyTest;;
	*)		key_class="<Regular>";;
	esac
done

exit

'''
:HELP:
==============================
* Koy-Machine Emulator v1.00 *
==============================
Esc - Exit

F2: Compact mode [on/off]
F3: CPU step
F4: Edit RAM (immediate)
+Shift: Dump (in "hexcurse")
F5: Reset CPU context
F6: Run code until HALT
F7: Enter Assembly Instruction
______________________________
==== (C)2022 by Alikberov ====
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
:PLEH:
'''
