#!/usr/bin/python
# -*- coding: UTF-8 -*-
import sys
import os
import argparse


def createParser():
    parser = argparse.ArgumentParser()
    parser.add_argument('filename',
                        help='Имя загружаемого снепшота')
    parser.add_argument('-a', '--address', type=int, default=1,
                        help='Адрес размещения процедуры паузы, по умолчанию размещается на стеке, а '
                             'при значении 0 - непосредственно перед адресом запуска')
    parser.add_argument('-f', '--flag', action='store_const', const=True,
                        help='Сохранить регистровую пару AF')
    return parser


if __name__ == "__main__":
    parser = createParser()
    namespace = parser.parse_args(sys.argv[1:])
    filename = namespace.filename
    address = namespace.address

    # Читаем файл снепшота
    try:
        if os.stat(filename).st_size == 49179 and filename.split('.')[-1].lower() == 'sna':
                with open(filename, "rb") as f:
                    file_bytes = bytearray(f.read())
        else:
            print("Это не файл снепшота")
            sys.exit()
    except:
        print("Невозможно прочитать файл {}".format(filename))
        sys.exit()

    sp = file_bytes[23] + file_bytes[24] * 256
    pc = file_bytes[27 + sp - 16384] + file_bytes[27 + sp + 1 - 16384] * 256

    pause_code = [0xF5, 0xAF, 0xDB, 0xFE, 0xF6, 0xE0, 0x3C, 0x28, 0xF9, 0xF1, 0xFB, 0xC3]

    # Проверяем значение регистра А, если оно равно нулю, убираем ненужную команду XOR A
    if not file_bytes[22]:
        pause_code.remove(0xAF)  # Удаляем из процедуры XOR A

    # Проверяем прерывания
    if not (file_bytes[19] & 0b100):
        # Если прерываения запрещены, удаляем EI
        pause_code.remove(0xFB)  # Удаляем из процедуры EI
    else:
        # Если прерывания разрешены, сбрасываем флаг IFF в SNA и оставляем команду EI
        file_bytes[19] &= 0b11111011

    # Сохранять ли регистр АF?
    if not namespace.flag:  # Если нет ключа для схранения AF, то удаляем POP и PUSH
        pause_code.remove(0xF5)  # Удаляем из процедуры PUSH AF
        pause_code.remove(0xF1)  # Удаляем из процедуры POP AF

    code_len = len(pause_code)

    # Новый адрес запуска
    if 0 < address < 16384:  # Если процедуру хотим поместить перед стеком
        proc_addr = sp - (code_len + 2)
    elif 16383 < address <= (65536 - (code_len + 2)):  # Если адрес процедуры задан вручную
        proc_addr = address
    elif not address:  # Если проедуру хотим поместить перед текщим PC
        pause_code.remove(0xC3)  # Удаляем из процедуры ненужную команду JP
        code_len -= 1
        proc_addr = pc - code_len
    else:
        print("Ошибка адреса подпрограммы. Адрес для этого снепшота должен лежать в "
              "пределах 16384-{}".format(65536 - (code_len + 2)))
        sys.exit()

    file_bytes[27 + sp - 16384] = proc_addr % 256
    file_bytes[27 + sp + 1 - 16384] = proc_addr // 256
    code_start = 27 + proc_addr - 16384

    # Переносим готовую процедуру в снепшот
    for i in range(code_len):
        file_bytes[code_start] = pause_code[i]
        code_start += 1

    # Записываем адрес перехода, если нужно
    if address:  # Если адрес не перед текущим PC
        file_bytes[code_start] = pc % 256
        file_bytes[code_start + 1] = pc // 256

    # Записываем получившийся снепшот
    try:
        new_filename = filename[:-4] + '_paused.sna'
        with open(new_filename, "wb") as f:
            f.write(file_bytes)
    except:
        print("Невозможно записать файл {}".format(new_filename))
        sys.exit()
