/* conio.h
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
					
	Console input/output in MicroDOS Bold BIOS for Vector-06c
 			SuperSoft C 1.2.3 compiler

Notes on Supersoft compiler (odd looking C code, etc.)

	- in short: it is ancient Klingon, not even K&R
	- sometimes it chokes on most innocent valid code (reduce size)
	- preprocessor is rudimental: no parameters, minimal evaluation
	- Pascal calling convention, all function parameters must be passed
	- struct member names must be unique (heck, MS Windows was alike)
	- does not support list initializers
	- sizeof is non-K&R

Changelog
02.13.23	new millenium revamp
03.04.93	last change in previous millenium
12.20.92	combined isolated IO in separate header
*/
#ifndef _CONIO_H
#define _CONIO_H
/*
 *	character display in MicroDOS
 */
#define MAXX	80
#define MAXY	25
/*
 *	keyboard encoding in Bold BIOS
 */
#define BLANK 	0x20
#define ESC 	0x1b
#define LEFT 	0x8
#define RIGHT 	0x4
#define UP	0x5
#define DOWN	0x18
#define ENTER	0x0d
#define HOME	0x1
#define END	0x6	/* <CTP> mapped to <End> in emulators */
#define BKSPC	0x7F
#define PS	0x0a	/* mapped to <RShift> in emulators */
#define TAB	0x09
#define PGUP	0x12	/* <F1> */
#define	DEL	0x07	/* <F2> mapped to <Del> in emulators */
#define LINEDEL	0x19	/* <F3> */
#define	PGDN	0x03	/* <F4> */
#define	LANG	0x17	/* <F5> */
/*
 *	Vector-06c functional key mapping in Bold BIOS
 *		(avoid usage at all if possible)
 */
#define F1_KEY	0x12	/* PGUP	mapped to <PgUp> in emulators */
#define F2_KEY	0x07	/* DEL	mapped to <Del>  in emulators */ 
#define F3_KEY	0x19	/* LINEDEL mapped <F3>   in emulators */
#define F4_KEY	0x03	/* PGDN mapped to <PgDn> in emulators */
#define F5_KEY	0x17	/* LANG mapped to <F5>   in emulators */
/*
 *	pseudo-graphic character set
 */
#define PSG_HASH	0x80	/* base for  lte,  med,  hvy hashes */
#define PSG_FILL	0xAB	/*  fill	*/
#define PSG_BNIB	0xAC	/*  half bottom*/
#define PSG_LNIB	0xAD	/*  half left	*/
#define PSG_RNIB	0xAE	/*  half right	*/
#define PSG_TNIB	0xAF	/*  half top	*/
/*
 *	escape sequences
 */
#define CS_KOI8	0x5b	/* KOI-8 character set */
#define CS_KOI7	0x5c	/* KOI-7 character set */
#define CLS	0x4a	/* clear screen */
#define REV_VID	0x62	/* negative */
#define NRM_VID 0x61	/* positive */
#define SH_CSR	0x3a	/* show cursor */
#define HD_CSR	0x3b	/* hide cursor */
/*
 *	conio library API
 */
extern	escape	(/*char*/);
extern	clrscr	();
extern	goto_xy	(/*char,char*/);
extern	textcolor(/*COLOR*/);
extern	codepage(/*char*/);	/* 0,1,2, etc.. */
extern	hd_csr	();
extern	sh_csr	();
extern	kbhit	();		/* determines if keyboard was pressed */
extern	getch	();		/* gets console character no wait no echo */
extern	getkey	();		/* waits for keyboard input character no echo */
extern	getche	();		/* gets console character no wait with echo */
/*********************************************************/
/* do not use bputch() or cputch() in your code directly */
/* define and use putch below instead according to needs */
/*********************************************************/
extern	bputch	(/*char*/);	/* character to console by BIOS  96 cycles */
extern	cputch	(/*char*/);	/* character to console by BDOS 104 cycles */
#define	putch	bputch		/* redefine as putchar cputch or bputch*/

extern	putc_n(/*c,count*/);
extern	putc_at(/*x,y,c,count*/);	/* returns number printed */

extern	char puts_n(/*text,size*/);	/* returns number printed */
extern	char puts_at(/*x,y,text,size*/);/* returns number printed */

/* 
 * following functions should be in conio library but not present
 * 
 * cputs(char*);	depends on putch definition
 */
#endif /*_CONIO_H*/
