/****************************************************************/
/* cpmver.c							*/
/* (c) 2023 Perlin Production Co.Ltd.				*/
/****************************************************************/
#include "cpmver.h"

/* SuperSoft cpmver() is POS as it sets <H> to 0 on return */
unsigned _cpmver()
{
#if	0	
	return bdos(CC_CPMVER,0); /* shit doesn't work per their own spec */
#else	
#asm
	push	b
	mvi	c,12
	call	5
	pop	b
#endasm
#endif
}

#asm
os_cpm:		DB "CP/M",0
os_mpm:		DB "MP/M",0
os_cpnet:	DB "CP/Net",0
os_cpm3:	DB "CP/M Plus",0
os_nondr:	DB "non-DR",0		; possibly MicroDOS

os_name:	DW os_cpm
		DW os_mpm
		DW os_cpnet
		DW os_cpm3
		DW os_nondr
#endasm

char* cpmname(family)
OS_FAMILY family;
{
#asm
	lxi	h,2
	dad	sp
	mov	l,m
	mvi	h,0
	dad	h
	lxi	d,os_name
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	xchg
#endasm
}


unsigned osver(_osver)
OSVER*	_osver;
{
	register OSVER*	this;
	
	*((unsigned*)(this = _osver)) = _cpmver();
	if (!this->os_ver) this->os_ver = 0x14;
	
	this->os_lo = this->os_ver & 0xF;
	this->os_hi = (this->os_ver & 0xF0) >> 4;
	
	if (this->os_family)
	{
		this->os_family = this->os_family == 1 ? OS_MPM : OS_CPNET;
	}
	else
	{
		this->os_family = (this->os_ver > 0x30) ? OS_NONDR
				: (this->os_ver == 0x30 ? OS_CPM3 : OS_CPM);
	}
	this->os_name = cpmname(this->os_family);
	return this->os_ver;
}
