/** FONTED00.C ******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *	Collection of wrappers not included in		*
 * 	library package for very specific reasons	*
 *	(portability, generosity, limitations)		*
 *	Carry this along with msgbox() to your shit	*
 * Abstract:	WIOS extensions				*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include "conio.h"
#include "wios.h"
/********************************************************
 *		C O N I O   h e l p e r s		*
 ********************************************************/
#if 0
char psg_hash(id) char id; { return (id < 3) ? (id | PSG_HASH) : PSG_FILL; }
#endif
/*
 * text to console using putch
 * not in conio library to save size: both BDOS and BIOS
 * printout would be unlikely used in same user program
 * disclaimer: certain BIOS printout issues indeed exist
 */
char* cputs(text) char *text;
{
	register char *s;

	s=text; while (*s) putch(*s++);

	return s;
}

/* SuperSoft C doesn't support parametrized macros */
#ifdef DEBUG
dbgsput(text) char *text;
{
	cputs(text);
	putch('\n');
	getkey();	
}
#endif	/* DEBUG */
/*
 * CPU delay() machine-dependent, can be better:
 * Even with CPU cooldown by 'di' and 20ms resolution on Vector-06c
 * But then target system is expected to have IRQs
 * CP/M actually does not assume interrupt presence, enjoy tight loop
 */
#define CPU_DELAY 0x4000	/* CPU clock-dependent delay counter */

delay(ticks) unsigned ticks;
{
	register unsigned i;

	while (!getch() && ticks--) { i = CPU_DELAY; while (--i); }
}
/* isspace() accepts '\n' and '\r' in addition to '\t' and ' '
 * Note that SuperSoft C isspace() does not accept '\r'
 * still it is used because we opt:size and inline dumps shitload of code
 * Aztec C has proper table-driven bit-based ctype macros
 */
char* skpspc(text)
char	*text;
{
	register char *c;
	
	c = text; while (isspace(*c++)); return --c;
}
/********************************************************
 *		W I O S   h e l p e r s			*
 ********************************************************/

/********************************************************
 * 	hunky dory accessors/mutators 			*
 ********************************************************/
/*
 * limitations/side-fx:
 *	accepts stock borders only (BR_XY indices from wios.h)
 */
sw_border(wn,br_xy)
WINDOW	*wn;
char	br_xy;	/* use BR_DROP flag for dropdown windows (submenus) */
{
	wn->wn_style |= WS_BORDER;
	wn->wn_brd = &bframe[br_xy & (BR_DROP|BR_DD)];
	/* **********************************************
	 * BUG: client area must be recalculated	*
	 * since WINDOW could have no BORDER before	*
	 ************************************************/
}
/********************************************************
 * 	actors						*
 ********************************************************/
/*
 * prints window text, then changes cursor position to next line in window
 * wn_sput() could be made to handle '\n', but it'll affect overall speed
wn_snput(wn,text) WINDOW* wn; char *text; { wn_sput(wn,text); wn_nl(wn); }
 */

/*
 * changes window border and repaints non-client area in new colors
 */
wn_active(wn,active)
WINDOW	*wn;
char	active;
{
	register WINDOW	*this;
	
	sw_active(this=wn, active);
#if 0
	nc_repaint(this);
#else
	wn_border(this);
#endif
}

char*	wn_caption(wn,text,active)
WINDOW	*wn;
char	*text;
char	active;
{
	register char *old_name;

	old_name = sw_name(wn,text);
	wn_active(wn,active);
	return old_name;
}

/********************************************************
 * 	creators (Prometheus)				*
 ********************************************************/
static WINDOW* def_cb(wn,msg,param)
WINDOW	*wn;
WNDMSG	msg;
int	param; /* void* */
{
	register WINDOW *this;
	
	this = wn;
	
	switch (msg)
	{
		case WM_ACTIVE:
			sw_border(this, param ? BR_DD : BR_SS);
			sw_color (this, WN_NC, param != 0);
			break;
	}
	return this;
}
/*
 * simplified window creation wrapper
 * limitations/side-fx:
 *	dynamic memory allocation only
 *	accepts stock borders only (BR_XY indices from wios.h)
 */
WINDOW* window(name,parent,x,y,dx,dy,br_xy)
char	*name;
WINDOW	*parent;
AXIS	x,y;
DELTA	dx,dy;
char	br_xy;
{
	register WINDOW *this;

	if (this = wn_def(0,parent,x,y,dx,dy,&bframe[br_xy & (BR_DROP|BR_DD)]))
	{
		sw_name(this,name);
		this->wn_cb = def_cb;	/* register window callback */
	}
	return this;
}

extern WINDOW *DESKTOP;	/* time to move it to WIOS */

/*	
 *	0 -> 1
 *	1 -> 2
 *	2 -> 0
 */
 
WINDOW* modal(name,dx,dy)
char	*name;
DELTA	dx,dy;
{
	register WINDOW *this;

	if (this = window(name,DESKTOP,0,0,dx,dy,BR_DD))
	{
		sw_color(this, WN_NC	, COLOR_1);
		sw_fill	(this, WN_CLIENT, PSG_HASH+2);
		sw_fill	(this, WN_SHADOW, BLANK);
		
		wn_center(this);
	}
	return this;
}
/*
 * simplified menubar/dropdown list creation wrapper
 * calculates menu window sizes automagically
 *	menubar will span from x to MAXX
 *	listbox : width=longest text, height=number of menu items
 *	automatically calculates proper separator per border frames
 * limitations/side-fx:
 *	dynamic memory allocation only
 *	accepts stock borders only (BR_XY indices from wios.h)
 */
WINDOW* menu(parent,x,y,style,count,cb)
WINDOW		*parent;
AXIS		x,y;
unsigned	style;	/* WS_MENU or WS_LIST */
char		count;	/* menu item count */
WINDOW*	(*cb)(/*WINDOW*,WNDMSG*/);
{
	register WINDOW	*this;
	char		br_xy;

	if ( this = window(0, parent, x, y, 2, 2 
	   , br_xy = (style & WS_LIST) ? BR_DROP|BR_SD : BR_DD))
	{
		if (mn_def(this, WS_MENU|style, count, &separator[br_xy]))
		{
			this->wn_menu->mn_cb = cb; /* register menu callback */
		}
		else
		{
			wn_destroy(this);
			this = 0;
		}
	}
	return this;
}
/*
 *	change standard control focus (no redraw)
 */
WINDOW* sw_focus(wn, focus)
WINDOW	*wn;
char	focus;
{	/*	Project-specific and not general:
	 *	sets highlighted COLOR1 for focused WINDOW
	 */
	sw_color(wn, WN_CLIENT,focus != 0);
	return wn;
}
/*
 *	draw standard control focus selection
 */
WINDOW* ws_focus(wn, focus)
WINDOW	*wn;
char	focus;
{
	return wn_clear(sw_focus(wn,focus));
	/* wn_border(this); */
}
/*
 * pushbutton callback
 */
WINDOW* on_btn(wn,msg,param)
WINDOW	*wn;
WNDMSG	msg;
int	param;
{
	register WINDOW *this;
	
	this = wn;
	
	switch (msg)
	{
		case WM_PAINT:
			wn_scx(this, this->wn_name ? this->wn_name : "Button");
		case WM_CAPTION:
			return 0;
	}
	return def_cb(wn,msg,param);
}
/*
 * simplified push button creation wrapper
 * limitations/side-fx:
 *	dynamic memory allocation only
 */
WINDOW* button(accel,name,parent,x,y)
char	accel;
char	*name;
WINDOW	*parent;
AXIS	x,y;
{
	register WINDOW *this;
	DELTA		dx;

	dx = strlen(name) + 4;
	if (this = window(name,parent,x,y,dx,3,BR_SD))
	{
#if 0
		sw_margin(this, 1,1);
		sw_fill	 (this, WN_SHADOW, PSG_HASH+2);
#endif
		this->wn_accel	= accel;
		this->wn_cb	= on_btn;	/* register window callback */
		this->wn_style	|= WS_BUTTON;	/* pushbutton */
	}
	return this;
}
/*
 * checkbox callback
 */
WINDOW* on_cbox(wn,msg,param)
WINDOW	*wn;
WNDMSG	msg;
int	param;
{
	register WINDOW *this;
	
	this = wn;
	
	switch (msg)
	{
		case WM_PAINT:
			wn_sput(this, gw_active(this) ? "[X] " : "[ ] ");
			wn_sput(this, this->wn_name ? this->wn_name : "Checkbox");
			break;
	}
	return this;
}
/*
 * simplified checkbox creation wrapper
 * limitations/side-fx:
 *	dynamic memory allocation only
 */
WINDOW* checkbox(accel,name,parent,x,y)
char	accel;
char	*name;
WINDOW	*parent;
AXIS	x,y;
{
	register WINDOW *this;
	DELTA		dx;

	dx = strlen(name) + 4;	/* "[X] " */

	if (this = wn_def(0,parent,x,y,dx,1,0))
	{
		sw_name(this,name);
		this->wn_accel	= accel;
		this->wn_cb	= on_cbox;	/* register window callback */
		this->wn_style	|= WS_CHECK;	/* checkbox */
	}
	return this;
}
