/** FONTED01.C ******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	program startup & termination, msgbox,	*
 * 		main menu handling, desktop repaint	*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 * Feb 2023	recovered from abyss (was lost)		*
 ********************************************************/
#include "fonted.h"
#include "cport.h"
#include "conio.h"

static wredraw()
{
	sh_font();
	wn_set(DLG_CODE);
	wn_set(DLG_EDIT);
}

redraw(name)
char*	name;
{
	clrscr();
	wn_set(DESKTOP);
	set_name(name);
	wn_set(MNU_MAIN);
	wredraw();
	wn_set(DLG_INFO);
}

MENUSEL msgbox(text,caption,style)
char	*text,*caption;
char	style;		/* MB_OK|MB_YES|MB_NO|MB_CANCEL */
{
	register WINDOW *this;
	MENUSEL		result;
	
	if (this = modal(caption,0,0))
	{
		sw_border(this,BR_DS);
		result = msg_box(this,text,style);
		wn_destroy	(this);
		wredraw		();
		return result;
	}
	return MB_CANCEL;
}

wininit(name)
char*	name;	/* passed from cmdline or 0 */
{
	codepage(0);
	hd_csr();
#if 0
	wincfg = WCF_SEPTIC;
#endif
	windef();
	/* if nothing passed from cmdline, try pref[PREF_LASTLOAD] from	*/
	/* fonted.cfg LASTLOAD= entry					*/
	if (!(name = prf_load(name)))
	{	/* show splash if starting without filename */
		clrscr(); splash(10);
	}
	redraw(name);	/* name == 0 will create new fontXX.fnt file */

}
/* explicit hammer & sickle one's balls
 * don't want to implement atexit() or use ungodly setexit() / reset() pair
 */
sigterm()
{
	if (pref[PREF_LASTLOAD]) prf_save();
	
	textcolor(0);
	/* codepage(0); */
	clrscr();
	sh_csr();
	exit(0);
}

mb_focus(focus)
char	focus;
{
	char	t1[MAXX],t2[MAXX];
		
	if (focus)
	{
		sprintf(t1
, " [Arrows] menu navigation   [%s] option select   [%s] menu exit"
		, keynam(ENTER),keynam(ESC)
		);
		sprintf(t2
," [%s/%s] first/last menu item   <*> accelerator hotkey symbol"
		, keynam(HOME),keynam(END)
		);
		sh_info(t1,t2);
	}	
	wn_active(MNU_MAIN,focus);	/* update corrupted menu border */
}

extern MENUSEL mi_file	();
extern MENUSEL mi_edit	();
extern MENUSEL mi_flash	();
extern MENUSEL mi_tools	();
extern MENUSEL mi_help	();
/*
MENUSEL	stub() { return MENU_EXIT; }
#endif
*/
int main(_argc,_argv)
int	_argc;
char	*_argv[];
{
	register MENUSEL pos;
	MENUSEL	(*submenu[NUM_MAIN])();
	
	idx_chr	= 'A'-FIRST_CHAR;

	wininit(_argc > 1 ? _argv[1] : 0);
	
	if (!try_open(O_RDWR)) sigterm();
	rd_font();
	/* Supersoft C does not support list initializers */
	submenu[MAIN_FILE]	= mi_file;
	submenu[MAIN_EDIT]	= mi_edit;
	submenu[MAIN_FLASH]	= mi_flash;
	submenu[MAIN_TOOLS]	= mi_tools;
	submenu[MAIN_HELP]	= mi_help;
	
	mb_focus(1);
	
	while (1)
	{	/* everything matters below */
		if ((pos = wn_menubar(MNU_MAIN)) > MENU_EXIT)
		{	/* navigate through submenus */
			do
			{	/* restore corrupted border bottom */
				mb_focus(0);
				/* redraw navigated main menu item */
				pos = wn_mbpos(MNU_MAIN,pos);
				pos = (*(submenu[pos]))();
			} while  pos < MENU_EXIT;
			mb_focus(1);
		}
	}
}
