/** FONTED02.C ******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	windows and menus creation, status bar,	*
 * 		document bar, info bar, key names	*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include "fonted.h"
#include "conio.h"
#include "vector06.h"

WINDOW	*DESKTOP;
WINDOW	*MNU_MAIN;
WINDOW	*MNU_FILE;
WINDOW	*MNU_EDIT;
WINDOW	*MNU_FLASH;
WINDOW	*MNU_TOOLS;
WINDOW	*MNU_HELP;
WINDOW	*DLG_EDIT;
WINDOW	*DLG_CODE;
WINDOW	*DLG_OSFONT;
WINDOW	*DLG_INFO;

#define DB_COL	26	/* docbar start.x */
#define	DB_ROW	0	/* docbar start.y */
#define SB_COL	1	/* stsbar start.x */
#define SB_ROW	24	/* stsbar start.y */
/*
 * Topmost document bar, contains program name and edited filename
 */
docbar(text) char* text;
{
	wn_home(DESKTOP);
	textcolor(COLOR_1);
	cputs(" Bold BIOS Font Editor ");
	textcolor(COLOR_0);
	cputs(" - ");
	
	putc_n(BLANK,MAXX-DB_COL);

	goto_xy(DB_COL,DB_ROW);
	if (text) { cputs(text);putch(BLANK); }
	putch('['); puts(filename); putch(']');
}
/*
 * 2-row DLG_INFO
 */
sh_info(text1,text2)
char	*text1,*text2;
{
	wn_clear(DLG_INFO);

	if (text1) wn_scx(DLG_INFO,text1); /* center by x axis */
	wn_nl(DLG_INFO);
	if (text2) wn_scx(DLG_INFO,text2);
	else
	{
		wn_scx	(DLG_INFO,"Press any key to continue");	/* center by x axis */
		getkey	();
	}
}

static stsbar(text)
char	*text;
{
	register AXIS	x;

	x = MAXX-(SB_COL+1);

	textcolor(COLOR_1);
	putc_at(0,SB_ROW,BLANK,SB_COL);

	if (text) x -= puts_n(text,x);

	do putch(BLANK); while --x;
}

static MENU* cb_menu(menu,msg)
MENU	*menu;
WNDMSG	msg;
{
	/* stsbar(menu->mn_item[menu->mn_pos].mi_desc); */
	if (msg == WM_MENU|WM_FOCUS) stsbar(gmi_sel(menu)->mi_desc);
	return menu;
}

char	*vk_nam(key)
char	key;
{
	register char	v06c;
	
	v06c = pref[PREF_PLATFORM];
	
	switch (key)
	{
		case VK_LANG	: return "Pyc/Lat";
		case VK_CTRL	: return v06c ? "YC" : "Ctrl";
		case VK_SHIFT	: return v06c ? "CC" : "Shift";
	}
	return "";
}


static char _knam[2];

char	*keynam(key)
char	key;
{
	if (pref[PREF_PLATFORM])
	{
		switch (key)
		{
			case PGDN	: return "F4";
			case END	: return "CTP";
			case DEL	: return "F2";
			case PS		: return "PS";
			case ENTER	: return "BK";
			case PGUP	: return "F1";
			case LINEDEL	: return "F3";
			case LANG	: return "F5";
			case ESC	: return "AP2";
			case BKSPC	: return "3B";
		}
	}
	switch (key)
	{	case HOME	: return "Home";
		case PGDN	: return "PgDn";
		case RIGHT	: return "Right";
		case UP		: return "Up";
		case END	: return "End";
		case DEL	: return "Del";
		case LEFT	: return "Left";
		case TAB	: return "Tab";
		case PS		: return "RShift";
		case ENTER	: return "CR";
		case PGUP	: return "PgUp";
		case LINEDEL	: return "LineDel";
		case LANG	: return "Lang";
		case DOWN	: return "Down";
		case ESC	: return "Esc";
		case BKSPC	: return "BkSpc";
		case BLANK	: return "Spc";		
	}
	_knam[0] = key;
	return _knam;
}

/*
not_impl(text) char* text; { msgbox(DESKTOP, text,"Not implemented",MB_OK); }
*/

#define SUBTOP	3
#define	WINTOP	5

windef()
{
	DESKTOP = wn_def(0,0,0,0,MAXX,MAXY,0);
	sw_fill(DESKTOP,WN_CLIENT,PSG_HASH);
	/* MNU_MAIN */
	MNU_MAIN = menu(DESKTOP, 0, 1, WS_MENU, NUM_MAIN, &cb_menu);
	sw_fill(MNU_MAIN,WN_CLIENT,PSG_HASH+1);
	mi_set(MNU_MAIN,MAIN_FILE ,'F',"<F>ile"		,"File operations");
	mi_set(MNU_MAIN,MAIN_EDIT ,'E',"<E>dit"		,"Modify font bitmaps");
	mi_set(MNU_MAIN,MAIN_FLASH,'P',"<P>atch"	,"Load or store OS font");
	mi_set(MNU_MAIN,MAIN_TOOLS,'T',"<T>ools"	,"Configuration settings");
	mi_set(MNU_MAIN,MAIN_HELP ,'H',"<H>elp"		,"Information and support");
	/* MNU_FILE */
	MNU_FILE = menu(DESKTOP, 2, SUBTOP, WS_LIST, NUM_FILE, &cb_menu);
	mi_set(MNU_FILE,FILE_NEW   ,'N'," <N>ew"	,"Create new file");
	mi_set(MNU_FILE,FILE_OPEN  ,'O'," <O>pen..."	,"Open existing file");
	mi_set(MNU_FILE,FILE_RELOAD,'R'," <R>eload"	,"Read current file from disk");
	mi_set(MNU_FILE,FILE_SAVE  ,'S'," <S>ave"	,"Save file to disk");
	mi_set(MNU_FILE,FILE_RENAME,'A'," Save <A>s..." ,"Save file under new name");
	mi_set(MNU_FILE,FILE_EXIT  ,'X'," e<X>it"	,"Prompt to save font and exit to OS");
	/* MNU_EDIT */
	MNU_EDIT = menu(DESKTOP, 10, SUBTOP, WS_LIST, NUM_EDIT, &cb_menu);
	mi_set(MNU_EDIT,EDIT_NOW,'B'," <B>itmaps..."	,"Edit font bitmaps");
	mi_set(MNU_EDIT,EDIT_NEG,'I'," <I>nvert all..."	,"Invert all bitmaps");
	mi_set(MNU_EDIT,EDIT_CLR,'C'," <C>lear all..."	,"Copy blank character to all bitmaps");
	/* MNU_FLASH */
	MNU_FLASH = menu(DESKTOP, 18, SUBTOP, WS_LIST, NUM_FLASH, &cb_menu);
	mi_set(MNU_FLASH,FLASH_LOAD,'L'," <L>oad ...","Read font from OS memory");
	mi_set(MNU_FLASH,FLASH_SAVE,'F'," <F>lash...","Write font to OS memory");
	mi_set(MNU_FLASH,FLASH_DESK,'R'," <R>efresh!","Redraw desktop");
	/* MNU_TOOLS */
	MNU_TOOLS = menu(DESKTOP, 27, SUBTOP, WS_LIST, NUM_TOOL, &cb_menu);
	mi_set(MNU_TOOLS,TOOL_PREF,'P'," <P>references ...","Configure font editor");
	/* MNU_HELP */
	MNU_HELP = menu(DESKTOP, 36, SUBTOP, WS_LIST, NUM_HELP, &cb_menu);
	mi_set(MNU_HELP,HELP_ABOUT,'A', " <A>bout..."	,"Show program information, version number and copyright");
	mi_set(MNU_HELP,HELP_OSVER,'O', " <O>S info..."	,"Display OS family and version");
	/* DLG_OSFONT (displays current OS font) */
	DLG_OSFONT = window("OS font",DESKTOP,45,WINTOP,34,9,BR_SS);
	/* DLG_EDIT (font editing) */
	DLG_EDIT = window("Font",DESKTOP,1,WINTOP,8,12,BR_SS);
	/* DLG_CODE shows edited character code properties */
	DLG_CODE = window("Editing",DESKTOP,10,WINTOP+5,17,4,BR_SS);
	sw_margin(DLG_CODE,1,1);
	/* DLG_INFO information window above status bar */
	DLG_INFO = window(0,DESKTOP,1,SB_ROW-5,MAXX-2,4,BR_SS);
	sw_margin(DLG_INFO,1,1);
}
