/** FONTED03.C ******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	font bitmap editor			*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include "fonted.h"
#include "conio.h"
#include "cport.h"
#include "vector06.h"

int	idx_chr;			/* H ।㥬 ᨬ */
char	font[NUM_CHARS][FNT_HGT];	/* ᨢ  㯠묨 ᨬ.	*/

static char	symbol[FNT_WDT][FNT_HGT];/* ࠧ  ।஢	*/
static char	fmask;			/* ᯮ  㯠	*/
static bool	stored;

bm_show()
{
	register char	x;
	char		y;
	
	for (y = FNT_HGT; y--; )
	{
		wn_goto(DLG_EDIT,x = 0,y);
		while (x != FNT_WDT)
#ifdef O_SPEED
		putch(symbol[x++][y]);
#else		
		wn_cput(DLG_EDIT,symbol[x++][y]);
#endif		
	}
}

sinvert(_s)
char *_s;
{
	register char* s;
	
	*(s=_s) = (*s==BLANK) ? PSG_FILL : BLANK;
}

static _sshx(sx,cx,dx)	/* shift by x axis */
char	sx,cx;
int	dx;
{
	register char	x;
	char		s,y;
	
	for (y = FNT_HGT; y--; )
	{
		s = symbol[x = sx][y];
		while (x != cx) symbol[x][y] = symbol[x+=dx][y];
		symbol[x][y] = s;
	}
}

static _sshy(sy,cy,dy)	/* shift by y axis */
char	sy,cy;
int	dy;
{
	register char	y;
	char		s,x;
	
	for (x = FNT_WDT; x--; )
	{
		s = symbol[x][y=sy];
		while (y != cy) symbol[x][y] = symbol[x][y+=dy];
		symbol[x][y] = s;
	}
}

static bool sshift(_key)
char	_key;
{
	register char	x;
	char		*p,s,z,y;
	/* %= is slow */
	switch (_key)
	{		/* shift by x and y */
	case LEFT	: _sshx(0, FNT_WDT-1, 1); break;
	case RIGHT	: _sshx(FNT_WDT-1, 0,-1); break;
	case UP		: _sshy(0, FNT_HGT-1, 1); break;
	case DOWN	: _sshy(FNT_HGT-1, 0,-1); break;
	
	case PGUP:	/* mirror by x */	
		for (y = FNT_HGT; y--; )
		{
			x = 0;
			z = FNT_WDT - 1;
			while (x != FNT_WDT/2)
			{
				s = symbol[x][y];
				symbol[x++][y] = symbol[z][y];
				symbol[z--][y] = s;
			}
		} break;
	case PGDN:	/* mirror by y */
		for (x = FNT_WDT; x--; )
		{
			y = 0;
			z = FNT_HGT - 1;
			while (y != FNT_HGT/2)
			{
				s = symbol[x][y];
				symbol[x][y++] = symbol[x][z];
				symbol[x][z--] = s;
			}
		} break;
	case DEL:	/* clear symbol */
		setmem(symbol,FNT_WDT * FNT_HGT, BLANK);
		break;
	case BLANK:	/* invert symbol */
		x = FNT_WDT * FNT_HGT;
		for (p = symbol; x--; sinvert(p++));
		break;
	default:return true;
	}
	bm_show();
	return false;
}

/*
symset(_x,_y,_s)
char _x,_y,_s;
{
	register char y;
	
	symbol[_x][y=_y] = ((font[idx_chr][y] << _s) & 0x80) ? PSG_FILL : BLANK;
}
*/	

bm_load()
{
	register char	s;
	char		*name,text[16],y,x;
	
	y = idx_chr+FIRST_CHAR;
	sprintf(text,"%c   %3d   %2x",y,y,y);
	
	name = wn_caption(DLG_CODE,"Loading",1);
	wn_home(DLG_CODE);
	wn_sput(DLG_CODE,"CHR  DEC  HEX");
	wn_goto(DLG_CODE,1,1);
	wn_sput(DLG_CODE,text);
	
	for (y=0; y != FNT_HGT; ++y)
	{
#ifdef O_SIZE
		x = s = 0;
		while (s != FNT_WDT)
		{
			symbol[x][y]	= ((font[idx_chr][y] << s) & 0x80)
					? PSG_FILL : BLANK;
			/*
				s =	x =
				0 1 2 	0 2 4
				3 4 5	1 3 5
			*/			
			x = (++s == FNT_WDT/2) ? 1 : x + 2; /* (!(++s & 3)) */
	 	}
#else		/* +11 bytes */
		for (x = s = 0; s != FNT_WDT; ++s, x+=2)
		{
			/*
				s =	x =
				0 1 2 	0 2 4
				3 4 5	1 3 5
			*/			
			if (s == FNT_WDT/2) x = 1; /* if (!(s & 3)) */
			symbol[x][y]	= ((font[idx_chr][y] << s) & 0x80)
					? PSG_FILL : BLANK;
		}
#endif	 	
	}
	bm_show();
	wn_caption(DLG_CODE,name,0);
	stored = true;
}


static set_msk(x,y)
char x,y;
{
	if (symbol[x][y] == BLANK)
	{
#asm
		ORA A
		LDA fmask
		RAL
		STA fmask
#endasm
	}
	else
	{
#asm
		STC
		LDA fmask
		RAL
		STA fmask
#endasm
	}
}

static bmstore(xs,y)
char	xs,y;
{
	register char x;
	
	for (x = xs; x < FNT_WDT; x+=2) set_msk(x,y);
}

static bool bm_store()
{
	register char	y;
	char		*s;
	
	s = wn_caption(DLG_CODE,"Storing",1);
	
	for (y=0; y != FNT_HGT; ++y)
	{
		bmstore( fmask = 0	,y);
		bmstore( 1		,y);
		font[idx_chr][y] = fmask << 2;
	}
	wn_caption(DLG_CODE,s,0);
	if (!stored) is_dirty = true;
	stored = true;
}

static bool msg_store()
{
	register bool result;
	
	if (!(result = stored || !pref[PREF_BMDIRTY]))
	{	hd_csr();
		if (msgbox("Save modified bitmap?", "Save bitmap"
			,MB_YES|MB_NO) == BTN_YES) bm_store();
		/* stored must be altered after possible bm_store(); */			
		result = stored = true;
		wn_border(MNU_EDIT);
		sh_csr();
	}	
	return result;
}

static fnt_edit()
{
	/* SuperSoft is bad with local [][] */
	char		t1[MAXX],t2[MAXX];
	char		*s;
	char		x,y;
	register char	key;
	
	sprintf	(t1
	, "[Arrows] cursor  [%s] invert  [%s+arrow] shift  [%s+%s/%s] mirror"
	, keynam(BLANK),vk_nam(VK_CTRL)
	, vk_nam(VK_CTRL),keynam(PGUP),keynam(PGDN)
	);
	sprintf	(t2
	, "[%s/%s] prev/next   [%s] code   [%s] reload   [%s] save   [%s] menu"
	, keynam(PGUP),keynam(PGDN),keynam(ENTER),keynam(DEL),keynam(END)
	, keynam(ESC)
	);
	sh_info	(t1,t2);
	
	x=y=0;
	
	sw_border(DLG_EDIT,BR_DD);
	wn_border(DLG_EDIT);
	
	bm_load();
	if (pref[PREF_SELCHAR]) selchar();
	else sh_csr();
	
	stored = true;
	do
	{
		wn_goto(DLG_EDIT,x,y);
		
		key=getkey();
		if (vk_ctrl())	stored &= sshift(key);
		else switch (key)
		{			/* navigate editing cursor */
			case LEFT:	if (!x--) x = FNT_WDT-1;break;
			case RIGHT:	if (++x==FNT_WDT) x = 0;break;
			case UP:	if (!y--) y = FNT_HGT-1;break;
			case DOWN:	if (++y==FNT_HGT) y = 0;break;
			case HOME:	x=y=0;			break;
			case BLANK:	/* invert character bit */
				stored = false;
				sinvert(s = &symbol[x][y]);
				wn_cput(DLG_EDIT,*s);
				break;
			case PGUP:	/* load previous character */
				if (msg_store())
				{
					if (!idx_chr--) idx_chr=NUM_CHARS-1;
					bm_load();
				}
				break;
			case PGDN:	/* load next character */
				if (msg_store())
				{
					if (++idx_chr == NUM_CHARS) idx_chr=0;
					bm_load();
				}
				break;
			case ENTER:	/* select character by ASCII code */
				if (msg_store()) selchar();
				break;
			case DEL:	/* reload character */
				if (msg_store()) bm_load();
				break;
			case END:	/* save character */
				bm_store();
				break;
			case ESC:	/* exit character editor */
				if (!msg_store()) key = 0;
				break;
		}
	}
	while key != ESC;
	
	hd_csr();
	wn_active(wn_clear(DLG_CODE),0);
	wn_active(wn_clear(DLG_EDIT),0);
}

static fnt_clr(c) char *c; { *c = 0; }

static fnt_neg(c) char *c; { *c = ~*c; }
/*
 * full range backward font iterator
 */
static bool for_font(func,text)
int	(*func)(/* char* */);
char	*text;
{
	register char	*c;
	bool		r;
	
	if (r = msgbox(text,"All font action",MB_YES|MB_NO)==BTN_YES)
		for (c = &font[NUM_CHARS-1][FNT_HGT]; c != font; (*func)(--c));
	return r;
}

MENUSEL mi_edit()
{
	register MENUSEL sel;
	
	switch (sel = wn_list(wn_set(MNU_EDIT)))
	{
	case EDIT_NOW:	fnt_edit(); break;
	case EDIT_NEG:	is_dirty=for_font(&fnt_neg,"Invert character bitmaps?");
			break;
	case EDIT_CLR:	is_dirty=for_font(&fnt_clr,"Clear character bitmaps?");
			break;
	}
	wn_hide(MNU_EDIT);
	return sel;
}
