/** FONTED06.C *******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	edit file name dialog			*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include "fonted.h"
#include "conio.h"
#include "cport.h"

static unsigned _defnct;
static char	_defname[SIZ_FNAME];
char		filename[SIZ_FNAME];


char* new_name(name)
char	*name;
{
	/* mktemp() names new files 01,02,03... MDI naming is 1,2,3... */
	return name ? name : mktemp(strncpy(_defname,"FONTXX.FNT",SIZ_FNAME));
}

char*	set_name(name)
char	*name;
{
	register char *s;
	
	if (name = new_name(name))
	{
		strncpy(filename,name,SIZ_FNAME);
		
		if (s=index(filename,'.')) { if (!*(s+1)) *s = 0; }
		else strncat(filename,".FNT",SIZ_FNAME);
		
		docbar(0);
		return filename;
	}
	/* docbar("NONAME"); */
#if 1	
	return 	0;
#else
	return *filename = 0;	/* you've just been promoted LOL */
#endif	
}

/* CP/M Operating System Manual. 1.2.2 File References
 * The characters used in specifying an unambiguous file reference cannot
 * contain any of the following special characters:
 *	< > . , ; : = ? * [ ] % | ( ) / \
 * while all alphanumerics and remaining special characters are allowed.
 */
static bool isfname(c) char c;
{
	register char cc;
	return isprint(cc=c) && !index("<>.,;:=?*[]%|()/\\",cc);
}

static bool isdrive(c) char c;
{
	register char cc;
	
	return (cc=toupper(c)) >= 'A' && cc <= 'P';
}

bool editname()
{
	register char 	i;
	WINDOW		*this;
	bool		result;
	char		name[SIZ_FNAME+1];	/* +1 matters */
	char		text[MAXX];
	char		dot,colon,disp,start,maxchar,key;
	
	sprintf	(text	/* 112 bytes (47 bytes of code) */
	,"[%s] select   [%s] rubout   [%s] exit, CP/M file characters only"
	, keynam(ENTER),keynam(BKSPC),keynam(ESC)
	);
	
sh_info
("Please enter filename in [d:]FILENAME[.ext] format. Default \"ext\" is FNT"
, text
);
	setmem(name,SIZ_FNAME,result=colon=dot=start=i=0);
	maxchar = 8;

	this = modal("Enter filename:",18,3);
	wn_move		(this,22, 5);
	sw_margin	(this, 1, 1);
	wn_set		(this);
	
	sh_csr();
	do
	{
		wn_goto(this,i,name[i]=disp=0);
		switch (key=getkey())
		{
			case ':':
				if (i==1 && isdrive(name[0]))
				{
					disp = colon = 1;
					maxchar = 10;
				}
				break;
			case '.':
				if (!dot && i > (colon ? 2 : 0))
				{
					disp=start=dot=i;
					maxchar = 4;
				}
		}
		if (!disp) disp = isfname(key);
		
		if (disp)
		{
			if ((i - start) < maxchar) wn_cput(this,name[i++]=key);
			else BEEP;
		}
		else
		{
		  	switch (key)
		  	{
			case ENTER:	result = i > (colon+colon+dot);
			case ESC:	break;
			case BKSPC:
				if (i)
				{
					wn_goto	(this,--i,0);
					putch	(gw_fill(this,WN_CLIENT));
					wn_goto	(this,i,0);
					if (colon==i)
					{
						start=colon= 0;
						maxchar = 8;
					}
					else if (dot==i) maxchar=dot=0;
					break;
				}
			default:
				BEEP;
				break;
			}
		}
	}
	while (key != ENTER && key != ESC);
	
	hd_csr();
	set_name(result ? name : filename);
	
	wn_hide   (this);
	wn_destroy(this);
	
	return result;
}
