/** FONTED07.C *******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	Font load/flash to OS			*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include "fonted.h"
#include "conio.h"
#include "cpmver.h"
#include "cport.h"

sh_font()
{
	register char	c;
	char		n;
	
	wn_home(DLG_OSFONT);
	c = FIRST_CHAR;
	n = 8;
	while (--n)
	{
		do { putch(c); } while (++c & 0x1F);
		wn_nl(DLG_OSFONT);
	}
	wn_border(DLG_OSFONT);
}

static bool microdos()
{
#if	0	/*def O_SIZE*/
	return true;
#else		
	OSVER		ver;
	char		text[MAXX];

	if (osver(&ver) == 0x31 && ver.os_family == OS_NONDR) return true;
	
	sprintf	(text
	, "Incompatible Operating System\n%s, version %u.%u"
	, ver.os_name
	, ver.os_hi
	, ver.os_lo
	);
	msgbox(text,"Error",MB_OK);
	
	return false;
#endif	
}


#define	FONT_BASE 0xef40	/* Bold BIOS only */

static	_os_wr(fnt,os) char *fnt,*os; { *os = *fnt; }
static	_os_rd(fnt,os) char *fnt,*os; { *fnt= *os; }

static bool _osfun(osfun,doctext,query,caption)
int	(*osfun)();
char	*doctext,*query,*caption;
{
	register char	j;
	char		i,*os;
	char		text[0x80];
	
	sprintf(text,"%s OS memory?\nWARNING: OS must use BoldBIOS",query);
	
	if (microdos() && msgbox(text,caption,MB_YES|MB_NO)==BTN_YES)
	{
		wn_active(DLG_OSFONT,1);
		docbar(doctext);
		os=FONT_BASE;
		for (i=0; i != NUM_CHARS; ++i)
			for (j=FNT_HGT; j; (*osfun)(&font[i][--j], os++));
		sh_font();
		docbar(0);
		wn_active(DLG_OSFONT,0);
		return true;
	}
	return false;
}

static os_flash()
{
 	BEEP;
	if (_osfun(&_os_wr,"PATCHING OS WITH"
		,"Flash current font to","Flash font"
		)
	&& pref[PREF_DRAWDESK]) redraw(filename);
}

static os_fload()
{
	if (_osfun(&_os_rd,"LOADING OS FONT FOR EDITING"
		,"Load font from","Load font")
	) is_dirty = true;
}

MENUSEL mi_flash()
{
	register MENUSEL sel;
	
	switch sel = wn_list(wn_set(MNU_FLASH))
	{
		case FLASH_LOAD	: os_fload(); break;
		case FLASH_SAVE	: os_flash(); break;
		case FLASH_DESK	: redraw(filename);
				  return sel;
	}
	wn_hide(MNU_FLASH);
	return sel;
}
