/** FONTED08.C *******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	Preferences dialog			*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include <a:stdio.h>
#include "fonted.h"
#include "conio.h"
#include "cport.h"

bool pref[NUM_PREF];

#define NUM_GP1	4	/* number of non-nav controls on 1st property page */
#define NUM_NAV	3	/* number of nav controls */

static WGROUP* wp_def(ctl,num,nav)
WINDOW		*ctl,*nav;
unsigned	num;
{
	return wg_add(wg_def(0,ctl,num,WS_LIST|WS_TABSTOP),nav,NUM_NAV);
}

static prf_dlg()
{
	register WINDOW	*this;
	WINDOW		*dlg,*nav[NUM_NAV],*ctl[NUM_PREF];
	WGROUP		*wg[2];
	bool		act[NUM_PREF];	
	AXIS		y;
	MENUSEL		id;

	dlg = modal("Preferences",43,11);
	nav[0]	= button('N'," <N>ext ", dlg,  2, y = dlg->wn_rc.v_dy - 3);
	nav[1]	= button('K',"  O<K>  ", dlg, 15, y);
	nav[2]	= button('C',"<C>ancel", dlg, 28, y);
	/* WINDOW direly needs accelerator */	
	ctl[PREF_SELCHAR]  = checkbox('S',"<S>elect character dialog on edit",dlg,0,0);
	ctl[PREF_DRAWDESK] = checkbox('R',"<R>edraw desktop after font flash",dlg,0,0);
	ctl[PREF_AUTOSAVE] = checkbox('A',"<A>uto-save modified font on exit",dlg,0,0);
	ctl[PREF_LASTLOAD] = checkbox('L',"<L>ast open font loads by default",dlg,0,0);
	ctl[PREF_BMDIRTY]  = checkbox('B',"<B>itmap dirty editor exit prompt",dlg,0,0);
	ctl[PREF_FDIRTY]   = checkbox('R',"<R>eloading  modified file prompt",dlg,0,0);
	ctl[PREF_PLATFORM] = checkbox('V',"<V>ector-06c button names in help",dlg,0,0);
	
	wg[0] = wp_def(ctl,NUM_GP1,nav);
	wg[1] = wp_def(&ctl[NUM_GP1],NUM_PREF-NUM_GP1,nav);
	
	wn_set(dlg);
	
	movmem(pref,act,NUM_PREF);
	
	if (prp_shit(wg,2,act,NUM_NAV) == 1)	/* <OK> */
	{
		movmem(act,pref,NUM_PREF);
		prf_save();
	}
	/* ~dtor() */
	wn_hide(dlg);
	wg_destroy(wg[0]);
	wg_destroy(wg[1]);
	wn_derange(ctl,NUM_PREF);
	wn_derange(nav,NUM_NAV);
	wn_destroy(dlg);
#if 0
	wredraw();
#else
	wn_set(DLG_CODE);
#endif	
}

MENUSEL mi_tools()
{
	register MENUSEL sel;

	switch sel = wn_list(wn_set(MNU_TOOLS))
	{
		case TOOL_PREF: prf_dlg(); break;
	}
	wn_hide(MNU_TOOLS);
	sh_font();
	return sel;
}

static char *cfg_name;

prf_err(text,lineno,buf)
char		*text;
unsigned	lineno;
char		*buf;
{
	register int n;
	
	n = sprintf(buf,"Error %s %s",text,cfg_name);
#if 1	/* stdlib fuckup */
	n = strlen(buf);
#endif
	if (lineno) sprintf(&buf[n]," at line %u",lineno);
	BEEP;
	msgbox(buf, "Error",MB_OK);
}

static char* prf_match(s,pattern)
char	*s,*pattern;
{
	register char	*text;
	unsigned 	size;
	/* no strnicmp() in SuperSoft C stdlib */
	if (!strncmp(text=skpspc(s),pattern,size=strlen(pattern)))
	{
		dbgsput(pattern);
		
		text = skpspc(text + size);
		if (*text == '=') return skpspc(++text);
	}
	return 0;
}

static char* prf_pat(id)
char	id;
{
#if	0	/* Aztec and all sane K&R C compilers */
	static char *text[NUM_PREF] =
	{ "SELCHAR"
	, "DRAWDESK"
	, "AUTOSAVE"
	, "LASTLOAD"
	, "BMDIRTY"
	, "FDIRTY"
	, "PLATFORM"	
	};
	return (id < NUM_PREF) ? text[id] : "";
#else
	switch (id)
	{
		case PREF_SELCHAR	: return "SELCHAR";
		case PREF_DRAWDESK	: return "DRAWDESK";
		case PREF_AUTOSAVE	: return "AUTOSAVE";
		case PREF_LASTLOAD	: return "LASTLOAD";
		case PREF_BMDIRTY	: return "BMDIRTY";
		case PREF_FDIRTY	: return "FDIRTY";
		case PREF_PLATFORM	: return "PLATFORM";
	}
	return "";
#endif	
}

static char id_pref(text)
char	**text;
{
	register char	i;
	char		*c;
	
	for (i=0; i != NUM_PREF; ++i)
	{	/* smallest because compiler uses XTHL to access i */
		if (c = prf_match(*text, prf_pat(i)))
		{
			*text = c;
			break;
		}
	}
	return i;	
}

char*	prf_load(name)
char	*name;
{
	register char	id;	
	unsigned	lineno;
	FILE		*fd;
	char		*val,text[MAXX];
	/* defaults */	
	pref[PREF_PLATFORM]	=	/* Vector-06c button names in help*/
	pref[PREF_SELCHAR]	=	/* Select character dialog on edit*/
	pref[PREF_BMDIRTY]	=	/* prompt leaving modified bitmap */
	pref[PREF_FDIRTY]	= 1;	/* prompt reloading modified file */
	
	if (fd = fopen(cfg_name = "fonted.cfg","r",128))
	{
		lineno	= 0;
		
		while (fgets(text,MAXX,fd))
		{
			++lineno;
			if (*text == ';') continue;
			
			val = text;
			
			if ((id = id_pref(&val)) < NUM_PREF)
			{	/* note that *val could be 0 */
				dbgsput(val);
				
				if (id == PREF_LASTLOAD && *val)
				{
					if (name) val = "0";
					else
					{
						strncpy(filename,val,SIZ_FNAME);
						val = "1";
					}
				}
				pref[id] = atoi(val);
			}
			else
			{
				prf_err("in",lineno,text);
				break;
				
			}
		}
		fclose(fd);
	}
	return pref[PREF_LASTLOAD] ? filename : name;
}

static bool prf_put(fd,text,lineno)
FILE		*fd;
char		*text;
unsigned	lineno;
{
	if (fputs(text,fd) == EOF)
	{
		prf_err("writing",lineno,text);
		return false;
	}
	return true;
}	

prf_save()
{
	register char	id;	
	FILE		*fd;
	unsigned	lineno;
	char		text[MAXX];
	
	if (fd = fopen(cfg_name,"w",128))
	{
		if (prf_put(fd,"; FontEd configuration file\n",lineno = 1))
		for (id = 0; id != NUM_PREF; ++id)
		{
			if (id == PREF_LASTLOAD)
			{	/* we'd still dump the LASTLOAD = */
				sprintf	( text,"%s = %s\n"
					, prf_pat(id)
					, pref[id] ? filename : ""
					);
			}
			else sprintf(text,"%s = %u\n",prf_pat(id), pref[id]);

			if (!prf_put(fd,text,++lineno)) break;
		}
		fclose(fd);
	} else prf_err("creating",0,text);
}
