/** FONTED09.C *******************************************
 *							*
 *	(c) Perlin Production Co.Ltd. June 1993		*
 *		Bold BIOS Font Editor			*
 *							*
 * Abstract:	File submenu and file I/O operations	*
 * Revisions:						*
 * Mar 2023	adaptation overhaul to WIOS 5.0		*
 ********************************************************/
#include "fonted.h"
#include "conio.h"
#include "cport.h"

static int	file;		/*  ६ */
bool		is_dirty;

static io_err(_action,_text)
char *_action,*_text;
{
	char	text[MAXX];
	sprintf(text, "Failed to %s %s", _action,_text);
	BEEP;
	msgbox	(text, "Error", MB_OK);
}

static bool opened(_file)
int	_file;
{
	if (_file != EOF)
	{
		if (file) close(file);
		file = _file;
		return true;
	}
	return false;
}

bool try_open(o_mode)
unsigned o_mode;
{
	register int	ftmp;
	bool		can_create;
	char		text[MAXX];
		
	do if (*filename)
	{
		can_create = true;
		/********************************************************/
		/* access() not needed as long as creat() uses O_EXCL	*/
		/* otherwice R/O file will fall victim to bad runtime	*/
		/********************************************************/
		if ((ftmp = open(filename,O_RDWR)) != EOF)
		{
			if (o_mode & O_EXCL)
			{
				close(ftmp);
				sprintf (text,"Overwrite %s?",filename);
				switch	(msgbox	( text, "File exists"
						, MB_YES|MB_NO|MB_CANCEL)
					)
				{
					case BTN_NO	: can_create = false;
					case BTN_YES	: break;
					default		: return false;
				}			
			}
			else
			{
				if (opened(ftmp)) return true;
				clearerr();
			}
		}
		if (can_create)
		{
	 		if (opened(creat(filename,O_RDWR))) return true;
	 		
			io_err("create",filename);
		}
	}
	while editname();

	return false;
}

static io_check(num_chars,prompt,trail)
char	num_chars;
char	*prompt,*trail;
{
	char		text[MAXX];
	
	if (num_chars != NUM_CHARS)
	{
		if (num_chars)
			sprintf	( text,"Only %u characters %s\n%s%s"
				, num_chars,prompt,filename,trail
				);
		else sprintf(text,"No characters %s\n%s%s",prompt,filename,trail);
		
		msgbox(text,"Warning",MB_OK);
	}
	docbar(is_dirty = false);
}			


static cl_font()
{
	 setmem(font,NUM_CHARS*FNT_HGT,0);
/*	 is_dirty = true;
*/
}

rd_font()
{
	register char	i;
	char		n,bm[FNT_HGT];

	cl_font();
	
	docbar("READING FILE");
	
	seek(file,n=0,SEEK_SET);
	while (n != NUM_CHARS && read(file,bm,FNT_HGT)==FNT_HGT)
	{
		for (i=0; i != FNT_HGT; ++i) font[n][FNT_HGT-i-1]=bm[i];
		++n;
	}
	io_check(n,"read from",", unread data is zeroed");
}


static bool sav_dirty(question)
char	*question;
{
	char text[MAXX];
	
	if (is_dirty)
	{
		if (question)
		{
			sprintf	( text
, "Save modified file before %s?\nPress <Esc> or <Cancel> to abort"
				, question
				);
			switch	(msgbox	( text, "Save file"
					, MB_YES|MB_NO|MB_CANCEL)
				)
			{
				case BTN_YES	: break;
				case BTN_NO	: return true;
				default		: return false;
			}
		}
		on_save();
	}	
	return true;
}
	
/************************/
/* <F>ile menu handlers	*/
/************************/
static on_new()
{
	char	oldnam[SIZ_FNAME];
	
	if (sav_dirty("creating"))
	{
		strncpy(oldnam,filename,SIZ_FNAME);
		/* set_name(0) should skip existing files */
	 	if (set_name(0) && try_open(O_RDWR))
	 	{
	 		cl_font();	/* write new file with zeroes	*/
			on_save();	/* for sake of proper file size	*/
 		}
		else set_name(oldnam);
	}
}

static on_open()
{
	char	oldnam[SIZ_FNAME];
	
	if (sav_dirty("opening"))
	{
		strncpy(oldnam,filename,SIZ_FNAME);
		
	 	if (editname() && try_open(O_RDWR)) rd_font();
		else set_name(oldnam);
	}
}

static on_reload()
{
	if (!pref[PREF_FDIRTY] || sav_dirty("reloading"))
	{
		if (try_open(O_RDWR)) rd_font();
	}
}


static on_save()
{
	register char	i;
	char		bm[FNT_HGT],n;

	docbar("SAVING FILE");
	seek(file,n=0,SEEK_SET);
	
	do for (i=0; i != FNT_HGT; ++i) bm[i]=font[n][FNT_HGT-i-1];
	while ((write(file,bm,FNT_HGT)==FNT_HGT) && (++n != NUM_CHARS));
	
	io_check(n,"written to",", try again");
}

static bool on_rename()
{
	char	oldnam[SIZ_FNAME];
	
	strncpy(oldnam,filename,SIZ_FNAME);
	
	if (editname() && try_open(O_RDWR|O_EXCL)) on_save();
	else set_name(oldnam);
}

static on_exit()
{
	if (sav_dirty(pref[PREF_AUTOSAVE] ? 0 : "exit to OS"))
	{
		close(file);	/* just for MP/M (C runtime should do too) */
		sigterm();
	}
}

MENUSEL mi_file()
{
	register MENUSEL sel;

	switch (sel = wn_list(wn_set(MNU_FILE)))
	{
		case FILE_NEW	: on_new();	break;			
		case FILE_OPEN	: on_open();	break;
		case FILE_SAVE	: on_save();	break;
		case FILE_RELOAD: on_reload();	break;
		case FILE_RENAME: on_rename();	break;
		case FILE_EXIT	: on_exit();	break;
	}
	wn_hide	(MNU_FILE);
	wn_set	(DLG_EDIT);
	wn_set	(DLG_CODE);
	return sel;
}
