/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler

Notes on Supersoft compiler (odd looking C code, etc.)

	- in short: it is ancient Klingon, not even K&R
	- sometimes it chokes on most innocent valid code (reduce size)
	- preprocessor is rudimental:
		no parametrized macros
		minimal evaluation
	- __stdcall calling convention: all function parameters must be passed
	- does not support global/static initializers, but at least zeroes BSS
	  (global scope uninitialized data is 0 without linker assist)
	- does not support list initializers
	- struct member names must be unique (heck, MS Windows was alike)
	- sizeof is non-K&R, only works in certain cases (not in array decl)
	- no typedef
	- register storage can't be frame-declared, needs explicit assignment 
	- static has no effect

	Observations on how to lower the damage
	- use register storage whenever possible
	  <B,C> rp initialization is awful - over <D,E> scratchpad,
	  but it still saves many wasted bytes
	- declare most used structure members first
	- declare most used local auto last
	- optimize for minimal evaluation, C2 "optimizer" won't help much
	
Changelog
02.13.23	ver 3.1 (circa 08.05.1993) revamp
*/
/*
 *	C O M P I L E - T I M E   C O N D I T I O N A L S
 */
#define	WINVER		0x50
#define	WSPEED	/* optimize for speed at any cost			*/
#define	__align	/* indicates POSSIBLE UNALIGNMENT x80 cares less about	*/
/*
 *	R U N T I M E   C O N F I G U R A T I O N
 */
extern	unsigned	wincfg;	/* 16-bit configuration word, default=0 */
 
#define	WCF_SEPTIC	1	/* client-only separators (not on NC)	*/
/*
 *	P O I N T   A N D   V E C T O R
 */
#define AXIS	/* signed*/	char
#define DELTA	/* unsigned*/	char

struct	_POINT
{
	AXIS	pt_y;
	AXIS	pt_x;
};
#define POINT		struct _POINT
#define SIZE_POINT	sizeof(_POINT)	/* 2 bytes */

struct	_VECTOR
{
	AXIS	v_y;	/* origin.y	*/
	AXIS	v_x;	/* origin.x	*/
	DELTA	v_dy;	/* component.y	*/
	DELTA	v_dx;	/* component.x	*/
};
#define VECTOR		struct _VECTOR
#define SIZE_VECT	sizeof(_VECTOR)	/* 4 bytes */
/*
 *	B O R D E R
 */
struct _BORDER
{	/* vertices (corner characters)		*/
	char	br_tl;		/* top-left 	*/
	char	br_tr;		/* top-right	*/
	char	br_bl;		/* bottom-left	*/
	char	br_br;		/* bottom-right	*/
	/* edges (box side characters)		*/
	char	br_tside;	/* top		*/
	char	br_lside;	/* left		*/
	char	br_rside;	/* right	*/
	char	br_bside;	/* bottom	*/
};
#define	BORDER		struct _BORDER
#define	SIZE_BORD	sizeof(_BORDER)	/* 8 bytes */
/*
Predefined BORDRER structures

Positional coordinate data encoding in terminals expect
axis X data to be located in higher bits than axis Y
WIOS follows suite with 2-bit boxframe index encoding,
reserving bit[1] for X and bit[0] for Y axis
ͻ
 AXIS        X      Y   
 bit         1      0   
͹
 OFF == 0             
Ķ
 ON  == 1             
ͼ
As seen, setting axis bit ON doubles line thickness
Default border indices are named BR_XY, where
X,Y is 'S' or 'D' - Single/Double line thickness
------------------------------------------------------
ͻ
       BR_XY         code     
ͼ*/
#define BR_SS		0
#define BR_SD		1
#define BR_DS		2
#define BR_DD		3
#define BR_DROP		4	/* add to BR_XY index above to:	*/
				/* use bframe[] dropdown menu	*/
				/* use horizontal separator[]	*/
/*
	Predefined BORDER boxframes
; Window/dialog/menubar boxframes. Bottom is same as top
Ŀ
	[0] BR_SS		

ķ
	[1] BR_SD		
Ľ
͸
	[2] BR_DS		
;
ͻ
	[3] BR_DD		
ͼ
; Dropdown list boxframes. Bottom is same as sides

	[4] BR_SS|BR_DROP	


	[5] BR_SD|BR_DROP	
ͼ

	[6] BR_DS|BR_DROP	


	[7] BR_SS|BR_DROP	
ͼ
*/
extern BORDER bframe[8];	/* predefined borders */
/*
 *	S E P A R A T O R
 */
__align struct	_SEPARATOR
{
	char	sep_tl;		/* top-left	*/
	char	sep_fc;		/* fillchar	*/
	char	sep_br;		/* bottom-right	*/
};
#define	SEPARATOR	struct _SEPARATOR
#define	SIZE_SEP	sizeof(_SEPARATOR)	/* 3 bytes */

/* predefined separators first 4 are vertical, next 4 are horizontal */
extern SEPARATOR separator[8];
/* predefined crossbars, follow axis convention above */	
extern char	 crossbar[4];
/*
 *	M E N U   I T E M
 */
#define	MENUSEL		int
/* MENUSEL values returned from wn_list(),wn_menubar(),wn_mbpos() */
#define	MENU_EXIT	(-1)
#define	MENU_PREV	(-2)
#define	MENU_NEXT	(-3)

__align struct	_MENUITEM
{
	char	*mi_text;	/* menuitem text*/
	char	*mi_desc;	/* detailed menu item description */
	char	mi_accel;	/* hotkey	*/
};
#define	MENUITEM	struct _MENUITEM
#define	SIZE_ITEM	sizeof(_MENUITEM)	/* 11 bytes */
/*
 *	M E N U
 */
#define	MENU		struct _MENU
#define	SIZE_MENU	sizeof(_MENU)

__align struct	_MENU
{
	MENUITEM	*mn_item;
	MENUSEL		mn_pos;		/* menu or list item position 0-based */
	MENUSEL		mn_count;
	/*
	 * mn_cb(WINDOW*,WNDMSG, MENU*) MENU/list (item) callback
	 */
	MENU*		(*mn_cb)();
	SEPARATOR	*mn_sep;
	DELTA		mn_gap;		/* gap between menu bar items	*/
};
/*
 *	F I L L C O L O R
 */
#define	COLOR	char

#define COLOR_0	0
#define COLOR_1	1

struct	_FILLCOLOR
{
	COLOR	fc_color;	/* color	*/
	char	fc_fill;	/* fillchar	*/
};
#define	FILLCOLOR	struct _FILLCOLOR
#define	SIZE_FILLCOLOR	sizeof(_FILLCOLOR)	/* 2 bytes */
/* FILLCOLOR indices for window (areas painted)		*/
#define WN_CLIENT	0	/* client area		*/
#define WN_NC		1	/* non-client area	*/
#define WN_SHADOW	2	/* shadow		*/
extern	FILLCOLOR fillcolor;	/* console defaults	*/
/*
 *	W I N D O W
 */
/****************************************************************/
/* WINDOW::wn_style bits, need WXS_xx - running out of style ;)	*/
/****************************************************************/
#define WS_ACTIVE	1
#define WS_BORDER	2
#define WS_CAPTION	4
#define WS_MENU		8
#define WS_LIST		0x10		/* listbox	*/
#define WS_BUTTON	0x20		/* pushbutton	*/
#define WS_CHECK	0x40
#define WS_RADIO	0x80
#define WS_GROUP	0x100
#define WS_TABSTOP	0x200		/* applied to WSGROUP	*/
/****************************************************************/
/* WINDOW messages						*/
/*	WM_MENU_SELECT	is simply WM_MENU|WM_SELECT		*/
/*	WM_PARENTNOTIFY	is simply WM_NOTIFY|WNDMSG		*/
/*	WM_EXIT==(char)MENU_EXIT intentionally, same NEXT,PREV	*/
/****************************************************************/
#define WNDMSG		unsigned
#define	WM_MENU		0x4000	/* menu message			*/
#define WM_ACTIVE	1	/* activate/inactivate window	*/
#define WM_NCPAINT	2	/* draw everything non-client	*/
#define WM_BORDER	3	/* draw border  (non-client)	*/
#define WM_CAPTION	4	/* draw caption (non-client)	*/
#define WM_SHADOW	5	/* draw shadow  (non-client)	*/
#define WM_PAINT	7	/* user paint after WM_FILL	*/
#define WM_FOCUS	8	/* item/control gets/loses focus*/
#define WM_SELECT	9	/* exit menu/dlg with selection	*/
#define WM_EXIT		0xFF	/* on cancel selection and exit */
/****************************************************************/
/* Notes:							*/
/*	some messages are not defined for speed and size	*/
/*	if in need, feel free to enable their definition 	*/
/****************************************************************/
#ifndef	WSPEED
#define WM_NOTIFY	0x8000	/* parent notify		*/
#define WM_SHOW		10	/* change window visibility	*/
#define	WM_FILL		6	/* fill client area backround	*/
#define WM_NEXT		0xFD	/* on next submenu/grp select	*/
#define WM_PREV		0xFE	/* on prev submenu/grp select	*/
#endif	/*WSPEED*/
/****************************************************************/
#ifndef	WM_NOTIFY
#define wn_msg		sw_msg			/* send WINDOW message	*/
#define wn_notify	sw_msg
#endif

#define WINDOW		struct _WINDOW
#define	SIZE_WN		sizeof(_WINDOW)

struct _WINDOW
{
	POINT		wn_cur;		/* cursor pos client-RELATIVE	*/
	VECTOR		wn_rc;		/* client area parent-RELATIVE	*/
	VECTOR		wn_nc;		/* non-client  parent-RELATIVE	*/
	char		*wn_name;  	/* WS_CAPTION window name, or 0	*/
	WINDOW		*wn_parent;
	BORDER		*wn_brd;
	MENU		*wn_menu;
	FILLCOLOR	wn_fc[3];	/* client, NC, shadow fills	*/
	/*
	 * wn_cb(WINDOW*,WNDMSG,void*) WINDOW message callback
	 */
	WINDOW*		(*wn_cb)();
	unsigned	wn_style;	/* WS_xxx */
	char		wn_accel;	/* control accelerator */
};
/********************************************************/
/*		W I N D O W   G r o u p			*/
/********************************************************/
struct	_WGROUP
{
	WINDOW		**wg_ctl;	/* group of wg_count controls	*/
	unsigned	wg_count;	/* control group item count	*/
	unsigned	wg_style;
	WINDOW		*wg_sel;	/* control that has wg_focus()	*/
};

#define	WGROUP	struct _WGROUP
#define	SIZE_WG	sizeof(_WGROUP)		/* 8 bytes */
/********************************************************/
/*		M e s s a g e   B o x			*/
/********************************************************/
/*
 * msgbox styles (can be combined)
 */
#define MB_OK		0
#define MB_YES		1
#define MB_NO		2
#define MB_CANCEL	4
/*
 * msgbox MENUSEL results
 */
#define	BTN_YES		0
#define	BTN_NO		1
#define	BTN_CAN		2
