/* bdos.h
	Perlin Production Co. Ltd. February 1993, December 2020
	Contains global definitions of CP/M BDOS call vectors
	Compatible with SuperSoft and Aztec compilers
 */
#define _WBOOT		0	/* System reset				*/
#define _CONIN		1	/* Read symbol from CON:		*/
#define _CONOUT		2	/* Write symbol to  CON:		*/
#define _RDR		3	/* Read symbol from RDR:		*/
#define _PUN		4	/* Write symbol to  PUN:		*/
#define _LST		5	/* Write symbol to  LST:		*/
#define _CONIO		6	/* Direct CON: I/O			*/
#define _GETIOB		7	/* Get I/O byte				*/
#define _SETIOB		8	/* Set I/O byte				*/
#define _PUTS		9	/* Write string to the console		*/
#define _GETS		10	/* Read CP/M console buffer		*/
#define _CONST		11	/* Get console status			*/
#define _GETVER		12	/* Return CP/M version			*/
#define _RSTDSK		13	/* Reset all registered disk drives	*/
#define _SELDSK		14	/* Select disk drive			*/
#define _OPEN		15	/* Open file				*/
#define _CLOSE		16	/* Close file				*/
#define _FIRST		17	/* Find first file occurrence (in dir)	*/
#define _NEXT		18	/* Find next  file occurrence (in dir)	*/
#define _DELETE		19	/* Delete file				*/
#define _READ		20	/* Sequential read record 		*/
#define _WRITE		21	/* Sequential write record  		*/
#define _CREATE		22	/* Create and open file			*/
#define _RENAME		23	/* Rename file				*/
#define _LOGIN		24	/* Get drives log-in vector		*/
#define _CURDSK		25	/* Get current drive number		*/
#define _SETDMA		26	/* Set addres of DMA-buffer SET_DMA	*/
/* CP/M 1.1 BDOS ends here */
#define _GETALV		27	/* Get Allocation Vector address	*/
/* CP/M 1.3 BDOS ends here */
#define _SETRO		28	/* Set current drive to READ-ONLY	*/
#define _GETRO		29	/* Get Drive Protection Vector		*/
/* CP/M 1.4 BDOS ends here */
#define _ATTRIB		30	/* Set file attributes: R/O R/W DIR SYS */
#define _GETDPB		31	/* Get Disk Parameters Block addres	*/
#define _USER		32	/* Get/Set user code			*/
#define _RREAD		33	/* Random-access read record		*/
#define _RWRITE		34	/* Random-access write record 		*/
#define _FSIZE		35	/* Compute file size (CPM 2.0 only)	*/
#define _SETREC		36	/* Set random record number		*/
/* CP/M 2.0 BDOS ends here */
#define _RESET		37	/* LogOff/Reset selected disk drives	*/
#define _RWRITEF	40	/* Random access write with zero fill	*/
/* CP/M 2.2 and MP/M BDOS ends here */

/*
 *	BDOS calls not supported in all CP/M versions but must in any
 	MicroDOS ver. 3.1, YDOS (Yanus-Bios MicroDOS) or SCP
 */

#ifdef	MICRODOS

#define _SETCNT		44	/* Set a multi-sector counter		*/
#define _SETERR		45	/* Set an Error-Condition Mode		*/
#define _FRESPC		46	/* Get a free space of selected disk	*/
#define _XCPROG		47	/* Changing program			*/
#define _SETSCB		49	/* Set params.of a System Control Block */
#define _EXBDOS		50	/* Call BIOS or Extended BDOS operations*/
#define _SETDATE	104	/* Set date				*/
#define _GETDATE	105	/* Get date				*/
#define _EXITVAL	108	/* Get or set Program Exitcode		*/
#define _SEQDLM		110	/* Get or set sequence delimeter	*/
#define _CONARR		111	/* Write array of data to the CON:	*/
#define _PRTARR		112	/* Print array of data on the PRN:	*/
#define _SETFCB		152	/* Set PFCB buffer			*/
/************************************************************************/
/*	Some Extended BDOS calls (called using _EXBDOS and code	below)	*/
/************************************************************************/
#define _XFILE		129	/* Ex-BDOS file exchange		*/
#define _XDRIVE		130	/* Ex-BDOS drive exchange		*/
#define _CINFILE	131	/* Ex-BDOS set file for CON: input	*/
#define _CINSTD		132	/* Ex-BDOS set CON: to standart input	*/
#define _CINBUF		133	/* Ex-BDOS set buffer CON: input	*/
#define _GETCONF	240	/* Ex-BDOS get confirm			*/
#define _SETNAME	242	/* Ex-BDOS write filename		*/
#define _PUTDEC		243	/* Ex-BDOS write in a decimal format	*/

#endif	/* MICRODOS */

#ifdef CPM_11

#define	_ECHO		30	/* Control echo for call 1 */

#endif	/* CPM_11 */

