/* vector06.h
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
					
		Vector-06c machine-dependent functions
 			SuperSoft C 1.2.3 compiler
*/
#include "vector06.h"

#ifdef	VECTOR_06C
#define VK_REG	1
char	vk_rd	() { return (~inp(VK_REG) & (VK_LANG|VK_CTRL|VK_SHIFT)); }
char	vk_lang	() { return (inp(VK_REG) & VK_LANG)  == 0; }
char	vk_ctrl	() { return (inp(VK_REG) & VK_CTRL)  == 0; }
char	vk_shift() { return (inp(VK_REG) & VK_SHIFT) == 0; }
#else	/* not VECTOR_06C */
char	vk_rd	() { return 0; }
char	vk_lang	() { return 0; }
char	vk_ctrl	() { return 0; }
char	vk_shift() { return 0; }
#endif	/* VECTOR_06C */
