/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
Terminal escape sequencers
  
			LIST OF FUNCTIONS:
	codepage			
	clrscr
	escape
	goto_xy
	hd_csr
	sh_csr
	nrm_vid
	rev_vid
	textcolor
*/

#include "conio.h"
#include "vector06.h"

escape(code) char code; { putch(ESC); putch(code); }

#if	0	/* deprecated, use textcolor */
rev_vid	()	{ escape(REV_VID); }	
nrm_vid	()	{ escape(NRM_VID); }
#endif

textcolor(c) char c;	{ escape((c & 1) ? REV_VID : NRM_VID); }
codepage (c) char c;	{ escape(c==1 ? CS_KOI7 : CS_KOI8); }

goto_xy(x,y)
char x,y;
{
	escape(0x59);
	putch(0x20+y);
	putch(0x20+x);
}

home	()	{ goto_xy(0,0); }
clrscr	()	{ escape(CLS); }
hd_csr	()	{ escape(HD_CSR); }
sh_csr	()	{ escape(SH_CSR); }

putc_n(c,count)
char c,count;
{
	register char	n;

	if (n=count) do putch(c); while --n;
}

putc_at(x,y,c,count)
char x,y,c,count;
{
	goto_xy(x,y);
	putc_n(c,count);
}
/*
 * returns number of printed characters
 */
char puts_n(text,size)
char *text,size;
{
	register char *c;

	for (c=text; *c && size--; putch(*c++));
	return c-text;
}
/*
 * returns number of printed characters
 */
char puts_at(x,y,text,size)
char x,y,*text,size;
{
	goto_xy(x,y);
	return puts_n(text,size);
}
	