/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
POINT and VECTOR methods
 
			LIST OF FUNCTIONS:
*/
#include "wios.h"
#include "conio.h"
/************************************************
 *	P O I N T   A R I T H M E T I C S	*
 ************************************************/
POINT* pt_set(pt,x,y)
POINT	*pt;
AXIS	x,y;
{
	register POINT	*this;
	
	(this=pt)->pt_x	= x;
	this->pt_y	= y;
	return this;
}


POINT* pt_add(pt,x,y)
POINT	*pt;
AXIS	x,y;
{
	register POINT	*this;
	
	(this=pt)->pt_x	+= x;
	this->pt_y 	+= y;
	return this;
}

POINT* pt_copy(dst,src)
AXIS	*dst,*src;	/* the beauty of K&R */
{	/* pointer arithmetics yields worse than below in Supersoft C */
	register AXIS *this;
	
	(this=dst)[0] = src[0];
	this[1] = src[1];
	
	return this;
}
/************************************************
 *	V E C T O R   A R I T H M E T I C S	*
 ************************************************/
/*
 * for struct _VECTOR
 *	v_dx==rc_xdist()
 * 	v_dy==rc_ydist()
 */
AXIS	rc_xend(rc) VECTOR *rc; { return endvec(rc->v_x,rc->v_dx); }
AXIS	rc_yend(rc) VECTOR *rc; { return endvec(rc->v_y,rc->v_dy); }

VECTOR* rc_set(rc,x,y,dx,dy)
VECTOR	*rc;
AXIS	x,y;
DELTA	dx,dy;
{
	register VECTOR	*this;
	
	(this=rc)->v_x	= x;
	this->v_y	= y;
	this->v_dx	= dx;
	this->v_dy	= dy;
	return this;
}
/*
 * optimized RECT/VECTOR copy (movmem in C1.2.3 RT is awful)
 */
VECTOR* rc_copy(dst,src)
AXIS	*dst,*src;	/* the beauty of K&R */
{	/* pointer arithmetics yields worse than below in Supersoft C */
	register char i;
	
	for (i=SIZE_VECT; i--; dst[i] = src[i]);
	return dst;
}

VECTOR* rc_add(rc,x,y,dx,dy)
VECTOR	*rc;
AXIS	x,y;
DELTA	dx,dy;
{
	register VECTOR	*this;
	
	(this=rc)->v_x	+= x;
	this->v_y	+= y;
	this->v_dx	+= dx;
	this->v_dy	+= dy;
	return this;
}
/*
 * fillrect
 */
VECTOR*	rc_fill(rc,fc)
VECTOR		*rc;
FILLCOLOR	*fc;
{
	register char	n;
	VECTOR		rcs;	/* local stack copy */
	char		fill;

	if (!fc) fc = &fillcolor;
	textcolor(fc->fc_color);
	fill = fc->fc_fill;
	
	rc_copy(&rcs,rc);
	
	while (rcs.v_dy--) if (n = rcs.v_dx)
	{
		goto_xy(rcs.v_x,rcs.v_y++);
		do putch(fill); while --n;
	}
	return rc;
}
