/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
WINDOW atribute accessors/mutators
no bounds check is intentional: make no bugs, it'll work

			LIST OF FUNCTIONS:

	gw_brw		computes WINDOW border width
	gw_color	gets color of particular WINDOW area
	gw_fill		gets fill character of particular WINDOW area
	
	sw_color	sets color of WINDOW area 
	sw_fill		sets fill character of WINDOW area
	sw_name		changes window caption
	sw_margin	changes left and right WN_CLIENT area margins
	
	wn_color	sets text color to WINDOW client area color
	wn_hiclr	sets text color to inverted WINDOW client area color 

	wincfg	
	winver		gets WIOS library version
*/
#include "wios.h"

#ifdef SW_STYLE
sw_style(wn,style,on)
WINDOW		*wn;
unsigned	style;
char		on;	/* bool */
{
	if (on)	wn->wn_style |= style;
	else	wn->wn_style &= ~style;
}
#endif	/* SW_STYLE */

WINDOW* gw_active(wn) WINDOW *wn; { return wn->wn_style & WS_ACTIVE ? wn : 0; }

sw_active(wn,active)
WINDOW	*wn;
char	active;
{
	register WINDOW	*this;
	WINDOW		*result;
	
	if (result = wn_notify(this = wn,WM_ACTIVE,active))
	{	/* only if both child and parent are OK (in that order)	*/
#ifdef SW_STYLE
		sw_style(this,WS_ACTIVE,active);
#else
		if (active)	this->wn_style |= WS_ACTIVE;
		else		this->wn_style &= ~WS_ACTIVE;
#endif	/* SW_STYLE */
	}
	return result;
}

char* sw_name(wn,name)
WINDOW	*wn;
char	*name;
{
	register WINDOW	*this;
	char		*old_name;
		
	old_name = (this=wn)->wn_name;
	
	this->wn_style	= (this->wn_name = name)
			? this->wn_style | WS_CAPTION
			: this->wn_style & ~WS_CAPTION;
			
	return old_name;
}

#if 0
/*
 * Get WINDOW WN_NC or WN_CLIENT position (top left POINT)
 */
gw_pos(wn,area,pt)
WINDOW	*wn;
char	area;	/* window area { WN_CLIENT, WN_NC } */
POINT	*pt;
{
	register WINDOW *parent;
	

	pt_set(pt,area== WN_CLIENT	? (POINT*)(&wn->wn_rc)
					: (POINT*)(&wn->wn_nc)
	if (parent = wn->wn_parent)
	{
		pt.x -= parent->wn_rc.v_x;
		pt.y -= parent->wn_rc.v_y;
	}
}
#endif
/*
 * computes WINDOW border width
 * ugly, but scalable contrary to this->wn_brd != 0
 */
DELTA	gw_brw(wn)
WINDOW *wn;
{ return wn->wn_brd ? 1 : 0; }
/*
 * changes left and right WN_CLIENT area margins
 */
sw_margin(wn,xl,xr)
WINDOW	*wn;
DELTA	xl,xr;
{
	register WINDOW	*this;
	
	DELTA	bw;
	xr += (bw = gw_brw(this = wn));
	xl += bw;
	rc_copy(&this->wn_rc,&this->wn_nc);
	rc_add (&this->wn_rc,xl,bw,-(xl+xr),-(bw << 1));
}
/*
 * gets WINDOW area color
 */
COLOR	gw_color(wn,area)
WINDOW	*wn;
char	area;	/* window area { WN_CLIENT, WN_NC, WN_SHADOW } */
{ return wn->wn_fc[area].fc_color; }
/*
 * gets WINDOW area fill character
 */
char	gw_fill(wn,area)
WINDOW	*wn;
char	area;	/* window area { WN_CLIENT, WN_NC, WN_SHADOW } */
{ return wn->wn_fc[area].fc_fill; }
/*
 * sets WINDOW area color
 */
sw_color(wn,area,clr)
WINDOW	*wn;
char	area;	/* window area { WN_CLIENT, WN_NC, WN_SHADOW } */
COLOR	clr;
{	wn->wn_fc[area].fc_color = clr; }
/*
 * sets WINDOW area fill character
 */
sw_fill(wn,area,fill)
WINDOW	*wn;
char	area;	/* window area { WN_CLIENT, WN_NC, WN_SHADOW } */
char	fill;
{	wn->wn_fc[area].fc_fill = fill; }

/* sets text color to { WN_CLIENT, WN_NC, WN_SHADOW } area */
wn_color(wn,area)
WINDOW	*wn;
char	area;	/* window area { WN_CLIENT, WN_NC, WN_SHADOW } */
{	textcolor(wn->wn_fc[area].fc_color); }
/*
 * set text color to inverted WN_CLIENT (WINDOW backround color)
 */
wn_hiclr(wn,hi) WINDOW *wn; char hi;
{
	register COLOR	clr;
	
	clr = wn->wn_fc[WN_CLIENT].fc_color;
	
	textcolor(hi ? ~clr : clr);
}
/*
 * gets WIOS library version
 */
int	winver() { return WINVER; }
