/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
MENU and MENUITEM
			LIST OF FUNCTIONS:

	mn_def		create  MENU
	mn_destroy	destroy MENU
	mn_attach	attach	MENU to WINDOW
	mn_detach	detach	MENU from WINDOW
	mn_nav		listbox/MENU navigation and item select
	mi_set		add MENUITEM - Aztec C will use mi_add(MENUITEM*)	
	mi_prev		prograde   list or menu item pos skipping separators
	mi_next		retrograde list or menu item pos skipping separators
 	gmi_at		get MENUITEM at valid pos
	gmi_sel		get selected MENUITEM object
*/
#include "wios.h"
#include "keyboard.h"
#include "conio.h"

/* SuperSoft C does not support parametrized macro declarations */
#ifdef 	WSPEED
#define _OR_	+	/* requires discipline invoking mn_msg */
#else
#define _OR_	|	/* extra runtime CCOR call  */
#endif
/*
 * MENU message callback
 */
MENU* mn_msg(menu,msg)
MENU	*menu;
WNDMSG	msg;
{
	register MENU* this;
	 /* menu message callback should return
	 * 0		to stop default message processing
	 * MENU*	to let	default message processing
	 */
	return	(this=menu)->mn_cb
	? (*(this->mn_cb))(this, WM_MENU _OR_ msg) : this;
}
/*
 * destroy MENU
 */
MENU* mn_destroy(menu)
MENU	*menu;
{
	register MENU *this;
	
	if (this=menu)
	{
		free(this->mn_item);
		free(this);
	}
	return 0;	/* needed somewhere in chain */
}
/*
 * detach MENU from WINDOW
 */
MENU* mn_detach(wn)
WINDOW	*wn;
{
	register WINDOW *this;
	MENU		*menu;
	
	if (menu = (this=wn) ? this->wn_menu : 0)
	{
		this->wn_style &= ~WS_MENU & ~WS_LIST;
		this->wn_menu = 0;		
	}
	return menu;
}
/*
 * attach MENU to WINDOW
 */
MENU* mn_attach(wn,menu,style,sep)
WINDOW		*wn;	/* can be 0 				*/
MENU		*menu;
unsigned	style;	/* WS_LIST bit creates vertical list	*/
SEPARATOR	*sep;	/* ugly no auto-switch support by style	*/
{
	register MENU	*this;
	unsigned	ws_list;
	
	mn_destroy(mn_detach(wn));
	if (this = menu)
	{	 /* menu/list item gap */
		this->mn_gap	= (ws_list = style & WS_LIST) ? 0 : 2;
		this->mn_sep	= sep;
		if (wn)
		{
			wn->wn_menu	= this;
			wn->wn_style	|= WS_MENU | ws_list;
		}
	}
	return this;
}
/*
 * create MENU
 */
MENU* mn_def(wn,style,count,sep)
WINDOW		*wn;	/* can be 0 for dangling MENU		*/
unsigned	style;	/* WS_LIST bit creates vertical list	*/
MENUSEL		count;	/* passing 0 destroys old WINDOW MENU	*/
SEPARATOR	*sep;
{
	register MENU	*this;
	
	return	(  (this = count  ? calloc(1,SIZE_MENU) : 0)
		&& (this->mn_item = calloc(this->mn_count=count,SIZE_ITEM))
		) ? mn_attach(wn,this,style,sep) : mn_destroy(this);
}
/*
 *	add MENUITEM for SuperSoft C most efficiently
 *	Manx Aztec C will use mi_add(wn,MENUITEM*,pos)
 */
WINDOW*	mi_set(wn,pos,accel,text,desc)
WINDOW	*wn;
MENUSEL	pos;	/* menu item pos	*/
char	accel;
char	*text;	/* 0 is treated as separator */
char	*desc;
{
	register MENUITEM	*this;
	DELTA			ds_brd;
	DELTA			dx,dy;	/* window sizes		*/
	char			count;	/* menu item count	*/
	MENU			*menu;
	
	if ((menu = wn->wn_menu) && (pos < (count = menu->mn_count)))
	{
		this = &menu->mn_item[pos];
		this->mi_accel= accel;
		this->mi_text = text;
		this->mi_desc = desc;
		
		ds_brd = wn->wn_style & WS_BORDER ? 2 : 0;
		
		if (wn->wn_style & WS_LIST)
		{	/* dropdown listbox */
			this = menu->mn_item;	/* sic! losing both */
		
			for (pos=dx=0; pos != count; ++pos)
			{
				if (text = this[pos].mi_text)
					dx = max(dx,strlen(text));
			}
			dx+= ds_brd + 1;
			dy = ds_brd + menu->mn_count;
		}
		else
		{	/* menubar */
			dx = MAXX;	/* span entire screen for now	*/
			dy = ds_brd + 1;/* menubars have fixed  height	*/
		}
		/* possible clipping must be resolved by wn_size */
		wn_size(wn,dx,dy);
		
	} else wn = 0;
	return wn;
}
/*
MENUSEL _posdec(pos,last)
MENUSEL	pos,last;
{ return pos ? (vk_ctrl() ? 0 : pos - 1) : last; }

MENUSEL _posinc(pos,last)
MENUSEL	pos,last;
{ return pos == last ? 0 : (vk_ctrl() ? last : pos + 1); }
*/

/*
 * prograde list or menu item position bypassing separators
 */
MENUSEL mi_prev(menu,sel,count)
MENU*	menu;
MENUSEL	sel;
MENUSEL	count;	/* min(wn->wn_rc.v_dy, menu->mn_count); */
{
	register MENUSEL pos;
	MENUITEM	*mi;

	pos = (sel && vk_ctrl()) ? 1 : sel;
	mi= menu->mn_item;
	
	do { if (!pos) pos = count; --pos; }
	while (!(mi[pos].mi_text) && (pos != sel));
	return pos;
}
/*
 * retrograde list or menu item position bypassing separators
 */
MENUSEL mi_next(menu,sel,count)
MENU*	menu;
MENUSEL	sel;
MENUSEL	count;	/* min(wn->wn_rc.v_dy, menu->mn_count); */
{
	register MENUSEL pos;
	MENUITEM	*mi;
	
	pos = ((sel != (count-1)) && vk_ctrl()) ? count - 2 : sel;
	mi=menu->mn_item;
	
	do if (++pos == count) pos = 0;
	while (!(mi[pos].mi_text) && (pos != sel));
	return pos;
}
/*
 * General-purpose menu/listbox/etc. navigation and keyboard handler
 * allows runtime virtual key translation by patching NAVKEY(s)
 * saves 36178 - 36118 = 60 bytes
 */
MENUSEL mn_nav(wn,nav_key,count,txt_max)
WINDOW	*wn;
NAVKEY	*nav_key;
MENUSEL	count;		/* rudimental, menu/list must scroll	*/
DELTA	txt_max;	/* rudimental, mi_set() has all info	*/
{
	register NAVKEY	*nk;
	MENU		*menu;
	MENUITEM	*mi;
	MENUSEL		(*dir)(),i,prv,pos;
	char		key;
	
	prv = pos = (menu=wn->wn_menu)->mn_pos;
	mi = menu->mn_item;	
	nk = nav_key;
		
	while (1)
	{
		prv=(*nk->nk_draw)(wn,prv,pos,txt_max);
		
		dir = &mi_prev;
		if ((key=toupper(getkey())) == nk->nk_end) pos = 0;
		else if (key != nk->nk_prev)
		{
			dir = &mi_next;
			if (key==nk->nk_home) pos = count-1;
			else if (key!=nk->nk_next) dir = 0;
		}
		if (dir) { pos = (*dir)(menu,pos,count); }
		else
		{
			if ((key == nk->nk_xprev)
#ifdef	WM_PREV
			&& mn_msg(menu,WM_PREV)
#endif	/* WM_PREV */		
			)				return MENU_PREV;
			
			if ((key == nk->nk_xnext)
#ifdef	WM_NEXT
			&& mn_msg(menu,WM_NEXT)
#endif	/* WM_NEXT */		
			)				return MENU_NEXT;
			if ((key == nk->nk_exit)
			&& mn_msg(menu,WM_EXIT))	return MENU_EXIT;
			if ((key == nk->nk_sel || key==nk->nk_sel2)
			&& mn_msg(menu,WM_SELECT))	return pos;
			
			for (i=count; i--;) if (mi[i].mi_accel == key)
				return (*nk->nk_draw)(wn,prv,i,txt_max);
		}
	}		
}
#if 0
/*
 * get MENUITEM at valid pos
 */
MENUITEM* gmi_at(menu,pos)
MENU 	*menu;
MENUSEL	pos;
{ return &menu->mn_item[pos]; }
#endif
/*
 * get selected MENUITEM
 */
MENUITEM* gmi_sel(menu) MENU *menu; { return &menu->mn_item[menu->mn_pos]; }
