/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
Window creation
			LIST OF FUNCTIONS:

	wn_center
	wn_def		creator
	wn_move
	wn_size
*/

#include "conio.h"
#include "wios.h"
/*
 * center window in parent
 */
wn_center(wn)
WINDOW	*wn;
{
	register WINDOW	*this;
	WINDOW		*parent;
	DELTA		dx,dy;

	if (parent = (this=wn)->wn_parent)
	{
		dx = parent->wn_nc.v_dx;
		dy = parent->wn_nc.v_dy;
	}
	else { dx = MAXX; dy = MAXY; } /* I miss DESKTOP in WINK for Aztec */
	
	wn_move(this,center(this->wn_nc.v_dx,dx),center(this->wn_nc.v_dy,dy));
}	
/*
 * move window in parent coordinate system
 */
wn_move(wn,x,y)
WINDOW	*wn;
AXIS	x,y;
{
	register VECTOR	*nc;
	DELTA		cx,cy;

	nc = &wn->wn_nc;
	cx = x - nc->v_x;
	cy = y - nc->v_y;
		
	if (wn->wn_parent)
	{	/* offset by parent's client area */
		nc = &wn->wn_parent->wn_rc;
		x  += nc->v_x;
		cx += nc->v_x;
		y  += nc->v_y;
		cy += nc->v_y;
	}
	pt_set((POINT*)(&wn->wn_nc),x,y);
	pt_add((POINT*)(&wn->wn_rc),cx,cy);
	
	return wn;
}
/*
 * deallocates assuming everything was dynamically allocated
 */
wn_destroy(wn) WINDOW* wn;
{
	mn_destroy(wn->wn_menu);
	free(wn);
}
/*
 * redefines window (can attach to a different parent)
 */
WINDOW* wn_def(wn,parent,x,y,dx,dy,border)
WINDOW	*wn;	/* can be 0 for dynamic allocation	*/
WINDOW	*parent;/* can be 0 too, then console is parent	*/
AXIS	x,y;
DELTA	dx,dy;
BORDER	*border;
{
	register WINDOW	*this;

	if (this = wn ? wn : malloc(SIZE_WN))
	{
		setmem(this,SIZE_WN,0);
		
		this->wn_parent	= parent;
		
		if (this->wn_brd = border) this->wn_style |= WS_BORDER;
		
		sw_fill	(this,WN_CLIENT,BLANK);
		rc_set	(&this->wn_nc, x, y, dx?dx:1, dy?dy:1);
		sw_margin(this,0,0);
		wn_move	(this,x,y);
	}
	return this;
}

WINDOW* wn_size(wn,dx,dy)
WINDOW	*wn;
AXIS	dx,dy;
{
	register WINDOW	*this;
	DELTA		mx;

	this = wn;
	this->wn_nc.v_dx = dx ? dx : 1;
	this->wn_nc.v_dy = dy ? dy : 1;
	/* cheating since margins is bad idea anyway and should be removed */
	mx = this->wn_rc.v_x - this->wn_nc.v_x - 1;
	sw_margin(this,mx,mx);
	return this;
}
/*
 * direct (and only) WINDOW message callback
 */
static WINDOW* sw_msg(wn,msg,param)
WINDOW	*wn;
WNDMSG	msg;
int	param;	 /* prevents struct WNDMSG declaration */
{
	register WINDOW	*this;
	return (this = wn)->wn_cb ? (*this->wn_cb)(this,msg,param) : this;
}

#ifdef WM_NOTIFY
/*
 * default WINDOW message callback with WM_PARENT (parent notify) handling
 */
WINDOW* wn_msg(wn,msg,param)
WINDOW	*wn;
WNDMSG	msg;
int	param;
{
	register WINDOW	*parent;
	WINDOW		*result;
	/* user message handler should return
	 * 0		to stop default message processing
	 * WINDOW*	to let	default message processing
	 * Notes:	do not clean WM_NOTIFY here-it is slow
	 		!(msg & WM_NOTIFY) yields shorter code
	 */
	if (!(msg & WM_NOTIFY)) return sw_msg(wn,msg,param);
	/*
	 * clean parent notify bit and callback child handler
	 * ( absolutely needed to redraw child accordingly )
	 */
	if (result = sw_msg(wn,msg & ~WM_NOTIFY,param))
	{
		/* treat lack of parent callback as non-error */
		if ((parent = wn->wn_parent) && parent->wn_cb)
		{
			/* WM_NOTIFY sent to parent should return
			 * 0		to stop default message processing
			 * non-0	to let	default message processing
			 */
			return (*parent->wn_cb)(wn,msg,param) ? wn : 0;
		}
	}
	return result;
}
/*
 * parent notify shortcut used by controls
 */
WINDOW* wn_notify(wn,msg,param)
WINDOW	*wn;
WNDMSG	msg;
int	param;
{
	return wn_msg(wn,WM_NOTIFY|msg,param);
}
#endif	/* WM_NOTIFY */
