/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
Non-client area drawing

			LIST OF FUNCTIONS:
			
	wn_border	draws border and caption in non-client area
*/
#include "conio.h"
#include "wios.h"
/*
 * draws border and caption in non-client area
 */
wn_border(wn)
WINDOW	*wn;
{
	register BORDER	*this;
	AXIS		xs,ys,xe,ye;
	char		*c;
	char		dx,i;
	
	if ((this=wn->wn_brd) && wn_msg(wn, WM_BORDER, this))
	{
		wn_color(wn,WN_NC);
		/* top-left */
		goto_xy(xs=wn->wn_nc.v_x,ys=wn->wn_nc.v_y); putch(this->br_tl);
		/* line top */
		i=dx=(xe=rc_xend(&wn->wn_nc))-xs;
		while (--i) putch(this->br_tside);
		/* top-right */
		putch(this->br_tr);
		/* bottom-left */
		goto_xy(xs,ye=rc_yend(&wn->wn_nc)); putch(this->br_bl);
		/* line bottom */
		i=dx; while (--i) putch(this->br_bside);
		/* bottom-right */
		putch(this->br_br);
		/* sides */
		i=ys; while (++i != ye)
		{
			goto_xy(xs,i); putch(this->br_lside);
			goto_xy(xe,i); putch(this->br_rside);
		}
		/* no separate wn_caption(wn) for speed sake */
		if (wn_msg(wn, WM_CAPTION, wn->wn_name))
		{
			if (c = wn->wn_name)
			{
				goto_xy(xs+2,ys);
				for (i=dx-3; *c && i--; putch(*c++));
			}
		}
		wn_color(wn,WN_CLIENT);	/* this is ugly */
	}
}
