/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 			
Window drawing
			LIST OF FUNCTIONS:
  
	gw_client	returns WINDOW client rectangle in parent coordinates
	wn_clear	clears entire client area (margins included)
	wn_hide		cleans everything with parent color or BLANK zero color
	wn_shadow	draws shadows with WINDOW::wn_sc shadow character
	nc_repaint	repaints non-client (and shadow) WINDOW area
	wn_set		draws non-client area (border,caption,shadows)+wn_cl()
	wn_unset	cleans everything (client,non-client and shadows)
	wn_hide		cleans WINDOW with its parent FILLCOLOR
	wn_show		calls wn_set/wn_hide after WM_SHOW processing
*/
#include "conio.h"
#include "wios.h"

VECTOR* gw_client(wn,rc)
WINDOW	*wn;
VECTOR	*rc;
{
	register DELTA	bw;
	
	rc_copy(rc,&wn->wn_nc);
	return  (bw = gw_brw(wn)) ? rc_add(rc,bw,bw,bw=-(bw+bw),bw) : rc;
}
/*
 * update window client area (aka UpdateWindow in WinAPI)
 * clears entire client area (margins included)
 * can't use while (wn_goto(wn,x,y++)) because of margins
 */
WINDOW* wn_clear(wn)
WINDOW *wn;
{
	register WINDOW *this;
	VECTOR		rc;
	FILLCOLOR	fc;
#ifdef WM_FILL
	/* user can modify filled client rect handling WM_FILL */
	if (wn_msg(this = wn, WM_FILL, gw_client(this,&rc)))
		rc_fill(&rc,&this->wn_fc[WN_CLIENT]);
#else
	rc_fill(gw_client(this=wn,&rc),&this->wn_fc[WN_CLIENT]);
#endif
	wn_msg	(this, WM_PAINT, &rc);	/* unconditionally */
	wn_home	(this);			/* sic! don't return wn_home(); */
	return	this;
}

#define SH_DELTA 1	/* shadow size */
		
wn_shadow(wn)
WINDOW *wn;
{
	register DELTA	n;
	AXIS		x,y;
	char		*p,fill;	/* shadow fillchar */
	
	fill = gw_fill(wn,WN_SHADOW);
	
	if (fill && wn_msg(wn,WM_SHADOW,fill))
	{
		if (fill = gw_fill(wn,WN_SHADOW))
		{
			wn_color(wn,WN_SHADOW);
			/* can't use wn_home() because of margins */
			goto_xy	( wn->wn_nc.v_x + SH_DELTA
				, y = rc_yend(&wn->wn_nc) + SH_DELTA
				);
			/* horizontal, bottom-up */
			for (n = wn->wn_nc.v_dx; --n; putch(fill));
			/* vertical, bottom-up */
			x = rc_xend(&wn->wn_nc) + SH_DELTA;
			for (n = wn->wn_nc.v_dy; n--; putch(fill)) goto_xy(x,y--);
			
			wn_color(wn,WN_CLIENT);
		}
	} 
}
/*
 * repaint non-client and shadow WINDOW areas
 *
 *	WNDMSG order
 *	if (WM_NCPAINT)
 *	{
 *		WM_BORDER
 *		WM_CAPTION
 *		WM_SHADOW
 *	}
 */
WINDOW* nc_repaint(wn)
WINDOW *wn;
{
	register WINDOW	*this;
	
	if (wn_msg(this=wn, WM_NCPAINT, 0))	/* cond aggregator */
	{
		wn_border(this);
		wn_shadow(this);
	}
	return this;
}

WINDOW* wn_set(wn) WINDOW *wn; { return nc_repaint(wn_clear(wn)); }

WINDOW* wn_unset(wn,fill,clr)
WINDOW	*wn;
char	fill;
COLOR	clr;
{
	register DELTA	ds;
	DELTA		dx,dy;
	AXIS		y;
	
	textcolor(clr);
	/* shadow size */
	ds = (gw_fill(wn,WN_SHADOW)) ? SH_DELTA : 0;	
	dx = ds + wn->wn_nc.v_dx;
	dy = ds + wn->wn_nc.v_dy;
	y  = wn->wn_nc.v_y  - 1;
#if 0	/* don't clean	top edge of dropdown list boxframe */
	if ((wn->wn_style & (WS_MENU|WS_LIST)) == WS_MENU|WS_LIST)
	{
		if (dy)
		{	/* less code than return */
			--dy;++y;
		}			
	}
#endif	/* WS_MENULIST */
	while (dy--)
	{
		goto_xy(wn->wn_nc.v_x,++y);
		for (ds=dx; ds--; putch(fill));
	}
	return wn;
}

WINDOW* wn_hide(wn) WINDOW *wn;
{
	register FILLCOLOR	*fc;
	
	fc = wn->wn_parent	? &(wn->wn_parent->wn_fc[WN_CLIENT])
				: &fillcolor;
	
	return wn_unset(wn, fc->fc_fill, fc->fc_color);
}
/*
 * Benny Hill Show with redundant anal inquiry. But who knows!
 * One day it might support SHOWMINNOACTIVE shite
 */
#ifdef WM_SHOW
WINDOW* wn_show(wn,visible)
WINDOW	*wn;
char	visible;
{
	return	wn_msg(wn,WM_SHOW,visible)
		? (visible ? wn_set(wn) : wn_hide(wn)) : 0;
}
#endif
