/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler

Character output
			LIST OF FUNCTIONS:
			
	wn_cio	prepares WINDOW for console I/O
	wn_cput	prints character in WINDOW client area
	wn_sput	prints string in WINDOW client area
	wn_scx	prints horizontally centered string in WINDOW client area
	wn_ctx	prints text separated by \n centered in window client area
*/

#include "conio.h"
#include "wios.h"
/*
 * Prepares WINDOW for console I/O
 * sets client color, attempts to place cursor at current client position
 * It is lower-level function compared to WINDOW focus setting, therefore
 * sw_style(this,WS_FOCUS,1) is not called here
 * 
 */
WINDOW* wn_cio(wn)
WINDOW *wn;
{
	register WINDOW	*this;
	
	wn_color(this = wn,WN_CLIENT);
	return wn_goto(this,this->wn_cur.pt_x,this->wn_cur.pt_y);
}
/*
 * Prints character in WINDOW client area at wn_cur position
 * Advances WINDOW cursor while it is still in client area
 * Doesn't handle carriage returns (other unprintable chars) properly
 * isprint() is costly and flawed in SuperSoft C
 * Aztec C has much better standard table-driven implementation
 */
WINDOW*	wn_cput(wn,c)
WINDOW	*wn;
char	c;
{
	register WINDOW	*this;
	
	if (wn_cio(this = wn))
	{
		putch(c);
		++(this->wn_cur.pt_x);
		return this;
	}
	return	0;
}
/*
 * Prints string in WINDOW client area at wn_cur position
 * Advances WINDOW cursor while it is still in client area
 * Doesn't handle carriage returns (other unprintable chars) properly
 */
WINDOW* wn_sput(wn,text)
WINDOW	*wn;
char	*text;
{
	register char	*c;
	DELTA		dx;
	
	if (wn_cio(wn))
	{
		dx = wn->wn_rc.v_dx - wn->wn_cur.pt_x + 1;
		for (c = text; --dx && *c ; putch(*c++));
		wn->wn_cur.pt_x += c - text;
		
		return wn;
	}
	return	0;
}
/*
 * Prints horizontally centered string in WN_CLIENT at wn_cur.pt_y
 * Advances WINDOW cursor while it is still in client area
 * Doesn't handle carriage returns (other unprintable chars) properly
 */
WINDOW* wn_scx(wn,text)
WINDOW	*wn;
char	*text;
{
	register WINDOW	*this;
	
	(this = wn)->wn_cur.pt_x = center(strlen(text),this->wn_rc.v_dx);
	
	return wn_sput(this,text);
}

/*
 * Prints text separated by \n centered in window client area
 * numlines limit number of printed lines
 */
wn_ctx(wn, text, numlines)
WINDOW	*wn;
char	*text;
DELTA	numlines;
{
	register char	*s;
	char		buf[MAXX],*z;	/* optimal declaration order */

	for (s=text; *s && numlines--;)
	{
		if (z = index(strncpy(buf,s,MAXX-1),'\n'))
		{
			*z = 0;
			/* lets violate indexing rules and save a byte	*/
			/* mind you, SuperSoft stdlib does it too	*/
			/* anal perfectionists can do s += z - buf + 1;	*/
			s += z - &buf[-1];

		}
		wn_scx(wn,buf);	/* center string by x axis */
		if (z) wn_nl(wn); else break;
	}
}

