/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved

	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.2 from 01.12.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler

listbox
			LIST OF FUNCTIONS:
	wn_list
*/

#include "conio.h"
#include "wios.h"
#include "keyboard.h"

static _sepside(wn,c)
WINDOW	*wn;
char	c;
{
	wn_color(wn,WN_NC);
	putch(c);
	wn_color(wn,WN_CLIENT); /* client separator part is never highlighted */
}
/*
 * prints text at line y in window client area
 * filling line remainder with WINDOW fillchar
 * treats 0 text pointer as separator
 */
static _lbsput(wn,y,text,hilite)
WINDOW	*wn;
AXIS	y;
char	*text;
char	hilite;
{
	register char	*s;
	SEPARATOR	*sep;
	char		nc_sep;	/* separator spans non-client area */
	char		fc;	/* WINDOW fillchar */
	char		sc;	/* separator color */
	DELTA		dx,bw;

	wn_hiclr(wn,hilite);
	dx=wn->wn_rc.v_dx;
	goto_xy(wn->wn_rc.v_x,wn->wn_rc.v_y+y);
	if (s = text)
	{
		fc = gw_fill(wn,WN_CLIENT);
		while (dx--) putch(*s ? *s++ : fc);
	}
	else
	{	/* draw separator */
		if (sep = wn->wn_menu ? wn->wn_menu->mn_sep : (nc_sep = 0))
		{	/* MENU::SEPARATOR defined */
			if (nc_sep = (bw=gw_brw(wn)) && !(wincfg & WCF_SEPTIC))
			{	/* separator spans non-client area */
				dx=wn->wn_nc.v_dx-(bw + bw);
				goto_xy(wn->wn_nc.v_x,wn->wn_rc.v_y+y);
				_sepside(wn,sep->sep_tl);
			}
			fc = sep->sep_fc;
		} else	fc = BLANK;

		while (dx--) putch(fc);
		if (nc_sep) _sepside(wn,sep->sep_br);
	}
}
/*
 * for MENU or listbox, prv is (must be) menu->mn_pos
 * but it is provided for signature conformance with control groups
 * Same if true for WINDOW*, that could be MENU*
 */
MENUSEL _lb_sel(wn,prv,pos,dx_max)
DELTA	dx_max;	/* unused */
WINDOW	*wn;
MENUSEL	prv;
MENUSEL	pos;
{
	register MENU	*this;
	MENUITEM	*mi;
	
	mi = (this = wn->wn_menu)->mn_item;
#ifdef	DEBUG
	assert( prv == this->mn_pos );
	assert((prv >= 0) && (prv < this->mn_count));
	assert((pos >= 0) && (pos < this->mn_count));
#endif	
#if 1
	_lbsput(wn,prv,mi[prv].mi_text,0);
	/* callback parameter introduction greed */	
	this->mn_pos = pos;
	
	if (!mn_msg(this,WM_FOCUS)) this->mn_pos = pos = prv;
	
	_lbsput(wn,pos,mi[pos].mi_text,1);
	return pos;
#else	/* extra parameter in signature makes it crawl */
	if (mn_msg(this,WM_FOCUS,pos))
	{
		_lbsput(wn,prv			,mi[prv].mi_text,0);
		_lbsput(wn,this->mn_pos = pos	,mi[pos].mi_text,1);
	}
	return this->mn_pos;
#endif
}
/*
 * draws and handles vertical menu list
 * returns:
 *	>= 0	selected list item
 *	-1	cancel
 *	-2	navigation request to previos parent menu item
 *	-3	navigation request to next parent menu item
 */
MENUSEL wn_list(wn)
WINDOW	*wn;
{
	register MENUSEL	pos;
	char			key,i;
	MENU			*menu;
	MENUITEM		*mi;
	MENUSEL			prv;
	char			count;	/* menu item count */

	if (!(menu = wn->wn_menu)) return MENU_EXIT;

	count=min(wn->wn_rc.v_dy, menu->mn_count);

	for (i=0; i != count; ++i) _lbsput(wn,i,menu->mn_item[i].mi_text,0);
	
	return mn_nav(wn,&navkey[NK_LIST],count,0);
}
