/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.2 from 01.12.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler

Menu bar

			LIST OF FUNCTIONS:
	wn_menubar
	wn_mbpos
*/
#include "conio.h"
#include "wios.h"
#include "keyboard.h"
/*
 * calculates menu item length
 */
DELTA _mi_len(menu,pos)
MENU	*menu;
MENUSEL	pos;
{
	register char *text;
	/* menu->mi_text[i] == 0 for separators */
	return (text = menu->mn_item[pos].mi_text) ? strlen(text) : 1;
}

_misel(wn,xoff,item,size,active)
WINDOW	*wn;
AXIS	xoff;
MENUSEL	item;
DELTA	size;
char	active;
{
	register WINDOW	*this;

	wn_hiclr( this=wn, active);
	
	puts_at	( this->wn_rc.v_x+xoff
		, this->wn_rc.v_y
		, this->wn_menu->mn_item[item].mi_text
		, size
		);
}
/*
 * redraws active menubar item
 * for MENU or listbox, prv is (must be) menu->mn_pos
 * but it is provided for signature conformance with control groups
 * Same if true for WINDOW*, that could be MENU*
 */
MENUSEL _mi_sel(wn,prv,pos,siz_max)
WINDOW		*wn;
MENUSEL		prv;
MENUSEL		pos;
DELTA		siz_max;	/* max{ MENU::mi_text[] }	*/
{
	MENU		*this;
	AXIS		xprv,xpos;	/* this item x offsets		*/
	DELTA		len;
	MENUSEL		i;		/* #pragma(__declseq) frame opt */
	
	this = wn->wn_menu;
	
#ifdef	DEBUG
	assert( prv == wn->mn_pos );
	assert((prv >= 0) && (prv < wn->mn_count));
	assert((pos >= 0) && (pos < wn->mn_count));
#endif
	for (xprv=xpos=len=i=0; i != this->mn_count; ++i)
	{
		len += this->mn_gap;	/* ++len; */
		if (prv == i) { xprv = len; if (xpos) break; }
		if (pos == i) { xpos = len; if (xprv) break; }
		len += _mi_len(this,i);
	}
#if 1
	_misel(wn,xprv,prv,siz_max-=this->mn_gap,0);
	/* callback parameter introduction greed */		
	this->mn_pos = pos;
	
	if (!mn_msg(this,WM_FOCUS))
	{
		this->mn_pos = pos = prv;		
		xpos = xprv;
	}
	_misel(wn,xpos,pos,siz_max,1);
		
	return pos;
#else	/* extra parameter in signature makes it crawl */
	if (mn_msg(this,WM_FOCUS,pos))
	{
		_misel(wn,xprv,prv,siz_max-=this->mn_gap,0);
		_misel(wn,xpos,this->mn_pos = pos,siz_max,1);
	}
	return this->mn_pos;
#endif
}	
/*
 * computes maximum allowed length of menubar item text
 * clamps item index to be between 0 and menu item count
 */
static DELTA _mit_max(wn)
WINDOW	*wn;
{
	register MENU	*menu;
	DELTA		len;
	DELTA		siz_max;	/* max{ menu->mi_text[] }	*/
	DELTA		siz_tot;	/* sum{ menu->mi_text[] }	*/
	DELTA		gap_tot;	/*	menu->mn_gap*count	*/
	char		count;		/* menu item count	*/
	MENUSEL		pos;
	/********************************************************/
	/* length and gap fitting must be checked for Supersoft	*/
	/* 	(menu is scrollable in Aztec C WINK library)	*/
	/********************************************************/
	siz_max	= 0;
	count	= (menu=wn->wn_menu)->mn_count;
	gap_tot = count * menu->mn_gap;
	
	if (count && (wn->wn_rc.v_dx >= (gap_tot + count)))
	{	/* normalizing menu position */
		if (menu->mn_pos >= count) menu->mn_pos = 0;
		else if (menu->mn_pos < 0) menu->mn_pos = count-1;
		
		siz_tot = gap_tot;
		for (pos = count; pos; --pos)
		{
			siz_tot += len = _mi_len(menu,pos);
			if (len > siz_max) siz_max = len;
		}
		if (siz_tot > wn->wn_rc.v_dx)
		{	/* text doesn't fit, use equidistant max size	*/
			/* and ensure gap fits between these menu items	*/
			siz_max = wn->wn_rc.v_dx/count;
			if (siz_max <= menu->mn_gap) siz_max = 0;
		}
		else siz_max += menu->mn_gap;
	}
	return siz_max;
}
/*
 * draws and handles horizontal menu bar
 * returns:
 *	>= 0	selected list item
 *	-1	cancel
 *	-2	navigation request to previos parent menu item
 *	-3	navigation request to next parent menu item
 */
MENUSEL wn_menubar(wn)
WINDOW *wn;
{
	register MENUSEL i;
	char		key;
	AXIS		x,y;
	DELTA		txt_max;/* max{MENU::mi_text[]}	*/
	MENU		*menu;
	MENUITEM	*mi;
	char		count;	/* menu item count	*/
	MENUSEL		prv,pos;
	
	if (!(menu=wn->wn_menu) || !(txt_max=_mit_max(wn))) return MENU_EXIT;
	
	wn_home(wn);
	
	count = menu->mn_count;
	x = wn->wn_rc.v_x;
	for (wn_hiclr(wn,i=0); i != count; ++i)
	{
		puts_at	( x += menu->mn_gap	, wn->wn_rc.v_y
			, menu->mn_item[i].mi_text
			, txt_max
			);
		x += min(_mi_len(menu,i),txt_max);
	}
	return mn_nav(wn,&navkey[NK_MENU],count,txt_max);
}
/*
 * translates negative menu item, returned from
 * wn_list() to valid parent menu item position
 * allowing parent menu navigation from dropdown
 */
MENUSEL	wn_mbpos(wn,pos)
WINDOW	*wn;	/* parent menu */
MENUSEL	pos;	/* return value from drop-down listbox submenu */
{
	register MENU	*menu;
	DELTA		txt_max;/* max{ wn->wn_menu->mi_text[] }*/
	MENUSEL		prv;

	if (!(menu=wn->wn_menu)) return MENU_EXIT;
	
	prv = menu->mn_pos; /* must be >=0 */
	
	switch (pos)
	{
		case MENU_PREV:
#ifdef	WM_PREV
			if (mn_msg(menu,WM_PREV))
#endif	/* WM_PREV */
			{
				menu->mn_pos=mi_prev(menu,prv,menu->mn_count);				
				break;
			}
		case MENU_NEXT:
#ifdef	WM_NEXT
			if (mn_msg(menu,WM_NEXT))
#endif	/* WM_NEXT */
			{
				menu->mn_pos=mi_next(menu,prv,menu->mn_count);				
				break;
			}
		default	: return prv;
	}
	return	txt_max = _mit_max(wn)	/* bounds menu->mn_pos */
		? (menu->mn_pos =_mi_sel(wn,prv,menu->mn_pos,txt_max))
		: MENU_EXIT; /* not much of a choice */
}
