/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.1 from 08.05.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler
 
SuperSoft C does not support list initializers (initb() is awful)
All of below can be statically initialized by Aztec or any other K&R C

I don't see much shame in assembly usage below portability-wise
Layouts are same, almost any good asm will digest macro facilities
Only concern is target platform alignment: every byte counts here

Predefined data (NAVKEY is defined in "keyboard.h", other types in "wios.h")

	NAVKEY		navkey[4];
	FILLCOLOR	fillcolor;
	BORDER		bframe	 [8];
	SEPARATOR	separator[4];
	char		crossbar [4];
*/
#include "keyboard.h"

#asm
include conio.inc

ALT_FRAMES	EQU	0	; use alternative drop-down menu list frames

DSeg
;################################################
;#	menu & listbox navigation keys		#
;################################################
NAVKEY	Macro	nkdraw,nklist
	IFNB	<nkdraw>
		ext	nkdraw
		DW	nkdraw
	ELSE
		DW	0
	EndIF
	IRP	nk_xx,<nklist>
		DB	nk_xx
	EndM
EndM
public	navkey
navkey:
NAVKEY	<$lb$sel>,<HOME,END_KEY,UP,DOWN,ENTER,0,ESC,LEFT,RIGHT>
NAVKEY	<$mi$sel>,<HOME,END_KEY,LEFT,RIGHT,ENTER,DOWN,ESC,0,0>
NAVKEY	,<HOME,END_KEY,UP,DOWN,ENTER,BLANK,ESC,0,0>
NAVKEY	,<HOME,END_KEY,LEFT,RIGHT,ENTER,BLANK,ESC,0,0>
;################################################
;#	C o n f i g u r a t i o n		#
;################################################
; stuff below can all go into single WINCFG structure to save on publics
public wincfg
wincfg:	DW	0
public fillcolor
fillcolor:
DB	0	; fc_color
DB	20h	; fc_fill
;################################################
;#		B o x   f r a m e s		#	
;################################################
public bframe	; struct _BORDER[8] array of pseudo graphic boxframes
bframe:
;################################################
;#	window/dialog/menubar frames		#
;################################################
;	Ŀ
;		[0] BR_SS boxframe		
;	
DB	0AAh	;  top-left corner
DB	08Fh	;  top-right corner
DB	090h	;  bottom-left corner
DB	0A9h	;  bottom-right corner

DB	094h	;  top-horizontal line
DB	083h	;  left-vertical line
DB	083h	;  right-vertical line
DB	094h	;  bottom-horizontal line
;	ķ
;		[1] BR_SD boxframe		
;	Ľ
DB	166	;  top-left corner
DB	135	;  top-right corner
DB	163 	;  bottom-left corner
DB	141	;  bottom-right corner

DB	148	;  top-horizontal line
DB	138	;  left-vertical line
DB	138	;  right-vertical line
DB	148	;  bottom-horizontal line
;	͸
;		[2] BR_DS boxframe		
;	;
DB	165	;  top-left corner
DB	136	;  top-right corner
DB	164	;  bottom-left corner
DB	142	;  bottom-right corner

DB	157	;  top-horizontal line
DB	131	;  left-vertical line
DB	131	;  right-vertical line
DB	157	;  bottom-horizontal line
;	ͻ
;		[3] BR_DD boxframe		
;	ͼ
DB	099h	;  top-left corner
DB	08Bh	;  top-right corner
DB	098h	;  bottom-left corner
DB	08Ch	;  bottom-right corner

DB	09Dh	;  top-horizontal line
DB	08Ah	;  left-vertical line
DB	08Ah	;  right-vertical line
DB	09Dh	;  bottom-horizontal line
IFF	ALT_FRAMES
;################################################
;#	dropdown list frames			#
;################################################
;	
;		[4] BR_SS|BR_DROP boxframe	
;	
DB	092h	;  top-left corner
DB	092h	;  top-right corner
DB	090h	;  bottom-left corner
DB	0A9h	;  bottom-right corner

DB	094h	;  top-horizontal single line
DB	083h	;  left-vertical line
DB	083h	;  right-vertical line
DB	094h	;  bottom-horizontal line
;	
;		[5] BR_SD|BR_DROP boxframe	
;	ͼ
DB	0A2h	;  top-left corner
DB	0A2h	;  top-right corner
DB	098h	;  bottom-left corner
DB	08Ch	;  bottom-right corner

DB	094h	;  top-horizontal single line
DB	08Ah	;  left-vertical line
DB	08Ah	;  right-vertical line
DB	09Dh	;  bottom-horizontal line
;	
;		[6] BR_DS|BR_DROP boxframe	
;	
DB	0A1h	;  top-left corner
DB	0A1h	;  top-right corner
DB	090h	;  bottom-left corner
DB	0A9h	;  bottom-right corner

DB	09Dh	;  top-horizontal double line
DB	083h	;  left-vertical line
DB	083h	;  right-vertical line
DB	094h	;  bottom-horizontal line
;	
;		[7] BR_SS|BR_DROP boxframe	
;	ͼ
DB	09Bh	;  top-left corner
DB	09Bh	;  top-right corner
DB	098h	;  bottom-left corner
DB	08Ch	;  bottom-right corner

DB	09Dh	;  top-horizontal double line
DB	08Ah	;  left-vertical line
DB	08Ah	;  right-vertical line
DB	09Dh	;  bottom-horizontal line
ELSE
;################################################
;#	alternative dropdown list frames	#
;################################################
;	                                       
;		[4] BR_SS|BR_DROP boxframe	
;	
DB	08Fh	;  top-left corner
DB	0AAh	;  top-right corner
DB	090h	;  bottom-left corner
DB	0A9h	;  bottom-right corner

DB	020h	;   top-horizontal space
DB	083h	;  left-vertical line
DB	083h	;  right-vertical line
DB	094h	;  bottom-horizontal line
;	                                       
;		[5] BR_SD|BR_DROP boxframe	
;	ͼ
DB	135	;  top-left corner
DB	166	;  top-right corner
DB	098h	;  bottom-left corner
DB	08Ch	;  bottom-right corner

DB	020h	;   top-horizontal space
DB	08Ah	;  left-vertical line
DB	08Ah	;  right-vertical line
DB	09Dh	;  bottom-horizontal line
;						
;		[6] BR_DS|BR_DROP boxframe	
;	
DB	136	;  top-left corner
DB	165	;  top-right corner
DB	090h	;  bottom-left corner
DB	0A9h	;  bottom-right corner

DB	020h	;   top-horizontal space
DB	083h	;  left-vertical line
DB	083h	;  right-vertical line
DB	094h	;  bottom-horizontal line
;						
;		[7] BR_SS|BR_DROP boxframe	
;	ͼ
DB	08Bh	;  top-left corner
DB	099h	;  top-right corner
DB	098h	;  bottom-left corner
DB	08Ch	;  bottom-right corner

DB	020h	;   top-horizontal space
DB	08Ah	;  left-vertical line
DB	08Ah	;  right-vertical line
DB	09Dh	;  bottom-horizontal line
EndIF
public separator; struct _SEPARATOR[8]
separator:
;################################################
;#	vertical separators (menubar)		#
;################################################
;	[0] BR_SS separator
DB	091h	;  menu top
DB	083h	;  menu fillchar
DB	092h	;  menu bottom

;	[1] BR_SD separator
DB	0A2h	;  menu top
DB	08Ah	;  menu fillchar
DB	0A0h	;  menu bottom

;	[2] BR_DS separator
DB	0A1h	;  menu top
DB	083h	;  menu fillchar
DB	09Fh	;  menu bottom

;	[3] BR_DD separator
DB	09Bh	;  menu top
DB	08Ah	;  menu fillchar
DB	09Ah	;  menu bottom
;################################################
;#	horizontal separators (list)		#
;################################################
;	[4] BR_SS|BR_DROP separator
DB	093h	;  listbox left
DB	094h	;  listbox fillchar
DB	084h	;  listbox right

;	[5] BR_SD|BR_DROP separator
DB	097h	;  listbox left
DB	094h	;  listbox fillchar
DB	086h	;  listbox right

;	[6] BR_DS|BR_DROP separator
DB	096h	;  listbox left
DB	09Dh	;  listbox fillchar
DB	085h	;  listbox right

;	[7] BR_DD|BR_DROP separator
DB	09Ch	;  listbox left
DB	09Dh	;  listbox fillchar
DB	089h	;  listbox right
;################################################
;#	crossbars				#
;################################################
public crossbar	; 4 crossbars
crossbar:
DB	095h	;  BR_SS crossbar
DB	0A7h	;  BR_SD crossbar
DB	0A8h	;  BR_DS crossbar
DB	09Eh	;  BR_DD crossbar
End
#endasm
