/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.2 from 01.12.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler

Message Box

			LIST OF FUNCTIONS:
	msg_box
*/
#include "wios.h"
#include "conio.h"

#define SX_BTN		5	/* first button offset (from margin)	*/
#define DX_BTN		17	/* (12 characters) button + gap		*/

#define DY_TXT		9	/* maximum number of printed lines + 1	*/
#define DY_MIN		8	/* min dialog height minus text lines	*/

#define	BTN_NUM		3

/* user side or WIOS extension must provide following extern functions	*/
extern 
WINDOW* button	(/*	char	*name;
		,	WINDOW	*parent;
		,	AXIS	x
		,	AXIS	y	*/
		);

MENUSEL msg_box(this,text,style)
WINDOW	*this;
char	*text;
char	style;		/* MB_OK|MB_YES|MB_NO|MB_CANCEL */
{
	register WINDOW	*wn;
	WINDOW		*btn[BTN_NUM];
	WGROUP		wg;
	VECTOR		rc;
	FILLCOLOR	fc;
	DELTA		dx_min,dx,dy;
	MENUSEL		pos;		/* actually # of dialog buttons */
	char		*s,i;
	COLOR		clr;
	
	btn[BTN_YES] = (style & MB_YES) ? button('Y'," <Y>es  ", this,0,0)
					: button('K',"  O<K>  ", this,0,0);
	btn[BTN_NO]  = (style & MB_NO)	? button('N',"  <N>o  ", this,0,0) : 0;
	btn[BTN_CAN]=(style & MB_CANCEL)? button('C',"<C>ancel", this,0,0) : 0;
	/*
	 * compute dialog width, SX_BTN + 2 because of 2 margins
	 */
	for (i=pos=0, dx=SX_BTN+2; i < BTN_NUM; ++i)
		if (btn[i]) { ++pos; dx += DX_BTN; }
	/*
	 * increase single button dialog width
	 */
	dx_min = (pos < 2) ? DX_BTN : 0;
	/*
	 * dialog height is increased if text contains newline characters
	 */
	for (s=text, dy=1; s=index(s,'\n'); ++s) if (++dy==DY_TXT) break;

	wn_size	 (this, dx+dx_min, dy+DY_MIN);
	wn_center(this);			/* center dialog in parent WINDOW */
	wn_set	 (this);
	/* custom group rect sort of */
	gw_client(this,&rc);
	fc.fc_fill = BLANK;
	fc.fc_color= COLOR_0;
	rc_fill(rc_add(&rc,1,1,-2,-6),&fc);
	/*
	 * position buttons to leave 2 empty lines above and below text
	 */
	dx = SX_BTN + (dx_min >> 1);

	for (i=0; i != BTN_NUM; ++i) if (wn=btn[i])
		{ wn_move(wn,dx,2+dy); wn_set(wn); dx+=DX_BTN; }
	/*
	 * print dy number of lines from text
	 */
	wn_nl(this);
	wn_ctx(this,text,dy);
	/*
	 * get control selection from user
	 */
	wg_def(&wg,btn,BTN_NUM,WS_MENU|WS_TABSTOP);
	/*
	 * highlight selected buton
	 */
	if ((pos = wg_nav(&wg,--pos)) > MENU_EXIT) wn_active(wn=btn[pos],1);

	wn_hide(this);
	/*
	 * destroy everything
	 */
	i=BTN_NUM; do wn_destroy(btn[--i]); while (i);
	
	return pos;
}
