/*
		(c) Perlin Production Co. Ltd, 1991-2023
			All rights reserved
		
	Pseudographic window I/O system ver.5.0 for Vector-06c
	(modified ver 3.2 from 01.12.1993, previous millenium)
 			SuperSoft C 1.2.3 compiler

WINDOW (control) Group

			LIST OF FUNCTIONS:
	wg_def		defines control group (for property sheets)
	wg_focus	focuses caret at control in group
	wg_nav		handles caret navigation in group of controls
*/
#include "wios.h"
#include "conio.h"
#include "keyboard.h"

/* user side or WIOS extension must provide following extern functions	*/
extern 
WINDOW* ws_focus(/*	WINDOW*
		,	bool	focus
		*/
		);
		
WGROUP* wg_def(wg,list,count,style)
WGROUP		*wg;
WINDOW		**list;
unsigned	count;
unsigned	style;
{
	register WGROUP	*this;
	
	if (this = wg ? wg : calloc(1,SIZE_WG))
	{
		this->wg_ctl	= list;
		this->wg_count	= count;
		this->wg_style	= style;
	}	
	return this;
}
/*
 * regress group control position skipping zeroed control pointers
 */
static MENUSEL wg_prev(wg,sel,count)
WGROUP	*wg;
MENUSEL	sel;	/* currently focused control index */
MENUSEL	count;
{
	register MENUSEL id;
	
	id = (sel && vk_ctrl()) ? 1 : sel;
	
	do { if (!id) id = count; --id; }
	while (!wg->wg_ctl[id] && (id != sel));
	return id;
}
/*
 * advance group control position skipping zeroed control pointers
 */
static MENUSEL wg_next(wg,sel,count)
WGROUP	*wg;
MENUSEL	sel;	/* currently focused control index */
MENUSEL	count;
{
	register MENUSEL id;
	
	id = ((sel != (count-1)) && vk_ctrl()) ? count - 2 : sel;
	
	do if (++id == count) id = 0;
	while (!wg->wg_ctl[id] && (id != sel));
	return id;
}

/*
	See WIOS13 NAVKEY definition
MENUSEL _wg_sel(wn,prv,pos,dx_max)
WINDOW	*wn;
MENUSEL	prv;
MENUSEL	pos;
DELTA	dx_max;
{
	wg_focus(wn,pos,1);
}
*/

/*
 * change group control focus
 */
MENUSEL wg_focus(wg,id,focus)
WGROUP	*wg;
MENUSEL	id;	/* control index getting focus */
char	focus;	/* bool */
{
	register WGROUP *this;

	this = wg;	
	
	if (this->wg_sel) ws_focus(this->wg_sel	,0);
	this->wg_sel	= ws_focus(this->wg_ctl[id],focus);
	
	return id;
}

/*
 * Group control navigation (scroll between group controls)
 * returns 0-based control position in group or negative
 * MENU_EXIT for cancellation request
 *
 * if WGROUP style is defined without WS_TABSTOP bit,
 * MENU_PREV or MENU_NEXT is returned to indicate navigation
 * request to previous/next group of controls
 *
 */
MENUSEL wg_nav(wg,pos)
WGROUP	*wg;
MENUSEL	pos;	/* initial focused control position in group */
{
	register NAVKEY	*nk;
	WINDOW		*wn;
	MENUSEL		(*dir)(),count,i;
	char		key;

	nk	= &navkey[NK_GROUP | ((wg->wg_style & WS_MENU) != 0)];
	count	= wg->wg_count;

	while (1)
	{
		wg_focus(wg,pos,1);
		dir = &wg_prev;
		
		if ((key = toupper(getkey())) == TAB)
		{
#if 1			
			if (wg->wg_style & WS_TABSTOP)
#else
			wn  = wg->wg_ctl[pos];
			if (wn->wn_style & WS_TABSTOP)
#endif			
			{	
				key = vk_shift() ? nk->nk_prev : nk->nk_next;
			}
			else return vk_shift() ? MENU_PREV : MENU_NEXT;
		}

		if (key == nk->nk_end) pos = 0;
		else if (key != nk->nk_prev)
		{
			dir = &wg_next;
			if (key == nk->nk_home) pos = count-1;
			else if (key != nk->nk_next) dir = 0;
		}
		if (dir) { pos = (*dir)(wg,pos,count); }
		else
		{
			if (key == nk->nk_exit)	return MENU_EXIT;
			/*
			 * control may redraw itself but
			 * keep wg_nav() running further
			 */
			if ((key == nk->nk_sel || key==nk->nk_sel2)
			&& wn_notify(wg->wg_ctl[pos], WM_SELECT, pos)
			) return pos;
			
			if (key) for (i=0; i != count; ++i)
			{
				if ((wn=wg->wg_ctl[i]) && (wn->wn_accel==key))
				 	return wg_focus(wg,i,1);
			}
		}
	}		
}
