#!/usr/bin/python
# -*- coding: UTF-8 -*-

import sys
import argparse


def createParser():
    parser = argparse.ArgumentParser()
    parser.add_argument('filename',
                        help='Имя загружаемого снепшота .Z80')
    parser.add_argument('-s', '--sna', type=int, default=0,
                        help='Принудительный формат для .SNA (48 или 128)')
    return parser


def unpack(z80_shift, z80_length, sna_shift, sna_length=16384):
    counter_z80 = z80_shift
    counter_sna = sna_shift

    if z80_length and (z80_length != 1) and (z80_length != 0xFFFF):
        while counter_sna < (sna_shift + sna_length):
            if z80_bytes[counter_z80:counter_z80 + 2] != bytearray(b'\xed\xed'):
                sna_bytes[counter_sna] = z80_bytes[counter_z80]
                counter_z80 += 1
                counter_sna += 1
            else:
                for i in range(z80_bytes[counter_z80 + 2]):
                    sna_bytes[counter_sna] = z80_bytes[counter_z80 + 3]
                    counter_sna += 1
                counter_z80 += 4
    elif z80_length == 0xFFFF:
        sna_bytes[counter_sna:counter_sna + sna_length] = z80_bytes[counter_z80:counter_z80 + sna_length]
        counter_z80 += sna_length

    return counter_z80


if __name__ == "__main__":
    parser = createParser()
    namespace = parser.parse_args(sys.argv[1:])
    filename = namespace.filename
    snaformat = namespace.sna

    # Читаем файл снепшота
    try:
        if filename.split('.')[-1].lower() == 'z80':
            with open(filename, "rb") as f:
                z80_bytes = bytearray(f.read())
        else:
            print("Это не файл снепшота")
            sys.exit()
    except:
        print("Невозможно прочитать файл {}".format(filename))
        sys.exit()

    # Определяем версию .Z80
    if z80_bytes[6] and z80_bytes[7]:
        version = 1
        print("Z80 версии 1.45 и ниже")
    else:
        if z80_bytes[30] == 23:
            version = 2
            print("Z80 версии 2.01 и выше")
        elif z80_bytes[30] == 54 or z80_bytes[30] == 55:
            version = 3
            print("Z80 версии 3.0 и выше")
        else:
            version = 0
            print("Z80 неизвестной версии")

    # Определяем модель ZX Spectrum
    if version == 1:
        model = 48
    elif z80_bytes[34] < 2:
        model = 48
    elif z80_bytes[34] == 3 and version == 3:
        model = 48
    elif z80_bytes[34] == 2:
        model = 64  # SamRam
    else:
        model = 128
    print("ZX Spectrum {} Кб".format(model))

    # Формируем массив под .SNA нужного размера
    if model == 128:
        port_7ffd = z80_bytes[35]
        page = port_7ffd & 0b111
        if page == 8:
            sna_bytes = bytearray(147487)
        else:
            sna_bytes = bytearray(131103)
    elif model == 48:
        page = 1
        sna_bytes = bytearray(49179)

    # pc = bytearray(2)

# Распаковка данных
    # Распаковка дампа памяти
    if version > 1:  # Новая версия .Z80
        print("Распаковка данных...")
        pc = z80_bytes[32:34]
        pages = 8
        if model == 48:
            pages = 3

        counter_z80 = 30 + z80_bytes[30] + z80_bytes[30 + 1] * 256 + 2
        sna_append = 49183

        for i in range(pages):
            z80_length = z80_bytes[counter_z80 + 1] * 256 + z80_bytes[counter_z80]
            page_number = z80_bytes[counter_z80 + 2]
            counter_z80 += 3
            counter2_z80 = counter_z80

            if page_number == 8:
                counter_sna = 27  # 4000
                counter2_z80 = unpack(counter_z80, z80_length, counter_sna)
            if ((model == 128) and (page_number == 5)) or ((model == 48) and (page_number == page + 3)):
                counter_sna = 27 + 0x4000  # 8000
                counter2_z80 = unpack(counter_z80, z80_length, counter_sna)
            if ((model == 128) and (page_number == page + 3)) or ((model == 48) and (page_number == 5)):
                counter_sna = 27 + 0x8000  # C000
                counter2_z80 = unpack(counter_z80, z80_length, counter_sna)
            if (model == 128) and (page_number != 8) and (page_number != 5) and (page_number != page + 3):
                counter_sna = sna_append
                counter2_z80 = unpack(counter_z80, z80_length, counter_sna)
                sna_append += 16384
            counter_z80 = counter2_z80
    else:  # Старая версия .Z80
        pc = z80_bytes[6:8]
        counter_sna = 27
        counter_z80 = 30
        z80_length = len(z80_bytes) - counter_z80
        sna_length = 49152
        if z80_bytes[12] & 0b00100000:
            print("Распаковка данных...")
            counter2_z80 = unpack(counter_z80, z80_length, counter_sna, sna_length)
        else:
            print("Перенос незапакованных данных...")
            sna_bytes[counter_sna:counter_sna + sna_length] = z80_bytes[counter_z80:counter_z80 + sna_length]

    # Фрмируем заголовок SNA общий для обоих форматов
    # Конвертируем регистры
    convert_tab = [[0, 22], [1, 21], [2, 13], [3, 14], [4, 9], [5, 10], [10, 0], [11, 20], [13, 11], [14, 12], [15, 5],
                   [16, 6], [17, 3], [18, 4], [19, 1], [20, 2], [21, 8], [22, 7], [23, 15], [24, 16], [25, 17],
                   [26, 18]]
    for i in range(len(convert_tab)):
        sna_bytes[convert_tab[i][1]] = z80_bytes[convert_tab[i][0]]

    # Триггер прерываний IFF2
    if z80_bytes[27]:
        sna_bytes[19] = 0b100

    # Режим прерываний
    sna_bytes[25] = z80_bytes[29] & 0b111

    # Обработка сложного байта 12
    if z80_bytes[12] == 255:
        z80_bytes[12] = 1
    # Цвет бордюра
    sna_bytes[26] = z80_bytes[12] >> 1 & 0b111
    # Старший бит регистра R
    sna_bytes[20] = (sna_bytes[20] & 0b1111111) | (z80_bytes[12] << 7 & 0b10000000)

    # Делаем принудительно SNA 48К из Z80 128К
    if model == 128 and snaformat == 48:
        model = 48
        sna_bytes = sna_bytes[0:49179]
    # Делаем принудительно SNA 128К из Z80 48К
    elif model == 48 and snaformat == 128:
        model = 128
        sna_bytes += bytearray(81924)
        port_7ffd = 0x10

    # Записываем PC и SP в зависимости от модели
    if model == 48:
        # Запись скорректированного значения стека в заголовок
        sp = ((z80_bytes[9] * 256 + z80_bytes[8]) - 2) & 0xFFFF
        sna_bytes[23] = sp % 256
        sna_bytes[24] = sp // 256
        # Запись PC на стек
        if 16383 < sp < 65536:
            sna_bytes[27 + sp - 16384] = pc[0]
        if 16382 < sp < 65535:
            sna_bytes[27 + sp + 1 - 16384] = pc[1]
    elif model == 128:
        sna_bytes[49179:49181] = pc  # PC
        sna_bytes[23:25] = z80_bytes[8:10]  # SP
        sna_bytes[49181] = port_7ffd  # Порт #7FFD

    # Записываем получившийся снепшот
    new_filename = filename[:-4] + '.sna'
    print("На выходе SNA{}: {}".format(model, new_filename))

    try:
        with open(new_filename, "wb") as f:
            f.write(sna_bytes)
    except:
        print("Невозможно записать файл {}".format(new_filename))
        sys.exit()
