;Player for Fast PSG Packer for compression levels [4..5]
;8080 compact version by Ivan Gorodetsky 25.09.2023
;based on z80 version
;
;z80 version source code is based on psndcj/tbk player and bfox/tmk player.
;Modified by physic 8.12.2021
;

#define EQU .equ
#define equ .equ
#define db .db
#define dw .dw
#define ds .ds
#define org .org
#define end .end

MAX_NESTED_LEVEL EQU 4

AYREG	equ 15h
AYDAT	equ 14h

#define SAVE_POS xchg\ lhld pl_track+1\ mov m,e\ inr l\ mov m,d


stop:
			mvi d,13
stop1:
			mov a,d
			out AYREG
			xra a
			out AYDAT
			dcr d
			jnz stop1
			ret

mus_init:
			lxi h,music
			mov a,l
			sta mus_low+1
			mov a,h
			sta mus_high+1
			lxi d,16*4
			dad d
			shld stack_pos+1
			mvi a,21h		;lxi h,
			sta trb_play
			xra a
			lxi h,stack_pos
			mov m,a
			inx h
			shld pl_track+1
			ret

pause_rep	db 0
trb_pause:
			lxi h,pause_rep
			dcr m
			rnz

saved_track:
			mvi a,21h		;lxi h, (end of pause)
			sta trb_play
			lhld pl_track+1
			jmp trb_rep

endtrack:
			pop h
			jmp mus_init

pl_frame:
			call pl0x
after_play_frame:
			xra a
			sta stack_pos
			SAVE_POS
			dcr l
trb_rep:
			dcr l
			dcr m
			rnz

trb_rest:
			dcr l
			dcr l
			shld pl_track+1
			ret

trb_play:
			jmp trb_pause		;или lxi h,
pl_track:
			lhld stack_pos+1
			mov a,m
			add a
			jnc pl_frame

pl1x:
			mov b,m
			inx h
			mov c,m
			inx h
			jp pl10

pl11:
			mov a,m
			inx h
			xchg
			lhld pl_track+1
			dcr l
			dcr m
			jz same_level_ref

nested_ref:
			inr l
			mov m,e
			inr l
			mov m,d
			inr l
same_level_ref:
			mov m,a
			inr l
			shld pl_track+1
			xchg
			dad b
			mov a,m
			add a
			call pl0x
			SAVE_POS
			ret							 

single_pause:
			pop d
			jmp after_play_frame

long_pause:
			inx h
			mov a,m
			inx h
			jmp pause_cont
pl_pause:
			ani 0Fh
			inx h
			jz single_pause

pause_cont:
			sta pause_rep
			xchg
			lhld pl_track+1
			mov m,e
			inr l
			mov m,d
			mvi a,0C3h		;jmp
			sta trb_play
			pop h
			ret

pause_or_psg1:
			add a
			mov a,m
			jc pl_pause
			jz long_pause
			cpi 0Fh
			jz endtrack
			dcr a
			inx h
			jmp out2_

pl00:
			add a
			jnc pause_or_psg1
			mvi d,5
			rrc\ rrc
			push h
mus_low:
			adi 0
			mov l,a
mus_high:
			aci 0
			sub l
			mov h,a
			mov a,m
			inx h
			mov h,m
			xthl
			inx h
			call reg_left_6
			pop psw
			add a
			jmp play_by_mask_13_6


pl10:
			SAVE_POS
			xchg
			mvi a,64
			ora b
			mov b,a
			dad b
			mov a,m
			add a
			call pl0x
			lhld pl_track+1
			jmp trb_rep

pl0x:
			add a
			jnc pl00

pl01:
			inx h
			mvi d,0
			jz play_all_0_5
			mvi e,5
			.db 0FEh			;cpi ...
play_by_mask_0_5:
			mov a,c\ add a\ mov c,a\ cnc out2\ inr d
			dcr e\ jnz play_by_mask_0_5
			mov a,c\ add a
			jc play_all_0_5_end
			call out2

second_mask:
			mov a,m
			inx h
before_6:
			add a
			jz play_all_6_13
			jmp play_by_mask_13_6

play_all_0_5:
			mvi e,6
			call play_all_6_13_2

play_all_0_5_end:
			mov a,m
			inx h
			add a
			jnz play_by_mask_13_6

play_all_6_13:
			mvi e,7
			jc play_all_6_13_1
			inr e
play_all_6_13_1:
			inr d
play_all_6_13_2:
			call out2
			dcr e\ jnz play_all_6_13_1
			ret

play_by_mask_13_6:
			mvi d,13\ mov c,a
			cnc out2
			dcr d
			mov a,c\ add a\ mov c,a
			cnc out2
			dcr d
			mov a,c
reg_left_6:
			add a\ mov c,a
			cnc out2
			mvi e,5
reg_left_6_1_loop:
			dcr d\ mov a,c\ add a\ mov c,a\ cnc out2
			dcr e\ jnz reg_left_6_1_loop
			ret

out2:
			mov a,d
out2_:
			out AYREG\ mov a,m\ inx h\ out AYDAT
			ret

;принудительный переход в следующий блок с одинаковыми старшими байтами адреса
;			org ($+255)&0FF00h

stack_pos:
			ds MAX_NESTED_LEVEL*3
stack_pos_end
			db 0

init		EQU mus_init
play		EQU trb_play


music:


			end