#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds


#define LEN (3000/4*14)

MUL10kTAB	.equ 0E000h
font		.equ 0E300h
BUF			.equ 0C00h+100h-2
MULprocs	.equ 6000h

	ORG 0100h

	di
	xra	a
	out	10h
	lxi	sp,100h
	mvi	a,0C3h
	sta	0
	sta 38h
	lxi	h,Restart
	shld	1
	call	Cls
	lxi h,Int
	shld 39h
	ei
	hlt
	lxi	h, colors+15
colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:	mov	a, c
	out	2
	mov	a, m
	out	0Ch
	xthl
	xthl
	mov a,a
	dcx	h
	dcr	c
	out	0Ch
	jp	colorset1
	cma
	out	3
	mvi a,10h
	out 2

;prepare font
	lxi b,(256*3)/2
	lxi h,fontsrc
	lxi d,font
PrepareFontLoop:
	mov a,m
	stax d
	inx h
	inx d
	push d
	mov d,m
	xchg
	dad h\ rar
	dad h\ rar
	dad h\ rar
	dad h\ rar
	dad h\ rar
	dad h\ rar
	dad h\ rar
	dad h\ rar
	xchg
	pop d
	stax d
	inx h
	inx d
	dcx b
	mov a,b
	ora c
	jnz PrepareFontLoop

	lxi h,MULprocs
	mov c,l
GenMUL1:
	push h
	xra a
	ora c
	jnz GenMUL1nz
	mvi m,22h\ inx h	;shld
	mvi m,(Set_D+1)&255\ inx h
	mvi m,(Set_D+1)>>8\ inx h
	mvi m,69h\ inx h	;mov l,c
	mvi m,26h\ inx h	;mvi h,
	mvi m,0\ inx h
	mvi m,0C3h\ inx h	;jmp
	mvi m,MUL16_&255\ inx h
	mvi m,MUL16_>>8
	jmp SwToOne1_	

GenMUL1nz:
	mvi m,41h\ inx h	;mov b,c
	mvi m,4Ch\ inx h	;mov c,h
	mvi m,0E5h\ inx h	;push h
	
	mvi m,62h\ inx h	;mov h,d
	mvi m,6Bh\ inx h	;mov l,e	

	add a
	add a
	mvi m,3Eh\ inx h	;mvi a,
	add a
	mov m,a\ inx h
	jc SwToOne6noC
	mvi m,87h\ inx h	;add a
	add a\ jc SwToOne5noC
	mvi m,87h\ inx h	;add a
	add a\ jc SwToOne4noC
	mvi m,87h\ inx h	;add a
	add a\ jc SwToOne3noC
	mvi m,87h\ inx h	;add a
	add a\ jc SwToOne2noC
	mvi m,87h\ inx h	;add a
	jmp PreSw1

SwToOne6noC:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne5noC:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne4noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne3noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne2noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC

PreSw1:	
SwToOne1:
	mvi m,0C3h\ inx h	;jmp
	mvi m,(MUL16_16_ & 255)\ inx h
	mvi m,(MUL16_16_ >> 8)
SwToOne1_:
	pop h
	inr h
	inr c
	mvi a,11000000b
	ana c
	jz GenMUL1
	
Restart:
	di
	xra a
	out 10h
	cma
	sta MUL16hibyte+1
	call	Cls
	lxi	h,000FFh-7
	shld	cursor
	mvi a,'P'
	call PrintChar
	mvi a,'I'
	call PrintChar
	mvi a,'='
	call PrintChar


	lxi d,0
	lxi b,10000
	xra a
	mov l,a
GenMulTab:
	mvi h,MUL10kTAB>>8
	mov m,e
	inr h
	mov m,d
	inr h
	mov m,a
	xchg
	dad b
	xchg
	aci 0
	inr l
	jnz GenMulTab

	ei
	hlt
	lxi h,0
	shld IntCount
	shld IntCountHi

; for (i = 0; i < LEN; ++i) r[i] = 2000;
	lxi h,BUF+(LEN*2)-1
	lxi d,2000
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = LEN; k > 0; k -= 14) {
L2:	PUSH H
	xchg		; i = k;
	LXI H,0     ; d = 0;
	SHLD Set_D+1
L3_:
	SHLD Set_D2+1
	dcx d
	push d      ; while(1) {
	xchg
	dad h
	push h
	mvi a,BUF>>8
	add h
	mov h,a
	SHLD Set_RI+1
	mov e,m
	inr l
	mov l,m     ; r[i]
	
;BCDE=LE*10000
	mvi h,2+(MUL10kTAB>>8)
	mov b,m
	dcr h
	mov c,m
	dcr h
	mov a,m
	mov l,e
	mov e,m
	inr h
	add m
	mov d,a
	inr h
	mov a,m
	adc c
	mov c,a
	jnc AfterMUL10k
	inr b
AfterMUL10k:

	
; d += (uint32_t)(r[i]) * 10000UL;
Set_D:	
	lxi h,0
	dad d
	xchg
Set_D2:
	lxi h,0
	JNC $+4
	inx h
	dad b
	pop b	; b = 2 * i - 2

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	push d
	mov a,e
	sta SetE+1
	mov a,c
	cma
	mov e,a
	add l
	mov a,b
	cma
	mov d,a
	adc h
	inx b
	jnc DIV32_
	xchg
	lxi h,mulmore
	shld mulmore-2	
	lxi h,0
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
	XCHG
	SHLD Set_D2+1
	pop h
	XCHG
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
	mov b,h
	mov c,l
	lhld Set_RI+1
	mov m,c
	inr l
	mov m,b
	jmp AfterDIV
DIV32_:
	xra a
	ora b
	jnz FastDiv
	ora c
	jm SlowDiv
	pop psw
	mov b,c\ mov c,h
	mov h,l\ mov l,a
	mov d,e\ mov e,c

	dad h\ dad d\ jnc A1_
	adc a\ dad h\ dad d\ jnc A2_
S2_:	adc a\ dad h\ dad d\ jnc A3_
S3_:	adc a\ dad h\ dad d\ jnc A4_
S4_:	adc a\ dad h\ dad d\ jnc A5_
S5_:	adc a\ dad h\ dad d\ jnc A6_
S6_:	adc a\ dad h\ dad d\ jnc A7_
S7_:	adc a\ dad h\ dad d\ jnc A8_
S8_:	adc a\ dad d\ jnc A9_
S9_: inr a
	jmp DIV_2

A1_: adc a\ dad h\ dad b\ jc S2_
A2_: adc a\ dad h\ dad b\ jc S3_
A3_: adc a\ dad h\ dad b\ jc S4_
A4_: adc a\ dad h\ dad b\ jc S5_
A5_: adc a\ dad h\ dad b\ jc S6_
A6_: adc a\ dad h\ dad b\ jc S7_
A7_: adc a\ dad h\ dad b\ jc S8_
A8_: adc a
A9_: dad b

DIV_2:
	sta SetD+1
	lda SetE+1
	mov l,a
	dad h\ dad d\ jnc A10_
	adc a\ dad h\ dad d\ jnc A11_
S11_: adc a\ dad h\ dad d\ jnc A12_
S12_: adc a\ dad h\ dad d\ jnc A13_
S13_: adc a\ dad h\ dad d\ jnc A14_
S14_: adc a\ dad h\ dad d\ jnc A15_
S15_: adc a\ dad h\ dad d\ jnc A16_
S16_: adc a\ dad h\ dad d\ jnc A17_
S17_: adc a\
	dad d\ jnc A18_
S18_: inr a
	mov l,h\ mov h,c
	jmp SetD

A10_: adc a\ dad h\ dad b\ jc S11_
A11_: adc a\ dad h\ dad b\ jc S12_
A12_: adc a\ dad h\ dad b\ jc S13_
A13_: adc a\ dad h\ dad b\ jc S14_
A14_: adc a\ dad h\ dad b\ jc S15_
A15_: adc a\ dad h\ dad b\ jc S16_
A16_: adc a\ dad h\ dad b\ jc S17_
A17_: adc a
A18_: dad b
	mov l,h\ mov h,c
	jmp SetD

SlowDiv:
	pop psw
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA0
	adc a\ jc DIVS0_1\ dad h\ dad d\ jnc DIVA1
DIVS1:	adc a\ jc DIVS1_1
DIVS1_0: dad h\ dad d\ jnc DIVA2
DIVS2:	adc a\ jc DIVS2_1
DIVS2_0: dad h\ dad d\ jnc DIVA3
DIVS3:	adc a\ jc DIVS3_1
DIVS3_0: dad h\ dad d\ jnc DIVA4
DIVS4:	adc a\ jc DIVS4_1
DIVS4_0: dad h\ dad d\ jnc DIVA5
DIVS5:	adc a\ jc DIVS5_1
DIVS5_0: dad h\ dad d\ jnc DIVA6
DIVS6:	adc a\ jc DIVS6_1
DIVS6_0: dad h\ dad d\ jnc DIVA7
DIVS7:	adc a\ jmp DIV7_2

DIVS0_1: dad h\ inr l\ dad d\ jnc DIVA1\ adc a\ jnc DIVS1_0
DIVS1_1: dad h\ inr l\ dad d\ jnc DIVA2\ adc a\ jnc DIVS2_0
DIVS2_1: dad h\ inr l\ dad d\ jnc DIVA3\ adc a\ jnc DIVS3_0
DIVS3_1: dad h\ inr l\ dad d\ jnc DIVA4\ adc a\ jnc DIVS4_0
DIVS4_1: dad h\ inr l\ dad d\ jnc DIVA5\ adc a\ jnc DIVS5_0
DIVS5_1: dad h\ inr l\ dad d\ jnc DIVA6\ adc a\ jnc DIVS6_0
DIVS6_1: dad h\ inr l\ dad d\ jnc DIVA7\ adc a\ jmp DIV7_2

DIVA0: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS1
DIVA1: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS2
DIVA2: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS3
DIVA3: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS4
DIVA4: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS5
DIVA5: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS6
DIVA6: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS7
DIVA7: adc a\ dad b
DIV7_2:
	sta SetD+1
	lda SetE+1
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA8
	adc a\ jc DIVS8_1\ dad h\ dad d\ jnc DIVA9
DIVS9:	adc a\ jc DIVS9_1
DIVS9_0: dad h\ dad d\ jnc DIVA10
DIVS10:	adc a\ jc DIVS10_1
DIVS10_0: dad h\ dad d\ jnc DIVA11
DIVS11:	adc a\ jc DIVS11_1
DIVS11_0: dad h\ dad d\ jnc DIVA12
DIVS12:	adc a\ jc DIVS12_1
DIVS12_0: dad h\ dad d\ jnc DIVA13
DIVS13:	adc a\ jc DIVS13_1
DIVS13_0: dad h\ dad d\ jnc DIVA14
DIVS14:	adc a\ jc DIVS14_1
DIVS14_0: dad h\ dad d\ jnc DIVA15
DIVS15:	adc a\ jmp SetD

DIVS8_1: dad h\ inr l\ dad d\ jnc DIVA9\ adc a\ jnc DIVS9_0
DIVS9_1: dad h\ inr l\ dad d\ jnc DIVA10\ adc a\ jnc DIVS10_0
DIVS10_1: dad h\ inr l\ dad d\ jnc DIVA11\ adc a\ jnc DIVS11_0
DIVS11_1: dad h\ inr l\ dad d\ jnc DIVA12\ adc a\ jnc DIVS12_0
DIVS12_1: dad h\ inr l\ dad d\ jnc DIVA13\ adc a\ jnc DIVS13_0
DIVS13_1: dad h\ inr l\ dad d\ jnc DIVA14\ adc a\ jnc DIVS14_0
DIVS14_1: dad h\ inr l\ dad d\ jnc DIVA15\ adc a\ jmp SetD	

DIVA8: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS9
DIVA9: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS10
DIVA10: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS11
DIVA11: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS12
DIVA12: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS13
DIVA13: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS14
DIVA14: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS15
DIVA15: adc a\ dad b\ jmp SetD

FastDiv:
	pop psw
	sta S8+3
	sta A8+3
	dad h\ dad d\ jnc A1
	adc a\ dad h\ dad d\ jnc A2
S2:	adc a\ dad h\ dad d\ jnc A3
S3:	adc a\ dad h\ dad d\ jnc A4
S4:	adc a\ dad h\ dad d\ jnc A5
S5:	adc a\ dad h\ dad d\ jnc A6
S6:	adc a\ dad h\ dad d\ jnc A7
S7:	adc a\ dad h\ dad d\ jnc A8
S8:	adc a
	push d\ lxi d,0\ dad d\ pop d
	dad d\ jnc A9
S9: inr a
	jmp DIV_

A1: adc a\ dad h\ dad b\ jc S2
A2: adc a\ dad h\ dad b\ jc S3
A3: adc a\ dad h\ dad b\ jc S4
A4: adc a\ dad h\ dad b\ jc S5
A5: adc a\ dad h\ dad b\ jc S6
A6: adc a\ dad h\ dad b\ jc S7
A7: adc a\ dad h\ dad b\ jc S8
A8: adc a
	push d\ lxi d,0\ dad d\ pop d
	jc S9
A9: dad b

DIV_:
	sta SetD+1
SetE:
	mvi a,0
	sta S17+3
	sta A17+3
	dad h\ dad d\ jnc A10
	adc a\ dad h\ dad d\ jnc A11
S11:	adc a\ dad h\ dad d\ jnc A12
S12:	adc a\ dad h\ dad d\ jnc A13
S13:	adc a\ dad h\ dad d\ jnc A14
S14:	adc a\ dad h\ dad d\ jnc A15
S15:	adc a\ dad h\ dad d\ jnc A16
S16:	adc a\ dad h\ dad d\ jnc A17
S17:	adc a\
	push d\ lxi d,0\ dad d\ pop d
	dad d\ jnc A18
S18: inr a
	jmp SetD

A10: adc a\ dad h\ dad b\ jc S11
A11: adc a\ dad h\ dad b\ jc S12
A12: adc a\ dad h\ dad b\ jc S13
A13: adc a\ dad h\ dad b\ jc S14
A14: adc a\ dad h\ dad b\ jc S15
A15: adc a\ dad h\ dad b\ jc S16
A16: adc a\ dad h\ dad b\ jc S17
A17: adc a
	push d\ lxi d,0\ dad d\ pop d
	jc S18
A18: dad b
SetD:
	mvi d,0
	mov e,a
Set_RI:	
	shld 0
AfterDIV:

; r[i] = res.rem; d = res.quot;
	POP B
	xra a
	ora c
	jnz NoL4
	ora b
	JZ L4	; if (--i == 0) break;
	mov a,c
NoL4:
; d *= (uint32_t)(i);

; HL:(Set_D+1) = BC*DE
	push b
	mov h,d\ mov l,e
	mvi c,0
	add a\ jc MUL1
	add a\ jc MUL2+2
	add a\ jc MUL3+2
	add a\ jc MUL4+2
	add a\ jc MUL5+2
	add a\ jc MUL6+2
	add a\ jc MUL7+2
	add a\ jc MUL8+2
	lxi h,0
	jmp MUL8_

MUL1: dad h\ adc a\ jnc MUL2+2
MUL2: dad d\ adc c\ dad h\ adc a\ jnc MUL3+2
MUL3: dad d\ adc c\ dad h\ adc a\ jnc MUL4+2
MUL4: dad d\ adc c\ dad h\ adc a\ jnc MUL5+2
MUL5: dad d\ adc c\ dad h\ adc a\ jnc MUL6+2
MUL6: dad d\ adc c\ dad h\ adc a\ jnc MUL7+2
MUL7: dad d\ adc c\ dad h\ adc a\ jnc MUL8+2
MUL8: dad d\ adc c

MUL8_:
	mov c,a
MUL16hibyte:
	mvi a,0FFh
	cmp b
MUL16hibyteJmp:
	jz 0
	mov a,b
	sta MUL16hibyte+1
	adi MULprocs>>8
	sta MUL16hibyteJmp+2
	xra a
	jmp MUL16hibyteJmp
MUL16_00:
	SHLD Set_D+1
	mov l,a
	mov h,b
	pop d
	jmp L3_

MUL16_16_:
	dad b
	aci 0
MUL16_16:
	xchg
	pop h
	mov h,e
	SHLD Set_D+1
	mov l,d
	mov h,a
MUL16_:
	pop d
	jmp mulmore
mulmore:
	LDA Set_D2+1
	ora a
	jz breakmulmore
	dad d
	dcr a
	jnz $-2
breakmulmore:
	push h
	lxi h,L3_
	shld mulmore-2
	pop h
	jmp L3_		; }

L4:
	LHLD Set_D2+1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	xra a
Check:
	ora h
	jnz L2
	lda Check
	cpi 0B5h
	jz MakeAsItWas
	mvi a,0B5h
	sta Check
	call Mov9
	jmp L2
MakeAsItWas:
	mvi a,0B4h
	sta Check
	call Mov9
	
	di
	mvi a,' '
	call PrintChar
	mvi a,'T'
	call PrintChar
	mvi a,'='
	call PrintChar
	lhld IntCount
	xchg
	lhld IntCountHi

	lxi b,50
	call DIV320
	push h
	xchg
	call PR0000
	mvi a,'.'
	call PrintChar
	pop h
	dad h
	call PR00
	JMP $

Mov9:	
	push h
	lxi h,MUL8_
	lxi d,MUL16_00
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d
	pop h
	ret

DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
	push d
	mov a,e
	sta SetE2+1
	xra a
	sub c
	mov e,a
	sbb b
	sub e
	mov d,a

	pop psw
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA0_
	adc a\ jc DIVS0_1_\ dad h\ dad d\ jnc DIVA1_
DIVS1_:	adc a\ jc DIVS1_1_
DIVS1_0_: dad h\ dad d\ jnc DIVA2_
DIVS2_:	adc a\ jc DIVS2_1_
DIVS2_0_: dad h\ dad d\ jnc DIVA3_
DIVS3_:	adc a\ jc DIVS3_1_
DIVS3_0_: dad h\ dad d\ jnc DIVA4_
DIVS4_:	adc a\ jc DIVS4_1_
DIVS4_0_: dad h\ dad d\ jnc DIVA5_
DIVS5_:	adc a\ jc DIVS5_1_
DIVS5_0_: dad h\ dad d\ jnc DIVA6_
DIVS6_:	adc a\ jc DIVS6_1_
DIVS6_0_: dad h\ dad d\ jnc DIVA7_
DIVS7_:	adc a\ jmp DIV7_2_

DIVS0_1_: dad h\ inr l\ dad d\ jnc DIVA1_\ adc a\ jnc DIVS1_0_
DIVS1_1_: dad h\ inr l\ dad d\ jnc DIVA2_\ adc a\ jnc DIVS2_0_
DIVS2_1_: dad h\ inr l\ dad d\ jnc DIVA3_\ adc a\ jnc DIVS3_0_
DIVS3_1_: dad h\ inr l\ dad d\ jnc DIVA4_\ adc a\ jnc DIVS4_0_
DIVS4_1_: dad h\ inr l\ dad d\ jnc DIVA5_\ adc a\ jnc DIVS5_0_
DIVS5_1_: dad h\ inr l\ dad d\ jnc DIVA6_\ adc a\ jnc DIVS6_0_
DIVS6_1_: dad h\ inr l\ dad d\ jnc DIVA7_\ adc a\ jmp DIV7_2_

DIVA0_:	dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS1_
DIVA1_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS2_
DIVA2_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS3_
DIVA3_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS4_
DIVA4_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS5_
DIVA5_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS6_
DIVA6_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS7_
DIVA7_: adc a\ dad b
DIV7_2_:
	sta	SetD2+1

DivLo:	
SetE2:
	mvi a,0
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA8_
	adc a\ jc DIVS8_1_\ dad h\ dad d\ jnc DIVA9_
DIVS9_:	adc a\ jc DIVS9_1_
DIVS9_0_: dad h\ dad d\ jnc DIVA10_
DIVS10_:	adc a\ jc DIVS10_1_
DIVS10_0_: dad h\ dad d\ jnc DIVA11_
DIVS11_:	adc a\ jc DIVS11_1_
DIVS11_0_: dad h\ dad d\ jnc DIVA12_
DIVS12_:	adc a\ jc DIVS12_1_
DIVS12_0_: dad h\ dad d\ jnc DIVA13_
DIVS13_:	adc a\ jc DIVS13_1_
DIVS13_0_: dad h\ dad d\ jnc DIVA14_
DIVS14_:	adc a\ jc DIVS14_1_
DIVS14_0_: dad h\ dad d\ jnc DIVA15_
DIVS15_:	adc a\ jmp SetD2

DIVS8_1_: dad h\ inr l\ dad d\ jnc DIVA9_\ adc a\ jnc DIVS9_0_
DIVS9_1_: dad h\ inr l\ dad d\ jnc DIVA10_\ adc a\ jnc DIVS10_0_
DIVS10_1_: dad h\ inr l\ dad d\ jnc DIVA11_\ adc a\ jnc DIVS11_0_
DIVS11_1_: dad h\ inr l\ dad d\ jnc DIVA12_\ adc a\ jnc DIVS12_0_
DIVS12_1_: dad h\ inr l\ dad d\ jnc DIVA13_\ adc a\ jnc DIVS13_0_
DIVS13_1_: dad h\ inr l\ dad d\ jnc DIVA14_\ adc a\ jnc DIVS14_0_
DIVS14_1_: dad h\ inr l\ dad d\ jnc DIVA15_\ adc a\ jmp SetD2

DIVA8_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS9_
DIVA9_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS10_
DIVA10_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS11_
DIVA11_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS12_
DIVA12_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS13_
DIVA13_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS14_
DIVA14_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS15_
DIVA15_: adc a\ dad b
SetD2:
	mvi d,0
	mov e,a
	ret


PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:	ADI 30h
PRC:
	JMP PrintChar
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
	ADI 30h
PrintChar:
		push psw
		push b
		push d
		push h
		mov c,a
        ;  +   
        ;    c
term_putchar:
        lxi h, term_xy
        mov e, m
        inx h
        mov d, m
        call putcharv
        
term_advance:
        lxi h, term_xy + 1
        mov a, m
        inr m
        cpi 84
		jnz PutCharExit
        mvi m, 0
        ; advance line
        dcx h
        mvi a, -7
        add m
        mov m, a
PutCharExit:
		pop h
		pop d
		pop b
		pop psw
        ret

MaskTable:
		.db 10000000b
		.db 01000000b
		.db 00100000b
		.db 00010000b
		.db 00001000b
		.db 00000100b
		.db 00000010b
		.db 00000001b

;#DEFINE ZeroColumn


        ;       
        ; de =   
        ; c =  
putcharv:
        ;   :  * 6
        mvi b, 0
		mov h,b
		mov l,c
        dad h
        dad b
        dad h   
        lxi b, font
        dad b   ; hl = &fontsrc[c * 6]
        
        ;   : d * 3 / 8
        mov a, d
        add d
        add d
        mov c, a ;  d * 3
		rar\ rar\ rar\ ori 0C0h
        mov d, a ; d = column * 3 / 8
        
        ;     = $80 >> (d * 3 % 8)
        mvi a, 7
        ana c
		adi MaskTable&255
        mov c, a
		aci MaskTable>>8
		sub c
		mov b,a
		ldax b

        call kapec
        call kapec
kapec:
		mov c,a
		cma
		mov b,a
		mov a,m
		inx h
		push h
#IFDEF ZeroColumn
		ora a
		jnz NotZero1
		mov h,m
;		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d\ inr e
		ldax d\ ana b\ stax d
		jmp NotZero1_
#ENDIF

NotZero1:
		mov l,m
		mov h,a
;		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		dad h
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ inr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d

        ;  
        ;  1:  ,     
NotZero1_:
		mov l,d
        mvi a, -$20 \ add d \ mov d, a
		
#IFDEF ZeroColumn
ChkZero2:
		xra a
		ora h
		jnz NotZero2
;		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d\ dcr e
		ldax d\ ana b\ stax d
        mov d,l
		pop h
		inx h
        mov a,c \ rrc
        rnc
        ;   
        inr d
        ret
#ENDIF

NotZero2:
        ; 1:   8
;		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d\ dcr e
		ldax d\ ana b\ dad h\ jnc $+4\ ora c\ stax d
		dad h

        ;  2:    $a0,   
        mov d,h
		pop h
		inx h
        mov a,c \ rrc
        rnc
        ;   
        inr d
        ret

cursor
term_xy      .db 256-8, 0


printstr_char:  .db 020h ; =ord('!') - 1
printstr_xy:    .db 0, -1


_C:	DW 0

		
Cls:
		lxi	h,0A000h
		mvi e,0
		mvi a,0E0h
ClrScr:
		mov	m,e
		inx	h
		cmp	h
		jnz	ClrScr
		ret
Int:
		push psw
		push h
		lxi h,IntCount
		inr m
		jnz IntExit
		inx h
		inr m
		jnz IntExit
		inx h
		inr m
IntExit:
		pop h
		pop psw
		ei
		ret

MakeOneNoC:
	mvi m,19h\ inx h	;dad d
	mvi m,0CEh\ inx h	;
	mvi m,00h\ inx h	;aci 0
	ret

IntCount:	
		.dw 0
IntCountHi:
		.dw 0

colors:
		.db 000,000,173,173
		.db 173,000,000,000
		.db 000,000,000,000
		.db 173,173,173,000

dword .db 0,0,0,0
	
fontsrc:

        .db  $00,$00,$00,$00,$00,$00,$00,$3e,$55,$51,$55,$3e,$00,$3e,$6b,$6f,$6b,$3e,$00,$1c,$3e,$7c,$3e,$1c,$00,$18,$3c,$7e,$3c,$18,$00,$30
        .db  $36,$7f,$36,$30,$00,$18,$5c,$7e,$5c,$18,$00,$00,$18,$18,$00,$00,$ff,$ff,$e7,$e7,$ff,$ff,$00,$3c,$24,$24,$3c,$00,$ff,$c3,$db,$db
        .db  $c3,$ff,$00,$30,$48,$4a,$36,$0e,$00,$06,$29,$79,$29,$06,$00,$60,$70,$3f,$02,$04,$00,$60,$7e,$0a,$35,$3f,$00,$2a,$1c,$36,$1c,$2a
        .db  $00,$00,$7f,$3e,$1c,$08,$00,$08,$1c,$3e,$7f,$00,$00,$14,$36,$7f,$36,$14,$00,$00,$5f,$00,$5f,$00,$00,$06,$09,$7f,$01,$7f,$00,$22
        .db  $4d,$55,$59,$22,$00,$60,$60,$60,$60,$00,$00,$14,$b6,$ff,$b6,$14,$00,$04,$06,$7f,$06,$04,$00,$10,$30,$7f,$30,$10,$00,$08,$08,$3e
        .db  $1c,$08,$00,$08,$1c,$3e,$08,$08,$00,$78,$40,$40,$40,$40,$00,$08,$3e,$08,$3e,$08,$00,$30,$3c,$3f,$3c,$30,$00,$03,$0f,$3f,$0f,$03
        .db  $00,$00,$00,$00,$00,$00,$00,$00,$00,$5f,$00,$00,$00,$00,$03,$00,$03,$00,$00,$14,$7f,$14,$7f,$14,$00,$24,$2a,$7f,$2a,$12,$00,$63
        .db  $13,$08,$64,$63,$00,$36,$49,$56,$20,$50,$00,$00,$0b,$07,$00,$00,$00,$00,$1c,$22,$41,$00,$00,$00,$41,$22,$1c,$00,$00,$14,$08,$3e
        .db  $08,$14,$00,$08,$08,$3e,$08,$08,$00,$00,$b0,$70,$00,$00,$00,$08,$08,$08,$08,$08,$00,$00,$60,$60,$00,$00,$00,$60,$10,$08,$04,$03
        .db  $00,$3e,$51,$49,$45,$3e,$00,$00,$42,$7f,$40,$00,$00,$62,$51,$49,$49,$46,$00,$21,$41,$45,$4b,$31,$00,$18,$14,$12,$7f,$10,$00,$27
        .db  $45,$45,$45,$39,$00,$3c,$4a,$49,$49,$30,$00,$01,$71,$09,$05,$03,$00,$36,$49,$49,$49,$36,$00,$06,$49,$49,$29,$1e,$00,$00,$6c,$6c
        .db  $00,$00,$00,$00,$ac,$6c,$00,$00,$00,$08,$14,$22,$41,$00,$00,$14,$14,$14,$14,$14,$00,$00,$41,$22,$14,$08,$00,$02,$01,$51,$09,$06
        .db  $00,$3e,$41,$5d,$55,$1e,$00,$7e,$11,$11,$11,$7e,$00,$7f,$49,$49,$49,$36,$00,$3e,$41,$41,$41,$22,$00,$7f,$41,$41,$22,$1c,$00,$7f
        .db  $49,$49,$49,$41,$00,$7f,$09,$09,$09,$01,$00,$3e,$41,$49,$49,$7a,$00,$7f,$08,$08,$08,$7f,$00,$00,$41,$7f,$41,$00,$00,$30,$40,$40
        .db  $40,$3f,$00,$7f,$08,$14,$22,$41,$00,$7f,$40,$40,$40,$40,$00,$7f,$02,$04,$02,$7f,$00,$7f,$02,$04,$08,$7f,$00,$3e,$41,$41,$41,$3e
        .db  $00,$7f,$09,$09,$09,$06,$00,$3e,$41,$51,$21,$5e,$00,$7f,$09,$09,$19,$66,$00,$26,$49,$49,$49,$32,$00,$01,$01,$7f,$01,$01,$00,$3f
        .db  $40,$40,$40,$3f,$00,$1f,$20,$40,$20,$1f,$00,$3f,$40,$3c,$40,$3f,$00,$63,$14,$08,$14,$63,$00,$07,$08,$70,$08,$07,$00,$61,$51,$49
        .db  $45,$43,$00,$00,$7f,$41,$41,$00,$00,$03,$04,$08,$10,$60,$00,$00,$41,$41,$7f,$00,$00,$04,$02,$01,$02,$04,$80,$80,$80,$80,$80,$80
        .db  $00,$00,$01,$02,$04,$00,$00,$20,$54,$54,$54,$78,$00,$7f,$44,$44,$44,$38,$00,$38,$44,$44,$44,$28,$00,$38,$44,$44,$44,$7f,$00,$38
        .db  $54,$54,$54,$18,$00,$08,$7e,$09,$01,$02,$00,$18,$a4,$a4,$a4,$7c,$00,$7f,$08,$04,$04,$78,$00,$00,$44,$7d,$40,$00,$00,$20,$40,$44
        .db  $3d,$00,$00,$7f,$10,$28,$44,$00,$00,$00,$00,$3f,$40,$00,$00,$7c,$04,$78,$04,$78,$00,$7c,$08,$04,$04,$78,$00,$38,$44,$44,$44,$38
        .db  $00,$7c,$14,$14,$14,$08,$00,$08,$14,$14,$18,$7c,$00,$7c,$08,$04,$04,$08,$00,$48,$54,$54,$54,$20,$00,$04,$3f,$44,$40,$20,$00,$3c
        .db  $40,$40,$20,$7c,$00,$1c,$20,$40,$20,$1c,$00,$3c,$60,$3c,$60,$3c,$00,$44,$28,$10,$28,$44,$00,$8c,$50,$20,$10,$0c,$00,$44,$64,$54
        .db  $4c,$44,$00,$08,$3e,$41,$41,$00,$00,$00,$00,$7f,$00,$00,$00,$00,$41,$41,$3e,$08,$00,$02,$01,$02,$01,$00,$00,$3c,$26,$23,$26,$3c
        .db  $44,$11,$44,$11,$44,$11,$aa,$55,$aa,$55,$aa,$55,$bb,$ee,$bb,$ee,$bb,$ee,$00,$00,$00,$ff,$00,$00,$08,$08,$08,$ff,$00,$00,$0a,$0a
        .db  $0a,$ff,$00,$00,$08,$ff,$00,$ff,$00,$00,$08,$f8,$08,$f8,$00,$00,$0a,$0a,$0a,$fe,$00,$00,$0a,$fb,$00,$ff,$00,$00,$00,$ff,$00,$ff
        .db  $00,$00,$0a,$fa,$02,$fe,$00,$00,$0a,$0b,$08,$0f,$00,$00,$08,$0f,$08,$0f,$00,$00,$0a,$0a,$0a,$0f,$00,$00,$08,$08,$08,$f8,$00,$00
        .db  $00,$00,$00,$0f,$08,$08,$08,$08,$08,$0f,$08,$08,$08,$08,$08,$f8,$08,$08,$00,$00,$00,$ff,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
        .db  $08,$ff,$08,$08,$00,$00,$00,$ff,$0a,$0a,$00,$ff,$00,$ff,$08,$08,$00,$0f,$08,$0b,$0a,$0a,$00,$fe,$02,$fa,$0a,$0a,$0a,$0b,$08,$0b
        .db  $0a,$0a,$0a,$fa,$02,$fa,$0a,$0a,$00,$ff,$00,$fb,$0a,$0a,$0a,$0a,$0a,$0a,$0a,$0a,$0a,$fb,$00,$fb,$0a,$0a,$0a,$0a,$0a,$0b,$0a,$0a
        .db  $08,$0f,$08,$0f,$08,$08,$0a,$0a,$0a,$fa,$0a,$0a,$08,$f8,$08,$f8,$08,$08,$00,$0f,$08,$0f,$08,$08,$00,$00,$00,$0f,$0a,$0a,$00,$00
        .db  $00,$fe,$0a,$0a,$00,$f8,$08,$f8,$08,$08,$08,$ff,$00,$ff,$08,$08,$00,$7c,$55,$54,$55,$44,$08,$08,$08,$0f,$00,$00,$00,$00,$00,$f8
        .db  $08,$08,$ff,$ff,$ff,$ff,$ff,$ff,$f0,$f0,$f0,$f0,$f0,$f0,$ff,$ff,$ff,$00,$00,$00,$00,$00,$00,$ff,$ff,$ff,$0f,$0f,$0f,$0f,$0f,$0f
        .db  $00,$00,$04,$0a,$04,$00,$00,$00,$24,$2e,$24,$00,$00,$00,$00,$7e,$00,$00,$00,$00,$00,$7a,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
        .db  $00,$00,$00,$00,$00,$06,$0f,$7f,$01,$7f,$00,$00,$00,$08,$00,$00,$00,$38,$55,$54,$55,$18,$00,$00,$24,$2a,$24,$00,$00,$00,$00,$00
        .db  $00,$00,$00,$28,$10,$00,$28,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$78,$02,$00
        .db  $00,$7e,$11,$11,$11,$7e,$00,$7f,$45,$45,$45,$39,$00,$7f,$49,$49,$49,$36,$00,$7f,$01,$01,$01,$03,$00,$c0,$7e,$41,$7f,$c0,$00,$7f
        .db  $49,$49,$49,$41,$00,$77,$08,$7f,$08,$77,$00,$22,$41,$49,$49,$36,$00,$7f,$10,$08,$04,$7f,$00,$7f,$20,$13,$08,$7f,$00,$7f,$08,$14
        .db  $22,$41,$00,$40,$3e,$01,$01,$7f,$00,$7f,$02,$04,$02,$7f,$00,$7f,$08,$08,$08,$7f,$00,$3e,$41,$41,$41,$3e,$00,$7f,$01,$01,$01,$7f
        .db  $00,$7f,$09,$09,$09,$06,$00,$3e,$41,$41,$41,$22,$00,$01,$01,$7f,$01,$01,$00,$27,$48,$48,$48,$3f,$00,$1c,$22,$7f,$22,$1c,$00,$63
        .db  $14,$08,$14,$63,$00,$7f,$40,$40,$7f,$c0,$00,$07,$08,$08,$08,$7f,$00,$7f,$40,$7f,$40,$7f,$00,$7f,$40,$7f,$40,$ff,$00,$01,$7f,$48
        .db  $48,$30,$00,$7f,$48,$30,$00,$7f,$00,$7f,$48,$48,$48,$30,$00,$22,$49,$49,$49,$3e,$00,$7f,$08,$3e,$41,$3e,$00,$46,$29,$19,$09,$7f
        .db  $00,$20,$54,$54,$54,$78,$00,$3c,$4a,$4a,$49,$30,$00,$7c,$54,$54,$54,$28,$00,$7c,$04,$04,$04,$0c,$00,$c0,$78,$44,$7c,$c0,$00,$38
        .db  $54,$54,$54,$18,$00,$6c,$10,$7c,$10,$6c,$00,$28,$44,$54,$54,$28,$00,$7c,$20,$10,$08,$7c,$00,$7c,$21,$12,$09,$7c,$00,$7c,$10,$28
        .db  $44,$00,$00,$40,$38,$04,$04,$7c,$00,$7c,$08,$10,$08,$7c,$00,$7c,$10,$10,$10,$7c,$00,$38,$44,$44,$44,$38,$00,$7c,$04,$04,$04,$7c
        .db  $00,$7c,$14,$14,$14,$08,$00,$38,$44,$44,$44,$28,$00,$04,$04,$7c,$04,$04,$00,$0c,$50,$50,$50,$3c,$00,$10,$28,$7c,$28,$10,$00,$44
        .db  $28,$10,$28,$44,$00,$7c,$40,$40,$7c,$c0,$00,$0c,$10,$10,$10,$7c,$00,$7c,$40,$7c,$40,$7c,$00,$7c,$40,$7c,$40,$fc,$00,$04,$7c,$50
        .db  $50,$20,$00,$7c,$50,$20,$00,$7c,$00,$7c,$50,$50,$50,$20,$00,$44,$54,$54,$54,$38,$00,$7c,$10,$38,$44,$38,$00,$08,$54,$34,$14,$7c

	END
