        title   "pdp11con"
; base on:
; QBUS Reset and 60 Hz clock emulation
; Brad Parker <brad@heeltoe.com> 8/2012
; Based on the original circuit by John Wilson, D Bit <wilson@dbit.com>.
;
; pic16f876 50\60 Hz mod va@kaluga.org 

;16 to 8-pin backplane conn DVK3 mod (16pin conn: pin1->pin15, pin13=gnd, pin12=5v)
;1 (9)  B:A2    BPWOK
;2 (10) NC
;3 (11) A:A7    SRUN   
;4 (12) +5v
;5 (13) GND
;6 (14) B:A14   /BEVNT
;7 (15) B:A1    BDCOK
;8 (16) A:A13   /BHALT
;
; PIC16F876:
;
; pic pin 2  (ra0) -> BDCOK
; pic pin 3  (ra1) -> BPOK      toggle w/pb
; pic pin 4  (ra2) -> BHALT     toggle w/pb
; pic pin 5  (ra3) -> 
; pic pin 6  (ra4) -> BEVNT
;
; pic pin 12 (rc1) -> led orange smd  POWER_ON
; pic pin 13 (rc2) -> led red smd     BPOK
; pic pin 14 (rc3) -> led red smd     BDCOK
; pic pin 15 (rc4) -> led red th      RUN
; pic pin 16 (rc5) -> led green th    TIMER
;
; pic pin 22  (rb1) <- jumper to gnd 60/50 Hz
; pic pin 23  (rb2) <- button to gnd HALT
; pic pin 24  (rb3) <- SRUN qbus signal
; pic pin 25  (rb4) <- button to gnd POWER
; pic pin 26  (rb5) <- button to gnd TIMER
; pic pin 27  (rb7) PGC
; pic pin 28  (rb7) PGD
;
; Crystal:
; quartx 3579545 Hz
; clk/4 = 894886,25 Hz
; 894886,25 / 8949=99.998 Hz   0x10000-0x22F5=0xDD0B
; 894886,25 / 7457=120.006 Hz  0x10000-0x1D21=0xE2DF 
; 
        list    p=16F876, r=dec
        include "P16F876.INC"

  __CONFIG _BODEN_ON&_CP_OFF&_WRT_ENABLE_ON&_PWRTE_ON&_WDT_OFF&_HS_OSC&_DEBUG_OFF&_CPD_OFF&_LVP_OFF
;  __IDLOCS (dVersion<<8)|dRelease  ; version: vvrr , vv- version, rr - release
;Crystal freq 3579545 Hz
;---------------------------------------------------------------------
        cblock  h'20'           ; variables (start at 0x20 in ram)
        status_temp
        w_temp
		dlcnth
		dlcntl
		tmp_a
        endc
;---------------------------------------------------------------------
        org     0x000			; reset vector
        goto    start
        org     0x004			; interrupt vector
;  Interrupt service routine
        movwf   w_temp          ; save state
		swapf	STATUS,w
        movwf   status_temp

        bcf     PIR1,TMR1IF		; reset TIMER 1 OVERFLOW FLAG

; pic pin 22  (rb1) <- jumper to gnd 60/50 Hz
        btfsc   PORTB,1         ; check 60/50 Hz jumper
		goto	isr1			; go 60 Hz

        movfw   TMR1L			; adjust count for current timer for 100 Hz
        addlw   0x0B
        movwf   TMR1L
        movfw   TMR1H
		btfsc	STATUS,C
		incfsz	TMR1H,w
        addlw   0xDD
        movwf   TMR1H
		goto	isr2
isr1:
        movfw   TMR1L			; adjust count for current timer for 120 Hz
        addlw   0xDF
        movwf   TMR1L
        movfw   TMR1H
		btfsc	STATUS,C
		incfsz	TMR1H,w
        addlw   0xE2
        movwf   TMR1H

isr2;
; pic pin 24  (rb3) <- SRUN qbus signal
        btfss   PORTB,3         ; check SRUN
        bsf     PORTC,4         ; red led RUN off
        btfsc   PORTB,3         ; check SRUN
        bcf     PORTC,4         ; red led RUN on

        movlw   0x01
        xorwf   PORTC,f         ; toggle bit 0

		movlw   0x10
		btfss	PORTC,5			; if TIMER led on
		xorwf   tmp_a,f         ; toggle bit 4
		btfsc	PORTC,5			; if TIMER led off
		bsf		tmp_a,4         ; set high if EVNT off
isr_e
		movf	tmp_a,w	
		movwf	PORTA

		swapf	status_temp,w
        movwf   STATUS
        swapf   w_temp,f
        swapf   w_temp,w
        retfie
;;
;; Initialization
;; 
start:
        bcf		STATUS,RP0      ; select low register space
		bcf		T1CON,TMR1ON	; TIMER1 off
        movlw	0x14			; BEVNT=1, HALT=1, BPOK=0, BDCOK=0
        movwf	PORTA           ; set PORTA
        clrf	PORTB
        movlw	0xF1			; 1111 0001		movlw   0xC1	; all leds
        movwf	PORTC           ; led orange smd on
        
        bsf		STATUS,RP0      ; select high bank
        movlw	0x00
        movwf	TRISA           ; PORTA is all outputs
        movlw	0xFF
        movwf	TRISB           ; PORTB has input
        movlw	0x00
        movwf	TRISC           ; PORTC is all outputs
        bcf		OPTION_REG,7    ; enable weak pullups on port B
		bsf		INTCON,PEIE 	;ENABLE PERITHERIAL INTERUPTS
		bsf		PIE1,TMR1IE 	;ENABLE TIMER 1 INTERUPT
        bcf		STATUS,RP0      ; back to low bank
        
		movlw	B'00000001'		;TIMER 1 WILL COUNT ONCE EVERY 8 CYCLES, THE OSCILLATOR IS DIABLED
		movwf	T1CON			;USES THE INTERNAL CLOCK (FOSC/4)
		bcf		PIR1,TMR1IF		;CLEAR TIMER 1 OVERFLOW FLAG
        bsf		INTCON,GIE      ; enable interrupts

        movlw	0x14			; BEVNT=1, HALT=1, BPOK=0, BDCOK=0
        movwf	tmp_a           ; set PORTA

        call	delay
        call	delay
        call	delay
        bsf		tmp_a,1			; BPOK
        bsf		PORTC,2			; BPOK red smd led off
        call	delay
        bsf		tmp_a,0			; BDCOK
        bsf		PORTC,3			; BDCOK red smd led off
        call	delay

; Main loop. Vanage POK and HALT pulses, poll TIMER button and toggle TIMER led
loop:
        ;; DCOK pulse
; pic pin 25  (rb4) <- button to gnd POWER
        btfsc   PORTB,4			; test POW button
        goto    loop1
        bcf     tmp_a,0         ; BDCOK off
        bcf     PORTC,3         ; BDCOK red smd led on
        call    delay
        bsf     tmp_a,0         ; BDCOK
        bsf     PORTC,3         ; BDCOK red smd led off
      
loop1:
; pic pin 23  (rb2) <- button to gnd HALT
        btfsc   PORTB,2			; test HALT button
        goto    loop3
        bcf     tmp_a,2         ; keep HALT low
        call    delay_
        bsf     tmp_a,2         ; turn HALT back high
loop2:
        btfss   PORTB,2			; wait HALT button off
        goto    loop2
        call    delay_

loop3:
; pic pin 26  (rb5) <- button to gnd TIMER
        btfsc   PORTB,5         ; check TIMER button
		goto	loop			; no TIMER button? new loop
        movlw   0x20
        xorwf   PORTC,f         ; toggle bit 6 TIMER led
        call    delay_
loop4:
        btfss   PORTB,5			; wait TIMER button off
        goto    loop4
        call    delay_
        goto    loop            ; back to top
;---------------------------------------------------------------------
delay_:
        movlw   0x20
        movwf   dlcnth
		goto	dllooph
;---------------------------------------------------------------------
delay:
        movlw   0xFF
        movwf   dlcnth
dllooph:
        movlw   0xFF
        movwf   dlcntl
dlloopl:
        decfsz  dlcntl,f
        goto    dlloopl
        decfsz  dlcnth,f
        goto    dllooph
        return
;---------------------------------------------------------------------
		end

