;Здесь пишем код
	device zxspectrum48

;!!!
;	org 0x0000
	org 0x100

start:
	di
    xor     a
	out (10h),a
	ld a,0C3h
	ld (0),a
	ld (38h),a
	ld hl,Restart
	ld (1),hl
	ld sp,start
	ld hl,Int
	ld (39h),hl
	
	ld hl,tiles
	ld c,1120/32
TranspLoop2:
	push hl
	ld b,16
	ld de,4000h
	call LdirB
	ld b,16
	ld de,4100h
	call LdirB
	pop hl
	ld de,4000h
	ld b,8
TranspLoop1:
	ld a,(de)
	inc d
	ld (hl),a
	inc hl
	ld a,(de)
	inc e
	ld (hl),a
	inc hl
	ld a,(de)
	dec d
	ld (hl),a
	inc hl
	ld a,(de)
	inc e
	ld (hl),a
	inc hl
	dec b
	jp nz,TranspLoop1
	dec c
	jp nz,TranspLoop2
	
	ld hl,PaletteE0+15
	ei
	halt
	ld	a, 88h
	out	(0),a	
	ld b,15
SetPalLoop:
	ld a,b
	out (2),a
	ld a,(hl)
	out (0Ch),a
	ex (sp),hl
	ex (sp),hl
	dec hl
	dec b
	ld a,a
	out (0Ch),a
	jp p,SetPalLoop
	cpl
	out (3),a

Restart:
	ld sp,start
	xor a
	ld hl,0C000h
ClsLoop:
	ld (hl),a
	inc hl
	cp h
	jp nz,ClsLoop
	ei
        xor     a
        ld      (frame_counter),a

;!!!
		ld a,16
        ld      (x_coord),a
		ld a,56
        ld      (y_coord),a

        ld      hl, map+4
        call    print_map
main_loop:
        call    clear_map_copy
        call    restore_background
        call    anim_map


        ld      a, (frame_counter)
        add     4
        ld      (frame_counter), a

        call    change_coords
		push de
		call tile_to_buf
		pop de
        call    anim_sprite
        call    print_sprite_mask
		call    put_sprite_tile

        ld      hl, map_copy+4
        call    print_map

        jp      main_loop
		

; Выбираем фазу анимации
; На выходе в A текущий кадр анимации (0..2):
anim_sprite:		
		ld		a, (x_coord)
		ld		b, a
		ld		a, (x_coord_prev)
		cp		b
		jp		nz, anim_sprite_2
		ld		a, (y_coord)
		ld		b, a
		ld		a, (y_coord_prev)
		cp		b
		jp		nz, anim_sprite_2
		ld		a, (current_anim)
		ret
		
anim_sprite_2:
		ld		a, (x_coord)
		ld		(x_coord_prev), a
		ld		a, (y_coord)
		ld		(y_coord_prev), a        

		ld		a, (current_anim)
		inc		a
		cp		3		; Три фазы анимации движения
		jp		nz, anim_sprite_1
		xor		a
anim_sprite_1:
		ld		(current_anim), a
		ret

; Восстанавливаем фон
; Берём последние координаты героя и вычисляем какие тайлы на карте он перекрывает
; Главный герой при перемещении на 8, всегда занимает только 2 тайла по горизонтали и 2 по вертикали
; При попиксельном перемещении может покрывать 3 тайла
restore_background:
		call XY_to_adr
		
		; Копируем из оригинальной карты в копию квадрат 2*2 со сдвигом от начала карты в DE
		; На будущее НЕОБХОДИМО УЧЕСТЬ ПЕРЕХОД ЗА ПРАВЫЙ КРАЙ И НИЗ (добавить ещё одну лишнюю строку внизу?)

; Второй, более быстрый вариант
		ld		hl, map
		add		hl, de
		push	hl
		ld		a, (hl)
		inc		hl
		ld		b, (hl)
		
		ld		hl, map_copy
		add		hl, de
		push	hl
		ld		(hl), a
		inc		hl
		ld		(hl), b
		
		ld		bc, 24		; Количество тайлов в одной строке (384 / 16)
		pop		hl
		add hl,bc
		ex de,hl
		pop		hl
		add		hl, bc
		ld		a, (hl)
		inc		hl
		ld		b, (hl)
		
		ex		de,hl
		ld		(hl), a
		inc		hl
		ld		(hl), b
		ret


tile_to_buf:
		call XY_to_adr

		ld c,e
		ld b,d
		ld		hl, map
		add		hl, bc
		ex de,hl				;de - map
		ld		hl, map_copy
		add		hl, bc			;hl - map_copy

		push hl
		push de
		ld a,(hl)
		cp 0FFh
		jp nz, $+4
		ld a,(de)
		ld c,a
		inc hl
		inc de
		ld a,(hl)
		cp 0FFh
		jp nz, $+4
		ld a,(de)
		ld b,a

		pop de
		pop hl
		push bc
		ld		bc, 24		; Количество тайлов в одной строке (384 / 16)
		add		hl, bc
		ex de,hl
		add hl,bc
		ex de,hl

		ld a,(hl)
		cp 0FFh
		jp nz, $+4
		ld a,(de)
		ld c,a
		inc hl
		inc de
		ld a,(hl)
		cp 0FFh
		jp nz, $+4
		ld a,(de)
		ld b,a

		ld a,c
		ld de,0DC00h+16
; A - номер тайла
; DE - адрес в экранной области
		call print_tile_my
		ld a,b
		ld de,0DE00h+16
		call print_tile_my

		pop bc
		ld a,c
		ld de,0DC00h
		call print_tile_my
		ld a,b
		ld de,0DE00h
		call print_tile_my

		ret

XY_to_adr:
		ld		a, (x_coord)	; 0...47
		or		a				; Сбрасываем флаг С
		rra						; Делим на 2 получаем левую координату тайла 
		ld		e, a
      
		ld		a, (y_coord)	; 0...255
		rra						; Делим на 16 получаем верхнюю координату тайла 
		rra
		rra
		rra
		and		0b00001111			; Убираем возможные лишние единицы после rra, если флаг С был установлен
		ld		d, a
        
		; Теперь нужно скопировать из оригинальной карты в её копию значение тайла с координатами в DE
		
		; По координатам ищем сдвиг в карте: y * 24 + x
		ld		h, 0
		ld		l, d	; HL = y (D)
		ld		d, h	; DE = x (E)
		
		add		hl, hl ; y * 2
		add		hl, hl ; y * 4
		add		hl, hl ; y * 8
		ld		b, h
		ld		c, l
		add		hl, hl ; y * 16
		add		hl, bc ; y * 24
		add		hl, de ; + x

		ex		hl, de		; В DE сдвиг относительно начала карты
		ret

put_sprite_tile:
		call XY_to_adr

		ld		hl, map_copy
		add		hl, de
		push	hl
		ld		(hl), 60
		inc		hl
		ld		(hl), 62
		
		pop		hl
		ld		bc, 24		; Количество тайлов в одной строке (384 / 16)
		add		hl, bc
		ld		(hl), 61
		inc		hl
		ld		(hl), 63
		ret

; Изменение координат спрайта
change_coords:
		call	keyboard
		jp		z, no_key

; Отдельные установленные биты:
; 0 - Вниз
; 1 - Вверх
; 2 - Вправо
; 4 - Влево
		ld		b, a
		and		0b100
		jp		z, key_1
		ld		a, (x_coord)

;!!!
;		cp		45				; (384 - 24) / 8
		cp 29+8

		jp		nc, key_1
		inc		a
		ld		(x_coord), a
key_1:

		ld		a, b
		and		0b10000
		jp		z, key_2
		ld		a, (x_coord)
;
;		or		a
;		jp		z, key_2
		cp 9
		jp c,key_2

		dec		a
		ld		(x_coord), a
key_2:

		ld		a, b
		and		0b10
		jp		z, key_3
		ld		a, (y_coord)
		or		a
		jp		z, key_3
		; dec		a
		sub		8
		ld		(y_coord), a
key_3:

		ld		a, b
		and		0b1
		jp		z, key_4
		ld		a, (y_coord)
		cp		256 - 24
		jp		nc, key_4
		; inc		a
		add		8
		ld		(y_coord), a
key_4:

no_key:
		ld		a, (x_coord)
		ld		d, a
		ld		a, (y_coord)
		ld		e, a

        ret

; Опрос клавиатуры на предмет нажатия курсорных клавиш
; Результат в регистре А
; A = 0 - не было нажатия
; Z = 1 - не было нажатия
; Отдельные установленные биты:
; 0 - Вниз
; 1 - Вверх
; 2 - Вправо
; 4 - Влево
keyboard:
		ld a,(CursorKeys)
		ld d,a
		and 01000000b	;вправо?
		ld e,0
		jp nz, ChkLeft
		ld e,100b
ChkLeft:
		ld a,00010000b
		and d
		jp nz, ChkUp
		ld a,10000b
		or e
		ld e,a
ChkUp:
		ld a,00100000b
		and d
		jp nz, ChkDown
		ld a,10b
		or e
		ld e,a
ChkDown:
		ld a,10000000b
		and d
		jp nz, keyboardExit
		ld a,1b
		or e
		ld e,a
keyboardExit:
		xor a
		or e
		ret

; Печать спрайта с маской
; D - координата X - 0...13
; E - координата Y - 0...232
; A - номер спрайта
print_sprite_mask:
;!!!
;        ld      hl, 0x9000
        ld      hl, 0E000h-(8*256)
		
        add     hl, de
        ex      hl, de

        ; Умножаем A на 144
		ld		l, a
		ld		h, 0
		add		hl, hl
		add		hl, hl
		add		hl, hl
		add		hl, hl
		ld		b, h
		ld		c, l
		add		hl, hl
		add		hl, hl
		add		hl, hl
		add		hl, bc

		ld		bc, sprites
		add		hl, bc

;!!!	
		ld a,1
		and d
		add 0DCh
		ld b,a
		ld a,8
		and e
		cpl
		ld c,a

		call print_sprite_mask_1
		call print_sprite_mask_1
		call print_sprite_mask_1
		
		ld de,tiles+(60*32)
		ld hl,0DCFFh
		call SaveSprTile
		ld hl,0DEFFh

SaveSprTile:
		ld b,16
SaveSprTileLoop1:
		ld a,(hl)
		inc h
		ld (de),a
		inc de
		ld a,(hl)
		dec l
		ld (de),a
		inc de
		ld a,(hl)
		dec h
		ld (de),a
		inc de
		ld a,(hl)
		dec l
		ld (de),a
		inc de
		dec b
		jp nz,SaveSprTileLoop1
		ret

print_sprite_mask_1:
		DUP 24
		ld		a, (bc)
		or		(hl)			; В регистре A результат OR c маской
		inc		hl
		xor		(hl)			; В регистре A результат XOR со спрайтом
		ld (bc),a
		dec c
		inc		hl
		EDUP
		ld		a, c
		add a,24
		ld		c, a
		inc b
		ret

; Расставляем на копии карты текущие правильные кадры анимации спрайтов
anim_map:
		ld		c, 384/2		; Длина всей карты
		ld		de, map

anim_map_2:
		ld		a, (de)
		or a
		call	nz, anim_map_3
		inc		de

		ld		a, (de)
		or a
		call	nz, anim_map_3
		inc		de
		
		dec		c
		jp		nz, anim_map_2

		ret


anim_map_3:
		; Имеем номер тайла, нужно узнать его свойство
		add tiles_prop&255
		ld l,a
		adc tiles_prop>>8
		sub l
		ld h,a
		ld 		a, (hl)
		and		0b00000011
		ret z
		call	calc_anim_frame
		; По возвращении кадр анимации, который нужно записать в копию карты

		ex de,hl
		add (hl)	; В А текущий номер кадра для анимации
		ex de,hl
		ld hl,map_copy-map
		add hl,de
		ld		(hl),a
		ret

; HL - адрес текущего элемента на карте
; DE - номер текущего элемента на карте

; Нужно
; 1. Определить номер текущего кадра анимации
; 2. Записать его в копию карты


calc_anim_frame:
		push de
		ld		a, (hl)		; Загружаем свойство спрайта
		ld		e, a		; Сохраняем свойство спрайта

		and		0b11		; Количество кадров
		inc		a			; Необходимо перевести с 0...3 на 1...4
		ld 		h, a		; Сохраняем количество кадров

		ld		a, e
		and		0b11000		; Скорость анимации
		ld		e, a		; Сохраняем скорость анимации
		ld		d, a		; Сохраняем скорость анимации

		; Умножаем количество кадров на скорость анимации
		xor		a
calc_anim_frame_1:
		add		e
		dec		h
		jp		nz, calc_anim_frame_1

		; В A имеем длительность анимации текущего тайла в кадрах

		; Нужно поделить счётчик кадров на длительность анимации в кадрах
		; и получить остаток от деления
		ld		e, a
		ld		hl, frame_counter
		ld		a, (hl)
		; c - длительность анимации в кадрах
		; a - счётчик кадров
calc_anim_frame_3:
		cp 		e			; A - C
		jp		c, calc_anim_frame_2
		sub		e
		jp		calc_anim_frame_3
calc_anim_frame_2:

		; В A остаток от деления кадры/длительность анимации
		; Это текущая позиция в анимации

		; Текущую позицию (A) в анимации нужно поделить без остатка на скорость проигрывания (D)
		; Так мы получим текущий кадр анимации

		; A - текущая позиция в анимации
		; D - скорость анимации в кадрах

		ld		e, 0	; Текущий кадр
calc_anim_frame_5:
		cp		d
		jp		c, calc_anim_frame_4
		sub		d
		inc		e
		jp		calc_anim_frame_5

calc_anim_frame_4:
		ld		a, e
		; В A текущий кадр анимации для
		pop de
		ret

;!!!
; Очищаем копию карты
clear_map_copy:
		ld bc,0FFFFh
		ld hl,0
		add hl,sp
		ld sp,map_copy+384
		DUP 384/2
		push bc
		EDUP
		ld sp,hl
        ret

; Печать карты по тайлам
; HL - адреc карты
print_map:
		ld e,0
        ld      c, 16
print_map2:
        ld      b, 16
		ld d,4
print_map_1:
        ld      a, (hl)
        cp      0xff
	call nz,print_tile_xy
	inc hl
	inc d
	dec b
	jp nz, print_map_1
		ld a,8
		add l
		ld l,a
		adc h
		sub l
		ld h,a

	inc e
	dec c
	jp nz, print_map2
        ret

; Печать тайла по координатам
; A - номер тайла
; D - координата X = 0...23 (на векторе 4...19)
; E - координата Y = 0...15
print_tile_xy:
        push    hl
        push    de

		rlca
		rlca
		rlca
		rlca
		rlca
		ld l,a
		and 11111b
		ld h,a
		xor l
		add tiles&255
		ld l,a
		ld a,tiles>>8
		adc h
		ld h,a

        ld      a, e
		add a
		add a
		add a
		add a
        ld      e, a

        ld      a, d
        add a
		add 0E0h-8
        ld      d, a

        call    print_tile
        pop     de
        pop     hl
        ret

; A - номер тайла
; DE - адрес в экранной области
print_tile_my:
		rlca
		rlca
		rlca
		rlca
		rlca
		ld l,a
		and 11111b
		ld h,a
		xor l
		add tiles&255
		ld l,a
		ld a,tiles>>8
		adc h
		ld h,a
; Печать тайла 16*16
; HL - адрес данных тайла
; DE - адрес в экранной области
print_tile:
;!!!
	ld a,e
	cpl
	ld e,a
	push bc
	
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	ld (SetSP1+1),hl
	ld hl,0
	add hl,sp
SetSP1:
	ld sp,0
	ex de,hl
	
	ld (hl),c
	inc h
	ld (hl),b
	dec l
	pop bc
	ld (hl),c
	dec h
	ld (hl),b
	dec l
	
	DUP 7
	pop bc
	ld (hl),c
	inc h
	ld (hl),b
	dec l
	pop bc
	ld (hl),c
	dec h
	ld (hl),b
	dec l
	EDUP

	ex de,hl
	ld sp,hl
		pop bc
        ret

;!!!
Int:
		ex (sp),hl
		ld (SetIntExit+1),hl
		pop hl
		push af
		ld a,8Ah
		out (0),a
		ld a,0FEh
		out (3),a
		in a,(2)
		ld (CursorKeys),a
		pop af
		push bc
		pop bc
		ei
SetIntExit:
		jp 0

LdirB:
	ld a,(hl)
	inc hl
	ld (de),a
	inc de
	dec b
	jp nz,LdirB
	ret
		
CursorKeys:
		db 0FFh

 ; Свойства тайлов:
 ; 00 (2 бита) - количество кадров в анимации
 ; 0 (1 бит) - тип анимации
 ; 00 (2 бита) - скорость проигрывания анимации
 ; 000 (3 бита) - тип (пустота, поверхность, лестница и т.д.)
tiles_prop:
        db      0b00000000 ; 0 Пустота

        db      0b00100000 ; 1 Кирпич №1
        db      0b00100000 ; 2 Кирпич №2

        db      0b00000000 ; 3 Окно фрагмент №1
        db      0b00000000 ; 4 Окно фрагмент №2
        db      0b00000000 ; 5 Окно фрагмент №3
        db      0b00000000 ; 6 Окно фрагмент №4

        db      0b01000000 ; 7 Лестница поверх кирпича
        db      0b01000000 ; 8 Лестница

        db      0b00001111 ; 9 Цветок №1, 4 кадра, скорость 8
        db      0b00000000 ; 10
        db      0b00000000 ; 11
        db      0b00000000 ; 12

        db      0b00010111 ; 13 Цветок №2, 4 кадра, скорость 16
        db      0b00000000 ; 14
        db      0b00000000 ; 15
        db      0b00000000 ; 16

        db      0b00011111 ; 17 Цветок №3, 4 кадра, скорость 24
        db      0b00000000 ; 18
        db      0b00000000 ; 19
        db      0b00000000 ; 20

        db      0b00001111 ; 21 Цветок №4, 4 кадра, скорость 8
        db      0b00000000 ; 22
        db      0b00000000 ; 23
        db      0b00000000 ; 24

        db      0b00001111 ; 25 Волна №1, 4 кадра, скорость 8
        db      0b00000000 ; 26
        db      0b00000000 ; 27
        db      0b00000000 ; 28

        db      0b00001111 ; 29 Волна №2, 4 кадра, скорость 8
        db      0b00000000 ; 30
        db      0b00000000 ; 31
        db      0b00000000 ; 32

        db      0b00000000 ; 33 Кирпич №1
        db      0b00000000 ; 34 Кирпич №2

PaletteE0:
	db 0,173,0,173,0,173,0,173,0,173,0,173,0,173,0,173

	dw 0
map_copy:
        defs    384, 0xff

frame_counter
        db      0

x_coord:
		db		0
y_coord:
		db		0

current_anim:
        db      0
x_coord_prev:
        db      0
y_coord_prev:
        db      0  
map:
        include "map.asm"

sprites:
        incbin  "sprites_3x3_mask.bin"
tiles:
        incbin  "sprites_2x2_nomask.bin"


finish:
        savebin "game.bin", start, finish-start

      