; Пример псевдографического режима
; (с) 17-04-2012 vinxru

; Converted to pdp11asm85 by Shaos on 21-Feb-2024

		.i8080

start:		; Ждем обратный ход

		lxi h, 0C001h   ; для Апогея 0EF01h
		mov a,m
wait1:		mov a,m
		ani 20h
		jz wait1

                ; Вырубаем видео

		mvi m, 0h

		; Устаналиваем режим

		lxi h, 0C000h	; для Апогея 0EF00h
		mvi m, 04Dh	; 78 символов
		mvi m, 60	; 61 строка (50 Гц)
		mvi m, 4	; Высота символа 5
		mvi m, 03h ; 83h

                ; Заполняем видеопамять (из за байта F1 это надо делать пока видео выключено)

		lxi b, data
		lxi h, 4000h
copy:		ldax b
		cpi 0FFh
		jz endCopy
		mov m,a
		inx b
		inx h
		jmp copy
endCopy:

		; Врубаем видео

		lxi h, 0C001h
		mvi m, 27h

loop:		mov a,m		; читаем статус
		ani 20h		; маскируем 'Interrupt request flag'
		jz loop		; ждем прерывания по VRTC

		lxi h,0E008h	; VT_57+8
		mvi m,80h
		mvi l,4		; VT_57+4
		mvi m,00h	; 0D0H
		mvi m,40h	; 076H
		inr l		; адрес VT_57+5
		mvi m,95h	; число байтов минус 1
		mvi m,52h	; режим
		mvi l,8		; VT_57+8
		mvi m,0A4h

		jmp $

data:

    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 0
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 1
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 2
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 3
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 4
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 5
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,7,19,19,23,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,23,23,23,19,3,3,19,3,19,19,19,19,19,19,23,19,19,19,19,19,3,3,5,3,123,5,19,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 6
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,19,19,19,23,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,23,23,23,19,3,3,19,23,19,19,3,3,3,23,19,19,23,23,23,19,19,3,112,5,5,3,102,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 7
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,7,19,19,23,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,23,23,23,19,3,19,19,3,109,5,114,99,100,126,5,3,3,7,19,23,19,19,19,96,5,5,3,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 8
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,7,19,19,23,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,23,23,23,19,3,5,5,5,107,60,92,47,94,34,94,94,117,3,3,19,19,19,19,19,109,5,3,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 9
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,23,23,19,3,35,5,121,107,60,94,34,59,47,92,34,117,117,59,125,19,19,19,19,19,19,5,3,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 10
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,23,19,5,3,121,5,5,107,89,121,107,59,47,94,34,34,115,115,92,35,19,19,19,19,19,19,19,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 11
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,23,3,5,3,112,5,5,5,120,126,5,59,117,59,94,59,47,94,59,92,94,3,3,19,19,19,3,19,23,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 12
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,19,19,19,23,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,23,3,119,5,5,101,112,121,117,89,119,101,59,101,117,117,115,92,4,34,60,60,108,3,19,19,19,3,19,19,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 13
    db	0,0,0,0,0,0,0,0,0,23,23,23,23,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,23,19,119,5,5,1,108,101,115,34,117,101,107,111,121,111,107,115,92,32,94,34,92,34,96,19,19,19,3,19,3,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 14
    db	0,0,0,0,0,0,0,0,0,23,23,23,23,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,19,3,109,5,5,34,126,89,92,34,111,34,59,111,5,5,5,59,92,47,4,92,60,34,99,3,19,19,19,3,3,19,23,23,23,23,23,23,23,0,0,0,0,0 ; 15
    db	0,0,0,0,0,0,0,0,0,23,23,23,23,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,19,5,5,5,101,89,120,59,47,94,120,59,34,119,3,3,3,126,115,92,47,4,94,60,59,123,19,19,19,19,3,3,23,23,23,23,23,23,23,0,0,0,0,0 ; 16
    db	0,0,0,0,0,0,0,0,0,23,23,23,23,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,7,3,111,5,5,115,99,115,59,4,94,59,94,111,3,3,3,19,3,114,34,60,47,34,34,63,117,3,19,19,19,3,3,3,23,23,23,23,23,23,0,0,0,0,0 ; 17
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,19,5,5,5,5,34,99,34,47,92,60,94,117,109,3,3,19,3,19,3,99,60,92,34,59,94,117,96,19,19,19,3,3,3,23,23,23,23,23,23,0,0,0,0,0 ; 18
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,19,5,5,5,1,34,101,92,94,47,92,34,111,3,3,3,19,19,19,3,5,101,47,62,59,60,59,126,3,19,19,19,3,3,7,23,23,23,23,23,0,0,0,0,0 ; 19
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,7,3,126,5,5,120,100,59,92,92,94,47,115,35,3,3,19,19,19,19,19,3,99,60,62,115,115,34,117,3,19,19,19,3,3,3,23,23,23,23,23,0,0,0,0,0 ; 20
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,19,3,126,5,5,59,99,34,94,92,60,94,100,3,3,3,19,19,19,19,19,3,5,59,47,117,59,94,117,35,19,19,19,3,3,3,23,23,23,23,23,0,0,0,0,0 ; 21
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,19,5,3,96,101,63,120,34,34,47,92,94,119,3,3,19,19,19,19,19,19,19,5,101,47,63,59,34,34,35,19,19,3,19,3,3,23,23,23,23,23,0,0,0,0,0 ; 22
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,19,5,3,96,101,93,59,60,16,34,47,117,3,3,3,19,3,19,19,19,19,19,3,34,59,4,107,59,34,126,3,19,19,3,3,3,19,23,23,23,23,0,0,0,0,0 ; 23
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,7,3,96,5,3,92,55,94,34,92,60,94,111,3,5,19,35,5,3,35,19,19,19,19,115,59,4,99,59,34,117,3,19,3,19,3,3,19,23,23,23,23,0,0,0,0,0 ; 24
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,3,123,5,5,91,120,34,59,4,92,59,34,59,92,47,47,100,111,121,112,3,3,19,1,59,47,115,115,89,94,3,3,19,3,19,3,3,23,23,23,23,0,0,0,0,0 ; 25
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,5,5,3,101,47,120,59,16,59,47,55,59,59,111,112,119,5,3,35,3,3,35,19,5,34,60,89,115,63,94,123,3,19,3,19,3,3,23,23,23,23,0,0,0,0,0 ; 26
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,5,3,96,101,93,34,59,47,92,34,119,5,5,101,34,92,94,34,107,119,3,3,3,114,34,59,94,120,34,59,55,3,19,3,19,3,3,23,23,23,23,0,0,0,0,0 ; 27
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,5,3,96,91,55,34,91,92,92,42,3,119,120,92,32,32,47,4,47,4,34,112,5,5,59,59,94,107,60,76,99,3,19,3,3,19,3,23,23,23,23,0,0,0,0,0 ; 28
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,3,119,3,109,16,107,34,59,47,47,35,3,5,101,32,32,99,92,62,34,47,94,117,119,5,59,59,94,99,34,59,94,3,3,3,19,3,3,19,23,23,23,0,0,0,0,0 ; 29
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,5,19,3,109,5,5,34,120,59,94,92,89,3,3,3,107,92,62,35,76,32,112,94,117,35,3,5,1,59,34,117,34,34,94,3,3,3,3,19,3,19,23,23,23,0,0,0,0,0 ; 30
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,5,3,96,1,74,59,34,92,47,111,3,19,3,5,120,47,63,59,47,55,119,3,3,3,3,101,34,59,63,34,34,62,35,19,3,3,19,3,19,23,23,23,0,0,0,0,0 ; 31
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,35,5,3,59,74,59,60,92,74,125,3,19,3,3,5,101,121,119,35,3,3,3,3,19,19,5,117,34,94,115,34,47,35,19,3,3,19,3,3,23,23,23,0,0,0,0,0 ; 32
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,23,19,23,23,23,23,23,23,23,23,23,23,23,3,3,35,35,5,101,94,59,92,92,34,3,3,19,19,3,3,3,109,3,3,3,3,3,19,19,19,5,99,59,94,115,34,47,125,19,3,3,3,3,19,23,23,23,0,0,0,0,0 ; 33
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,19,19,23,23,23,23,23,23,23,23,23,23,23,23,3,3,119,5,3,4,117,59,47,47,122,3,19,19,19,19,3,3,3,3,3,3,3,3,19,19,19,3,47,115,34,115,34,47,123,19,3,3,3,3,19,23,23,23,0,0,0,0,0 ; 34
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,19,19,19,19,23,23,23,23,23,23,23,23,23,23,3,3,109,5,5,34,99,59,92,63,3,3,19,19,19,19,19,3,3,19,3,3,3,3,19,19,3,3,92,115,34,59,34,92,126,3,19,3,3,3,19,23,23,23,0,0,0,0,0 ; 35
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,3,19,19,23,23,23,23,23,23,23,23,23,23,3,5,5,5,5,94,99,34,47,35,19,19,19,19,19,19,3,3,3,3,19,3,3,3,19,3,19,5,1,117,34,59,34,16,57,3,3,3,3,3,3,23,23,23,0,0,0,0,0 ; 36
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,3,3,5,19,23,23,23,23,23,23,23,23,23,23,23,3,5,5,5,5,4,107,92,47,3,3,3,3,3,19,19,3,3,3,3,3,3,3,19,3,3,3,3,16,117,59,34,59,16,108,3,3,3,3,3,3,23,23,23,0,0,0,0,0 ; 37
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,126,3,19,23,23,23,23,23,23,23,23,23,23,3,5,5,5,1,94,120,47,47,124,3,35,3,57,3,3,3,3,3,3,3,3,3,3,19,3,3,5,1,93,59,34,34,16,100,3,3,3,3,3,3,23,23,23,0,0,0,0,0 ; 38
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,119,3,19,23,23,23,23,23,23,23,23,23,23,3,5,5,5,101,74,60,47,32,4,5,5,3,3,96,3,3,3,3,3,3,3,19,3,3,19,3,5,1,93,59,34,34,60,63,3,3,3,3,3,3,23,23,23,0,0,0,0,0 ; 39
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,3,19,5,3,19,23,23,23,23,23,23,23,23,23,23,3,3,126,107,107,59,59,92,32,47,42,5,19,3,3,3,3,3,3,19,3,3,19,3,19,3,3,3,59,33,115,34,34,60,63,35,19,3,3,3,19,7,23,23,0,0,0,0,0 ; 40
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,3,19,119,3,23,23,23,23,23,23,23,23,23,23,23,3,3,112,120,59,94,115,34,16,89,3,3,3,3,19,3,19,3,3,19,3,19,3,19,3,3,19,3,115,74,120,92,34,60,74,35,19,3,3,3,3,19,23,23,0,0,0,0,0 ; 41
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,3,3,5,19,23,23,23,23,23,23,23,23,23,23,23,3,3,119,101,92,47,112,5,19,3,3,3,3,3,3,19,3,3,3,19,3,19,3,19,3,3,19,3,115,62,120,47,47,47,4,35,19,3,3,3,3,7,23,23,0,0,0,0,0 ; 42
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,23,3,3,3,3,23,23,23,23,23,23,23,23,23,23,23,3,3,5,5,16,47,3,3,3,5,5,5,107,107,99,5,3,5,19,3,3,3,3,19,3,19,3,3,115,92,120,47,32,16,94,125,19,3,3,3,3,7,23,23,0,0,0,0,0 ; 43
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,35,19,23,23,23,23,23,23,23,23,23,23,23,3,3,5,5,91,4,3,3,5,5,3,112,119,119,5,5,101,126,5,19,3,3,3,19,3,19,3,3,59,92,59,47,32,92,47,113,3,3,3,3,3,7,23,23,0,0,0,0,0 ; 44
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,3,3,23,23,23,23,23,23,23,23,23,23,23,3,3,3,115,59,47,35,19,3,19,19,5,3,109,5,19,3,3,3,3,3,3,3,3,19,3,3,3,117,92,59,47,4,47,94,125,19,3,3,3,3,7,23,23,0,0,0,0,0 ; 45
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,3,3,23,23,23,23,23,23,23,23,23,23,23,3,3,3,5,91,47,39,19,19,19,3,119,119,119,5,3,3,3,3,3,3,3,3,3,19,3,19,5,5,115,59,47,32,32,32,18,3,3,3,3,3,7,23,23,0,0,0,0,0 ; 46
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,3,3,19,23,23,23,23,23,23,23,23,23,23,3,3,7,3,5,91,47,35,23,19,19,19,3,3,3,3,19,3,3,19,3,3,3,3,19,3,3,119,5,5,107,59,32,32,32,113,19,3,3,3,3,7,23,23,0,0,0,0,0 ; 47
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,3,3,7,23,23,23,23,23,23,23,23,23,23,3,3,3,19,19,112,119,3,3,23,19,19,3,19,3,19,3,19,19,3,19,3,3,3,3,3,96,5,3,112,114,115,16,32,32,18,3,3,3,3,3,23,23,23,0,0,0,0,0 ; 48
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,3,3,7,23,23,23,23,23,23,23,23,23,23,3,3,3,7,19,5,3,3,19,19,19,19,3,3,3,3,3,19,3,19,3,3,3,3,35,5,3,5,19,96,5,101,59,32,32,113,19,3,3,3,3,23,23,23,0,0,0,0,0 ; 49
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,3,3,3,23,23,23,23,23,23,23,23,23,23,3,3,3,3,19,19,3,7,19,3,19,3,5,3,3,3,3,3,3,3,5,3,96,5,19,35,3,35,3,35,5,5,120,32,92,102,19,3,3,3,7,23,23,23,0,0,0,0,0 ; 50
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,3,3,3,23,23,23,23,23,23,23,23,23,23,3,3,3,3,3,19,3,19,23,19,3,3,109,5,3,96,3,3,119,5,119,5,3,35,3,35,3,5,19,5,3,109,114,60,117,3,3,3,3,3,23,23,23,23,0,0,0,0,0 ; 51
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,3,3,19,23,23,23,23,23,23,23,23,23,23,3,3,35,3,3,3,19,19,23,19,19,107,5,91,94,3,3,3,3,109,5,5,3,3,35,3,3,5,19,3,35,3,109,101,3,3,3,3,19,23,23,23,23,23,0,0,0,0,0 ; 52
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,3,3,19,19,23,23,23,23,23,23,23,23,23,23,23,3,3,35,3,3,3,19,19,19,23,19,3,126,119,114,3,3,19,3,3,96,3,35,3,3,3,3,3,3,3,3,3,5,19,3,7,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 53
    db	0,0,0,0,0,0,0,0,0,23,23,23,19,19,19,3,19,19,23,23,23,23,23,23,23,23,23,23,23,3,3,35,3,3,5,19,19,19,7,19,19,19,3,3,3,19,19,3,3,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,19,23,23,23,23,23,23,23,23,0,0,0,0,0 ; 54
    db	0,0,0,0,0,0,0,0,0,23,23,23,3,19,19,19,19,19,23,23,23,23,23,23,23,23,23,23,23,3,3,35,3,35,3,119,121,5,3,3,3,35,3,3,3,19,19,19,3,3,35,3,3,3,3,3,3,3,3,19,3,3,19,3,19,19,23,23,23,23,23,23,23,0,0,0,0,0 ; 55
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 56
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 57
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 58
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 59
    db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 60

	db 0FFh

		make_radio86rk_rom "test_vinxru_5.rkr"
