scr_lines   equ 38
scr_length  equ $b00
scr_start   equ $4000

    IFDEF RK86
crt_ctrl    equ $c001
dma_ctrl    equ $e008
    ENDIF
    IFDEF APOGEE
crt_ctrl    equ $ef01
dma_ctrl    equ $f008
    ENDIF

    org $start_addr
    ld hl,scr_start:ld (frame_adress),hl
    ld hl,scr_length-1:ld (frame_len),hl
    ld hl,scr_start+scr_length-1:ld (frame_end),hl
    ld a,1:ld (old_hgt_l),a:ld (old_hgt_u),a
    ld (target_l),a:ld (target_u),a

    call make_row_table

    ld  hl,scr_start:ld  bc,scr_length
    xor a:call fill_mem
    ld  hl,scr_start+$2000:ld  bc,scr_length
    xor a:call fill_mem

    ld a,$f3
    ld (scr_start+scr_length-1),a
    ld (scr_start+$2000+scr_length-1),a

    ld hl,crt_ctrl:ld (hl),0
    dec hl:ld (hl),$4d:ld (hl),scr_lines-1:ld (hl),$77:ld (hl),$53
    inc hl:ld (hl),$27
mainloop
    ld a,(crt_ctrl)
.loop
    ld a,(crt_ctrl):and a,$20:jp z,.loop
    ld hl,(frame_adress):ex de,hl
    ld hl,(frame_len):ld a,h:or $40:ld b,a:ld c,l

    ld hl,dma_ctrl:ld (hl),$80
    ld l,4:ld (hl),e:ld (hl),d
    inc hl:ld (hl),c:ld (hl),b
    inc hl:ld (hl),0:ld a,d:and $f0:ld (hl),a
    inc hl:ld (hl),low (scr_length-1):ld (hl),$40+(high (scr_length-1))
    ld l,8:ld (hl),$a4


    ld a,d:xor $20:ld h,a:ld l,e:ld (frame_adress),hl
    and $20:jp z,.skip
        ld e,l:ld d,h
        inc l:call z,wrap_inc_hl
        ld (frame_adress),hl
        ld hl,(frame_end):ld (hl),0
        ld a,h:xor $20:ld h,a:ld (hl),0
        ld hl,scr_length-1:add hl,de:call wrap_hl
        ld (hl),$f3:ld a,h:xor $20:ld h,a
        ld (hl),$f3:ld (frame_end),hl

        ld hl,(frame_len)
        ld a,h:or l
        dec hl:jp nz,.skip2
            ld hl,scr_length-1
.skip2
        ld (frame_len),hl

.skip
    ld hl,(frame_adress):ld de,$4e*4+6
    add hl,de:call wrap_hl
    push hl:call erase:pop hl
    ld de,64:add hl,de:call wrap_hl
    call draw
    call draw_ship
.wait
    call $f81b
    cp 32:jp z,.wait
    cp $1b:jp nz,mainloop

    call $f82d
    jp $f86c

wrap_inc_hl
    inc h
wrap_hl
    ld a,h:and $1f:cp high scr_length:ret c
    ld a,h:sub high scr_length:ld h,a
    ret

wrap_dec_hl
    dec h
    ld a,h:and $10:ret z
    ld a,h:add a,high scr_length:ld h,a
    ret


fill_mem
    ld  (hl),a:inc hl
    dec c:jp  nz,fill_mem
    dec b:jp  nz,fill_mem
    ret

frame_adress    defw scr_start
frame_len       defw scr_length-1
frame_end       defw scr_start+scr_length-1

rnd         defw $f800
old_hgt_u   defb 1
old_hgt_l   defb 1

target_u    defb 1
target_l    defb 1

upper   equ 15
lower   equ 7
middle  equ 23

draw
    ld de,$0017
    ld a,(old_hgt_u):ld b,a
    ld a,(target_u):cp b:jp z,du_new

        sbc a,a:ccf:adc a,b:ld c,a
        ld (old_hgt_u),a
        jp draw_upper
du_new
        push hl
        ld hl,(rnd)
        add a,(hl):inc hl
        rlca:rlca:and upper:inc a
        ld (target_u),a
        ld a,h:or $f8:ld h,a:ld (rnd),hl
        pop hl:jp draw

draw_upper
    ld (hl),e
    ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.du0
    ld a,e
    dec b:jp p,.du3
    and $6
.du3
    dec b:jp p,.du1
    and $7
.du1
    dec c:jp p,.du2
    and $11
.du2
    dec c:jp p,.du4
    and $13
.du4
    ld e,a
    inc d
    or a
    jp nz,draw_upper

    ld a,middle:sub d:add a,a
    ex de,hl
    ld l,a:ld h,high row_table
    ld a,(hl):inc l:ld h,(hl):ld l,a
    add hl,de:call wrap_hl
    ld de,middle*256

    ld a,(old_hgt_l):ld b,a:ld c,a
    ld a,(target_l):dec a:ld (target_l),a
    jp nz,draw_lower
        push hl
        ld hl,(rnd)
        add a,(hl):inc hl
        rlca:rlca:and lower:inc a:ld c,a
        ld (target_l),a:ld (old_hgt_l),a
        ld a,h:or $f8:ld h,a:ld (rnd),hl
        pop hl

draw_lower
    ld (hl),e
    ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.du0
    ld a,e
    dec b:jp p,.dl3
    or $11
.dl3
    dec b:jp p,.dl1
    or $10
.dl1
    dec c:jp p,.dl4
    or $6
.dl4
    dec c:jp p,.dl2
    or $4
.dl2
    ld e,a
    inc d:ld a,d:cp 31:jp nz,draw_lower
    ret

    IFDEF RK86
color_cyan      equ $8c
color_magenta   equ $89
color_red       equ $81
color_yellow    equ $85
    ENDIF
    IFDEF APOGEE
color_cyan      equ $81
color_magenta   equ $88
color_red       equ $8c
color_yellow    equ $84
    ENDIF

erase
    ld de,$4d
    ld bc,color_cyan*256+10:call .loop
    ld bc,color_magenta*256+32-18:call .loop
    ld bc,color_red*256+4:call .loop
    ld bc,color_yellow*256+4
.loop   ld (hl),0:inc l:call z,wrap_inc_hl
        ld (hl),b:add hl,de:call wrap_hl
        dec c:jp nz,.loop
    ret

test_draw
    ld hl,$77c2
.loop
    push hl
    ld bc,$c08
    call draw
    pop hl
    inc hl
    ld a,l
    cp 2
    jp nz,.loop
    jp $f86c

ship_x  equ 10
ship_y  equ 14


draw_ship
    ld hl,high row_table*256+ship_y*2+4
    ld e,(hl):inc l:ld d,(hl)
    ld hl,(frame_adress):add hl,de
    ld de,ship_x:add hl,de:call wrap_hl
    ld de,ship:ld a,(de):ld c,a
.ds2    ld b,$4e
.ds1        ld (hl),c
            inc de:ld a,(de):inc a:ret z
            ld c,a:inc l:call z,wrap_inc_hl
            dec b:dec c:jp nz,.ds1
        ld a,l:add a,b:ld l,a:call c,wrap_inc_hl
        jp .ds2

ship
    defb 0," \\"
    defb 0,">]==-"
    defb 0," /"
    defb $ff

make_row_table
    ld de,$0
    ld hl,row_table
    ld bc,$4e
    ld a,32
.loop   ld (hl),e:inc hl:ld (hl),d:inc hl
        ex de,hl:add hl,bc:ex de,hl
        dec a:jp nz,.loop
    ret

    align 256
row_table defs 64
