// Дмитрий Иванов 2024г.

#include "WiFi.h"
#include <HTTPClient.h>

#define D0      0     // PA0 через резистор 1к
#define D1      1     // PA1 через резистор 1к
#define D2      2     // PA2 через резистор 1к
#define D3      3     // PA3 через резистор 1к
#define D4      4     // PA4 через резистор 1к
#define D5      5     // PA5 через резистор 1к
#define D6      6     // PA6 через резистор 1к
#define D7      7     // PA7 через резистор 1к

#define ADDR    10    // PB0 через резистор 1к
#define VPP     20    // PC6 через резистор 1к
#define EN      21    // PC7 через резистор 1к
#define LED     8

#define URL     "https://vtub.me/86rk/file.bin"

uint32_t PORT_INPUTS, PORT_OUTPUTS;

struct KR580VV55
{
  bool en = false;
  bool vpp = false;
  bool clock = false;
  bool state = false;
  uint16_t index = 4;
};

KR580VV55 BUS;

const char* ssid = "👽";
const char* password =  "a-number";

String data;

void setup(void)
{
      
  pinMode(LED, OUTPUT);

  // Устраняем косяки с коннектом ESP32C3
  WiFi.useStaticBuffers(true);
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  WiFi.setTxPower(WIFI_POWER_8_5dBm);

  // Мигаем светодиодом, пока нет коннекта
  while (WiFi.status() != WL_CONNECTED) 
  {
    delay(1000);
    digitalWrite(LED, HIGH);
    delay(1000);
    digitalWrite(LED, LOW);
  }

  // Скачиваем файл из мировой сети
  HTTPClient http;
  http.begin(URL);
  int httpResponseCode = http.GET();
      
  if (httpResponseCode > 0) data = http.getString();

  http.end();

  pinMode(D0, INPUT);
  pinMode(D1, INPUT);
  pinMode(D2, INPUT);
  pinMode(D3, INPUT);
  pinMode(D4, INPUT);
  pinMode(D5, INPUT);
  pinMode(D6, INPUT);
  pinMode(D7, INPUT);
 
  pinMode(ADDR, INPUT_PULLUP);
  pinMode(EN, INPUT_PULLUP);
  pinMode(VPP, INPUT_PULLUP);

  // Прервания
  attachInterrupt(digitalPinToInterrupt(ADDR), ISR_ADR, CHANGE);  
  attachInterrupt(digitalPinToInterrupt(EN), ISR_EN, CHANGE);  

  // Запоминаем состояние портов для восстановления
  PORT_INPUTS = REG_READ(GPIO_ENABLE_W1TC_REG);
  PORT_OUTPUTS = REG_READ(GPIO_ENABLE_W1TS_REG);

  // Заранее пишем в порт первый байт, чтобы нивелировать дребезг прерываний
  REG_WRITE(GPIO_ENABLE_W1TS_REG, 0xFF);  
  REG_WRITE(GPIO_OUT_REG, data.charAt(BUS.index));

  digitalWrite(LED, HIGH);
}

void loop(void)
{
  // Основной цикл пока пуст
}

// Прерывание при смене адреса, пишем очередной байт в порт
void ISR_ADR() 
{
  if (!BUS.en) return;
  BUS.index++;
  REG_WRITE(GPIO_OUT_REG, data.charAt(BUS.index));
}

// Прерывание при смене сигнала выбора чипа
void ISR_EN() 
{

    BUS.en = !digitalRead(EN);

    // Начало передачи
    if (BUS.en && !BUS.state)
    {

      // Пишем первый байт здесь т.к. есть дребезг прерывания при смене адреса
      REG_WRITE(GPIO_OUT_REG, data.charAt(BUS.index));
      BUS.state = true;
      return;
    }
    
    // Конец передачи
    if (!BUS.en && BUS.state)
    {
      BUS.state = false;
      BUS.index = 4;

      REG_WRITE(GPIO_OUT_REG, data.charAt(BUS.index));
    }

}
