#!/bin/bash

function save_rkr {
	local	codes=$(xxd -g 1 "$1" | sed -E "s/^.{9}(.{3,48}).*$/\1/g" | sed -E "s/([0-9a-f]+)/0x\1/g" )
	local	dump=(${codes})
	local	crc86rk=0
	local	length=${#dump[@]}-1
	printf "\x00\x00\x`printf "%02X" $((length>>8))`\x`printf "%02X" $((length&255))`" > $2
	for code in ${dump[@]}
	do
		local	data=$((code))
		if [[ $length -gt 0 ]]
		then
			crc86rk=$((crc86rk+data*257))
		else
			crc86rk=$((crc86rk+data))
		fi
		((length-=1))
		crc86rk=$((crc86rk&0xFFFF))
		printf "\x`printf "%02X" $((data))`" >> $2
	done
	printf "\x00\x00\xE6\x`printf "%02X" $((crc86rk>>8))`\x`printf "%02X" $((crc86rk&255))`" >> $2
}

if [[ "$1" == "--run" ]]
then
	temp_file=$(mktemp)
	save_rkr $2 ${temp_file}
	wine ~/Emu80/Emu80qt.exe --platform rk86 --run ${temp_file}
	rm ${temp_file}
else
	save_rkr $1 ${1//.bin/.rkr}
fi