scr_lines   equ 38
scr_length  equ $b00
scr_start   equ $4000

        IFDEF RK86
crt_ctrl    equ $c001
dma_ctrl    equ $e008
        ENDIF
        IFDEF APOGEE
crt_ctrl    equ $ef01
dma_ctrl    equ $f008
        ENDIF

        org $start_addr
        ld hl,scr_start:ld (frame_adress),hl
        ld hl,scr_length-1:ld (frame_len),hl
        ld hl,scr_start+scr_length-1:ld (frame_end),hl
        ld a,1:ld (old_hgt_l),a:ld (old_hgt_u),a
        ld (target_l),a:ld (target_u),a

        call make_row_table
        call make_sprite_save

        ld de,boom:ld hl,boom2:ld bc,boom_length:call shift_sprite_left

        ld  hl,scr_start:ld  bc,scr_length
        xor a:call fill_mem
        ld  hl,scr_start+$2000:ld  bc,scr_length
        xor a:call fill_mem

        ld a,$f3
        ld (scr_start+scr_length-1),a
        ld (scr_start+$2000+scr_length-1),a

        ld hl,crt_ctrl:ld (hl),0
        dec hl:ld (hl),$4d:ld (hl),scr_lines-1:ld (hl),$37:ld (hl),$73
        inc hl:ld (hl),$27
mainloop
        ld a,(crt_ctrl)
.loop   ld a,(crt_ctrl):and a,$20:jp z,.loop
        ld hl,(frame_adress):ex de,hl
        ld hl,(frame_len):ld a,h:or $40:ld b,a:ld c,l

        ld hl,dma_ctrl:ld (hl),$80
        ld l,4:ld (hl),e:ld (hl),d
        inc hl:ld (hl),c:ld (hl),b
        inc hl:ld (hl),0:ld a,d:and $f0:ld (hl),a
        inc hl:ld (hl),low (scr_length-1):ld (hl),$40+(high (scr_length-1))
        ld l,8:ld (hl),$a4

        ld a,d:xor $20:ld h,a:ld l,e:ld (frame_adress),hl
        and $20:ld (frame_mask),a:jp z,.skip
                
                inc l:call z,wrap_inc_hl
                ld (frame_adress),hl

                ld hl,(frame_end):ld (hl),0
                ld a,h:xor $20:ld h,a:ld (hl),0

                ld hl,scr_length-1:add hl,de:call wrap_hl
                ld (hl),$f3:ld a,h:xor $20:ld h,a
                ld (hl),$f3:ld (frame_end),hl

                ld hl,(frame_len)
                ld a,h:or l
                dec hl:jp nz,.skip2
                        ld hl,scr_length-1
.skip2  ld (frame_len),hl

.skip   call restore_sprites

        ld hl,(frame_adress):ld de,$4e*4+6
        add hl,de:call wrap_hl
        push hl:call erase:pop hl
        
        ld de,64:add hl,de:call wrap_hl
        call draw
        call draw_sprites
        
.wait   call $f81b
        cp $32:jp z,shoot_laser
        cp $20:jp z,.wait
        cp $31:jp z,launch_rocket
        cp $08:jp z,fly_left
        cp $18:jp z,fly_right
        cp $19:jp z,fly_up
        cp $1a:jp z,fly_down
        
        cp $1b:jp nz,mainloop

        call $f82d
        jp $f86c
        
fly_left
        ld a,(ship_x):cp 10:jp c,mainloop
        dec a:ld (ship_x),a
        jp mainloop
fly_right
        ld a,(ship_x):cp 60:jp nc,mainloop
        inc a:ld (ship_x),a
        jp mainloop
fly_up
        ld a,(ship_y):cp 5:jp c,mainloop
        dec a:ld (ship_y),a
        jp mainloop
fly_down
        ld a,(ship_y):cp 29:jp nc,mainloop
        inc a:ld (ship_y),a
        jp mainloop


launch_rocket
        ld a,(rocket.state):or a:jp nz,mainloop
        ld a,$ff:ld (rocket.state),a
        ld a,(ship_x): add a,rocket_init_x:ld (rocket.x),a
        ld a,(ship_y): add a,rocket_init_y:ld (rocket.y),a
        jp mainloop

shoot_laser
        ld a,(laser_state):cp laser_idle:jp nz,mainloop
        ld a,7:ld (laser_state),a
        jp mainloop

        include "utils.asm"


frame_adress    defw scr_start
frame_len       defw scr_length-1
frame_end       defw scr_start+scr_length-1
frame_mask      defb 0

rnd             defw $f800
old_hgt_u       defb 1
old_hgt_l       defb 1

target_u        defb 1
target_l        defb 1

upper   equ 15
lower   equ 7
middle  equ 23

        ; drawing the sky
        ; target_u holds random height
        ; each iteration current height is changed towards target
draw
        push hl:call draw_star:pop hl
        ld de,$0017
        ld a,(old_hgt_u):ld b,a
        ld a,(target_u):cp b:jp z,du_new

                sbc a,a:ccf:adc a,b:ld c,a
                ld (old_hgt_u),a
                jp draw_upper
        ; get here when target height reached
        ; randomly choose new height
du_new  push hl
        ld hl,(rnd)
        add a,(hl):inc hl
        rlca:rlca:and upper:inc a
        ld (target_u),a
        ld a,h:or $f8:ld h,a:ld (rnd),hl
        pop hl:jp draw

draw_upper
        ld (hl),e
        ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.du0
        ld a,e
        dec b:jp p,.du3:and $6
.du3    dec b:jp p,.du1:and $7
.du1    dec c:jp p,.du2:and $11
.du2    dec c:jp p,.du4:and $13
.du4    ld e,a:inc d:or a
        jp nz,draw_upper

        ;skip middle part of playfild
        ld a,middle+1:sub d:add a,a
        ex de,hl
        ld l,a:ld h,high row_table
        ld a,(hl):inc l:ld h,(hl):ld l,a
        add hl,de:call wrap_hl
        ld de,middle*256

        ld a,(old_hgt_l):ld b,a:ld c,a
        ld a,(target_l):dec a:ld (target_l),a
        jp nz,draw_lower
                push hl
                ld hl,(rnd)
                add a,(hl):inc hl
                rlca:rlca:and lower:inc a:ld c,a
                ld (target_l),a:ld (old_hgt_l),a
                ld a,h:or $f8:ld h,a:ld (rnd),hl
                pop hl

        ; and draw ground
        ; a random height is choosen
        ; then a random number of lines of that height is drawn
draw_lower
        ld (hl),e
        ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.du0    ld a,e
        dec b:jp p,.dl3:or $11
.dl3    dec b:jp p,.dl1:or $10
.dl1    dec c:jp p,.dl4:or $6
.dl4    dec c:jp p,.dl2:or $4
.dl2    ld e,a
        inc d:ld a,d:cp 31:jp nz,draw_lower
        ret
        
draw_star
        ld hl,(rnd):add a,(hl):inc hl:rrca:rrca:rrca
        xor (hl):and 127:cp 16:ret nc
        add a,upper:ld c,a
        ld a,h:or $f8:ld h,a:ld (rnd),hl
        ld b,64+6
        call xy_to_addr
        ld (hl),'.'
        ret
        
        
        ; sizes of playfield zones
        ; total playfield height is 32 characters
sky_width       equ     9
scape_width     equ     4
ground_width    equ     3
middle_width    equ     32-sky_width-ground_width-scape_width


erase
        ld de,$4d
        ld bc,default_colors
        jp .ent
.loop           ld (hl),d:inc l:call z,wrap_inc_hl
                ld a,(bc):ld (hl),a
                ld a,l:add a,e:ld l,a:call c,wrap_inc_hl
                inc c
.ent            ld a,(bc):or a:jp nz,.loop
                ret
                

        struct Save
cursor  defb 0 ; x
        defb 0 ; y
ship    defw 0
        defs ship_sprite_size
rocket  defw 0
        defs rocket_sprite_size
laser   defw 0 ; custom save procedure saves 2 bytes
        defb 0 ; at start
        defw 0
        defb 0 ; at end of laser beam
        ends

        ; in fact there are 2 save buffers this and at $7000
        ; they hold backgrounds under sprites for each frame buffer
        ; if frame_adress>=$6000 save buffers are swithed automatically
save_buffer Save = $5000


draw_sprites
        call draw_rocket
        call draw_ship
        call draw_laser
        ret

restore_sprites
        ld de,save_buffer.cursor:ld a,(frame_mask)
        xor $20:or d:ld d,a
        ld a,$80:ld (crt_ctrl),a
        ld a,(de):ld (crt_ctrl-1),a:inc de
        ld a,(de):ld (crt_ctrl-1),a
        
        call restore_laser
        ld de,save_buffer.ship
        call restore_sprite
        ld de,save_buffer.rocket
        call restore_sprite
        ret


ship_init_x  equ 20
ship_init_y  equ 1+4

ship_x  defb ship_init_x
ship_y  defb ship_init_y

draw_ship ; hardware cursor is used to immitate ship's laser cannon
        ld de,save_buffer.cursor 
        ld a,(frame_mask):or d:ld d,a
        ld a,(ship_x):ld b,a:add a,laser_init_x:ld (de),a:inc de
        ld a,(ship_y):ld c,a:add a,laser_init_y:ld (de),a
        ld de,save_buffer.ship
        ld hl,ship_sprite
        jp put_sprite
        

rocket_init_x   equ 1 ;relative to ship
rocket_init_y   equ 2 ;relative to ship
rocket_max_x    equ 64
rocket_min_x    equ 52 ;min x for rocket to explode
rocket_max_y    equ 32

        struct Rocket
x       defb 0
y       defb 0
state   defb 0 ;0 = no rocket; $ff = flying; 1-127 = exploging
cnt     defb 0 ;some counter
        ends

rocket  Rocket

draw_rocket
        ld a,(rocket.state):or a:ret z
        jp p,draw_boom

        ld a,(rocket.x):ld b,a:ld a,(rocket.y):ld c,a
        ld a,(rocket.cnt):dec a:ld (rocket.cnt),a:jp p,.dr1
                ld a,c:cp rocket_max_y/2:ld a,0:jp nc,.dr2
                ld a,b:cpl:rrca:rrca:rrca:and 7
.dr2            ld (rocket.cnt),a
                inc c:ld a,c:cp b:ccf:sbc a,0:ld c,a
                cp rocket_max_y:ld (rocket.y),a:jp c,.dr1
                ld a,$7f:ld (rocket.state),a
.dr1
        inc b:ld a,b:cp rocket_max_x:ccf:sbc a,0:ld (rocket.x),a
        ld hl,rocket_sprite
        ld de,save_buffer.rocket
        jp put_sprite


boom_anim_delay equ 6 ; measured in frames

draw_boom
        ld c,a:cp $7f:jp nz,.db1
                ld a,(rocket.y):sub 2:ld (boom_y),a
                ld c,a:ld a,(rocket.x):ld b,a
                call xy_to_addr
                ld (boom_addr),hl
                
                ld hl,boom:ld (boom_sprite),hl
                ld a,boom_anim_delay:ld (rocket.cnt),a
                ld a,boom_cnt:ld (rocket.state),a
.db1
        ld hl,(boom_sprite):ld e,l:ld d,h
        ld a,(rocket.cnt):dec a:ld (rocket.cnt),a:jp nz,.db4
                ld a,boom_anim_delay:ld (rocket.cnt),a
                ld bc,boom_size:add hl,bc:ld (boom_sprite),hl
                ld a,(rocket.state):dec a:ld (rocket.state),a:ret z
.db4
        ld hl,(boom_addr):ld b,h
        ld a,h:xor $20:ld h,a:ld (boom_addr),hl
        ld h,b:and $20:jp nz,.db3
        ex de,hl:ld bc,boom_length:add hl,bc:ex de,hl
.db3
        ld a,(boom_y):ld c,a
        jp draw_sprite

boom_addr       defw 0
boom_sprite     defw 0
boom_y          defb 0


laser_idle      equ $f0
laser_init_x    equ 6 ;relative to ship
laser_init_y    equ 1 ;relative to ship

restore_laser
        ld de,save_buffer.laser
        ld a,(frame_mask):or d:ld d,a
        call .rl1
.rl1    ld a,(de):ld l,a:inc de
        ld a,(de):or a:ret z:ld h,a
        xor a:ld (de),a:inc de
        ld a,(de):inc de:ld (hl),a
        ret

        ; laser beam is just a underline attribute of 8275
draw_laser
        ld a,(laser_state):cp laser_idle:ret z
        or a:ld bc,0:jp m,.dl2
                add a,low laser_colors:ld l,a
                ld h,high laser_colors:ld c,(hl)
                ld b,color_black
.dl1    ld h,high row_table
        ld a,(ship_y):add a,laser_init_y:add a,a:ld l,a
        ld e,(hl):inc l:ld d,(hl)
        ld hl,(frame_adress):add hl,de
        ld de,save_buffer.laser:ld a,h:and $20:or d:ld d,a
        push hl
                ld a,(ship_x):add a,laser_init_x:add a,l:ld l,a
                ld a,0:adc a,h:ld h,a:call wrap_hl
                ex de,hl:ld (hl),e:inc hl
                ld (hl),d:inc hl:ex de,hl
                ld a,(hl):ld (de),a:inc de
                ld (hl),c
        pop hl:push de
                ld de,64+7:add hl,de:call wrap_hl
        pop de
        ex de,hl:ld (hl),e:inc hl
        ld (hl),d:inc hl:ex de,hl
        ld a,(hl):ld (de),a:inc de
        ld (hl),b
.dl2        
        ld hl,laser_state:dec (hl)
        ret

        ;when laser_state >=0 laser is drawn
        ;if laser_state<0 and >laser_idle laser isn't drawn but can't be fired
laser_state defb laser_idle

        align 8
laser_colors
        defb color_black+$20,color_blue+$20,color_red+$20
        defb color_magenta+$20,color_green+$20,color_cyan+$20
        defb color_yellow+$20,color_white+$20

ship_sprite
        defb 8,color_magenta,"\\",$fe,13
        defb color_magenta,">]==-",$fe,13
        defb 8,color_magenta,"/",$fe
        defb $ff
ship_sprite_size    equ $-ship_sprite

rocket_sprite
        defb color_green,$0e,$1c,$fe,$ff
rocket_sprite_size  equ $-rocket_sprite


        ;row_table - values 0..39 multiplied by $4e for fast finding row address
make_row_table
        ld de,$0
        ld hl,row_table
        ld bc,$4e
        ld a,40
.loop           ld (hl),e:inc hl:ld (hl),d:inc hl
                ex de,hl:add hl,bc:ex de,hl
                dec a:jp nz,.loop
        ret

make_sprite_save
        ld hl,save_buffer.ship
        ld de,ship_sprite
        ld bc,ship_sprite_size
        call .do
        
        ld hl,save_buffer.rocket
        ld de,rocket_sprite
        ld bc,rocket_sprite_size

.do
        dup 2
                ld (hl),0:ld a,h:xor $20:ld h,a
                ld (hl),0:ld a,h:xor $20:ld h,a:inc hl
        edup
.l1             ld a,(de):ld (hl),a
                ld a,h:xor $20:ld h,a
                ld a,(de):ld (hl),a
                ld a,h:xor $20:ld h,a
                inc de:inc hl
                dec bc:ld a,b:or c
                jp nz,.l1
        ret


shift_sprite_left   ; de - source sprite
                    ; hl - destination
                    ; bc - sprite size
        push bc
            ld b,0
.ssl0
            ld a,(de):cp $0d:jp z,.ssl2
            or a:jp m,.ssl2
                and 1:rlca:ld c,a
                ld a,(de):and $10:rrca:rrca:or c:or b
                ld (hl),a
                ld a,(de):and 2:rrca:ld b,a
                ld a,(de):and 4:rlca:rlca:or b:ld b,a
.ssl3       inc hl:inc de
            ex (sp),hl:dec hl:ld a,h:or l:ex (sp),hl
        jp nz,.ssl0
        pop bc
        ret
.ssl2       ld (hl),a:ld b,0:jp .ssl3

        include "boom.asm"
        

        align 256
row_table       defs 128
default_colors  dup sky_width:defb color_cyan:edup
                dup middle_width:defb color_white:edup
                dup scape_width:defb color_red:edup
                dup ground_width:defb color_yellow:edup
                defb 0
