wrap_inc_hl
        inc h
wrap_hl
        ld a,h:and $1f:cp high scr_length:ret c
        ld a,h:sub high scr_length:ld h,a
        ret

wrap_dec_hl
        dec h
        ld a,h:and $10:ret z
        ld a,h:add a,high scr_length:ld h,a
        ret

xy_to_addr
        ld h,high row_table:ld a,c:add a,a:ld l,a
        ld e,(hl):inc l:ld d,(hl)
        ld hl,(frame_adress):add hl,de
        ld e,b:ld d,0:add hl,de
        jp wrap_hl


fill_mem
        ld  (hl),a:inc hl
        dec c:jp  nz,fill_mem
        dec b:jp  nz,fill_mem
        ret

draw_sprite
        .4 dec c
.ds0    ld b,$4e
.ds1    ld a,(de):cp $ff:ret z
                inc de
                cp 8:jp z,.ds3
                cp $0d:jp nz,.ds4
                        inc c
                        ld a,l:add a,b:ld l,a:call c,wrap_inc_hl
                        jp .ds0
.ds4            cp $fe:jp nz,.ds2
                        push de
                                ld de,default_colors
                                ld a,e:add a,c:ld e,a
                                ld a,(de)
                        pop de
.ds2            ld (hl),a
.ds3            inc l:call z,wrap_inc_hl
        dec b:jp .ds1


save_sprite
        ld a,h:and $20:or d:ld d,a
        ex de,hl:ld (hl),e:inc hl:ld (hl),d:inc hl:ex de,hl
.ss0
        ld b,$4e
.ss1            ld a,(de):cp $ff:ret z
                cp 8:jp z,.ss3
                cp $0d:jp nz,.ss2
                        ld a,l:add a,b:ld l,a:call c,wrap_inc_hl
                        inc de:jp .ss0
.ss2            ld a,(hl):ld (de),a
.ss3            inc de
                inc l:call z,wrap_inc_hl
        dec b:jp .ss1

restore_sprite
        ld a,(frame_mask):or d:ld d,a
        ld a,(de):ld l,a:inc de
        ld a,(de):or a:ret z:ld h,a
        xor a:ld (de),a:inc de
        jp draw_sprite
        
put_sprite      ; bc = xy, hl = sprite data, de = save buffer
        push hl,de:call xy_to_addr
                pop de:push hl:call save_sprite
        pop hl,de:jp draw_sprite

        IFDEF RK86
color_black     equ $80
color_blue      equ $88
color_red       equ $81
color_magenta   equ $89
color_cyan      equ $8c
color_green     equ $84
color_yellow    equ $85
color_white     equ $8d
        ENDIF
        
        IFDEF APOGEE
color_black     equ $8d
color_blue      equ $89
color_red       equ $8c
color_magenta   equ $88
color_cyan      equ $81
color_green     equ $85
color_yellow    equ $84
color_white     equ $80
        ENDIF

